/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmmn.handler;

import java.util.HashMap;
import org.camunda.bpm.engine.exception.NotValidException;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.cmmn.entity.repository.CaseDefinitionEntity;
import org.camunda.bpm.engine.impl.cmmn.handler.CmmnElementHandler;
import org.camunda.bpm.engine.impl.cmmn.handler.CmmnHandlerContext;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnActivity;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnCaseDefinition;
import org.camunda.bpm.engine.impl.cmmn.transformer.CmmnTransformerLogger;
import org.camunda.bpm.engine.impl.task.TaskDefinition;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.model.cmmn.CmmnModelInstance;
import org.camunda.bpm.model.cmmn.instance.Case;
import org.camunda.bpm.model.cmmn.instance.CmmnElement;
import org.camunda.bpm.model.cmmn.instance.Definitions;

public class CaseHandler
extends CmmnElementHandler<Case, CmmnCaseDefinition> {
    protected static final CmmnTransformerLogger LOG = ProcessEngineLogger.CMMN_TRANSFORMER_LOGGER;

    @Override
    public CmmnCaseDefinition handleElement(Case element, CmmnHandlerContext context) {
        CaseDefinitionEntity definition = this.createActivity((CmmnElement)element, context);
        this.initializeActivity(element, definition, context);
        return definition;
    }

    protected void initializeActivity(Case element, CmmnActivity activity, CmmnHandlerContext context) {
        CaseDefinitionEntity definition = (CaseDefinitionEntity)activity;
        Deployment deployment = context.getDeployment();
        definition.setKey(element.getId());
        definition.setName(element.getName());
        definition.setDeploymentId(deployment.getId());
        definition.setTaskDefinitions(new HashMap<String, TaskDefinition>());
        Integer camundaHistoryTimeToLive = element.getCamundaHistoryTimeToLive();
        if (camundaHistoryTimeToLive != null) {
            EnsureUtil.ensureGreaterThanOrEqual(NotValidException.class, "", "historyTimeToLive", camundaHistoryTimeToLive.intValue(), 0L);
        }
        definition.setHistoryTimeToLive(camundaHistoryTimeToLive);
        CmmnModelInstance model = context.getModel();
        Definitions definitions = model.getDefinitions();
        String category = definitions.getTargetNamespace();
        definition.setCategory(category);
    }

    protected CaseDefinitionEntity createActivity(CmmnElement element, CmmnHandlerContext context) {
        CaseDefinitionEntity definition = new CaseDefinitionEntity();
        definition.setCmmnElement(element);
        return definition;
    }
}

