/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.List;
import org.camunda.bpm.application.ProcessApplicationReference;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.exception.DeploymentResourceNotFoundException;
import org.camunda.bpm.engine.exception.NotFoundException;
import org.camunda.bpm.engine.exception.NotValidException;
import org.camunda.bpm.engine.exception.NullValueException;
import org.camunda.bpm.engine.exception.cmmn.CaseDefinitionNotFoundException;
import org.camunda.bpm.engine.exception.cmmn.CmmnModelInstanceNotFoundException;
import org.camunda.bpm.engine.exception.dmn.DecisionDefinitionNotFoundException;
import org.camunda.bpm.engine.exception.dmn.DmnModelInstanceNotFoundException;
import org.camunda.bpm.engine.impl.DeploymentQueryImpl;
import org.camunda.bpm.engine.impl.ProcessDefinitionQueryImpl;
import org.camunda.bpm.engine.impl.ServiceImpl;
import org.camunda.bpm.engine.impl.cmd.AddIdentityLinkForProcessDefinitionCmd;
import org.camunda.bpm.engine.impl.cmd.DeleteDeploymentCmd;
import org.camunda.bpm.engine.impl.cmd.DeleteIdentityLinkForProcessDefinitionCmd;
import org.camunda.bpm.engine.impl.cmd.DeleteProcessDefinitionCmd;
import org.camunda.bpm.engine.impl.cmd.DeployCmd;
import org.camunda.bpm.engine.impl.cmd.GetDeployedProcessDefinitionCmd;
import org.camunda.bpm.engine.impl.cmd.GetDeploymentBpmnModelInstanceCmd;
import org.camunda.bpm.engine.impl.cmd.GetDeploymentProcessDiagramCmd;
import org.camunda.bpm.engine.impl.cmd.GetDeploymentProcessDiagramLayoutCmd;
import org.camunda.bpm.engine.impl.cmd.GetDeploymentProcessModelCmd;
import org.camunda.bpm.engine.impl.cmd.GetDeploymentResourceCmd;
import org.camunda.bpm.engine.impl.cmd.GetDeploymentResourceForIdCmd;
import org.camunda.bpm.engine.impl.cmd.GetDeploymentResourceNamesCmd;
import org.camunda.bpm.engine.impl.cmd.GetDeploymentResourcesCmd;
import org.camunda.bpm.engine.impl.cmd.GetIdentityLinksForProcessDefinitionCmd;
import org.camunda.bpm.engine.impl.cmd.UpdateDecisionDefinitionHistoryTimeToLiveCmd;
import org.camunda.bpm.engine.impl.cmd.UpdateProcessDefinitionHistoryTimeToLiveCmd;
import org.camunda.bpm.engine.impl.cmmn.cmd.GetDeploymentCaseDefinitionCmd;
import org.camunda.bpm.engine.impl.cmmn.cmd.GetDeploymentCaseDiagramCmd;
import org.camunda.bpm.engine.impl.cmmn.cmd.GetDeploymentCaseModelCmd;
import org.camunda.bpm.engine.impl.cmmn.cmd.GetDeploymentCmmnModelInstanceCmd;
import org.camunda.bpm.engine.impl.cmmn.cmd.UpdateCaseDefinitionHistoryTimeToLiveCmd;
import org.camunda.bpm.engine.impl.cmmn.entity.repository.CaseDefinitionQueryImpl;
import org.camunda.bpm.engine.impl.dmn.cmd.GetDeploymentDecisionDefinitionCmd;
import org.camunda.bpm.engine.impl.dmn.cmd.GetDeploymentDecisionDiagramCmd;
import org.camunda.bpm.engine.impl.dmn.cmd.GetDeploymentDecisionModelCmd;
import org.camunda.bpm.engine.impl.dmn.cmd.GetDeploymentDecisionRequirementsDefinitionCmd;
import org.camunda.bpm.engine.impl.dmn.cmd.GetDeploymentDecisionRequirementsDiagramCmd;
import org.camunda.bpm.engine.impl.dmn.cmd.GetDeploymentDecisionRequirementsModelCmd;
import org.camunda.bpm.engine.impl.dmn.cmd.GetDeploymentDmnModelInstanceCmd;
import org.camunda.bpm.engine.impl.dmn.entity.repository.DecisionDefinitionQueryImpl;
import org.camunda.bpm.engine.impl.dmn.entity.repository.DecisionRequirementsDefinitionQueryImpl;
import org.camunda.bpm.engine.impl.pvm.ReadOnlyProcessDefinition;
import org.camunda.bpm.engine.impl.repository.DeleteProcessDefinitionsBuilderImpl;
import org.camunda.bpm.engine.impl.repository.DeploymentBuilderImpl;
import org.camunda.bpm.engine.impl.repository.ProcessApplicationDeploymentBuilderImpl;
import org.camunda.bpm.engine.impl.repository.UpdateProcessDefinitionSuspensionStateBuilderImpl;
import org.camunda.bpm.engine.repository.CaseDefinition;
import org.camunda.bpm.engine.repository.CaseDefinitionQuery;
import org.camunda.bpm.engine.repository.DecisionDefinition;
import org.camunda.bpm.engine.repository.DecisionDefinitionQuery;
import org.camunda.bpm.engine.repository.DecisionRequirementsDefinition;
import org.camunda.bpm.engine.repository.DecisionRequirementsDefinitionQuery;
import org.camunda.bpm.engine.repository.DeleteProcessDefinitionsSelectBuilder;
import org.camunda.bpm.engine.repository.DeploymentBuilder;
import org.camunda.bpm.engine.repository.DeploymentQuery;
import org.camunda.bpm.engine.repository.DeploymentWithDefinitions;
import org.camunda.bpm.engine.repository.DiagramLayout;
import org.camunda.bpm.engine.repository.ProcessApplicationDeploymentBuilder;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinitionQuery;
import org.camunda.bpm.engine.repository.Resource;
import org.camunda.bpm.engine.repository.UpdateProcessDefinitionSuspensionStateSelectBuilder;
import org.camunda.bpm.engine.task.IdentityLink;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.cmmn.CmmnModelInstance;
import org.camunda.bpm.model.dmn.DmnModelInstance;

public class RepositoryServiceImpl
extends ServiceImpl
implements RepositoryService {
    protected Charset deploymentCharset;

    public Charset getDeploymentCharset() {
        return this.deploymentCharset;
    }

    public void setDeploymentCharset(Charset deploymentCharset) {
        this.deploymentCharset = deploymentCharset;
    }

    @Override
    public DeploymentBuilder createDeployment() {
        return new DeploymentBuilderImpl(this);
    }

    @Override
    public ProcessApplicationDeploymentBuilder createDeployment(ProcessApplicationReference processApplication) {
        return new ProcessApplicationDeploymentBuilderImpl(this, processApplication);
    }

    public DeploymentWithDefinitions deployWithResult(DeploymentBuilderImpl deploymentBuilder) {
        return this.commandExecutor.execute(new DeployCmd(deploymentBuilder));
    }

    @Override
    public void deleteDeployment(String deploymentId) {
        this.commandExecutor.execute(new DeleteDeploymentCmd(deploymentId, false, false, false));
    }

    @Override
    public void deleteDeploymentCascade(String deploymentId) {
        this.commandExecutor.execute(new DeleteDeploymentCmd(deploymentId, true, false, false));
    }

    @Override
    public void deleteDeployment(String deploymentId, boolean cascade) {
        this.commandExecutor.execute(new DeleteDeploymentCmd(deploymentId, cascade, false, false));
    }

    @Override
    public void deleteDeployment(String deploymentId, boolean cascade, boolean skipCustomListeners) {
        this.commandExecutor.execute(new DeleteDeploymentCmd(deploymentId, cascade, skipCustomListeners, false));
    }

    @Override
    public void deleteDeployment(String deploymentId, boolean cascade, boolean skipCustomListeners, boolean skipIoMappings) {
        this.commandExecutor.execute(new DeleteDeploymentCmd(deploymentId, cascade, skipCustomListeners, skipIoMappings));
    }

    @Override
    public void deleteProcessDefinition(String processDefinitionId) {
        this.deleteProcessDefinition(processDefinitionId, false);
    }

    @Override
    public void deleteProcessDefinition(String processDefinitionId, boolean cascade) {
        this.deleteProcessDefinition(processDefinitionId, cascade, false);
    }

    @Override
    public void deleteProcessDefinition(String processDefinitionId, boolean cascade, boolean skipCustomListeners) {
        this.commandExecutor.execute(new DeleteProcessDefinitionCmd(processDefinitionId, cascade, skipCustomListeners));
    }

    @Override
    public DeleteProcessDefinitionsSelectBuilder deleteProcessDefinitions() {
        return new DeleteProcessDefinitionsBuilderImpl(this.commandExecutor);
    }

    @Override
    public ProcessDefinitionQuery createProcessDefinitionQuery() {
        return new ProcessDefinitionQueryImpl(this.commandExecutor);
    }

    @Override
    public CaseDefinitionQuery createCaseDefinitionQuery() {
        return new CaseDefinitionQueryImpl(this.commandExecutor);
    }

    @Override
    public DecisionDefinitionQuery createDecisionDefinitionQuery() {
        return new DecisionDefinitionQueryImpl(this.commandExecutor);
    }

    @Override
    public DecisionRequirementsDefinitionQuery createDecisionRequirementsDefinitionQuery() {
        return new DecisionRequirementsDefinitionQueryImpl(this.commandExecutor);
    }

    @Override
    public List<String> getDeploymentResourceNames(String deploymentId) {
        return this.commandExecutor.execute(new GetDeploymentResourceNamesCmd(deploymentId));
    }

    @Override
    public List<Resource> getDeploymentResources(String deploymentId) {
        return this.commandExecutor.execute(new GetDeploymentResourcesCmd(deploymentId));
    }

    @Override
    public InputStream getResourceAsStream(String deploymentId, String resourceName) {
        return this.commandExecutor.execute(new GetDeploymentResourceCmd(deploymentId, resourceName));
    }

    @Override
    public InputStream getResourceAsStreamById(String deploymentId, String resourceId) {
        return this.commandExecutor.execute(new GetDeploymentResourceForIdCmd(deploymentId, resourceId));
    }

    @Override
    public DeploymentQuery createDeploymentQuery() {
        return new DeploymentQueryImpl(this.commandExecutor);
    }

    @Override
    public ProcessDefinition getProcessDefinition(String processDefinitionId) {
        return this.commandExecutor.execute(new GetDeployedProcessDefinitionCmd(processDefinitionId, true));
    }

    public ReadOnlyProcessDefinition getDeployedProcessDefinition(String processDefinitionId) {
        return this.commandExecutor.execute(new GetDeployedProcessDefinitionCmd(processDefinitionId, true));
    }

    @Override
    public void suspendProcessDefinitionById(String processDefinitionId) {
        this.updateProcessDefinitionSuspensionState().byProcessDefinitionId(processDefinitionId).suspend();
    }

    @Override
    public void suspendProcessDefinitionById(String processDefinitionId, boolean suspendProcessInstances, Date suspensionDate) {
        this.updateProcessDefinitionSuspensionState().byProcessDefinitionId(processDefinitionId).includeProcessInstances(suspendProcessInstances).executionDate(suspensionDate).suspend();
    }

    @Override
    public void suspendProcessDefinitionByKey(String processDefinitionKey) {
        this.updateProcessDefinitionSuspensionState().byProcessDefinitionKey(processDefinitionKey).suspend();
    }

    @Override
    public void suspendProcessDefinitionByKey(String processDefinitionKey, boolean suspendProcessInstances, Date suspensionDate) {
        this.updateProcessDefinitionSuspensionState().byProcessDefinitionKey(processDefinitionKey).includeProcessInstances(suspendProcessInstances).executionDate(suspensionDate).suspend();
    }

    @Override
    public void activateProcessDefinitionById(String processDefinitionId) {
        this.updateProcessDefinitionSuspensionState().byProcessDefinitionId(processDefinitionId).activate();
    }

    @Override
    public void activateProcessDefinitionById(String processDefinitionId, boolean activateProcessInstances, Date activationDate) {
        this.updateProcessDefinitionSuspensionState().byProcessDefinitionId(processDefinitionId).includeProcessInstances(activateProcessInstances).executionDate(activationDate).activate();
    }

    @Override
    public void activateProcessDefinitionByKey(String processDefinitionKey) {
        this.updateProcessDefinitionSuspensionState().byProcessDefinitionKey(processDefinitionKey).activate();
    }

    @Override
    public void activateProcessDefinitionByKey(String processDefinitionKey, boolean activateProcessInstances, Date activationDate) {
        this.updateProcessDefinitionSuspensionState().byProcessDefinitionKey(processDefinitionKey).includeProcessInstances(activateProcessInstances).executionDate(activationDate).activate();
    }

    @Override
    public UpdateProcessDefinitionSuspensionStateSelectBuilder updateProcessDefinitionSuspensionState() {
        return new UpdateProcessDefinitionSuspensionStateBuilderImpl(this.commandExecutor);
    }

    @Override
    public void updateProcessDefinitionHistoryTimeToLive(String processDefinitionId, Integer historyTimeToLive) {
        this.commandExecutor.execute(new UpdateProcessDefinitionHistoryTimeToLiveCmd(processDefinitionId, historyTimeToLive));
    }

    @Override
    public void updateDecisionDefinitionHistoryTimeToLive(String decisionDefinitionId, Integer historyTimeToLive) {
        this.commandExecutor.execute(new UpdateDecisionDefinitionHistoryTimeToLiveCmd(decisionDefinitionId, historyTimeToLive));
    }

    @Override
    public void updateCaseDefinitionHistoryTimeToLive(String caseDefinitionId, Integer historyTimeToLive) {
        this.commandExecutor.execute(new UpdateCaseDefinitionHistoryTimeToLiveCmd(caseDefinitionId, historyTimeToLive));
    }

    @Override
    public InputStream getProcessModel(String processDefinitionId) {
        return this.commandExecutor.execute(new GetDeploymentProcessModelCmd(processDefinitionId));
    }

    @Override
    public InputStream getProcessDiagram(String processDefinitionId) {
        return this.commandExecutor.execute(new GetDeploymentProcessDiagramCmd(processDefinitionId));
    }

    @Override
    public InputStream getCaseDiagram(String caseDefinitionId) {
        return this.commandExecutor.execute(new GetDeploymentCaseDiagramCmd(caseDefinitionId));
    }

    @Override
    public DiagramLayout getProcessDiagramLayout(String processDefinitionId) {
        return this.commandExecutor.execute(new GetDeploymentProcessDiagramLayoutCmd(processDefinitionId));
    }

    @Override
    public BpmnModelInstance getBpmnModelInstance(String processDefinitionId) {
        return this.commandExecutor.execute(new GetDeploymentBpmnModelInstanceCmd(processDefinitionId));
    }

    @Override
    public CmmnModelInstance getCmmnModelInstance(String caseDefinitionId) {
        try {
            return this.commandExecutor.execute(new GetDeploymentCmmnModelInstanceCmd(caseDefinitionId));
        }
        catch (NullValueException e) {
            throw new NotValidException(e.getMessage(), e);
        }
        catch (CmmnModelInstanceNotFoundException e) {
            throw new NotFoundException(e.getMessage(), e);
        }
        catch (DeploymentResourceNotFoundException e) {
            throw new NotFoundException(e.getMessage(), e);
        }
    }

    @Override
    public DmnModelInstance getDmnModelInstance(String decisionDefinitionId) {
        try {
            return this.commandExecutor.execute(new GetDeploymentDmnModelInstanceCmd(decisionDefinitionId));
        }
        catch (NullValueException e) {
            throw new NotValidException(e.getMessage(), e);
        }
        catch (DmnModelInstanceNotFoundException e) {
            throw new NotFoundException(e.getMessage(), e);
        }
        catch (DeploymentResourceNotFoundException e) {
            throw new NotFoundException(e.getMessage(), e);
        }
    }

    @Override
    public void addCandidateStarterUser(String processDefinitionId, String userId) {
        this.commandExecutor.execute(new AddIdentityLinkForProcessDefinitionCmd(processDefinitionId, userId, null));
    }

    @Override
    public void addCandidateStarterGroup(String processDefinitionId, String groupId) {
        this.commandExecutor.execute(new AddIdentityLinkForProcessDefinitionCmd(processDefinitionId, null, groupId));
    }

    @Override
    public void deleteCandidateStarterGroup(String processDefinitionId, String groupId) {
        this.commandExecutor.execute(new DeleteIdentityLinkForProcessDefinitionCmd(processDefinitionId, null, groupId));
    }

    @Override
    public void deleteCandidateStarterUser(String processDefinitionId, String userId) {
        this.commandExecutor.execute(new DeleteIdentityLinkForProcessDefinitionCmd(processDefinitionId, userId, null));
    }

    @Override
    public List<IdentityLink> getIdentityLinksForProcessDefinition(String processDefinitionId) {
        return this.commandExecutor.execute(new GetIdentityLinksForProcessDefinitionCmd(processDefinitionId));
    }

    @Override
    public CaseDefinition getCaseDefinition(String caseDefinitionId) {
        try {
            return this.commandExecutor.execute(new GetDeploymentCaseDefinitionCmd(caseDefinitionId));
        }
        catch (NullValueException e) {
            throw new NotValidException(e.getMessage(), e);
        }
        catch (CaseDefinitionNotFoundException e) {
            throw new NotFoundException(e.getMessage(), e);
        }
    }

    @Override
    public InputStream getCaseModel(String caseDefinitionId) {
        try {
            return this.commandExecutor.execute(new GetDeploymentCaseModelCmd(caseDefinitionId));
        }
        catch (NullValueException e) {
            throw new NotValidException(e.getMessage(), e);
        }
        catch (CaseDefinitionNotFoundException e) {
            throw new NotFoundException(e.getMessage(), e);
        }
        catch (DeploymentResourceNotFoundException e) {
            throw new NotFoundException(e.getMessage(), e);
        }
    }

    @Override
    public DecisionDefinition getDecisionDefinition(String decisionDefinitionId) {
        try {
            return this.commandExecutor.execute(new GetDeploymentDecisionDefinitionCmd(decisionDefinitionId));
        }
        catch (NullValueException e) {
            throw new NotValidException(e.getMessage(), e);
        }
        catch (DecisionDefinitionNotFoundException e) {
            throw new NotFoundException(e.getMessage(), e);
        }
    }

    @Override
    public DecisionRequirementsDefinition getDecisionRequirementsDefinition(String decisionRequirementsDefinitionId) {
        try {
            return this.commandExecutor.execute(new GetDeploymentDecisionRequirementsDefinitionCmd(decisionRequirementsDefinitionId));
        }
        catch (NullValueException e) {
            throw new NotValidException(e.getMessage(), e);
        }
        catch (DecisionDefinitionNotFoundException e) {
            throw new NotFoundException(e.getMessage(), e);
        }
    }

    @Override
    public InputStream getDecisionModel(String decisionDefinitionId) {
        try {
            return this.commandExecutor.execute(new GetDeploymentDecisionModelCmd(decisionDefinitionId));
        }
        catch (NullValueException e) {
            throw new NotValidException(e.getMessage(), e);
        }
        catch (DecisionDefinitionNotFoundException e) {
            throw new NotFoundException(e.getMessage(), e);
        }
        catch (DeploymentResourceNotFoundException e) {
            throw new NotFoundException(e.getMessage(), e);
        }
    }

    @Override
    public InputStream getDecisionRequirementsModel(String decisionRequirementsDefinitionId) {
        try {
            return this.commandExecutor.execute(new GetDeploymentDecisionRequirementsModelCmd(decisionRequirementsDefinitionId));
        }
        catch (NullValueException e) {
            throw new NotValidException(e.getMessage(), e);
        }
        catch (DecisionDefinitionNotFoundException e) {
            throw new NotFoundException(e.getMessage(), e);
        }
        catch (DeploymentResourceNotFoundException e) {
            throw new NotFoundException(e.getMessage(), e);
        }
    }

    @Override
    public InputStream getDecisionDiagram(String decisionDefinitionId) {
        return this.commandExecutor.execute(new GetDeploymentDecisionDiagramCmd(decisionDefinitionId));
    }

    @Override
    public InputStream getDecisionRequirementsDiagram(String decisionRequirementsDefinitionId) {
        return this.commandExecutor.execute(new GetDeploymentDecisionRequirementsDiagramCmd(decisionRequirementsDefinitionId));
    }
}

