/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.db.sql;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.ibatis.executor.BatchResult;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.session.SqlSession;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.db.AbstractPersistenceSession;
import org.camunda.bpm.engine.impl.db.DbEntity;
import org.camunda.bpm.engine.impl.db.EnginePersistenceLogger;
import org.camunda.bpm.engine.impl.db.HasDbRevision;
import org.camunda.bpm.engine.impl.db.entitymanager.operation.DbBulkOperation;
import org.camunda.bpm.engine.impl.db.entitymanager.operation.DbEntityOperation;
import org.camunda.bpm.engine.impl.db.sql.DbSqlSessionFactory;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.impl.util.IoUtil;
import org.camunda.bpm.engine.impl.util.ReflectUtil;

public class DbSqlSession
extends AbstractPersistenceSession {
    protected static final EnginePersistenceLogger LOG = ProcessEngineLogger.PERSISTENCE_LOGGER;
    protected SqlSession sqlSession;
    protected DbSqlSessionFactory dbSqlSessionFactory;
    protected String connectionMetadataDefaultCatalog = null;
    protected String connectionMetadataDefaultSchema = null;
    public static String[] JDBC_METADATA_TABLE_TYPES = new String[]{"TABLE"};

    public DbSqlSession(DbSqlSessionFactory dbSqlSessionFactory) {
        this.dbSqlSessionFactory = dbSqlSessionFactory;
        this.sqlSession = dbSqlSessionFactory.getSqlSessionFactory().openSession();
    }

    public DbSqlSession(DbSqlSessionFactory dbSqlSessionFactory, Connection connection, String catalog, String schema) {
        this.dbSqlSessionFactory = dbSqlSessionFactory;
        this.sqlSession = dbSqlSessionFactory.getSqlSessionFactory().openSession(connection);
        this.connectionMetadataDefaultCatalog = catalog;
        this.connectionMetadataDefaultSchema = schema;
    }

    @Override
    public List<BatchResult> flushOperations() {
        return this.sqlSession.flushStatements();
    }

    @Override
    public List<?> selectList(String statement, Object parameter) {
        statement = this.dbSqlSessionFactory.mapStatement(statement);
        List resultList = this.sqlSession.selectList(statement, parameter);
        for (Object object : resultList) {
            this.fireEntityLoaded(object);
        }
        return resultList;
    }

    @Override
    public <T extends DbEntity> T selectById(Class<T> type, String id) {
        String selectStatement = this.dbSqlSessionFactory.getSelectStatement(type);
        selectStatement = this.dbSqlSessionFactory.mapStatement(selectStatement);
        EnsureUtil.ensureNotNull("no select statement for " + type + " in the ibatis mapping files", "selectStatement", (Object)selectStatement);
        Object result = this.sqlSession.selectOne(selectStatement, (Object)id);
        this.fireEntityLoaded(result);
        return (T)((DbEntity)result);
    }

    @Override
    public Object selectOne(String statement, Object parameter) {
        statement = this.dbSqlSessionFactory.mapStatement(statement);
        Object result = this.sqlSession.selectOne(statement, parameter);
        this.fireEntityLoaded(result);
        return result;
    }

    @Override
    public void lock(String statement, Object parameter) {
        if (!"h2".equals(this.dbSqlSessionFactory.getDatabaseType())) {
            String mappedStatement = this.dbSqlSessionFactory.mapStatement(statement);
            if (!Context.getProcessEngineConfiguration().isJdbcBatchProcessing()) {
                this.sqlSession.update(mappedStatement, parameter);
            } else {
                this.sqlSession.selectList(mappedStatement, parameter);
            }
        }
    }

    @Override
    protected void insertEntity(DbEntityOperation operation) {
        DbEntity dbEntity = operation.getEntity();
        String insertStatement = this.dbSqlSessionFactory.getInsertStatement(dbEntity);
        insertStatement = this.dbSqlSessionFactory.mapStatement(insertStatement);
        EnsureUtil.ensureNotNull("no insert statement for " + dbEntity.getClass() + " in the ibatis mapping files", "insertStatement", (Object)insertStatement);
        this.executeInsertEntity(insertStatement, dbEntity);
        this.entityInserted(dbEntity);
    }

    protected void executeInsertEntity(String insertStatement, Object parameter) {
        LOG.executeDatabaseOperation("INSERT", parameter);
        this.sqlSession.insert(insertStatement, parameter);
        if (parameter instanceof HasDbRevision) {
            HasDbRevision versionedObject = (HasDbRevision)parameter;
            versionedObject.setRevision(1);
        }
    }

    protected void entityInserted(DbEntity entity) {
    }

    @Override
    protected void deleteEntity(DbEntityOperation operation) {
        DbEntity dbEntity = operation.getEntity();
        String deleteStatement = this.dbSqlSessionFactory.getDeleteStatement(dbEntity.getClass());
        EnsureUtil.ensureNotNull("no delete statement for " + dbEntity.getClass() + " in the ibatis mapping files", "deleteStatement", (Object)deleteStatement);
        LOG.executeDatabaseOperation("DELETE", dbEntity);
        int nrOfRowsDeleted = this.executeDelete(deleteStatement, dbEntity);
        if (dbEntity instanceof HasDbRevision && nrOfRowsDeleted == 0) {
            operation.setFailed(true);
            return;
        }
        this.entityDeleted(dbEntity);
    }

    protected int executeDelete(String deleteStatement, Object parameter) {
        deleteStatement = this.dbSqlSessionFactory.mapStatement(deleteStatement);
        return this.sqlSession.delete(deleteStatement, parameter);
    }

    protected void entityDeleted(DbEntity entity) {
    }

    @Override
    protected void deleteBulk(DbBulkOperation operation) {
        String statement = operation.getStatement();
        Object parameter = operation.getParameter();
        LOG.executeDatabaseBulkOperation("DELETE", statement, parameter);
        this.executeDelete(statement, parameter);
    }

    @Override
    protected void updateEntity(DbEntityOperation operation) {
        DbEntity dbEntity = operation.getEntity();
        String updateStatement = this.dbSqlSessionFactory.getUpdateStatement(dbEntity);
        EnsureUtil.ensureNotNull("no update statement for " + dbEntity.getClass() + " in the ibatis mapping files", "updateStatement", (Object)updateStatement);
        LOG.executeDatabaseOperation("UPDATE", dbEntity);
        if (Context.getProcessEngineConfiguration().isJdbcBatchProcessing()) {
            this.executeUpdate(updateStatement, dbEntity);
        } else {
            int numOfRowsUpdated = this.executeUpdate(updateStatement, dbEntity);
            if (dbEntity instanceof HasDbRevision) {
                if (numOfRowsUpdated != 1) {
                    operation.setFailed(true);
                    return;
                }
                HasDbRevision versionedObject = (HasDbRevision)((Object)dbEntity);
                versionedObject.setRevision(versionedObject.getRevisionNext());
            }
        }
        this.entityUpdated(dbEntity);
    }

    @Override
    public int executeUpdate(String updateStatement, Object parameter) {
        updateStatement = this.dbSqlSessionFactory.mapStatement(updateStatement);
        return this.sqlSession.update(updateStatement, parameter);
    }

    @Override
    public int executeNonEmptyUpdateStmt(String updateStmt, Object parameter) {
        updateStmt = this.dbSqlSessionFactory.mapStatement(updateStmt);
        MappedStatement mappedStatement = this.sqlSession.getConfiguration().getMappedStatement(updateStmt);
        if (mappedStatement.getBoundSql(parameter).getSql().isEmpty()) {
            return 0;
        }
        return this.sqlSession.update(updateStmt, parameter);
    }

    protected void entityUpdated(DbEntity entity) {
    }

    @Override
    protected void updateBulk(DbBulkOperation operation) {
        String statement = operation.getStatement();
        Object parameter = operation.getParameter();
        LOG.executeDatabaseBulkOperation("UPDATE", statement, parameter);
        this.executeUpdate(statement, parameter);
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
        this.sqlSession.close();
    }

    @Override
    public void commit() {
        this.sqlSession.commit();
    }

    @Override
    public void rollback() {
        this.sqlSession.rollback();
    }

    @Override
    public void dbSchemaCheckVersion() {
        try {
            String dbVersion = this.getDbVersion();
            if (!"fox".equals(dbVersion)) {
                throw LOG.wrongDbVersionException("fox", dbVersion);
            }
            ArrayList<String> missingComponents = new ArrayList<String>();
            if (!this.isEngineTablePresent()) {
                missingComponents.add("engine");
            }
            if (this.dbSqlSessionFactory.isDbHistoryUsed() && !this.isHistoryTablePresent()) {
                missingComponents.add("history");
            }
            if (this.dbSqlSessionFactory.isDbIdentityUsed() && !this.isIdentityTablePresent()) {
                missingComponents.add("identity");
            }
            if (this.dbSqlSessionFactory.isCmmnEnabled() && !this.isCmmnTablePresent()) {
                missingComponents.add("case.engine");
            }
            if (this.dbSqlSessionFactory.isDmnEnabled() && !this.isDmnTablePresent()) {
                missingComponents.add("decision.engine");
            }
            if (!missingComponents.isEmpty()) {
                throw LOG.missingTableException(missingComponents);
            }
        }
        catch (Exception e) {
            if (this.isMissingTablesException(e)) {
                throw LOG.missingActivitiTablesException();
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw LOG.unableToFetchDbSchemaVersion(e);
        }
    }

    @Override
    protected String getDbVersion() {
        String selectSchemaVersionStatement = this.dbSqlSessionFactory.mapStatement("selectDbSchemaVersion");
        return (String)this.sqlSession.selectOne(selectSchemaVersionStatement);
    }

    @Override
    protected void dbSchemaCreateIdentity() {
        this.executeMandatorySchemaResource("create", "identity");
    }

    @Override
    protected void dbSchemaCreateHistory() {
        this.executeMandatorySchemaResource("create", "history");
    }

    @Override
    protected void dbSchemaCreateEngine() {
        this.executeMandatorySchemaResource("create", "engine");
    }

    @Override
    protected void dbSchemaCreateCmmn() {
        this.executeMandatorySchemaResource("create", "case.engine");
    }

    @Override
    protected void dbSchemaCreateCmmnHistory() {
        this.executeMandatorySchemaResource("create", "case.history");
    }

    @Override
    protected void dbSchemaCreateDmn() {
        this.executeMandatorySchemaResource("create", "decision.engine");
    }

    @Override
    protected void dbSchemaCreateDmnHistory() {
        this.executeMandatorySchemaResource("create", "decision.history");
    }

    @Override
    protected void dbSchemaDropIdentity() {
        this.executeMandatorySchemaResource("drop", "identity");
    }

    @Override
    protected void dbSchemaDropHistory() {
        this.executeMandatorySchemaResource("drop", "history");
    }

    @Override
    protected void dbSchemaDropEngine() {
        this.executeMandatorySchemaResource("drop", "engine");
    }

    @Override
    protected void dbSchemaDropCmmn() {
        this.executeMandatorySchemaResource("drop", "case.engine");
    }

    @Override
    protected void dbSchemaDropCmmnHistory() {
        this.executeMandatorySchemaResource("drop", "case.history");
    }

    @Override
    protected void dbSchemaDropDmn() {
        this.executeMandatorySchemaResource("drop", "decision.engine");
    }

    @Override
    protected void dbSchemaDropDmnHistory() {
        this.executeMandatorySchemaResource("drop", "decision.history");
    }

    public void executeMandatorySchemaResource(String operation, String component) {
        this.executeSchemaResource(operation, component, this.getResourceForDbOperation(operation, operation, component), false);
    }

    @Override
    public boolean isEngineTablePresent() {
        return this.isTablePresent("ACT_RU_EXECUTION");
    }

    @Override
    public boolean isHistoryTablePresent() {
        return this.isTablePresent("ACT_HI_PROCINST");
    }

    @Override
    public boolean isIdentityTablePresent() {
        return this.isTablePresent("ACT_ID_USER");
    }

    @Override
    public boolean isCmmnTablePresent() {
        return this.isTablePresent("ACT_RE_CASE_DEF");
    }

    @Override
    public boolean isCmmnHistoryTablePresent() {
        return this.isTablePresent("ACT_HI_CASEINST");
    }

    @Override
    public boolean isDmnTablePresent() {
        return this.isTablePresent("ACT_RE_DECISION_DEF");
    }

    @Override
    public boolean isDmnHistoryTablePresent() {
        return this.isTablePresent("ACT_HI_DECINST");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTablePresent(String tableName) {
        boolean bl;
        String databaseType;
        tableName = this.prependDatabaseTablePrefix(tableName);
        Connection connection = null;
        connection = this.sqlSession.getConnection();
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        ResultSet tables = null;
        String schema = this.connectionMetadataDefaultSchema;
        if (this.dbSqlSessionFactory.getDatabaseSchema() != null) {
            schema = this.dbSqlSessionFactory.getDatabaseSchema();
        }
        if ("postgres".equals(databaseType = this.dbSqlSessionFactory.getDatabaseType())) {
            tableName = tableName.toLowerCase();
        }
        try {
            tables = databaseMetaData.getTables(this.connectionMetadataDefaultCatalog, schema, tableName, JDBC_METADATA_TABLE_TYPES);
            bl = tables.next();
        }
        catch (Throwable throwable) {
            try {
                tables.close();
                throw throwable;
            }
            catch (Exception e) {
                throw LOG.checkDatabaseTableException(e);
            }
        }
        tables.close();
        return bl;
    }

    @Override
    public List<String> getTableNamesPresent() {
        ArrayList<String> tableNames = new ArrayList();
        try {
            ResultSet tablesRs = null;
            try {
                if ("oracle".equals(this.getDbSqlSessionFactory().getDatabaseType())) {
                    tableNames = this.getTablesPresentInOracleDatabase();
                } else {
                    Connection connection = this.getSqlSession().getConnection();
                    String databaseTablePrefix = this.getDbSqlSessionFactory().getDatabaseTablePrefix();
                    String schema = this.getDbSqlSessionFactory().getDatabaseSchema();
                    String tableNameFilter = this.prependDatabaseTablePrefix("ACT_%");
                    if ("postgres".equals(this.getDbSqlSessionFactory().getDatabaseType())) {
                        schema = schema == null ? schema : schema.toLowerCase();
                        tableNameFilter = tableNameFilter.toLowerCase();
                    }
                    DatabaseMetaData databaseMetaData = connection.getMetaData();
                    tablesRs = databaseMetaData.getTables(null, schema, tableNameFilter, JDBC_METADATA_TABLE_TYPES);
                    while (tablesRs.next()) {
                        String tableName = tablesRs.getString("TABLE_NAME");
                        if (!databaseTablePrefix.isEmpty()) {
                            tableName = databaseTablePrefix + tableName;
                        }
                        tableName = tableName.toUpperCase();
                        tableNames.add(tableName);
                    }
                    LOG.fetchDatabaseTables("jdbc metadata", tableNames);
                }
            }
            catch (SQLException se) {
                throw se;
            }
            finally {
                if (tablesRs != null) {
                    tablesRs.close();
                }
            }
        }
        catch (Exception e) {
            throw LOG.getDatabaseTableNameException(e);
        }
        return tableNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> getTablesPresentInOracleDatabase() throws SQLException {
        ArrayList<String> tableNames = new ArrayList<String>();
        Connection connection = null;
        PreparedStatement prepStat = null;
        ResultSet tablesRs = null;
        String selectTableNamesFromOracle = "SELECT table_name FROM all_tables WHERE table_name LIKE ?";
        String databaseTablePrefix = this.getDbSqlSessionFactory().getDatabaseTablePrefix();
        try {
            connection = Context.getProcessEngineConfiguration().getDataSource().getConnection();
            prepStat = connection.prepareStatement(selectTableNamesFromOracle);
            prepStat.setString(1, databaseTablePrefix + "ACT_%");
            tablesRs = prepStat.executeQuery();
            while (tablesRs.next()) {
                String tableName = tablesRs.getString("TABLE_NAME");
                tableName = tableName.toUpperCase();
                tableNames.add(tableName);
            }
            LOG.fetchDatabaseTables("oracle all_tables", tableNames);
        }
        finally {
            if (tablesRs != null) {
                tablesRs.close();
            }
            if (prepStat != null) {
                prepStat.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
        return tableNames;
    }

    public String prependDatabaseTablePrefix(String tableName) {
        String prefixWithoutSchema = this.dbSqlSessionFactory.getDatabaseTablePrefix();
        String schema = this.dbSqlSessionFactory.getDatabaseSchema();
        if (prefixWithoutSchema == null) {
            return tableName;
        }
        if (schema == null) {
            return prefixWithoutSchema + tableName;
        }
        if (prefixWithoutSchema.startsWith(schema + ".")) {
            prefixWithoutSchema = prefixWithoutSchema.substring(schema.length() + 1);
        }
        return prefixWithoutSchema + tableName;
    }

    public String getResourceForDbOperation(String directory, String operation, String component) {
        String databaseType = this.dbSqlSessionFactory.getDatabaseType();
        return "org/camunda/bpm/engine/db/" + directory + "/activiti." + databaseType + "." + operation + "." + component + ".sql";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void executeSchemaResource(String operation, String component, String resourceName, boolean isOptional) {
        InputStream inputStream = null;
        try {
            inputStream = ReflectUtil.getResourceAsStream(resourceName);
            if (inputStream == null) {
                if (!isOptional) throw LOG.missingSchemaResourceException(resourceName, operation);
                LOG.missingSchemaResource(resourceName, operation);
                return;
            } else {
                this.executeSchemaResource(operation, component, resourceName, inputStream);
            }
            return;
        }
        finally {
            IoUtil.closeSilently(inputStream);
        }
    }

    public void executeSchemaResource(String schemaFileResourceName) {
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(new File(schemaFileResourceName));
            this.executeSchemaResource("schema operation", "process engine", schemaFileResourceName, inputStream);
        }
        catch (FileNotFoundException e) {
            try {
                throw LOG.missingSchemaResourceFileException(schemaFileResourceName, e);
            }
            catch (Throwable throwable) {
                IoUtil.closeSilently(inputStream);
                throw throwable;
            }
        }
        IoUtil.closeSilently(inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeSchemaResource(String operation, String component, String resourceName, InputStream inputStream) {
        String sqlStatement = null;
        String exceptionSqlStatement = null;
        try {
            Connection connection = this.sqlSession.getConnection();
            Exception exception = null;
            byte[] bytes = IoUtil.readInputStream(inputStream, resourceName);
            String ddlStatements = new String(bytes);
            BufferedReader reader = new BufferedReader(new StringReader(ddlStatements));
            String line = this.readNextTrimmedLine(reader);
            ArrayList<String> logLines = new ArrayList<String>();
            while (line != null) {
                if (line.startsWith("# ")) {
                    logLines.add(line.substring(2));
                } else if (line.startsWith("-- ")) {
                    logLines.add(line.substring(3));
                } else if (line.length() > 0) {
                    if (line.endsWith(";")) {
                        sqlStatement = this.addSqlStatementPiece(sqlStatement, line.substring(0, line.length() - 1));
                        Statement jdbcStatement = connection.createStatement();
                        try {
                            logLines.add(sqlStatement);
                            jdbcStatement.execute(sqlStatement);
                            jdbcStatement.close();
                        }
                        catch (Exception e) {
                            if (exception == null) {
                                exception = e;
                                exceptionSqlStatement = sqlStatement;
                            }
                            LOG.failedDatabaseOperation(operation, sqlStatement, e);
                        }
                        finally {
                            sqlStatement = null;
                        }
                    } else {
                        sqlStatement = this.addSqlStatementPiece(sqlStatement, line);
                    }
                }
                line = this.readNextTrimmedLine(reader);
            }
            LOG.performingDatabaseOperation(operation, component, resourceName);
            LOG.executingDDL(logLines);
            if (exception != null) {
                throw exception;
            }
            LOG.successfulDatabaseOperation(operation, component);
        }
        catch (Exception e) {
            throw LOG.performDatabaseOperationException(operation, exceptionSqlStatement, e);
        }
    }

    protected String addSqlStatementPiece(String sqlStatement, String line) {
        if (sqlStatement == null) {
            return line;
        }
        return sqlStatement + " \n" + line;
    }

    protected String readNextTrimmedLine(BufferedReader reader) throws IOException {
        String line = reader.readLine();
        if (line != null) {
            line = line.trim();
        }
        return line;
    }

    protected boolean isMissingTablesException(Exception e) {
        String exceptionMessage = e.getMessage();
        if (e.getMessage() != null) {
            if (exceptionMessage.indexOf("Table") != -1 && exceptionMessage.indexOf("not found") != -1) {
                return true;
            }
            if ((exceptionMessage.indexOf("Table") != -1 || exceptionMessage.indexOf("table") != -1) && exceptionMessage.indexOf("doesn't exist") != -1) {
                return true;
            }
            if ((exceptionMessage.indexOf("relation") != -1 || exceptionMessage.indexOf("table") != -1) && exceptionMessage.indexOf("does not exist") != -1) {
                return true;
            }
        }
        return false;
    }

    public SqlSession getSqlSession() {
        return this.sqlSession;
    }

    public DbSqlSessionFactory getDbSqlSessionFactory() {
        return this.dbSqlSessionFactory;
    }
}

