/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.dmn.cmd;

import java.util.Arrays;
import org.camunda.bpm.engine.impl.cfg.CommandChecker;
import org.camunda.bpm.engine.impl.history.event.HistoricDecisionInstanceEntity;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class DeleteHistoricDecisionInstanceByInstanceIdCmd
implements Command<Object> {
    protected final String historicDecisionInstanceId;

    public DeleteHistoricDecisionInstanceByInstanceIdCmd(String historicDecisionInstanceId) {
        this.historicDecisionInstanceId = historicDecisionInstanceId;
    }

    @Override
    public Object execute(CommandContext commandContext) {
        EnsureUtil.ensureNotNull("historicDecisionInstanceId", (Object)this.historicDecisionInstanceId);
        HistoricDecisionInstanceEntity historicDecisionInstance = commandContext.getHistoricDecisionInstanceManager().findHistoricDecisionInstance(this.historicDecisionInstanceId);
        EnsureUtil.ensureNotNull("No historic decision instance found with id: " + this.historicDecisionInstanceId, "historicDecisionInstance", (Object)historicDecisionInstance);
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkDeleteHistoricDecisionInstance(historicDecisionInstance);
        }
        commandContext.getHistoricDecisionInstanceManager().deleteHistoricDecisionInstanceByIds(Arrays.asList(this.historicDecisionInstanceId));
        return null;
    }
}

