/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.dmn.entity.repository;

import java.util.HashMap;
import java.util.List;
import org.camunda.bpm.engine.impl.Page;
import org.camunda.bpm.engine.impl.cfg.auth.ResourceAuthorizationProvider;
import org.camunda.bpm.engine.impl.dmn.entity.repository.DecisionDefinitionEntity;
import org.camunda.bpm.engine.impl.dmn.entity.repository.DecisionRequirementsDefinitionEntity;
import org.camunda.bpm.engine.impl.dmn.entity.repository.DecisionRequirementsDefinitionQueryImpl;
import org.camunda.bpm.engine.impl.persistence.AbstractManager;
import org.camunda.bpm.engine.impl.persistence.AbstractResourceDefinitionManager;
import org.camunda.bpm.engine.impl.persistence.entity.AuthorizationEntity;
import org.camunda.bpm.engine.repository.DecisionRequirementsDefinition;

public class DecisionRequirementsDefinitionManager
extends AbstractManager
implements AbstractResourceDefinitionManager<DecisionRequirementsDefinitionEntity> {
    public void insertDecisionRequirementsDefinition(DecisionRequirementsDefinitionEntity decisionRequirementsDefinition) {
        this.getDbEntityManager().insert(decisionRequirementsDefinition);
        this.createDefaultAuthorizations(decisionRequirementsDefinition);
    }

    public void deleteDecisionRequirementsDefinitionsByDeploymentId(String deploymentId) {
        this.getDbEntityManager().delete(DecisionDefinitionEntity.class, "deleteDecisionRequirementsDefinitionsByDeploymentId", deploymentId);
    }

    public DecisionRequirementsDefinitionEntity findDecisionRequirementsDefinitionById(String decisionRequirementsDefinitionId) {
        return this.getDbEntityManager().selectById(DecisionRequirementsDefinitionEntity.class, decisionRequirementsDefinitionId);
    }

    public String findPreviousDecisionRequirementsDefinitionId(String decisionRequirementsDefinitionKey, Integer version, String tenantId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("key", decisionRequirementsDefinitionKey);
        params.put("version", version);
        params.put("tenantId", tenantId);
        return (String)this.getDbEntityManager().selectOne("selectPreviousDecisionRequirementsDefinitionId", params);
    }

    public List<DecisionRequirementsDefinition> findDecisionRequirementsDefinitionByDeploymentId(String deploymentId) {
        return this.getDbEntityManager().selectList("selectDecisionRequirementsDefinitionByDeploymentId", deploymentId);
    }

    public DecisionRequirementsDefinitionEntity findDecisionRequirementsDefinitionByDeploymentAndKey(String deploymentId, String decisionRequirementsDefinitionKey) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("deploymentId", deploymentId);
        parameters.put("decisionRequirementsDefinitionKey", decisionRequirementsDefinitionKey);
        return (DecisionRequirementsDefinitionEntity)this.getDbEntityManager().selectOne("selectDecisionRequirementsDefinitionByDeploymentAndKey", parameters);
    }

    public DecisionRequirementsDefinitionEntity findLatestDecisionRequirementsDefinitionByKeyAndTenantId(String decisionRequirementsDefinitionKey, String tenantId) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("decisionRequirementsDefinitionKey", decisionRequirementsDefinitionKey);
        parameters.put("tenantId", tenantId);
        if (tenantId == null) {
            return (DecisionRequirementsDefinitionEntity)this.getDbEntityManager().selectOne("selectLatestDecisionRequirementsDefinitionByKeyWithoutTenantId", parameters);
        }
        return (DecisionRequirementsDefinitionEntity)this.getDbEntityManager().selectOne("selectLatestDecisionRequirementsDefinitionByKeyAndTenantId", parameters);
    }

    public List<DecisionRequirementsDefinition> findDecisionRequirementsDefinitionsByQueryCriteria(DecisionRequirementsDefinitionQueryImpl query, Page page) {
        this.configureDecisionRequirementsDefinitionQuery(query);
        return this.getDbEntityManager().selectList("selectDecisionRequirementsDefinitionsByQueryCriteria", query, page);
    }

    public long findDecisionRequirementsDefinitionCountByQueryCriteria(DecisionRequirementsDefinitionQueryImpl query) {
        this.configureDecisionRequirementsDefinitionQuery(query);
        return (Long)this.getDbEntityManager().selectOne("selectDecisionRequirementsDefinitionCountByQueryCriteria", query);
    }

    protected void createDefaultAuthorizations(DecisionRequirementsDefinition decisionRequirementsDefinition) {
        if (this.isAuthorizationEnabled()) {
            ResourceAuthorizationProvider provider = this.getResourceAuthorizationProvider();
            AuthorizationEntity[] authorizations = provider.newDecisionRequirementsDefinition(decisionRequirementsDefinition);
            this.saveDefaultAuthorizations(authorizations);
        }
    }

    protected void configureDecisionRequirementsDefinitionQuery(DecisionRequirementsDefinitionQueryImpl query) {
        this.getAuthorizationManager().configureDecisionRequirementsDefinitionQuery(query);
        this.getTenantManager().configureQuery(query);
    }

    @Override
    public DecisionRequirementsDefinitionEntity findLatestDefinitionByKey(String key) {
        return null;
    }

    @Override
    public DecisionRequirementsDefinitionEntity findLatestDefinitionById(String id) {
        return this.getDbEntityManager().selectById(DecisionRequirementsDefinitionEntity.class, id);
    }

    @Override
    public DecisionRequirementsDefinitionEntity findLatestDefinitionByKeyAndTenantId(String definitionKey, String tenantId) {
        return null;
    }

    @Override
    public DecisionRequirementsDefinitionEntity findDefinitionByKeyVersionAndTenantId(String definitionKey, Integer definitionVersion, String tenantId) {
        return null;
    }

    @Override
    public DecisionRequirementsDefinitionEntity findDefinitionByDeploymentAndKey(String deploymentId, String definitionKey) {
        return null;
    }

    @Override
    public DecisionRequirementsDefinitionEntity getCachedResourceDefinitionEntity(String definitionId) {
        return this.getDbEntityManager().getCachedEntity(DecisionRequirementsDefinitionEntity.class, definitionId);
    }
}

