/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.persistence.deploy.cache;

import org.camunda.bpm.engine.exception.dmn.DecisionDefinitionNotFoundException;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.dmn.entity.repository.DecisionDefinitionEntity;
import org.camunda.bpm.engine.impl.dmn.entity.repository.DecisionDefinitionManager;
import org.camunda.bpm.engine.impl.persistence.AbstractResourceDefinitionManager;
import org.camunda.bpm.engine.impl.persistence.deploy.cache.CacheDeployer;
import org.camunda.bpm.engine.impl.persistence.deploy.cache.CacheFactory;
import org.camunda.bpm.engine.impl.persistence.deploy.cache.ResourceDefinitionCache;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class DecisionDefinitionCache
extends ResourceDefinitionCache<DecisionDefinitionEntity> {
    public DecisionDefinitionCache(CacheFactory factory, int cacheCapacity, CacheDeployer cacheDeployer) {
        super(factory, cacheCapacity, cacheDeployer);
    }

    public DecisionDefinitionEntity findDeployedDefinitionByKeyAndVersion(String definitionKey, Integer definitionVersion) {
        DecisionDefinitionEntity definition = ((DecisionDefinitionManager)this.getManager()).findDecisionDefinitionByKeyAndVersion(definitionKey, definitionVersion);
        this.checkInvalidDefinitionByKeyAndVersion(definitionKey, definitionVersion, definition);
        definition = this.resolveDefinition(definition);
        return definition;
    }

    @Override
    protected AbstractResourceDefinitionManager<DecisionDefinitionEntity> getManager() {
        return Context.getCommandContext().getDecisionDefinitionManager();
    }

    @Override
    protected void checkInvalidDefinitionId(String definitionId) {
        EnsureUtil.ensureNotNull("Invalid decision definition id", "decisionDefinitionId", (Object)definitionId);
    }

    @Override
    protected void checkDefinitionFound(String definitionId, DecisionDefinitionEntity definition) {
        EnsureUtil.ensureNotNull(DecisionDefinitionNotFoundException.class, "no deployed decision definition found with id '" + definitionId + "'", "decisionDefinition", (Object)definition);
    }

    @Override
    protected void checkInvalidDefinitionByKey(String definitionKey, DecisionDefinitionEntity definition) {
        EnsureUtil.ensureNotNull(DecisionDefinitionNotFoundException.class, "no decision definition deployed with key '" + definitionKey + "'", "decisionDefinition", (Object)definition);
    }

    @Override
    protected void checkInvalidDefinitionByKeyAndTenantId(String definitionKey, String tenantId, DecisionDefinitionEntity definition) {
        EnsureUtil.ensureNotNull(DecisionDefinitionNotFoundException.class, "no decision definition deployed with key '" + definitionKey + "' and tenant-id '" + tenantId + "'", "decisionDefinition", (Object)definition);
    }

    protected void checkInvalidDefinitionByKeyAndVersion(String decisionDefinitionKey, Integer decisionDefinitionVersion, DecisionDefinitionEntity decisionDefinition) {
        EnsureUtil.ensureNotNull(DecisionDefinitionNotFoundException.class, "no decision definition deployed with key = '" + decisionDefinitionKey + "' and version = '" + decisionDefinitionVersion + "'", "decisionDefinition", (Object)decisionDefinition);
    }

    @Override
    protected void checkInvalidDefinitionByKeyVersionAndTenantId(String definitionKey, Integer definitionVersion, String tenantId, DecisionDefinitionEntity definition) {
        EnsureUtil.ensureNotNull(DecisionDefinitionNotFoundException.class, "no decision definition deployed with key = '" + definitionKey + "', version = '" + definitionVersion + "' and tenant-id '" + tenantId + "'", "decisionDefinition", (Object)definition);
    }

    @Override
    protected void checkInvalidDefinitionByDeploymentAndKey(String deploymentId, String definitionKey, DecisionDefinitionEntity definition) {
        EnsureUtil.ensureNotNull(DecisionDefinitionNotFoundException.class, "no decision definition deployed with key = '" + definitionKey + "' in deployment = '" + deploymentId + "'", "decisionDefinition", (Object)definition);
    }

    @Override
    protected void checkInvalidDefinitionWasCached(String deploymentId, String definitionId, DecisionDefinitionEntity definition) {
        EnsureUtil.ensureNotNull("deployment '" + deploymentId + "' didn't put decision definition '" + definitionId + "' in the cache", "cachedDecisionDefinition", (Object)definition);
    }
}

