/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.util;

import org.camunda.bpm.dmn.engine.DmnDecisionResult;
import org.camunda.bpm.dmn.engine.DmnDecisionTableResult;
import org.camunda.bpm.dmn.engine.impl.DmnDecisionTableResultImpl;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.core.model.BaseCallableElement;
import org.camunda.bpm.engine.impl.core.variable.scope.AbstractVariableScope;
import org.camunda.bpm.engine.impl.dmn.invocation.DecisionInvocation;
import org.camunda.bpm.engine.impl.dmn.invocation.VariableScopeContext;
import org.camunda.bpm.engine.impl.dmn.result.CollectEntriesDecisionResultMapper;
import org.camunda.bpm.engine.impl.dmn.result.DecisionResultMapper;
import org.camunda.bpm.engine.impl.dmn.result.ResultListDecisionTableResultMapper;
import org.camunda.bpm.engine.impl.dmn.result.SingleEntryDecisionResultMapper;
import org.camunda.bpm.engine.impl.dmn.result.SingleResultDecisionResultMapper;
import org.camunda.bpm.engine.impl.util.CallableElementUtil;
import org.camunda.bpm.engine.repository.DecisionDefinition;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.context.VariableContext;

public class DecisionEvaluationUtil {
    public static final String DECISION_RESULT_VARIABLE = "decisionResult";

    public static DecisionResultMapper getDecisionResultMapperForName(String mapDecisionResult) {
        if ("singleEntry".equals(mapDecisionResult)) {
            return new SingleEntryDecisionResultMapper();
        }
        if ("singleResult".equals(mapDecisionResult)) {
            return new SingleResultDecisionResultMapper();
        }
        if ("collectEntries".equals(mapDecisionResult)) {
            return new CollectEntriesDecisionResultMapper();
        }
        if ("resultList".equals(mapDecisionResult) || mapDecisionResult == null) {
            return new ResultListDecisionTableResultMapper();
        }
        return null;
    }

    public static void evaluateDecision(AbstractVariableScope execution, BaseCallableElement callableElement, String resultVariable, DecisionResultMapper decisionResultMapper) throws Exception {
        DecisionDefinition decisionDefinition = DecisionEvaluationUtil.resolveDecisionDefinition(callableElement, execution);
        DecisionInvocation invocation = DecisionEvaluationUtil.createInvocation(decisionDefinition, execution);
        DecisionEvaluationUtil.invoke(invocation);
        DmnDecisionResult result = invocation.getInvocationResult();
        if (result != null) {
            execution.setVariableLocalTransient(DECISION_RESULT_VARIABLE, result);
            if (resultVariable != null && decisionResultMapper != null) {
                Object mappedDecisionResult = decisionResultMapper.mapDecisionResult(result);
                execution.setVariable(resultVariable, mappedDecisionResult);
            }
        }
    }

    public static DmnDecisionResult evaluateDecision(DecisionDefinition decisionDefinition, VariableMap variables) throws Exception {
        DecisionInvocation invocation = DecisionEvaluationUtil.createInvocation(decisionDefinition, variables);
        DecisionEvaluationUtil.invoke(invocation);
        return invocation.getInvocationResult();
    }

    public static DmnDecisionTableResult evaluateDecisionTable(DecisionDefinition decisionDefinition, VariableMap variables) throws Exception {
        DmnDecisionResult decisionResult = DecisionEvaluationUtil.evaluateDecision(decisionDefinition, variables);
        return DmnDecisionTableResultImpl.wrap((DmnDecisionResult)decisionResult);
    }

    protected static void invoke(DecisionInvocation invocation) throws Exception {
        Context.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(invocation);
    }

    protected static DecisionInvocation createInvocation(DecisionDefinition decisionDefinition, VariableMap variables) {
        return DecisionEvaluationUtil.createInvocation(decisionDefinition, variables.asVariableContext());
    }

    protected static DecisionInvocation createInvocation(DecisionDefinition decisionDefinition, AbstractVariableScope variableScope) {
        return DecisionEvaluationUtil.createInvocation(decisionDefinition, VariableScopeContext.wrap(variableScope));
    }

    protected static DecisionInvocation createInvocation(DecisionDefinition decisionDefinition, VariableContext variableContext) {
        return new DecisionInvocation(decisionDefinition, variableContext);
    }

    protected static DecisionDefinition resolveDecisionDefinition(BaseCallableElement callableElement, AbstractVariableScope execution) {
        return CallableElementUtil.getDecisionDefinitionToCall(execution, callableElement);
    }
}

