/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.client.backoff;

import java.util.List;
import org.camunda.bpm.client.backoff.ErrorAwareBackoffStrategy;
import org.camunda.bpm.client.exception.ExternalTaskClientException;
import org.camunda.bpm.client.task.ExternalTask;

public class ExponentialErrorBackoffStrategy
implements ErrorAwareBackoffStrategy {
    protected long initTime;
    protected float factor;
    protected int level;
    protected long maxTime;

    public ExponentialErrorBackoffStrategy() {
        this(500L, 2.0f, 60000L);
    }

    public ExponentialErrorBackoffStrategy(long initTime, float factor, long maxTime) {
        this.initTime = initTime;
        this.factor = factor;
        this.level = 0;
        this.maxTime = maxTime;
    }

    @Override
    public void reconfigure(List<ExternalTask> externalTasks, ExternalTaskClientException error) {
        this.level = error != null ? ++this.level : 0;
    }

    @Override
    public long calculateBackoffTime() {
        if (this.level == 0) {
            return 0L;
        }
        long backoffTime = (long)((double)this.initTime * Math.pow(this.factor, this.level - 1));
        return Math.min(backoffTime, this.maxTime);
    }
}

