/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.dmn.engine.impl.evaluation;

import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.camunda.bpm.dmn.engine.impl.CachedCompiledScriptSupport;
import org.camunda.bpm.dmn.engine.impl.CachedExpressionSupport;
import org.camunda.bpm.dmn.engine.impl.DefaultDmnEngineConfiguration;
import org.camunda.bpm.dmn.engine.impl.DmnEngineLogger;
import org.camunda.bpm.dmn.engine.impl.DmnExpressionImpl;
import org.camunda.bpm.dmn.engine.impl.el.VariableContextScriptBindings;
import org.camunda.bpm.dmn.engine.impl.spi.el.DmnScriptEngineResolver;
import org.camunda.bpm.dmn.engine.impl.spi.el.ElExpression;
import org.camunda.bpm.dmn.engine.impl.spi.el.ElProvider;
import org.camunda.bpm.dmn.feel.impl.FeelEngine;
import org.camunda.bpm.engine.variable.context.VariableContext;
import org.camunda.commons.utils.EnsureUtil;
import org.camunda.commons.utils.StringUtil;

public class ExpressionEvaluationHandler {
    protected static final DmnEngineLogger LOG = DmnEngineLogger.ENGINE_LOGGER;
    protected final DmnScriptEngineResolver scriptEngineResolver;
    protected final ElProvider elProvider;
    protected final FeelEngine feelEngine;

    public ExpressionEvaluationHandler(DefaultDmnEngineConfiguration configuration) {
        this.scriptEngineResolver = configuration.getScriptEngineResolver();
        this.elProvider = configuration.getElProvider();
        this.feelEngine = configuration.getFeelEngine();
    }

    public Object evaluateExpression(String expressionLanguage, DmnExpressionImpl expression, VariableContext variableContext) {
        String expressionText = this.getExpressionTextForLanguage(expression, expressionLanguage);
        if (expressionText != null) {
            if (this.isFeelExpressionLanguage(expressionLanguage)) {
                return this.evaluateFeelSimpleExpression(expressionText, variableContext);
            }
            if (this.isElExpression(expressionLanguage)) {
                return this.evaluateElExpression(expressionLanguage, expressionText, variableContext, expression);
            }
            return this.evaluateScriptExpression(expressionLanguage, variableContext, expressionText, expression);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object evaluateScriptExpression(String expressionLanguage, VariableContext variableContext, String expressionText, CachedCompiledScriptSupport cachedCompiledScriptSupport) {
        ScriptEngine scriptEngine = this.getScriptEngineForName(expressionLanguage);
        VariableContextScriptBindings bindings = VariableContextScriptBindings.wrap(scriptEngine.createBindings(), variableContext);
        bindings.put("variableContext", (Object)variableContext);
        try {
            if (scriptEngine instanceof Compilable) {
                CompiledScript compiledScript = cachedCompiledScriptSupport.getCachedCompiledScript();
                if (compiledScript == null) {
                    CachedCompiledScriptSupport cachedCompiledScriptSupport2 = cachedCompiledScriptSupport;
                    synchronized (cachedCompiledScriptSupport2) {
                        compiledScript = cachedCompiledScriptSupport.getCachedCompiledScript();
                        if (compiledScript == null) {
                            Compilable compilableScriptEngine = (Compilable)((Object)scriptEngine);
                            compiledScript = compilableScriptEngine.compile(expressionText);
                            cachedCompiledScriptSupport.cacheCompiledScript(compiledScript);
                        }
                    }
                }
                return compiledScript.eval(bindings);
            }
            return scriptEngine.eval(expressionText, (Bindings)bindings);
        }
        catch (ScriptException e) {
            throw LOG.unableToEvaluateExpression(expressionText, scriptEngine.getFactory().getLanguageName(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object evaluateElExpression(String expressionLanguage, String expressionText, VariableContext variableContext, CachedExpressionSupport cachedExpressionSupport) {
        try {
            ElExpression elExpression = cachedExpressionSupport.getCachedExpression();
            if (elExpression == null) {
                CachedExpressionSupport cachedExpressionSupport2 = cachedExpressionSupport;
                synchronized (cachedExpressionSupport2) {
                    elExpression = cachedExpressionSupport.getCachedExpression();
                    if (elExpression == null) {
                        elExpression = this.elProvider.createExpression(expressionText);
                        cachedExpressionSupport.setCachedExpression(elExpression);
                    }
                }
            }
            return elExpression.getValue(variableContext);
        }
        catch (Exception e) {
            throw LOG.unableToEvaluateExpression(expressionText, expressionLanguage, e);
        }
    }

    protected Object evaluateFeelSimpleExpression(String expressionText, VariableContext variableContext) {
        return this.feelEngine.evaluateSimpleExpression(expressionText, variableContext);
    }

    protected String getExpressionTextForLanguage(DmnExpressionImpl expression, String expressionLanguage) {
        String expressionText = expression.getExpression();
        if (expressionText != null) {
            if (this.isJuelExpression(expressionLanguage) && !StringUtil.isExpression((String)expressionText)) {
                return "${" + expressionText + "}";
            }
            return expressionText;
        }
        return null;
    }

    private boolean isJuelExpression(String expressionLanguage) {
        return "juel".equalsIgnoreCase(expressionLanguage);
    }

    protected ScriptEngine getScriptEngineForName(String expressionLanguage) {
        EnsureUtil.ensureNotNull((String)"expressionLanguage", (Object)expressionLanguage);
        ScriptEngine scriptEngine = this.scriptEngineResolver.getScriptEngineForLanguage(expressionLanguage);
        if (scriptEngine != null) {
            return scriptEngine;
        }
        throw LOG.noScriptEngineFoundForLanguage(expressionLanguage);
    }

    protected boolean isElExpression(String expressionLanguage) {
        return this.isJuelExpression(expressionLanguage);
    }

    public boolean isFeelExpressionLanguage(String expressionLanguage) {
        EnsureUtil.ensureNotNull((String)"expressionLanguage", (Object)expressionLanguage);
        return expressionLanguage.equals("http://www.omg.org/spec/FEEL/20140401") || expressionLanguage.toLowerCase().equals("feel");
    }
}

