/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.assertions;

import java.util.Date;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractDateAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.history.HistoricActivityInstanceQuery;
import org.camunda.bpm.engine.history.HistoricDetailQuery;
import org.camunda.bpm.engine.history.HistoricProcessInstanceQuery;
import org.camunda.bpm.engine.history.HistoricTaskInstanceQuery;
import org.camunda.bpm.engine.history.HistoricVariableInstanceQuery;
import org.camunda.bpm.engine.repository.ProcessDefinitionQuery;
import org.camunda.bpm.engine.runtime.ExecutionQuery;
import org.camunda.bpm.engine.runtime.JobQuery;
import org.camunda.bpm.engine.runtime.ProcessInstanceQuery;
import org.camunda.bpm.engine.runtime.VariableInstanceQuery;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.task.TaskQuery;
import org.camunda.bpm.engine.test.assertions.AbstractProcessAssert;

public class TaskAssert
extends AbstractProcessAssert<TaskAssert, Task> {
    protected TaskAssert(ProcessEngine engine, Task actual) {
        super(engine, actual, TaskAssert.class);
    }

    protected static TaskAssert assertThat(ProcessEngine engine, Task actual) {
        return new TaskAssert(engine, actual);
    }

    @Override
    protected Task getCurrent() {
        return (Task)this.taskQuery().taskId(((Task)this.actual).getId()).singleResult();
    }

    public TaskAssert isNotAssigned() {
        Task current = (Task)this.getExistingCurrent();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)current.getAssignee()).overridingErrorMessage("Expecting %s not to be assigned, but found it to be assigned to user '%s'!", new Object[]{this.toString(current), current.getAssignee()})).isNull();
        return this;
    }

    public TaskAssert isAssignedTo(String userId) {
        Task current = (Task)this.getExistingCurrent();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)current.getAssignee()).overridingErrorMessage("Expecting %s to be assigned to user '%s', but found it to be assigned to '%s'!", new Object[]{this.toString(current), userId, current.getAssignee()})).isEqualTo((Object)userId);
        return this;
    }

    public TaskAssert hasCandidateGroup(String candidateGroupId) {
        Assertions.assertThat((String)candidateGroupId).isNotNull();
        Task current = (Task)this.getExistingCurrent();
        Task inGroup = (Task)this.taskQuery().taskId(((Task)this.actual).getId()).taskCandidateGroup(candidateGroupId).singleResult();
        ((AbstractObjectAssert)Assertions.assertThat((Object)inGroup).overridingErrorMessage("Expecting %s to have candidate group '%s', but found it not to have that candidate group!", new Object[]{this.toString(current), candidateGroupId})).isNotNull();
        return this;
    }

    public TaskAssert hasDueDate(Date dueDate) {
        Task current = (Task)this.getExistingCurrent();
        Assertions.assertThat((Date)dueDate).isNotNull();
        ((AbstractDateAssert)Assertions.assertThat((Date)current.getDueDate()).overridingErrorMessage("Expecting %s to be due at '%s', but found it to be due at '%s'!", new Object[]{this.toString(current), dueDate, current.getDueDate()})).isEqualTo((Object)dueDate);
        return this;
    }

    public TaskAssert hasDefinitionKey(String taskDefinitionKey) {
        Task current = (Task)this.getExistingCurrent();
        Assertions.assertThat((String)taskDefinitionKey).isNotNull();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)current.getTaskDefinitionKey()).overridingErrorMessage("Expecting %s to have definition key '%s', but found it to have '%s'!", new Object[]{this.toString(current), taskDefinitionKey, current.getTaskDefinitionKey()})).isEqualTo((Object)taskDefinitionKey);
        return this;
    }

    public TaskAssert hasId(String id) {
        Task current = (Task)this.getExistingCurrent();
        Assertions.assertThat((String)id).isNotNull();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)current.getId()).overridingErrorMessage("Expecting %s to have internal id '%s', but found it to be '%s'!", new Object[]{this.toString(current), id, current.getId()})).isEqualTo((Object)id);
        return this;
    }

    public TaskAssert hasName(String name) {
        Task current = (Task)this.getExistingCurrent();
        Assertions.assertThat((String)name).isNotNull();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)current.getName()).overridingErrorMessage("Expecting %s to have name '%s', but found it to be '%s'!", new Object[]{this.toString(current), name, current.getName()})).isEqualTo((Object)name);
        return this;
    }

    public TaskAssert hasDescription(String description) {
        Task current = (Task)this.getExistingCurrent();
        Assertions.assertThat((String)description).isNotNull();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)current.getDescription()).overridingErrorMessage("Expecting %s to have description '%s', but found it to be '%s'!", new Object[]{this.toString(current), description, current.getDescription()})).isEqualTo((Object)description);
        return this;
    }

    @Override
    protected String toString(Task task) {
        return task != null ? String.format("actual %s {id='%s', processInstanceId='%s', taskDefinitionKey='%s', name='%s'}", Task.class.getSimpleName(), task.getId(), task.getProcessInstanceId(), task.getTaskDefinitionKey(), task.getName()) : null;
    }

    @Override
    protected TaskQuery taskQuery() {
        return super.taskQuery().processInstanceId(((Task)this.actual).getProcessInstanceId());
    }

    @Override
    protected JobQuery jobQuery() {
        return super.jobQuery().processInstanceId(((Task)this.actual).getProcessInstanceId());
    }

    @Override
    protected ProcessInstanceQuery processInstanceQuery() {
        return super.processInstanceQuery().processInstanceId(((Task)this.actual).getProcessInstanceId());
    }

    @Override
    protected ExecutionQuery executionQuery() {
        return super.executionQuery().processInstanceId(((Task)this.actual).getProcessInstanceId());
    }

    @Override
    protected VariableInstanceQuery variableInstanceQuery() {
        return super.variableInstanceQuery().processInstanceIdIn(new String[]{((Task)this.actual).getProcessInstanceId()});
    }

    @Override
    protected HistoricActivityInstanceQuery historicActivityInstanceQuery() {
        return super.historicActivityInstanceQuery().processInstanceId(((Task)this.actual).getProcessInstanceId());
    }

    @Override
    protected HistoricDetailQuery historicDetailQuery() {
        return super.historicDetailQuery().processInstanceId(((Task)this.actual).getProcessInstanceId());
    }

    @Override
    protected HistoricProcessInstanceQuery historicProcessInstanceQuery() {
        return super.historicProcessInstanceQuery().processInstanceId(((Task)this.actual).getProcessInstanceId());
    }

    @Override
    protected HistoricTaskInstanceQuery historicTaskInstanceQuery() {
        return super.historicTaskInstanceQuery().processInstanceId(((Task)this.actual).getProcessInstanceId());
    }

    @Override
    protected HistoricVariableInstanceQuery historicVariableInstanceQuery() {
        return super.historicVariableInstanceQuery().processInstanceId(((Task)this.actual).getProcessInstanceId());
    }

    @Override
    protected ProcessDefinitionQuery processDefinitionQuery() {
        return super.processDefinitionQuery().processDefinitionId(((Task)this.actual).getProcessDefinitionId());
    }
}

