/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.apache.http.protocol;

import java.io.IOException;
import keycloakjar.org.apache.http.HttpEntityEnclosingRequest;
import keycloakjar.org.apache.http.HttpException;
import keycloakjar.org.apache.http.HttpRequest;
import keycloakjar.org.apache.http.HttpRequestInterceptor;
import keycloakjar.org.apache.http.annotation.Contract;
import keycloakjar.org.apache.http.annotation.ThreadingBehavior;
import keycloakjar.org.apache.http.protocol.HttpContext;
import keycloakjar.org.apache.http.protocol.HttpDateGenerator;
import keycloakjar.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.SAFE)
public class RequestDate
implements HttpRequestInterceptor {
    private static final HttpDateGenerator DATE_GENERATOR = new HttpDateGenerator();

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (request instanceof HttpEntityEnclosingRequest && !request.containsHeader("Date")) {
            String httpdate = DATE_GENERATOR.getCurrentDate();
            request.setHeader("Date", httpdate);
        }
    }
}

