/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.http.codec.multipart;

import java.util.Map;
import keycloakjar.org.springframework.core.ResolvableType;
import keycloakjar.org.springframework.core.codec.Hints;
import keycloakjar.org.springframework.core.io.buffer.DataBuffer;
import keycloakjar.org.springframework.core.io.buffer.DataBufferFactory;
import keycloakjar.org.springframework.core.io.buffer.DataBufferUtils;
import keycloakjar.org.springframework.core.io.buffer.PooledDataBuffer;
import keycloakjar.org.springframework.http.HttpHeaders;
import keycloakjar.org.springframework.http.MediaType;
import keycloakjar.org.springframework.http.ReactiveHttpOutputMessage;
import keycloakjar.org.springframework.http.codec.HttpMessageWriter;
import keycloakjar.org.springframework.http.codec.multipart.FilePart;
import keycloakjar.org.springframework.http.codec.multipart.MultipartHttpMessageReader;
import keycloakjar.org.springframework.http.codec.multipart.MultipartWriterSupport;
import keycloakjar.org.springframework.http.codec.multipart.Part;
import keycloakjar.org.springframework.lang.Nullable;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class PartHttpMessageWriter
extends MultipartWriterSupport
implements HttpMessageWriter<Part> {
    public PartHttpMessageWriter() {
        super(MultipartHttpMessageReader.MIME_TYPES);
    }

    @Override
    public Mono<Void> write(Publisher<? extends Part> parts, ResolvableType elementType, @Nullable MediaType mediaType, ReactiveHttpOutputMessage outputMessage, Map<String, Object> hints) {
        byte[] boundary = this.generateMultipartBoundary();
        mediaType = this.getMultipartMediaType(mediaType, boundary);
        outputMessage.getHeaders().setContentType(mediaType);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(Hints.getLogPrefix(hints) + "Encoding Publisher<Part>");
        }
        Flux body = Flux.from(parts).concatMap(part -> this.encodePart(boundary, (Part)part, outputMessage.bufferFactory())).concatWith(this.generateLastLine(boundary, outputMessage.bufferFactory())).doOnDiscard(PooledDataBuffer.class, DataBufferUtils::release);
        if (this.logger.isDebugEnabled()) {
            body = body.doOnNext(buffer -> Hints.touchDataBuffer(buffer, hints, this.logger));
        }
        return outputMessage.writeWith((Publisher<? extends DataBuffer>)body);
    }

    private <T> Flux<DataBuffer> encodePart(byte[] boundary, Part part, DataBufferFactory bufferFactory) {
        HttpHeaders headers = new HttpHeaders(part.headers());
        String name = part.name();
        if (!headers.containsKey("Content-Disposition")) {
            headers.setContentDispositionFormData(name, part instanceof FilePart ? ((FilePart)part).filename() : null);
        }
        return Flux.concat((Publisher[])new Publisher[]{this.generateBoundaryLine(boundary, bufferFactory), this.generatePartHeaders(headers, bufferFactory), part.content(), this.generateNewLine(bufferFactory)});
    }
}

