/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.web.server;

import java.util.Collections;
import java.util.Map;
import keycloakjar.org.springframework.core.NestedExceptionUtils;
import keycloakjar.org.springframework.core.NestedRuntimeException;
import keycloakjar.org.springframework.http.HttpHeaders;
import keycloakjar.org.springframework.http.HttpStatus;
import keycloakjar.org.springframework.lang.Nullable;
import keycloakjar.org.springframework.util.Assert;

public class ResponseStatusException
extends NestedRuntimeException {
    private final int status;
    @Nullable
    private final String reason;

    public ResponseStatusException(HttpStatus status) {
        this(status, null);
    }

    public ResponseStatusException(HttpStatus status, @Nullable String reason) {
        super("");
        Assert.notNull((Object)status, "HttpStatus is required");
        this.status = status.value();
        this.reason = reason;
    }

    public ResponseStatusException(HttpStatus status, @Nullable String reason, @Nullable Throwable cause) {
        super(null, cause);
        Assert.notNull((Object)status, "HttpStatus is required");
        this.status = status.value();
        this.reason = reason;
    }

    public ResponseStatusException(int rawStatusCode, @Nullable String reason, @Nullable Throwable cause) {
        super(null, cause);
        this.status = rawStatusCode;
        this.reason = reason;
    }

    public HttpStatus getStatus() {
        return HttpStatus.valueOf(this.status);
    }

    public int getRawStatusCode() {
        return this.status;
    }

    @Deprecated
    public Map<String, String> getHeaders() {
        return Collections.emptyMap();
    }

    public HttpHeaders getResponseHeaders() {
        Map<String, String> headers = this.getHeaders();
        if (headers.isEmpty()) {
            return HttpHeaders.EMPTY;
        }
        HttpHeaders result = new HttpHeaders();
        this.getHeaders().forEach(result::add);
        return result;
    }

    @Nullable
    public String getReason() {
        return this.reason;
    }

    @Override
    public String getMessage() {
        HttpStatus code = HttpStatus.resolve(this.status);
        String msg = (code != null ? code : Integer.valueOf(this.status)) + (this.reason != null ? " \"" + this.reason + "\"" : "");
        return NestedExceptionUtils.buildMessage(msg, this.getCause());
    }
}

