/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.keycloak.rest;

import org.camunda.bpm.extension.keycloak.KeycloakContextProvider;
import org.camunda.bpm.extension.keycloak.util.KeycloakPluginLogger;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

public class KeycloakRestTemplate
extends RestTemplate {
    private KeycloakContextProvider keycloakContextProvider;

    public <T> ResponseEntity<T> exchange(String url, HttpMethod method, Class<T> responseType, Object ... uriVariables) throws RestClientException {
        return this.exchange(url, method, this.keycloakContextProvider.createApiRequestEntity(), responseType, uriVariables);
    }

    public <T> ResponseEntity<T> exchange(String url, HttpMethod method, HttpEntity<?> requestEntity, Class<T> responseType, Object ... uriVariables) throws RestClientException {
        try {
            return super.exchange(url, method, requestEntity, responseType, uriVariables);
        }
        catch (HttpClientErrorException.Unauthorized u) {
            KeycloakPluginLogger.INSTANCE.requestFailedUnauthorized(url);
            this.keycloakContextProvider.invalidateToken();
            return super.exchange(url, method, this.keycloakContextProvider.createApiRequestEntity(), responseType, uriVariables);
        }
    }

    public void registerKeycloakContextProvider(KeycloakContextProvider keycloakContextProvider) {
        this.keycloakContextProvider = keycloakContextProvider;
    }
}

