/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.spring.boot.starter;

import java.util.List;
import org.camunda.bpm.engine.impl.cfg.CompositeProcessEnginePlugin;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.cfg.ProcessEnginePlugin;
import org.camunda.bpm.engine.spring.SpringProcessEngineConfiguration;
import org.camunda.bpm.spring.boot.starter.configuration.CamundaAuthorizationConfiguration;
import org.camunda.bpm.spring.boot.starter.configuration.CamundaDatasourceConfiguration;
import org.camunda.bpm.spring.boot.starter.configuration.CamundaDeploymentConfiguration;
import org.camunda.bpm.spring.boot.starter.configuration.CamundaFailedJobConfiguration;
import org.camunda.bpm.spring.boot.starter.configuration.CamundaHistoryConfiguration;
import org.camunda.bpm.spring.boot.starter.configuration.CamundaHistoryLevelAutoHandlingConfiguration;
import org.camunda.bpm.spring.boot.starter.configuration.CamundaJobConfiguration;
import org.camunda.bpm.spring.boot.starter.configuration.CamundaJpaConfiguration;
import org.camunda.bpm.spring.boot.starter.configuration.CamundaMetricsConfiguration;
import org.camunda.bpm.spring.boot.starter.configuration.CamundaProcessEngineConfiguration;
import org.camunda.bpm.spring.boot.starter.configuration.condition.NeedsHistoryAutoConfigurationCondition;
import org.camunda.bpm.spring.boot.starter.configuration.id.IdGeneratorConfiguration;
import org.camunda.bpm.spring.boot.starter.configuration.impl.CreateAdminUserConfiguration;
import org.camunda.bpm.spring.boot.starter.configuration.impl.CreateFilterConfiguration;
import org.camunda.bpm.spring.boot.starter.configuration.impl.DefaultAuthorizationConfiguration;
import org.camunda.bpm.spring.boot.starter.configuration.impl.DefaultDatasourceConfiguration;
import org.camunda.bpm.spring.boot.starter.configuration.impl.DefaultDeploymentConfiguration;
import org.camunda.bpm.spring.boot.starter.configuration.impl.DefaultFailedJobConfiguration;
import org.camunda.bpm.spring.boot.starter.configuration.impl.DefaultHistoryConfiguration;
import org.camunda.bpm.spring.boot.starter.configuration.impl.DefaultHistoryLevelAutoHandlingConfiguration;
import org.camunda.bpm.spring.boot.starter.configuration.impl.DefaultJobConfiguration;
import org.camunda.bpm.spring.boot.starter.configuration.impl.DefaultJpaConfiguration;
import org.camunda.bpm.spring.boot.starter.configuration.impl.DefaultMetricsConfiguration;
import org.camunda.bpm.spring.boot.starter.configuration.impl.DefaultProcessEngineConfiguration;
import org.camunda.bpm.spring.boot.starter.configuration.impl.EnterLicenseKeyConfiguration;
import org.camunda.bpm.spring.boot.starter.configuration.impl.GenericPropertiesConfiguration;
import org.camunda.bpm.spring.boot.starter.jdbc.HistoryLevelDeterminator;
import org.camunda.bpm.spring.boot.starter.jdbc.HistoryLevelDeterminatorJdbcTemplateImpl;
import org.camunda.bpm.spring.boot.starter.property.CamundaBpmProperties;
import org.camunda.bpm.spring.boot.starter.util.CamundaSpringBootUtil;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Import;
import org.springframework.jdbc.core.JdbcTemplate;

@Import(value={DefaultJobConfiguration.JobConfiguration.class, IdGeneratorConfiguration.class})
public class CamundaBpmConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={ProcessEngineConfigurationImpl.class})
    public ProcessEngineConfigurationImpl processEngineConfigurationImpl(List<ProcessEnginePlugin> processEnginePlugins) {
        SpringProcessEngineConfiguration configuration = CamundaSpringBootUtil.springProcessEngineConfiguration();
        configuration.getProcessEnginePlugins().add(new CompositeProcessEnginePlugin(processEnginePlugins));
        return configuration;
    }

    @Bean
    @ConditionalOnMissingBean(value={DefaultProcessEngineConfiguration.class})
    public static CamundaProcessEngineConfiguration camundaProcessEngineConfiguration() {
        return new DefaultProcessEngineConfiguration();
    }

    @Bean
    @ConditionalOnMissingBean(value={CamundaDatasourceConfiguration.class})
    public static CamundaDatasourceConfiguration camundaDatasourceConfiguration() {
        return new DefaultDatasourceConfiguration();
    }

    @Bean
    @ConditionalOnBean(name={"entityManagerFactory"})
    @ConditionalOnMissingBean(value={CamundaJpaConfiguration.class})
    @ConditionalOnProperty(prefix="camunda.bpm.jpa", name={"enabled"}, havingValue="true", matchIfMissing=true)
    public static CamundaJpaConfiguration camundaJpaConfiguration() {
        return new DefaultJpaConfiguration();
    }

    @Bean
    @ConditionalOnMissingBean(value={CamundaJobConfiguration.class})
    @ConditionalOnProperty(prefix="camunda.bpm.job-execution", name={"enabled"}, havingValue="true", matchIfMissing=true)
    public static CamundaJobConfiguration camundaJobConfiguration() {
        return new DefaultJobConfiguration();
    }

    @Bean
    @ConditionalOnMissingBean(value={CamundaHistoryConfiguration.class})
    public static CamundaHistoryConfiguration camundaHistoryConfiguration() {
        return new DefaultHistoryConfiguration();
    }

    @Bean
    @ConditionalOnMissingBean(value={CamundaMetricsConfiguration.class})
    public static CamundaMetricsConfiguration camundaMetricsConfiguration() {
        return new DefaultMetricsConfiguration();
    }

    @Bean(name={"historyLevelAutoConfiguration"})
    @ConditionalOnMissingBean(value={CamundaHistoryLevelAutoHandlingConfiguration.class})
    @ConditionalOnProperty(prefix="camunda.bpm", name={"history-level"}, havingValue="auto", matchIfMissing=false)
    @Conditional(value={NeedsHistoryAutoConfigurationCondition.class})
    public static CamundaHistoryLevelAutoHandlingConfiguration historyLevelAutoHandlingConfiguration() {
        return new DefaultHistoryLevelAutoHandlingConfiguration();
    }

    @Bean(name={"historyLevelDeterminator"})
    @ConditionalOnMissingBean(name={"camundaBpmJdbcTemplate", "historyLevelDeterminator"})
    @ConditionalOnBean(name={"historyLevelAutoConfiguration"})
    public static HistoryLevelDeterminator historyLevelDeterminator(CamundaBpmProperties camundaBpmProperties, JdbcTemplate jdbcTemplate) {
        return HistoryLevelDeterminatorJdbcTemplateImpl.createHistoryLevelDeterminator(camundaBpmProperties, jdbcTemplate);
    }

    @Bean(name={"historyLevelDeterminator"})
    @ConditionalOnBean(name={"camundaBpmJdbcTemplate", "historyLevelAutoConfiguration", "historyLevelDeterminator"})
    @ConditionalOnMissingBean(name={"historyLevelDeterminator"})
    public static HistoryLevelDeterminator historyLevelDeterminatorMultiDatabase(CamundaBpmProperties camundaBpmProperties, @Qualifier(value="camundaBpmJdbcTemplate") JdbcTemplate jdbcTemplate) {
        return HistoryLevelDeterminatorJdbcTemplateImpl.createHistoryLevelDeterminator(camundaBpmProperties, jdbcTemplate);
    }

    @Bean
    @ConditionalOnMissingBean(value={CamundaAuthorizationConfiguration.class})
    public static CamundaAuthorizationConfiguration camundaAuthorizationConfiguration() {
        return new DefaultAuthorizationConfiguration();
    }

    @Bean
    @ConditionalOnMissingBean(value={CamundaDeploymentConfiguration.class})
    public static CamundaDeploymentConfiguration camundaDeploymentConfiguration() {
        return new DefaultDeploymentConfiguration();
    }

    @Bean
    public GenericPropertiesConfiguration genericPropertiesConfiguration() {
        return new GenericPropertiesConfiguration();
    }

    @Bean
    @ConditionalOnProperty(prefix="camunda.bpm.admin-user", name={"id"})
    public CreateAdminUserConfiguration createAdminUserConfiguration() {
        return new CreateAdminUserConfiguration();
    }

    @Bean
    @ConditionalOnProperty(prefix="camunda.bpm", name={"is-enterprise"}, havingValue="true")
    public EnterLicenseKeyConfiguration enterLicenseKeyConfiguration() {
        return new EnterLicenseKeyConfiguration();
    }

    @Bean
    @ConditionalOnMissingBean(value={CamundaFailedJobConfiguration.class})
    public static CamundaFailedJobConfiguration failedJobConfiguration() {
        return new DefaultFailedJobConfiguration();
    }

    @Bean
    @ConditionalOnProperty(prefix="camunda.bpm.filter", name={"create"})
    public CreateFilterConfiguration createFilterConfiguration() {
        return new CreateFilterConfiguration();
    }
}

