/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.model.xml.impl;

import java.util.ArrayList;
import java.util.Collection;
import org.camunda.bpm.model.xml.Model;
import org.camunda.bpm.model.xml.ModelBuilder;
import org.camunda.bpm.model.xml.ModelException;
import org.camunda.bpm.model.xml.ModelInstance;
import org.camunda.bpm.model.xml.impl.ModelImpl;
import org.camunda.bpm.model.xml.impl.instance.ModelElementInstanceImpl;
import org.camunda.bpm.model.xml.impl.util.ModelUtil;
import org.camunda.bpm.model.xml.instance.DomDocument;
import org.camunda.bpm.model.xml.instance.DomElement;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;
import org.camunda.bpm.model.xml.type.ModelElementType;

public class ModelInstanceImpl
implements ModelInstance {
    protected final DomDocument document;
    protected ModelImpl model;
    protected final ModelBuilder modelBuilder;

    public ModelInstanceImpl(ModelImpl model, ModelBuilder modelBuilder, DomDocument document) {
        this.model = model;
        this.modelBuilder = modelBuilder;
        this.document = document;
    }

    @Override
    public DomDocument getDocument() {
        return this.document;
    }

    @Override
    public ModelElementInstance getDocumentElement() {
        DomElement rootElement = this.document.getRootElement();
        if (rootElement != null) {
            return ModelUtil.getModelElement(rootElement, this);
        }
        return null;
    }

    @Override
    public void setDocumentElement(ModelElementInstance modelElement) {
        ModelUtil.ensureInstanceOf(modelElement, ModelElementInstanceImpl.class);
        DomElement domElement = modelElement.getDomElement();
        this.document.setRootElement(domElement);
    }

    @Override
    public <T extends ModelElementInstance> T newInstance(Class<T> type) {
        ModelElementType modelElementType = this.model.getType(type);
        if (modelElementType != null) {
            return this.newInstance(modelElementType);
        }
        throw new ModelException("Cannot create instance of ModelType " + type + ": no such type registered.");
    }

    @Override
    public <T extends ModelElementInstance> T newInstance(ModelElementType type) {
        ModelElementInstance modelElementInstance = type.newInstance(this);
        ModelUtil.setGeneratedUniqueIdentifier(type, modelElementInstance);
        return (T)modelElementInstance;
    }

    @Override
    public Model getModel() {
        return this.model;
    }

    public ModelElementType registerGenericType(String namespaceUri, String localName) {
        ModelElementType elementType = this.model.getTypeForName(namespaceUri, localName);
        if (elementType == null) {
            elementType = this.modelBuilder.defineGenericType(localName, namespaceUri);
            this.model = (ModelImpl)this.modelBuilder.build();
        }
        return elementType;
    }

    @Override
    public <T extends ModelElementInstance> T getModelElementById(String id) {
        if (id == null) {
            return null;
        }
        DomElement element = this.document.getElementById(id);
        if (element != null) {
            return (T)ModelUtil.getModelElement(element, this);
        }
        return null;
    }

    @Override
    public Collection<ModelElementInstance> getModelElementsByType(ModelElementType type) {
        Collection<ModelElementType> extendingTypes = type.getAllExtendingTypes();
        ArrayList<ModelElementInstance> instances = new ArrayList<ModelElementInstance>();
        for (ModelElementType modelElementType : extendingTypes) {
            if (modelElementType.isAbstract()) continue;
            instances.addAll(modelElementType.getInstances(this));
        }
        return instances;
    }

    @Override
    public <T extends ModelElementInstance> Collection<T> getModelElementsByType(Class<T> referencingClass) {
        return this.getModelElementsByType(this.getModel().getType(referencingClass));
    }

    @Override
    public ModelInstance clone() {
        return new ModelInstanceImpl(this.model, this.modelBuilder, this.document.clone());
    }
}

