/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.model.xml.impl.parser;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.camunda.bpm.model.xml.ModelInstance;
import org.camunda.bpm.model.xml.ModelValidationException;
import org.camunda.bpm.model.xml.impl.util.DomUtil;
import org.camunda.bpm.model.xml.impl.util.ReflectUtil;
import org.camunda.bpm.model.xml.instance.DomDocument;
import org.camunda.bpm.model.xml.instance.DomElement;
import org.xml.sax.SAXException;

public abstract class AbstractModelParser {
    private final DocumentBuilderFactory documentBuilderFactory;
    protected SchemaFactory schemaFactory;
    protected Map<String, Schema> schemas = new HashMap<String, Schema>();

    protected AbstractModelParser() {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        this.configureFactory(dbf);
        this.documentBuilderFactory = dbf;
    }

    protected void configureFactory(DocumentBuilderFactory dbf) {
        dbf.setValidating(true);
        dbf.setIgnoringComments(false);
        dbf.setIgnoringElementContentWhitespace(false);
        dbf.setNamespaceAware(true);
        this.protectAgainstXxeAttacks(dbf);
    }

    private void protectAgainstXxeAttacks(DocumentBuilderFactory dbf) {
        try {
            dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
        }
        catch (ParserConfigurationException ignored) {
            // empty catch block
        }
        try {
            dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        }
        catch (ParserConfigurationException ignored) {
            // empty catch block
        }
        try {
            dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        dbf.setXIncludeAware(false);
        dbf.setExpandEntityReferences(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModelInstance parseModelFromStream(InputStream inputStream) {
        DomDocument document = null;
        DocumentBuilderFactory documentBuilderFactory = this.documentBuilderFactory;
        synchronized (documentBuilderFactory) {
            document = DomUtil.parseInputStream(this.documentBuilderFactory, inputStream);
        }
        this.validateModel(document);
        return this.createModelInstance(document);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModelInstance getEmptyModel() {
        DomDocument document = null;
        DocumentBuilderFactory documentBuilderFactory = this.documentBuilderFactory;
        synchronized (documentBuilderFactory) {
            document = DomUtil.getEmptyDocument(this.documentBuilderFactory);
        }
        return this.createModelInstance(document);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateModel(DomDocument document) {
        Schema schema = this.getSchema(document);
        if (schema == null) {
            return;
        }
        Validator validator = schema.newValidator();
        try {
            DomDocument domDocument = document;
            synchronized (domDocument) {
                validator.validate(document.getDomSource());
            }
        }
        catch (IOException e) {
            throw new ModelValidationException("Error during DOM document validation", e);
        }
        catch (SAXException e) {
            throw new ModelValidationException("DOM document is not valid", e);
        }
    }

    protected Schema getSchema(DomDocument document) {
        DomElement rootElement = document.getRootElement();
        String namespaceURI = rootElement.getNamespaceURI();
        return this.schemas.get(namespaceURI);
    }

    protected void addSchema(String namespaceURI, Schema schema) {
        this.schemas.put(namespaceURI, schema);
    }

    protected Schema createSchema(String location, ClassLoader classLoader) {
        URL cmmnSchema = ReflectUtil.getResource(location, classLoader);
        try {
            return this.schemaFactory.newSchema(cmmnSchema);
        }
        catch (SAXException e) {
            throw new ModelValidationException("Unable to parse schema:" + cmmnSchema);
        }
    }

    protected abstract ModelInstance createModelInstance(DomDocument var1);
}

