/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;
import org.camunda.community.rest.client.dto.BatchDto;
import org.camunda.community.rest.client.dto.CompleteExternalTaskDto;
import org.camunda.community.rest.client.dto.CountResultDto;
import org.camunda.community.rest.client.dto.ExtendLockOnExternalTaskDto;
import org.camunda.community.rest.client.dto.ExternalTaskBpmnError;
import org.camunda.community.rest.client.dto.ExternalTaskDto;
import org.camunda.community.rest.client.dto.ExternalTaskFailureDto;
import org.camunda.community.rest.client.dto.ExternalTaskQueryDto;
import org.camunda.community.rest.client.dto.FetchExternalTasksDto;
import org.camunda.community.rest.client.dto.LockExternalTaskDto;
import org.camunda.community.rest.client.dto.LockedExternalTaskDto;
import org.camunda.community.rest.client.dto.PriorityDto;
import org.camunda.community.rest.client.dto.RetriesDto;
import org.camunda.community.rest.client.dto.SetRetriesForExternalTasksDto;
import org.camunda.community.rest.client.invoker.ApiCallback;
import org.camunda.community.rest.client.invoker.ApiClient;
import org.camunda.community.rest.client.invoker.ApiException;
import org.camunda.community.rest.client.invoker.ApiResponse;
import org.camunda.community.rest.client.invoker.Configuration;
import org.camunda.community.rest.client.invoker.Pair;

public class ExternalTaskApi {
    private ApiClient localVarApiClient;

    public ExternalTaskApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ExternalTaskApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call completeExternalTaskResourceCall(String id, CompleteExternalTaskDto completeExternalTaskDto, ApiCallback _callback) throws ApiException {
        CompleteExternalTaskDto localVarPostBody = completeExternalTaskDto;
        String localVarPath = "/external-task/{id}/complete".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call completeExternalTaskResourceValidateBeforeCall(String id, CompleteExternalTaskDto completeExternalTaskDto, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling completeExternalTaskResource(Async)");
        }
        Call localVarCall = this.completeExternalTaskResourceCall(id, completeExternalTaskDto, _callback);
        return localVarCall;
    }

    public void completeExternalTaskResource(String id, CompleteExternalTaskDto completeExternalTaskDto) throws ApiException {
        this.completeExternalTaskResourceWithHttpInfo(id, completeExternalTaskDto);
    }

    public ApiResponse<Void> completeExternalTaskResourceWithHttpInfo(String id, CompleteExternalTaskDto completeExternalTaskDto) throws ApiException {
        Call localVarCall = this.completeExternalTaskResourceValidateBeforeCall(id, completeExternalTaskDto, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call completeExternalTaskResourceAsync(String id, CompleteExternalTaskDto completeExternalTaskDto, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.completeExternalTaskResourceValidateBeforeCall(id, completeExternalTaskDto, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call extendLockCall(String id, ExtendLockOnExternalTaskDto extendLockOnExternalTaskDto, ApiCallback _callback) throws ApiException {
        ExtendLockOnExternalTaskDto localVarPostBody = extendLockOnExternalTaskDto;
        String localVarPath = "/external-task/{id}/extendLock".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call extendLockValidateBeforeCall(String id, ExtendLockOnExternalTaskDto extendLockOnExternalTaskDto, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling extendLock(Async)");
        }
        Call localVarCall = this.extendLockCall(id, extendLockOnExternalTaskDto, _callback);
        return localVarCall;
    }

    public void extendLock(String id, ExtendLockOnExternalTaskDto extendLockOnExternalTaskDto) throws ApiException {
        this.extendLockWithHttpInfo(id, extendLockOnExternalTaskDto);
    }

    public ApiResponse<Void> extendLockWithHttpInfo(String id, ExtendLockOnExternalTaskDto extendLockOnExternalTaskDto) throws ApiException {
        Call localVarCall = this.extendLockValidateBeforeCall(id, extendLockOnExternalTaskDto, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call extendLockAsync(String id, ExtendLockOnExternalTaskDto extendLockOnExternalTaskDto, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.extendLockValidateBeforeCall(id, extendLockOnExternalTaskDto, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call fetchAndLockCall(FetchExternalTasksDto fetchExternalTasksDto, ApiCallback _callback) throws ApiException {
        FetchExternalTasksDto localVarPostBody = fetchExternalTasksDto;
        String localVarPath = "/external-task/fetchAndLock";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call fetchAndLockValidateBeforeCall(FetchExternalTasksDto fetchExternalTasksDto, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.fetchAndLockCall(fetchExternalTasksDto, _callback);
        return localVarCall;
    }

    public List<LockedExternalTaskDto> fetchAndLock(FetchExternalTasksDto fetchExternalTasksDto) throws ApiException {
        ApiResponse<List<LockedExternalTaskDto>> localVarResp = this.fetchAndLockWithHttpInfo(fetchExternalTasksDto);
        return localVarResp.getData();
    }

    public ApiResponse<List<LockedExternalTaskDto>> fetchAndLockWithHttpInfo(FetchExternalTasksDto fetchExternalTasksDto) throws ApiException {
        Call localVarCall = this.fetchAndLockValidateBeforeCall(fetchExternalTasksDto, null);
        Type localVarReturnType = new TypeToken<List<LockedExternalTaskDto>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call fetchAndLockAsync(FetchExternalTasksDto fetchExternalTasksDto, ApiCallback<List<LockedExternalTaskDto>> _callback) throws ApiException {
        Call localVarCall = this.fetchAndLockValidateBeforeCall(fetchExternalTasksDto, _callback);
        Type localVarReturnType = new TypeToken<List<LockedExternalTaskDto>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getExternalTaskCall(String id, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/external-task/{id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getExternalTaskValidateBeforeCall(String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getExternalTask(Async)");
        }
        Call localVarCall = this.getExternalTaskCall(id, _callback);
        return localVarCall;
    }

    public ExternalTaskDto getExternalTask(String id) throws ApiException {
        ApiResponse<ExternalTaskDto> localVarResp = this.getExternalTaskWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<ExternalTaskDto> getExternalTaskWithHttpInfo(String id) throws ApiException {
        Call localVarCall = this.getExternalTaskValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<ExternalTaskDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getExternalTaskAsync(String id, ApiCallback<ExternalTaskDto> _callback) throws ApiException {
        Call localVarCall = this.getExternalTaskValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<ExternalTaskDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getExternalTaskErrorDetailsCall(String id, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/external-task/{id}/errorDetails".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"text/plain", "application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getExternalTaskErrorDetailsValidateBeforeCall(String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getExternalTaskErrorDetails(Async)");
        }
        Call localVarCall = this.getExternalTaskErrorDetailsCall(id, _callback);
        return localVarCall;
    }

    public String getExternalTaskErrorDetails(String id) throws ApiException {
        ApiResponse<String> localVarResp = this.getExternalTaskErrorDetailsWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<String> getExternalTaskErrorDetailsWithHttpInfo(String id) throws ApiException {
        Call localVarCall = this.getExternalTaskErrorDetailsValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getExternalTaskErrorDetailsAsync(String id, ApiCallback<String> _callback) throws ApiException {
        Call localVarCall = this.getExternalTaskErrorDetailsValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getExternalTasksCall(String externalTaskId, String externalTaskIdIn, String topicName, String workerId, Boolean locked, Boolean notLocked, Boolean withRetriesLeft, Boolean noRetriesLeft, Date lockExpirationAfter, Date lockExpirationBefore, String activityId, String activityIdIn, String executionId, String processInstanceId, String processInstanceIdIn, String processDefinitionId, String tenantIdIn, Boolean active, Boolean suspended, Long priorityHigherThanOrEquals, Long priorityLowerThanOrEquals, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/external-task";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (externalTaskId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("externalTaskId", externalTaskId));
        }
        if (externalTaskIdIn != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("externalTaskIdIn", externalTaskIdIn));
        }
        if (topicName != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("topicName", topicName));
        }
        if (workerId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("workerId", workerId));
        }
        if (locked != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("locked", locked));
        }
        if (notLocked != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("notLocked", notLocked));
        }
        if (withRetriesLeft != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("withRetriesLeft", withRetriesLeft));
        }
        if (noRetriesLeft != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("noRetriesLeft", noRetriesLeft));
        }
        if (lockExpirationAfter != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("lockExpirationAfter", lockExpirationAfter));
        }
        if (lockExpirationBefore != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("lockExpirationBefore", lockExpirationBefore));
        }
        if (activityId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("activityId", activityId));
        }
        if (activityIdIn != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("activityIdIn", activityIdIn));
        }
        if (executionId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("executionId", executionId));
        }
        if (processInstanceId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("processInstanceId", processInstanceId));
        }
        if (processInstanceIdIn != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("processInstanceIdIn", processInstanceIdIn));
        }
        if (processDefinitionId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("processDefinitionId", processDefinitionId));
        }
        if (tenantIdIn != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("tenantIdIn", tenantIdIn));
        }
        if (active != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("active", active));
        }
        if (suspended != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("suspended", suspended));
        }
        if (priorityHigherThanOrEquals != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("priorityHigherThanOrEquals", priorityHigherThanOrEquals));
        }
        if (priorityLowerThanOrEquals != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("priorityLowerThanOrEquals", priorityLowerThanOrEquals));
        }
        if (sortBy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sortBy", sortBy));
        }
        if (sortOrder != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sortOrder", sortOrder));
        }
        if (firstResult != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("firstResult", firstResult));
        }
        if (maxResults != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("maxResults", maxResults));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getExternalTasksValidateBeforeCall(String externalTaskId, String externalTaskIdIn, String topicName, String workerId, Boolean locked, Boolean notLocked, Boolean withRetriesLeft, Boolean noRetriesLeft, Date lockExpirationAfter, Date lockExpirationBefore, String activityId, String activityIdIn, String executionId, String processInstanceId, String processInstanceIdIn, String processDefinitionId, String tenantIdIn, Boolean active, Boolean suspended, Long priorityHigherThanOrEquals, Long priorityLowerThanOrEquals, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getExternalTasksCall(externalTaskId, externalTaskIdIn, topicName, workerId, locked, notLocked, withRetriesLeft, noRetriesLeft, lockExpirationAfter, lockExpirationBefore, activityId, activityIdIn, executionId, processInstanceId, processInstanceIdIn, processDefinitionId, tenantIdIn, active, suspended, priorityHigherThanOrEquals, priorityLowerThanOrEquals, sortBy, sortOrder, firstResult, maxResults, _callback);
        return localVarCall;
    }

    public List<ExternalTaskDto> getExternalTasks(String externalTaskId, String externalTaskIdIn, String topicName, String workerId, Boolean locked, Boolean notLocked, Boolean withRetriesLeft, Boolean noRetriesLeft, Date lockExpirationAfter, Date lockExpirationBefore, String activityId, String activityIdIn, String executionId, String processInstanceId, String processInstanceIdIn, String processDefinitionId, String tenantIdIn, Boolean active, Boolean suspended, Long priorityHigherThanOrEquals, Long priorityLowerThanOrEquals, String sortBy, String sortOrder, Integer firstResult, Integer maxResults) throws ApiException {
        ApiResponse<List<ExternalTaskDto>> localVarResp = this.getExternalTasksWithHttpInfo(externalTaskId, externalTaskIdIn, topicName, workerId, locked, notLocked, withRetriesLeft, noRetriesLeft, lockExpirationAfter, lockExpirationBefore, activityId, activityIdIn, executionId, processInstanceId, processInstanceIdIn, processDefinitionId, tenantIdIn, active, suspended, priorityHigherThanOrEquals, priorityLowerThanOrEquals, sortBy, sortOrder, firstResult, maxResults);
        return localVarResp.getData();
    }

    public ApiResponse<List<ExternalTaskDto>> getExternalTasksWithHttpInfo(String externalTaskId, String externalTaskIdIn, String topicName, String workerId, Boolean locked, Boolean notLocked, Boolean withRetriesLeft, Boolean noRetriesLeft, Date lockExpirationAfter, Date lockExpirationBefore, String activityId, String activityIdIn, String executionId, String processInstanceId, String processInstanceIdIn, String processDefinitionId, String tenantIdIn, Boolean active, Boolean suspended, Long priorityHigherThanOrEquals, Long priorityLowerThanOrEquals, String sortBy, String sortOrder, Integer firstResult, Integer maxResults) throws ApiException {
        Call localVarCall = this.getExternalTasksValidateBeforeCall(externalTaskId, externalTaskIdIn, topicName, workerId, locked, notLocked, withRetriesLeft, noRetriesLeft, lockExpirationAfter, lockExpirationBefore, activityId, activityIdIn, executionId, processInstanceId, processInstanceIdIn, processDefinitionId, tenantIdIn, active, suspended, priorityHigherThanOrEquals, priorityLowerThanOrEquals, sortBy, sortOrder, firstResult, maxResults, null);
        Type localVarReturnType = new TypeToken<List<ExternalTaskDto>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getExternalTasksAsync(String externalTaskId, String externalTaskIdIn, String topicName, String workerId, Boolean locked, Boolean notLocked, Boolean withRetriesLeft, Boolean noRetriesLeft, Date lockExpirationAfter, Date lockExpirationBefore, String activityId, String activityIdIn, String executionId, String processInstanceId, String processInstanceIdIn, String processDefinitionId, String tenantIdIn, Boolean active, Boolean suspended, Long priorityHigherThanOrEquals, Long priorityLowerThanOrEquals, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, ApiCallback<List<ExternalTaskDto>> _callback) throws ApiException {
        Call localVarCall = this.getExternalTasksValidateBeforeCall(externalTaskId, externalTaskIdIn, topicName, workerId, locked, notLocked, withRetriesLeft, noRetriesLeft, lockExpirationAfter, lockExpirationBefore, activityId, activityIdIn, executionId, processInstanceId, processInstanceIdIn, processDefinitionId, tenantIdIn, active, suspended, priorityHigherThanOrEquals, priorityLowerThanOrEquals, sortBy, sortOrder, firstResult, maxResults, _callback);
        Type localVarReturnType = new TypeToken<List<ExternalTaskDto>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getExternalTasksCountCall(String externalTaskId, String externalTaskIdIn, String topicName, String workerId, Boolean locked, Boolean notLocked, Boolean withRetriesLeft, Boolean noRetriesLeft, Date lockExpirationAfter, Date lockExpirationBefore, String activityId, String activityIdIn, String executionId, String processInstanceId, String processInstanceIdIn, String processDefinitionId, String tenantIdIn, Boolean active, Boolean suspended, Long priorityHigherThanOrEquals, Long priorityLowerThanOrEquals, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/external-task/count";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (externalTaskId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("externalTaskId", externalTaskId));
        }
        if (externalTaskIdIn != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("externalTaskIdIn", externalTaskIdIn));
        }
        if (topicName != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("topicName", topicName));
        }
        if (workerId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("workerId", workerId));
        }
        if (locked != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("locked", locked));
        }
        if (notLocked != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("notLocked", notLocked));
        }
        if (withRetriesLeft != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("withRetriesLeft", withRetriesLeft));
        }
        if (noRetriesLeft != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("noRetriesLeft", noRetriesLeft));
        }
        if (lockExpirationAfter != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("lockExpirationAfter", lockExpirationAfter));
        }
        if (lockExpirationBefore != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("lockExpirationBefore", lockExpirationBefore));
        }
        if (activityId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("activityId", activityId));
        }
        if (activityIdIn != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("activityIdIn", activityIdIn));
        }
        if (executionId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("executionId", executionId));
        }
        if (processInstanceId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("processInstanceId", processInstanceId));
        }
        if (processInstanceIdIn != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("processInstanceIdIn", processInstanceIdIn));
        }
        if (processDefinitionId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("processDefinitionId", processDefinitionId));
        }
        if (tenantIdIn != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("tenantIdIn", tenantIdIn));
        }
        if (active != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("active", active));
        }
        if (suspended != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("suspended", suspended));
        }
        if (priorityHigherThanOrEquals != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("priorityHigherThanOrEquals", priorityHigherThanOrEquals));
        }
        if (priorityLowerThanOrEquals != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("priorityLowerThanOrEquals", priorityLowerThanOrEquals));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getExternalTasksCountValidateBeforeCall(String externalTaskId, String externalTaskIdIn, String topicName, String workerId, Boolean locked, Boolean notLocked, Boolean withRetriesLeft, Boolean noRetriesLeft, Date lockExpirationAfter, Date lockExpirationBefore, String activityId, String activityIdIn, String executionId, String processInstanceId, String processInstanceIdIn, String processDefinitionId, String tenantIdIn, Boolean active, Boolean suspended, Long priorityHigherThanOrEquals, Long priorityLowerThanOrEquals, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getExternalTasksCountCall(externalTaskId, externalTaskIdIn, topicName, workerId, locked, notLocked, withRetriesLeft, noRetriesLeft, lockExpirationAfter, lockExpirationBefore, activityId, activityIdIn, executionId, processInstanceId, processInstanceIdIn, processDefinitionId, tenantIdIn, active, suspended, priorityHigherThanOrEquals, priorityLowerThanOrEquals, _callback);
        return localVarCall;
    }

    public CountResultDto getExternalTasksCount(String externalTaskId, String externalTaskIdIn, String topicName, String workerId, Boolean locked, Boolean notLocked, Boolean withRetriesLeft, Boolean noRetriesLeft, Date lockExpirationAfter, Date lockExpirationBefore, String activityId, String activityIdIn, String executionId, String processInstanceId, String processInstanceIdIn, String processDefinitionId, String tenantIdIn, Boolean active, Boolean suspended, Long priorityHigherThanOrEquals, Long priorityLowerThanOrEquals) throws ApiException {
        ApiResponse<CountResultDto> localVarResp = this.getExternalTasksCountWithHttpInfo(externalTaskId, externalTaskIdIn, topicName, workerId, locked, notLocked, withRetriesLeft, noRetriesLeft, lockExpirationAfter, lockExpirationBefore, activityId, activityIdIn, executionId, processInstanceId, processInstanceIdIn, processDefinitionId, tenantIdIn, active, suspended, priorityHigherThanOrEquals, priorityLowerThanOrEquals);
        return localVarResp.getData();
    }

    public ApiResponse<CountResultDto> getExternalTasksCountWithHttpInfo(String externalTaskId, String externalTaskIdIn, String topicName, String workerId, Boolean locked, Boolean notLocked, Boolean withRetriesLeft, Boolean noRetriesLeft, Date lockExpirationAfter, Date lockExpirationBefore, String activityId, String activityIdIn, String executionId, String processInstanceId, String processInstanceIdIn, String processDefinitionId, String tenantIdIn, Boolean active, Boolean suspended, Long priorityHigherThanOrEquals, Long priorityLowerThanOrEquals) throws ApiException {
        Call localVarCall = this.getExternalTasksCountValidateBeforeCall(externalTaskId, externalTaskIdIn, topicName, workerId, locked, notLocked, withRetriesLeft, noRetriesLeft, lockExpirationAfter, lockExpirationBefore, activityId, activityIdIn, executionId, processInstanceId, processInstanceIdIn, processDefinitionId, tenantIdIn, active, suspended, priorityHigherThanOrEquals, priorityLowerThanOrEquals, null);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getExternalTasksCountAsync(String externalTaskId, String externalTaskIdIn, String topicName, String workerId, Boolean locked, Boolean notLocked, Boolean withRetriesLeft, Boolean noRetriesLeft, Date lockExpirationAfter, Date lockExpirationBefore, String activityId, String activityIdIn, String executionId, String processInstanceId, String processInstanceIdIn, String processDefinitionId, String tenantIdIn, Boolean active, Boolean suspended, Long priorityHigherThanOrEquals, Long priorityLowerThanOrEquals, ApiCallback<CountResultDto> _callback) throws ApiException {
        Call localVarCall = this.getExternalTasksCountValidateBeforeCall(externalTaskId, externalTaskIdIn, topicName, workerId, locked, notLocked, withRetriesLeft, noRetriesLeft, lockExpirationAfter, lockExpirationBefore, activityId, activityIdIn, executionId, processInstanceId, processInstanceIdIn, processDefinitionId, tenantIdIn, active, suspended, priorityHigherThanOrEquals, priorityLowerThanOrEquals, _callback);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getTopicNamesCall(Boolean withLockedTasks, Boolean withUnlockedTasks, Boolean withRetriesLeft, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/external-task/topic-names";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (withLockedTasks != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("withLockedTasks", withLockedTasks));
        }
        if (withUnlockedTasks != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("withUnlockedTasks", withUnlockedTasks));
        }
        if (withRetriesLeft != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("withRetriesLeft", withRetriesLeft));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getTopicNamesValidateBeforeCall(Boolean withLockedTasks, Boolean withUnlockedTasks, Boolean withRetriesLeft, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getTopicNamesCall(withLockedTasks, withUnlockedTasks, withRetriesLeft, _callback);
        return localVarCall;
    }

    public List<String> getTopicNames(Boolean withLockedTasks, Boolean withUnlockedTasks, Boolean withRetriesLeft) throws ApiException {
        ApiResponse<List<String>> localVarResp = this.getTopicNamesWithHttpInfo(withLockedTasks, withUnlockedTasks, withRetriesLeft);
        return localVarResp.getData();
    }

    public ApiResponse<List<String>> getTopicNamesWithHttpInfo(Boolean withLockedTasks, Boolean withUnlockedTasks, Boolean withRetriesLeft) throws ApiException {
        Call localVarCall = this.getTopicNamesValidateBeforeCall(withLockedTasks, withUnlockedTasks, withRetriesLeft, null);
        Type localVarReturnType = new TypeToken<List<String>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getTopicNamesAsync(Boolean withLockedTasks, Boolean withUnlockedTasks, Boolean withRetriesLeft, ApiCallback<List<String>> _callback) throws ApiException {
        Call localVarCall = this.getTopicNamesValidateBeforeCall(withLockedTasks, withUnlockedTasks, withRetriesLeft, _callback);
        Type localVarReturnType = new TypeToken<List<String>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call handleExternalTaskBpmnErrorCall(String id, ExternalTaskBpmnError externalTaskBpmnError, ApiCallback _callback) throws ApiException {
        ExternalTaskBpmnError localVarPostBody = externalTaskBpmnError;
        String localVarPath = "/external-task/{id}/bpmnError".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call handleExternalTaskBpmnErrorValidateBeforeCall(String id, ExternalTaskBpmnError externalTaskBpmnError, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling handleExternalTaskBpmnError(Async)");
        }
        Call localVarCall = this.handleExternalTaskBpmnErrorCall(id, externalTaskBpmnError, _callback);
        return localVarCall;
    }

    public void handleExternalTaskBpmnError(String id, ExternalTaskBpmnError externalTaskBpmnError) throws ApiException {
        this.handleExternalTaskBpmnErrorWithHttpInfo(id, externalTaskBpmnError);
    }

    public ApiResponse<Void> handleExternalTaskBpmnErrorWithHttpInfo(String id, ExternalTaskBpmnError externalTaskBpmnError) throws ApiException {
        Call localVarCall = this.handleExternalTaskBpmnErrorValidateBeforeCall(id, externalTaskBpmnError, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call handleExternalTaskBpmnErrorAsync(String id, ExternalTaskBpmnError externalTaskBpmnError, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.handleExternalTaskBpmnErrorValidateBeforeCall(id, externalTaskBpmnError, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call handleFailureCall(String id, ExternalTaskFailureDto externalTaskFailureDto, ApiCallback _callback) throws ApiException {
        ExternalTaskFailureDto localVarPostBody = externalTaskFailureDto;
        String localVarPath = "/external-task/{id}/failure".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call handleFailureValidateBeforeCall(String id, ExternalTaskFailureDto externalTaskFailureDto, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling handleFailure(Async)");
        }
        Call localVarCall = this.handleFailureCall(id, externalTaskFailureDto, _callback);
        return localVarCall;
    }

    public void handleFailure(String id, ExternalTaskFailureDto externalTaskFailureDto) throws ApiException {
        this.handleFailureWithHttpInfo(id, externalTaskFailureDto);
    }

    public ApiResponse<Void> handleFailureWithHttpInfo(String id, ExternalTaskFailureDto externalTaskFailureDto) throws ApiException {
        Call localVarCall = this.handleFailureValidateBeforeCall(id, externalTaskFailureDto, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call handleFailureAsync(String id, ExternalTaskFailureDto externalTaskFailureDto, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.handleFailureValidateBeforeCall(id, externalTaskFailureDto, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call lockCall(String id, LockExternalTaskDto lockExternalTaskDto, ApiCallback _callback) throws ApiException {
        LockExternalTaskDto localVarPostBody = lockExternalTaskDto;
        String localVarPath = "/external-task/{id}/lock".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call lockValidateBeforeCall(String id, LockExternalTaskDto lockExternalTaskDto, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling lock(Async)");
        }
        Call localVarCall = this.lockCall(id, lockExternalTaskDto, _callback);
        return localVarCall;
    }

    public void lock(String id, LockExternalTaskDto lockExternalTaskDto) throws ApiException {
        this.lockWithHttpInfo(id, lockExternalTaskDto);
    }

    public ApiResponse<Void> lockWithHttpInfo(String id, LockExternalTaskDto lockExternalTaskDto) throws ApiException {
        Call localVarCall = this.lockValidateBeforeCall(id, lockExternalTaskDto, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call lockAsync(String id, LockExternalTaskDto lockExternalTaskDto, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.lockValidateBeforeCall(id, lockExternalTaskDto, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call queryExternalTasksCall(Integer firstResult, Integer maxResults, ExternalTaskQueryDto externalTaskQueryDto, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        ExternalTaskQueryDto localVarPostBody = externalTaskQueryDto;
        String localVarPath = "/external-task";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (firstResult != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("firstResult", firstResult));
        }
        if (maxResults != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("maxResults", maxResults));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call queryExternalTasksValidateBeforeCall(Integer firstResult, Integer maxResults, ExternalTaskQueryDto externalTaskQueryDto, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.queryExternalTasksCall(firstResult, maxResults, externalTaskQueryDto, _callback);
        return localVarCall;
    }

    public List<ExternalTaskDto> queryExternalTasks(Integer firstResult, Integer maxResults, ExternalTaskQueryDto externalTaskQueryDto) throws ApiException {
        ApiResponse<List<ExternalTaskDto>> localVarResp = this.queryExternalTasksWithHttpInfo(firstResult, maxResults, externalTaskQueryDto);
        return localVarResp.getData();
    }

    public ApiResponse<List<ExternalTaskDto>> queryExternalTasksWithHttpInfo(Integer firstResult, Integer maxResults, ExternalTaskQueryDto externalTaskQueryDto) throws ApiException {
        Call localVarCall = this.queryExternalTasksValidateBeforeCall(firstResult, maxResults, externalTaskQueryDto, null);
        Type localVarReturnType = new TypeToken<List<ExternalTaskDto>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call queryExternalTasksAsync(Integer firstResult, Integer maxResults, ExternalTaskQueryDto externalTaskQueryDto, ApiCallback<List<ExternalTaskDto>> _callback) throws ApiException {
        Call localVarCall = this.queryExternalTasksValidateBeforeCall(firstResult, maxResults, externalTaskQueryDto, _callback);
        Type localVarReturnType = new TypeToken<List<ExternalTaskDto>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call queryExternalTasksCountCall(ExternalTaskQueryDto externalTaskQueryDto, ApiCallback _callback) throws ApiException {
        ExternalTaskQueryDto localVarPostBody = externalTaskQueryDto;
        String localVarPath = "/external-task/count";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call queryExternalTasksCountValidateBeforeCall(ExternalTaskQueryDto externalTaskQueryDto, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.queryExternalTasksCountCall(externalTaskQueryDto, _callback);
        return localVarCall;
    }

    public CountResultDto queryExternalTasksCount(ExternalTaskQueryDto externalTaskQueryDto) throws ApiException {
        ApiResponse<CountResultDto> localVarResp = this.queryExternalTasksCountWithHttpInfo(externalTaskQueryDto);
        return localVarResp.getData();
    }

    public ApiResponse<CountResultDto> queryExternalTasksCountWithHttpInfo(ExternalTaskQueryDto externalTaskQueryDto) throws ApiException {
        Call localVarCall = this.queryExternalTasksCountValidateBeforeCall(externalTaskQueryDto, null);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call queryExternalTasksCountAsync(ExternalTaskQueryDto externalTaskQueryDto, ApiCallback<CountResultDto> _callback) throws ApiException {
        Call localVarCall = this.queryExternalTasksCountValidateBeforeCall(externalTaskQueryDto, _callback);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call setExternalTaskResourcePriorityCall(String id, PriorityDto priorityDto, ApiCallback _callback) throws ApiException {
        PriorityDto localVarPostBody = priorityDto;
        String localVarPath = "/external-task/{id}/priority".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call setExternalTaskResourcePriorityValidateBeforeCall(String id, PriorityDto priorityDto, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling setExternalTaskResourcePriority(Async)");
        }
        Call localVarCall = this.setExternalTaskResourcePriorityCall(id, priorityDto, _callback);
        return localVarCall;
    }

    public void setExternalTaskResourcePriority(String id, PriorityDto priorityDto) throws ApiException {
        this.setExternalTaskResourcePriorityWithHttpInfo(id, priorityDto);
    }

    public ApiResponse<Void> setExternalTaskResourcePriorityWithHttpInfo(String id, PriorityDto priorityDto) throws ApiException {
        Call localVarCall = this.setExternalTaskResourcePriorityValidateBeforeCall(id, priorityDto, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call setExternalTaskResourcePriorityAsync(String id, PriorityDto priorityDto, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.setExternalTaskResourcePriorityValidateBeforeCall(id, priorityDto, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call setExternalTaskResourceRetriesCall(String id, RetriesDto retriesDto, ApiCallback _callback) throws ApiException {
        RetriesDto localVarPostBody = retriesDto;
        String localVarPath = "/external-task/{id}/retries".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call setExternalTaskResourceRetriesValidateBeforeCall(String id, RetriesDto retriesDto, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling setExternalTaskResourceRetries(Async)");
        }
        Call localVarCall = this.setExternalTaskResourceRetriesCall(id, retriesDto, _callback);
        return localVarCall;
    }

    public void setExternalTaskResourceRetries(String id, RetriesDto retriesDto) throws ApiException {
        this.setExternalTaskResourceRetriesWithHttpInfo(id, retriesDto);
    }

    public ApiResponse<Void> setExternalTaskResourceRetriesWithHttpInfo(String id, RetriesDto retriesDto) throws ApiException {
        Call localVarCall = this.setExternalTaskResourceRetriesValidateBeforeCall(id, retriesDto, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call setExternalTaskResourceRetriesAsync(String id, RetriesDto retriesDto, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.setExternalTaskResourceRetriesValidateBeforeCall(id, retriesDto, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call setExternalTaskRetriesCall(SetRetriesForExternalTasksDto setRetriesForExternalTasksDto, ApiCallback _callback) throws ApiException {
        SetRetriesForExternalTasksDto localVarPostBody = setRetriesForExternalTasksDto;
        String localVarPath = "/external-task/retries";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call setExternalTaskRetriesValidateBeforeCall(SetRetriesForExternalTasksDto setRetriesForExternalTasksDto, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.setExternalTaskRetriesCall(setRetriesForExternalTasksDto, _callback);
        return localVarCall;
    }

    public void setExternalTaskRetries(SetRetriesForExternalTasksDto setRetriesForExternalTasksDto) throws ApiException {
        this.setExternalTaskRetriesWithHttpInfo(setRetriesForExternalTasksDto);
    }

    public ApiResponse<Void> setExternalTaskRetriesWithHttpInfo(SetRetriesForExternalTasksDto setRetriesForExternalTasksDto) throws ApiException {
        Call localVarCall = this.setExternalTaskRetriesValidateBeforeCall(setRetriesForExternalTasksDto, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call setExternalTaskRetriesAsync(SetRetriesForExternalTasksDto setRetriesForExternalTasksDto, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.setExternalTaskRetriesValidateBeforeCall(setRetriesForExternalTasksDto, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call setExternalTaskRetriesAsyncOperationCall(SetRetriesForExternalTasksDto setRetriesForExternalTasksDto, ApiCallback _callback) throws ApiException {
        SetRetriesForExternalTasksDto localVarPostBody = setRetriesForExternalTasksDto;
        String localVarPath = "/external-task/retries-async";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call setExternalTaskRetriesAsyncOperationValidateBeforeCall(SetRetriesForExternalTasksDto setRetriesForExternalTasksDto, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.setExternalTaskRetriesAsyncOperationCall(setRetriesForExternalTasksDto, _callback);
        return localVarCall;
    }

    public BatchDto setExternalTaskRetriesAsyncOperation(SetRetriesForExternalTasksDto setRetriesForExternalTasksDto) throws ApiException {
        ApiResponse<BatchDto> localVarResp = this.setExternalTaskRetriesAsyncOperationWithHttpInfo(setRetriesForExternalTasksDto);
        return localVarResp.getData();
    }

    public ApiResponse<BatchDto> setExternalTaskRetriesAsyncOperationWithHttpInfo(SetRetriesForExternalTasksDto setRetriesForExternalTasksDto) throws ApiException {
        Call localVarCall = this.setExternalTaskRetriesAsyncOperationValidateBeforeCall(setRetriesForExternalTasksDto, null);
        Type localVarReturnType = new TypeToken<BatchDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call setExternalTaskRetriesAsyncOperationAsync(SetRetriesForExternalTasksDto setRetriesForExternalTasksDto, ApiCallback<BatchDto> _callback) throws ApiException {
        Call localVarCall = this.setExternalTaskRetriesAsyncOperationValidateBeforeCall(setRetriesForExternalTasksDto, _callback);
        Type localVarReturnType = new TypeToken<BatchDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call unlockCall(String id, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/external-task/{id}/unlock".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call unlockValidateBeforeCall(String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling unlock(Async)");
        }
        Call localVarCall = this.unlockCall(id, _callback);
        return localVarCall;
    }

    public void unlock(String id) throws ApiException {
        this.unlockWithHttpInfo(id);
    }

    public ApiResponse<Void> unlockWithHttpInfo(String id) throws ApiException {
        Call localVarCall = this.unlockValidateBeforeCall(id, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call unlockAsync(String id, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.unlockValidateBeforeCall(id, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
}

