/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;
import org.camunda.community.rest.client.dto.MetricsIntervalResultDto;
import org.camunda.community.rest.client.dto.MetricsResultDto;
import org.camunda.community.rest.client.invoker.ApiCallback;
import org.camunda.community.rest.client.invoker.ApiClient;
import org.camunda.community.rest.client.invoker.ApiException;
import org.camunda.community.rest.client.invoker.ApiResponse;
import org.camunda.community.rest.client.invoker.Configuration;
import org.camunda.community.rest.client.invoker.Pair;

public class MetricsApi {
    private ApiClient localVarApiClient;

    public MetricsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public MetricsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call deleteTaskMetricsCall(Date date, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/metrics/task-worker";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (date != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("date", date));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteTaskMetricsValidateBeforeCall(Date date, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.deleteTaskMetricsCall(date, _callback);
        return localVarCall;
    }

    public void deleteTaskMetrics(Date date) throws ApiException {
        this.deleteTaskMetricsWithHttpInfo(date);
    }

    public ApiResponse<Void> deleteTaskMetricsWithHttpInfo(Date date) throws ApiException {
        Call localVarCall = this.deleteTaskMetricsValidateBeforeCall(date, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteTaskMetricsAsync(Date date, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteTaskMetricsValidateBeforeCall(date, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getMetricsCall(String metricsName, Date startDate, Date endDate, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/metrics/{metrics-name}/sum".replaceAll("\\{metrics-name\\}", this.localVarApiClient.escapeString(metricsName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (startDate != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("startDate", startDate));
        }
        if (endDate != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("endDate", endDate));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getMetricsValidateBeforeCall(String metricsName, Date startDate, Date endDate, ApiCallback _callback) throws ApiException {
        if (metricsName == null) {
            throw new ApiException("Missing the required parameter 'metricsName' when calling getMetrics(Async)");
        }
        Call localVarCall = this.getMetricsCall(metricsName, startDate, endDate, _callback);
        return localVarCall;
    }

    public MetricsResultDto getMetrics(String metricsName, Date startDate, Date endDate) throws ApiException {
        ApiResponse<MetricsResultDto> localVarResp = this.getMetricsWithHttpInfo(metricsName, startDate, endDate);
        return localVarResp.getData();
    }

    public ApiResponse<MetricsResultDto> getMetricsWithHttpInfo(String metricsName, Date startDate, Date endDate) throws ApiException {
        Call localVarCall = this.getMetricsValidateBeforeCall(metricsName, startDate, endDate, null);
        Type localVarReturnType = new TypeToken<MetricsResultDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getMetricsAsync(String metricsName, Date startDate, Date endDate, ApiCallback<MetricsResultDto> _callback) throws ApiException {
        Call localVarCall = this.getMetricsValidateBeforeCall(metricsName, startDate, endDate, _callback);
        Type localVarReturnType = new TypeToken<MetricsResultDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call intervalCall(String name, String reporter, Date startDate, Date endDate, Integer firstResult, Integer maxResults, String interval, String aggregateByReporter, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/metrics";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (name != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("name", name));
        }
        if (reporter != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("reporter", reporter));
        }
        if (startDate != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("startDate", startDate));
        }
        if (endDate != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("endDate", endDate));
        }
        if (firstResult != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("firstResult", firstResult));
        }
        if (maxResults != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("maxResults", maxResults));
        }
        if (interval != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("interval", interval));
        }
        if (aggregateByReporter != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("aggregateByReporter", aggregateByReporter));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call intervalValidateBeforeCall(String name, String reporter, Date startDate, Date endDate, Integer firstResult, Integer maxResults, String interval, String aggregateByReporter, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.intervalCall(name, reporter, startDate, endDate, firstResult, maxResults, interval, aggregateByReporter, _callback);
        return localVarCall;
    }

    public List<MetricsIntervalResultDto> interval(String name, String reporter, Date startDate, Date endDate, Integer firstResult, Integer maxResults, String interval, String aggregateByReporter) throws ApiException {
        ApiResponse<List<MetricsIntervalResultDto>> localVarResp = this.intervalWithHttpInfo(name, reporter, startDate, endDate, firstResult, maxResults, interval, aggregateByReporter);
        return localVarResp.getData();
    }

    public ApiResponse<List<MetricsIntervalResultDto>> intervalWithHttpInfo(String name, String reporter, Date startDate, Date endDate, Integer firstResult, Integer maxResults, String interval, String aggregateByReporter) throws ApiException {
        Call localVarCall = this.intervalValidateBeforeCall(name, reporter, startDate, endDate, firstResult, maxResults, interval, aggregateByReporter, null);
        Type localVarReturnType = new TypeToken<List<MetricsIntervalResultDto>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call intervalAsync(String name, String reporter, Date startDate, Date endDate, Integer firstResult, Integer maxResults, String interval, String aggregateByReporter, ApiCallback<List<MetricsIntervalResultDto>> _callback) throws ApiException {
        Call localVarCall = this.intervalValidateBeforeCall(name, reporter, startDate, endDate, firstResult, maxResults, interval, aggregateByReporter, _callback);
        Type localVarReturnType = new TypeToken<List<MetricsIntervalResultDto>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

