/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.dto;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Date;
import java.util.Objects;
import javax.annotation.Nullable;

public class HistoricProcessInstanceDto {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_ROOT_PROCESS_INSTANCE_ID = "rootProcessInstanceId";
    @SerializedName(value="rootProcessInstanceId")
    private String rootProcessInstanceId;
    public static final String SERIALIZED_NAME_SUPER_PROCESS_INSTANCE_ID = "superProcessInstanceId";
    @SerializedName(value="superProcessInstanceId")
    private String superProcessInstanceId;
    public static final String SERIALIZED_NAME_SUPER_CASE_INSTANCE_ID = "superCaseInstanceId";
    @SerializedName(value="superCaseInstanceId")
    private String superCaseInstanceId;
    public static final String SERIALIZED_NAME_CASE_INSTANCE_ID = "caseInstanceId";
    @SerializedName(value="caseInstanceId")
    private String caseInstanceId;
    public static final String SERIALIZED_NAME_PROCESS_DEFINITION_NAME = "processDefinitionName";
    @SerializedName(value="processDefinitionName")
    private String processDefinitionName;
    public static final String SERIALIZED_NAME_PROCESS_DEFINITION_KEY = "processDefinitionKey";
    @SerializedName(value="processDefinitionKey")
    private String processDefinitionKey;
    public static final String SERIALIZED_NAME_PROCESS_DEFINITION_VERSION = "processDefinitionVersion";
    @SerializedName(value="processDefinitionVersion")
    private Integer processDefinitionVersion;
    public static final String SERIALIZED_NAME_PROCESS_DEFINITION_ID = "processDefinitionId";
    @SerializedName(value="processDefinitionId")
    private String processDefinitionId;
    public static final String SERIALIZED_NAME_BUSINESS_KEY = "businessKey";
    @SerializedName(value="businessKey")
    private String businessKey;
    public static final String SERIALIZED_NAME_START_TIME = "startTime";
    @SerializedName(value="startTime")
    private Date startTime;
    public static final String SERIALIZED_NAME_END_TIME = "endTime";
    @SerializedName(value="endTime")
    private Date endTime;
    public static final String SERIALIZED_NAME_REMOVAL_TIME = "removalTime";
    @SerializedName(value="removalTime")
    private Date removalTime;
    public static final String SERIALIZED_NAME_DURATION_IN_MILLIS = "durationInMillis";
    @SerializedName(value="durationInMillis")
    private Long durationInMillis;
    public static final String SERIALIZED_NAME_START_USER_ID = "startUserId";
    @SerializedName(value="startUserId")
    private String startUserId;
    public static final String SERIALIZED_NAME_START_ACTIVITY_ID = "startActivityId";
    @SerializedName(value="startActivityId")
    private String startActivityId;
    public static final String SERIALIZED_NAME_DELETE_REASON = "deleteReason";
    @SerializedName(value="deleteReason")
    private String deleteReason;
    public static final String SERIALIZED_NAME_TENANT_ID = "tenantId";
    @SerializedName(value="tenantId")
    private String tenantId;
    public static final String SERIALIZED_NAME_STATE = "state";
    @SerializedName(value="state")
    private StateEnum state;

    public HistoricProcessInstanceDto id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the process instance.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public HistoricProcessInstanceDto rootProcessInstanceId(String rootProcessInstanceId) {
        this.rootProcessInstanceId = rootProcessInstanceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The process instance id of the root process instance that initiated the process.")
    public String getRootProcessInstanceId() {
        return this.rootProcessInstanceId;
    }

    public void setRootProcessInstanceId(String rootProcessInstanceId) {
        this.rootProcessInstanceId = rootProcessInstanceId;
    }

    public HistoricProcessInstanceDto superProcessInstanceId(String superProcessInstanceId) {
        this.superProcessInstanceId = superProcessInstanceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the parent process instance, if it exists.")
    public String getSuperProcessInstanceId() {
        return this.superProcessInstanceId;
    }

    public void setSuperProcessInstanceId(String superProcessInstanceId) {
        this.superProcessInstanceId = superProcessInstanceId;
    }

    public HistoricProcessInstanceDto superCaseInstanceId(String superCaseInstanceId) {
        this.superCaseInstanceId = superCaseInstanceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the parent case instance, if it exists.")
    public String getSuperCaseInstanceId() {
        return this.superCaseInstanceId;
    }

    public void setSuperCaseInstanceId(String superCaseInstanceId) {
        this.superCaseInstanceId = superCaseInstanceId;
    }

    public HistoricProcessInstanceDto caseInstanceId(String caseInstanceId) {
        this.caseInstanceId = caseInstanceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the parent case instance, if it exists.")
    public String getCaseInstanceId() {
        return this.caseInstanceId;
    }

    public void setCaseInstanceId(String caseInstanceId) {
        this.caseInstanceId = caseInstanceId;
    }

    public HistoricProcessInstanceDto processDefinitionName(String processDefinitionName) {
        this.processDefinitionName = processDefinitionName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of the process definition that this process instance belongs to.")
    public String getProcessDefinitionName() {
        return this.processDefinitionName;
    }

    public void setProcessDefinitionName(String processDefinitionName) {
        this.processDefinitionName = processDefinitionName;
    }

    public HistoricProcessInstanceDto processDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The key of the process definition that this process instance belongs to.")
    public String getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public void setProcessDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    public HistoricProcessInstanceDto processDefinitionVersion(Integer processDefinitionVersion) {
        this.processDefinitionVersion = processDefinitionVersion;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The version of the process definition that this process instance belongs to.")
    public Integer getProcessDefinitionVersion() {
        return this.processDefinitionVersion;
    }

    public void setProcessDefinitionVersion(Integer processDefinitionVersion) {
        this.processDefinitionVersion = processDefinitionVersion;
    }

    public HistoricProcessInstanceDto processDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the process definition that this process instance belongs to.")
    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    public HistoricProcessInstanceDto businessKey(String businessKey) {
        this.businessKey = businessKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The business key of the process instance.")
    public String getBusinessKey() {
        return this.businessKey;
    }

    public void setBusinessKey(String businessKey) {
        this.businessKey = businessKey;
    }

    public HistoricProcessInstanceDto startTime(Date startTime) {
        this.startTime = startTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The time the instance was started. Default [format](https://docs.camunda.org/manual/7.19/reference/rest/overview/date-format/) `yyyy-MM-dd'T'HH:mm:ss.SSSZ`.")
    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public HistoricProcessInstanceDto endTime(Date endTime) {
        this.endTime = endTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The time the instance ended. Default [format](https://docs.camunda.org/manual/7.19/reference/rest/overview/date-format/) `yyyy-MM-dd'T'HH:mm:ss.SSSZ`.")
    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public HistoricProcessInstanceDto removalTime(Date removalTime) {
        this.removalTime = removalTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The time after which the instance should be removed by the History Cleanup job. Default [format](https://docs.camunda.org/manual/7.19/reference/rest/overview/date-format/) `yyyy-MM-dd'T'HH:mm:ss.SSSZ`.")
    public Date getRemovalTime() {
        return this.removalTime;
    }

    public void setRemovalTime(Date removalTime) {
        this.removalTime = removalTime;
    }

    public HistoricProcessInstanceDto durationInMillis(Long durationInMillis) {
        this.durationInMillis = durationInMillis;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The time the instance took to finish (in milliseconds).")
    public Long getDurationInMillis() {
        return this.durationInMillis;
    }

    public void setDurationInMillis(Long durationInMillis) {
        this.durationInMillis = durationInMillis;
    }

    public HistoricProcessInstanceDto startUserId(String startUserId) {
        this.startUserId = startUserId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the user who started the process instance.")
    public String getStartUserId() {
        return this.startUserId;
    }

    public void setStartUserId(String startUserId) {
        this.startUserId = startUserId;
    }

    public HistoricProcessInstanceDto startActivityId(String startActivityId) {
        this.startActivityId = startActivityId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the initial activity that was executed (e.g., a start event).")
    public String getStartActivityId() {
        return this.startActivityId;
    }

    public void setStartActivityId(String startActivityId) {
        this.startActivityId = startActivityId;
    }

    public HistoricProcessInstanceDto deleteReason(String deleteReason) {
        this.deleteReason = deleteReason;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The provided delete reason in case the process instance was canceled during execution.")
    public String getDeleteReason() {
        return this.deleteReason;
    }

    public void setDeleteReason(String deleteReason) {
        this.deleteReason = deleteReason;
    }

    public HistoricProcessInstanceDto tenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The tenant id of the process instance.")
    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public HistoricProcessInstanceDto state(StateEnum state) {
        this.state = state;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Last state of the process instance, possible values are:  `ACTIVE` - running process instance  `SUSPENDED` - suspended process instances  `COMPLETED` - completed through normal end event  `EXTERNALLY_TERMINATED` - terminated externally, for instance through REST API  `INTERNALLY_TERMINATED` - terminated internally, for instance by terminating boundary event")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HistoricProcessInstanceDto historicProcessInstanceDto = (HistoricProcessInstanceDto)o;
        return Objects.equals(this.id, historicProcessInstanceDto.id) && Objects.equals(this.rootProcessInstanceId, historicProcessInstanceDto.rootProcessInstanceId) && Objects.equals(this.superProcessInstanceId, historicProcessInstanceDto.superProcessInstanceId) && Objects.equals(this.superCaseInstanceId, historicProcessInstanceDto.superCaseInstanceId) && Objects.equals(this.caseInstanceId, historicProcessInstanceDto.caseInstanceId) && Objects.equals(this.processDefinitionName, historicProcessInstanceDto.processDefinitionName) && Objects.equals(this.processDefinitionKey, historicProcessInstanceDto.processDefinitionKey) && Objects.equals(this.processDefinitionVersion, historicProcessInstanceDto.processDefinitionVersion) && Objects.equals(this.processDefinitionId, historicProcessInstanceDto.processDefinitionId) && Objects.equals(this.businessKey, historicProcessInstanceDto.businessKey) && Objects.equals(this.startTime, historicProcessInstanceDto.startTime) && Objects.equals(this.endTime, historicProcessInstanceDto.endTime) && Objects.equals(this.removalTime, historicProcessInstanceDto.removalTime) && Objects.equals(this.durationInMillis, historicProcessInstanceDto.durationInMillis) && Objects.equals(this.startUserId, historicProcessInstanceDto.startUserId) && Objects.equals(this.startActivityId, historicProcessInstanceDto.startActivityId) && Objects.equals(this.deleteReason, historicProcessInstanceDto.deleteReason) && Objects.equals(this.tenantId, historicProcessInstanceDto.tenantId) && Objects.equals((Object)this.state, (Object)historicProcessInstanceDto.state);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.rootProcessInstanceId, this.superProcessInstanceId, this.superCaseInstanceId, this.caseInstanceId, this.processDefinitionName, this.processDefinitionKey, this.processDefinitionVersion, this.processDefinitionId, this.businessKey, this.startTime, this.endTime, this.removalTime, this.durationInMillis, this.startUserId, this.startActivityId, this.deleteReason, this.tenantId, this.state});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HistoricProcessInstanceDto {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    rootProcessInstanceId: ").append(this.toIndentedString(this.rootProcessInstanceId)).append("\n");
        sb.append("    superProcessInstanceId: ").append(this.toIndentedString(this.superProcessInstanceId)).append("\n");
        sb.append("    superCaseInstanceId: ").append(this.toIndentedString(this.superCaseInstanceId)).append("\n");
        sb.append("    caseInstanceId: ").append(this.toIndentedString(this.caseInstanceId)).append("\n");
        sb.append("    processDefinitionName: ").append(this.toIndentedString(this.processDefinitionName)).append("\n");
        sb.append("    processDefinitionKey: ").append(this.toIndentedString(this.processDefinitionKey)).append("\n");
        sb.append("    processDefinitionVersion: ").append(this.toIndentedString(this.processDefinitionVersion)).append("\n");
        sb.append("    processDefinitionId: ").append(this.toIndentedString(this.processDefinitionId)).append("\n");
        sb.append("    businessKey: ").append(this.toIndentedString(this.businessKey)).append("\n");
        sb.append("    startTime: ").append(this.toIndentedString(this.startTime)).append("\n");
        sb.append("    endTime: ").append(this.toIndentedString(this.endTime)).append("\n");
        sb.append("    removalTime: ").append(this.toIndentedString(this.removalTime)).append("\n");
        sb.append("    durationInMillis: ").append(this.toIndentedString(this.durationInMillis)).append("\n");
        sb.append("    startUserId: ").append(this.toIndentedString(this.startUserId)).append("\n");
        sb.append("    startActivityId: ").append(this.toIndentedString(this.startActivityId)).append("\n");
        sb.append("    deleteReason: ").append(this.toIndentedString(this.deleteReason)).append("\n");
        sb.append("    tenantId: ").append(this.toIndentedString(this.tenantId)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StateEnum {
        ACTIVE("ACTIVE"),
        SUSPENDED("SUSPENDED"),
        COMPLETED("COMPLETED"),
        EXTERNALLY_TERMINATED("EXTERNALLY_TERMINATED"),
        INTERNALLY_TERMINATED("INTERNALLY_TERMINATED");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StateEnum fromValue(String value) {
            for (StateEnum b : StateEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<StateEnum> {
            public void write(JsonWriter jsonWriter, StateEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StateEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StateEnum.fromValue(value);
            }
        }
    }
}

