/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

public class JobDefinitionSuspensionStateDto {
    public static final String SERIALIZED_NAME_INCLUDE_JOBS = "includeJobs";
    @SerializedName(value="includeJobs")
    private Boolean includeJobs;
    public static final String SERIALIZED_NAME_EXECUTION_DATE = "executionDate";
    @SerializedName(value="executionDate")
    private String executionDate;
    public static final String SERIALIZED_NAME_SUSPENDED = "suspended";
    @SerializedName(value="suspended")
    private Boolean suspended;

    public JobDefinitionSuspensionStateDto includeJobs(Boolean includeJobs) {
        this.includeJobs = includeJobs;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A `Boolean` value which indicates whether to activate or suspend also all jobs of the referenced job definitions. When the value is set to `true`, all jobs of the provided job definitions will be activated or suspended and when the value is set to `false`, the suspension state of all jobs of the provided job definitions will not be updated.")
    public Boolean getIncludeJobs() {
        return this.includeJobs;
    }

    public void setIncludeJobs(Boolean includeJobs) {
        this.includeJobs = includeJobs;
    }

    public JobDefinitionSuspensionStateDto executionDate(String executionDate) {
        this.executionDate = executionDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The date on which the referenced job definitions will be activated or suspended. If null, the suspension state of the given job definitions is updated immediately. By [default](https://docs.camunda.org/manual/7.19/reference/rest/overview/date-format/), the date must have the format `yyyy-MM- dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.")
    public String getExecutionDate() {
        return this.executionDate;
    }

    public void setExecutionDate(String executionDate) {
        this.executionDate = executionDate;
    }

    public JobDefinitionSuspensionStateDto suspended(Boolean suspended) {
        this.suspended = suspended;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A Boolean value which indicates whether to activate or suspend a given instance  (e.g. process instance, job, job definition, or batch). When the value is set to true,  the given instance will be suspended and when the value is set to false,  the given instance will be activated.")
    public Boolean getSuspended() {
        return this.suspended;
    }

    public void setSuspended(Boolean suspended) {
        this.suspended = suspended;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobDefinitionSuspensionStateDto jobDefinitionSuspensionStateDto = (JobDefinitionSuspensionStateDto)o;
        return Objects.equals(this.includeJobs, jobDefinitionSuspensionStateDto.includeJobs) && Objects.equals(this.executionDate, jobDefinitionSuspensionStateDto.executionDate) && Objects.equals(this.suspended, jobDefinitionSuspensionStateDto.suspended);
    }

    public int hashCode() {
        return Objects.hash(this.includeJobs, this.executionDate, this.suspended);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class JobDefinitionSuspensionStateDto {\n");
        sb.append("    includeJobs: ").append(this.toIndentedString(this.includeJobs)).append("\n");
        sb.append("    executionDate: ").append(this.toIndentedString(this.executionDate)).append("\n");
        sb.append("    suspended: ").append(this.toIndentedString(this.suspended)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

