/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.20.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.api;

import org.camunda.community.rest.client.invoker.ApiCallback;
import org.camunda.community.rest.client.invoker.ApiClient;
import org.camunda.community.rest.client.invoker.ApiException;
import org.camunda.community.rest.client.invoker.ApiResponse;
import org.camunda.community.rest.client.invoker.Configuration;
import org.camunda.community.rest.client.invoker.Pair;
import org.camunda.community.rest.client.invoker.ProgressRequestBody;
import org.camunda.community.rest.client.invoker.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import org.camunda.community.rest.client.dto.CountResultDto;
import java.util.Date;
import org.camunda.community.rest.client.dto.DecisionDefinitionDiagramDto;
import org.camunda.community.rest.client.dto.DecisionDefinitionDto;
import org.camunda.community.rest.client.dto.EvaluateDecisionDto;
import org.camunda.community.rest.client.dto.ExceptionDto;
import java.io.File;
import org.camunda.community.rest.client.dto.HistoryTimeToLiveDto;
import org.camunda.community.rest.client.dto.VariableValueDto;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DecisionDefinitionApi {
    private ApiClient localVarApiClient;

    public DecisionDefinitionApi() {
        this(Configuration.getDefaultApiClient());
    }

    public DecisionDefinitionApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    /**
     * Build call for evaluateDecisionById
     * @param id The id of the decision definition to be evaluated. (required)
     * @param evaluateDecisionDto  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Decision definition with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call evaluateDecisionByIdCall(String id, EvaluateDecisionDto evaluateDecisionDto, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = evaluateDecisionDto;

        // create path and map variables
        String localVarPath = "/decision-definition/{id}/evaluate"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call evaluateDecisionByIdValidateBeforeCall(String id, EvaluateDecisionDto evaluateDecisionDto, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling evaluateDecisionById(Async)");
        }
        

        okhttp3.Call localVarCall = evaluateDecisionByIdCall(id, evaluateDecisionDto, _callback);
        return localVarCall;

    }

    /**
     * Evaluate By Id
     * Evaluates a given decision and returns the result. The input values of the decision have to be supplied in the request body.
     * @param id The id of the decision definition to be evaluated. (required)
     * @param evaluateDecisionDto  (optional)
     * @return List&lt;Map&lt;String, VariableValueDto&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Decision definition with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public List<Map<String, VariableValueDto>> evaluateDecisionById(String id, EvaluateDecisionDto evaluateDecisionDto) throws ApiException {
        ApiResponse<List<Map<String, VariableValueDto>>> localVarResp = evaluateDecisionByIdWithHttpInfo(id, evaluateDecisionDto);
        return localVarResp.getData();
    }

    /**
     * Evaluate By Id
     * Evaluates a given decision and returns the result. The input values of the decision have to be supplied in the request body.
     * @param id The id of the decision definition to be evaluated. (required)
     * @param evaluateDecisionDto  (optional)
     * @return ApiResponse&lt;List&lt;Map&lt;String, VariableValueDto&gt;&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Decision definition with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<Map<String, VariableValueDto>>> evaluateDecisionByIdWithHttpInfo(String id, EvaluateDecisionDto evaluateDecisionDto) throws ApiException {
        okhttp3.Call localVarCall = evaluateDecisionByIdValidateBeforeCall(id, evaluateDecisionDto, null);
        Type localVarReturnType = new TypeToken<List<Map<String, VariableValueDto>>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Evaluate By Id (asynchronously)
     * Evaluates a given decision and returns the result. The input values of the decision have to be supplied in the request body.
     * @param id The id of the decision definition to be evaluated. (required)
     * @param evaluateDecisionDto  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Decision definition with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call evaluateDecisionByIdAsync(String id, EvaluateDecisionDto evaluateDecisionDto, final ApiCallback<List<Map<String, VariableValueDto>>> _callback) throws ApiException {

        okhttp3.Call localVarCall = evaluateDecisionByIdValidateBeforeCall(id, evaluateDecisionDto, _callback);
        Type localVarReturnType = new TypeToken<List<Map<String, VariableValueDto>>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for evaluateDecisionByKey
     * @param key The key of the decision definition (the latest version thereof) to be evaluated. (required)
     * @param evaluateDecisionDto  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Decision definition with given key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call evaluateDecisionByKeyCall(String key, EvaluateDecisionDto evaluateDecisionDto, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = evaluateDecisionDto;

        // create path and map variables
        String localVarPath = "/decision-definition/key/{key}/evaluate"
            .replaceAll("\\{" + "key" + "\\}", localVarApiClient.escapeString(key.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call evaluateDecisionByKeyValidateBeforeCall(String key, EvaluateDecisionDto evaluateDecisionDto, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'key' is set
        if (key == null) {
            throw new ApiException("Missing the required parameter 'key' when calling evaluateDecisionByKey(Async)");
        }
        

        okhttp3.Call localVarCall = evaluateDecisionByKeyCall(key, evaluateDecisionDto, _callback);
        return localVarCall;

    }

    /**
     * Evaluate By Key
     * Evaluates the latest version of the decision definition which belongs to no tenant. The input values of the decision have to be supplied in the request body.
     * @param key The key of the decision definition (the latest version thereof) to be evaluated. (required)
     * @param evaluateDecisionDto  (optional)
     * @return List&lt;Map&lt;String, VariableValueDto&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Decision definition with given key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public List<Map<String, VariableValueDto>> evaluateDecisionByKey(String key, EvaluateDecisionDto evaluateDecisionDto) throws ApiException {
        ApiResponse<List<Map<String, VariableValueDto>>> localVarResp = evaluateDecisionByKeyWithHttpInfo(key, evaluateDecisionDto);
        return localVarResp.getData();
    }

    /**
     * Evaluate By Key
     * Evaluates the latest version of the decision definition which belongs to no tenant. The input values of the decision have to be supplied in the request body.
     * @param key The key of the decision definition (the latest version thereof) to be evaluated. (required)
     * @param evaluateDecisionDto  (optional)
     * @return ApiResponse&lt;List&lt;Map&lt;String, VariableValueDto&gt;&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Decision definition with given key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<Map<String, VariableValueDto>>> evaluateDecisionByKeyWithHttpInfo(String key, EvaluateDecisionDto evaluateDecisionDto) throws ApiException {
        okhttp3.Call localVarCall = evaluateDecisionByKeyValidateBeforeCall(key, evaluateDecisionDto, null);
        Type localVarReturnType = new TypeToken<List<Map<String, VariableValueDto>>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Evaluate By Key (asynchronously)
     * Evaluates the latest version of the decision definition which belongs to no tenant. The input values of the decision have to be supplied in the request body.
     * @param key The key of the decision definition (the latest version thereof) to be evaluated. (required)
     * @param evaluateDecisionDto  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Decision definition with given key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call evaluateDecisionByKeyAsync(String key, EvaluateDecisionDto evaluateDecisionDto, final ApiCallback<List<Map<String, VariableValueDto>>> _callback) throws ApiException {

        okhttp3.Call localVarCall = evaluateDecisionByKeyValidateBeforeCall(key, evaluateDecisionDto, _callback);
        Type localVarReturnType = new TypeToken<List<Map<String, VariableValueDto>>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for evaluateDecisionByKeyAndTenant
     * @param key The key of the decision definition (the latest version thereof) to be evaluated. (required)
     * @param tenantId The id of the tenant the decision definition belongs to. (required)
     * @param evaluateDecisionDto  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Decision definition with given key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call evaluateDecisionByKeyAndTenantCall(String key, String tenantId, EvaluateDecisionDto evaluateDecisionDto, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = evaluateDecisionDto;

        // create path and map variables
        String localVarPath = "/decision-definition/key/{key}/tenant-id/{tenant-id}/evaluate"
            .replaceAll("\\{" + "key" + "\\}", localVarApiClient.escapeString(key.toString()))
            .replaceAll("\\{" + "tenant-id" + "\\}", localVarApiClient.escapeString(tenantId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call evaluateDecisionByKeyAndTenantValidateBeforeCall(String key, String tenantId, EvaluateDecisionDto evaluateDecisionDto, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'key' is set
        if (key == null) {
            throw new ApiException("Missing the required parameter 'key' when calling evaluateDecisionByKeyAndTenant(Async)");
        }
        
        // verify the required parameter 'tenantId' is set
        if (tenantId == null) {
            throw new ApiException("Missing the required parameter 'tenantId' when calling evaluateDecisionByKeyAndTenant(Async)");
        }
        

        okhttp3.Call localVarCall = evaluateDecisionByKeyAndTenantCall(key, tenantId, evaluateDecisionDto, _callback);
        return localVarCall;

    }

    /**
     * Evaluate By Key And Tenant
     * Evaluates the latest version of the decision definition for tenant. The input values of the decision have to be supplied in the request body.
     * @param key The key of the decision definition (the latest version thereof) to be evaluated. (required)
     * @param tenantId The id of the tenant the decision definition belongs to. (required)
     * @param evaluateDecisionDto  (optional)
     * @return List&lt;Map&lt;String, VariableValueDto&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Decision definition with given key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public List<Map<String, VariableValueDto>> evaluateDecisionByKeyAndTenant(String key, String tenantId, EvaluateDecisionDto evaluateDecisionDto) throws ApiException {
        ApiResponse<List<Map<String, VariableValueDto>>> localVarResp = evaluateDecisionByKeyAndTenantWithHttpInfo(key, tenantId, evaluateDecisionDto);
        return localVarResp.getData();
    }

    /**
     * Evaluate By Key And Tenant
     * Evaluates the latest version of the decision definition for tenant. The input values of the decision have to be supplied in the request body.
     * @param key The key of the decision definition (the latest version thereof) to be evaluated. (required)
     * @param tenantId The id of the tenant the decision definition belongs to. (required)
     * @param evaluateDecisionDto  (optional)
     * @return ApiResponse&lt;List&lt;Map&lt;String, VariableValueDto&gt;&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Decision definition with given key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<Map<String, VariableValueDto>>> evaluateDecisionByKeyAndTenantWithHttpInfo(String key, String tenantId, EvaluateDecisionDto evaluateDecisionDto) throws ApiException {
        okhttp3.Call localVarCall = evaluateDecisionByKeyAndTenantValidateBeforeCall(key, tenantId, evaluateDecisionDto, null);
        Type localVarReturnType = new TypeToken<List<Map<String, VariableValueDto>>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Evaluate By Key And Tenant (asynchronously)
     * Evaluates the latest version of the decision definition for tenant. The input values of the decision have to be supplied in the request body.
     * @param key The key of the decision definition (the latest version thereof) to be evaluated. (required)
     * @param tenantId The id of the tenant the decision definition belongs to. (required)
     * @param evaluateDecisionDto  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Decision definition with given key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call evaluateDecisionByKeyAndTenantAsync(String key, String tenantId, EvaluateDecisionDto evaluateDecisionDto, final ApiCallback<List<Map<String, VariableValueDto>>> _callback) throws ApiException {

        okhttp3.Call localVarCall = evaluateDecisionByKeyAndTenantValidateBeforeCall(key, tenantId, evaluateDecisionDto, _callback);
        Type localVarReturnType = new TypeToken<List<Map<String, VariableValueDto>>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getDecisionDefinitionById
     * @param id The id of the decision definition to be retrieved. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Decision definition with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getDecisionDefinitionByIdCall(String id, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/decision-definition/{id}"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getDecisionDefinitionByIdValidateBeforeCall(String id, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getDecisionDefinitionById(Async)");
        }
        

        okhttp3.Call localVarCall = getDecisionDefinitionByIdCall(id, _callback);
        return localVarCall;

    }

    /**
     * Get Decision Definition By Id
     * Retrieves a decision definition by id, according to the &#x60;DecisionDefinition&#x60; interface in the engine.
     * @param id The id of the decision definition to be retrieved. (required)
     * @return DecisionDefinitionDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Decision definition with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public DecisionDefinitionDto getDecisionDefinitionById(String id) throws ApiException {
        ApiResponse<DecisionDefinitionDto> localVarResp = getDecisionDefinitionByIdWithHttpInfo(id);
        return localVarResp.getData();
    }

    /**
     * Get Decision Definition By Id
     * Retrieves a decision definition by id, according to the &#x60;DecisionDefinition&#x60; interface in the engine.
     * @param id The id of the decision definition to be retrieved. (required)
     * @return ApiResponse&lt;DecisionDefinitionDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Decision definition with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<DecisionDefinitionDto> getDecisionDefinitionByIdWithHttpInfo(String id) throws ApiException {
        okhttp3.Call localVarCall = getDecisionDefinitionByIdValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<DecisionDefinitionDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Decision Definition By Id (asynchronously)
     * Retrieves a decision definition by id, according to the &#x60;DecisionDefinition&#x60; interface in the engine.
     * @param id The id of the decision definition to be retrieved. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Decision definition with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getDecisionDefinitionByIdAsync(String id, final ApiCallback<DecisionDefinitionDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = getDecisionDefinitionByIdValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<DecisionDefinitionDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getDecisionDefinitionByKey
     * @param key The key of the decision definition (the latest version thereof) to be retrieved. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Decision definition with given key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getDecisionDefinitionByKeyCall(String key, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/decision-definition/key/{key}"
            .replaceAll("\\{" + "key" + "\\}", localVarApiClient.escapeString(key.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getDecisionDefinitionByKeyValidateBeforeCall(String key, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'key' is set
        if (key == null) {
            throw new ApiException("Missing the required parameter 'key' when calling getDecisionDefinitionByKey(Async)");
        }
        

        okhttp3.Call localVarCall = getDecisionDefinitionByKeyCall(key, _callback);
        return localVarCall;

    }

    /**
     * Get Decision Definition By Key
     * Retrieves the latest version of the decision definition which belongs to no tenant.
     * @param key The key of the decision definition (the latest version thereof) to be retrieved. (required)
     * @return DecisionDefinitionDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Decision definition with given key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public DecisionDefinitionDto getDecisionDefinitionByKey(String key) throws ApiException {
        ApiResponse<DecisionDefinitionDto> localVarResp = getDecisionDefinitionByKeyWithHttpInfo(key);
        return localVarResp.getData();
    }

    /**
     * Get Decision Definition By Key
     * Retrieves the latest version of the decision definition which belongs to no tenant.
     * @param key The key of the decision definition (the latest version thereof) to be retrieved. (required)
     * @return ApiResponse&lt;DecisionDefinitionDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Decision definition with given key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<DecisionDefinitionDto> getDecisionDefinitionByKeyWithHttpInfo(String key) throws ApiException {
        okhttp3.Call localVarCall = getDecisionDefinitionByKeyValidateBeforeCall(key, null);
        Type localVarReturnType = new TypeToken<DecisionDefinitionDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Decision Definition By Key (asynchronously)
     * Retrieves the latest version of the decision definition which belongs to no tenant.
     * @param key The key of the decision definition (the latest version thereof) to be retrieved. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Decision definition with given key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getDecisionDefinitionByKeyAsync(String key, final ApiCallback<DecisionDefinitionDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = getDecisionDefinitionByKeyValidateBeforeCall(key, _callback);
        Type localVarReturnType = new TypeToken<DecisionDefinitionDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getDecisionDefinitionByKeyAndTenantId
     * @param key The key of the decision definition (the latest version thereof) to be retrieved. (required)
     * @param tenantId The id of the tenant the decision definition belongs to. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Decision definition with given key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getDecisionDefinitionByKeyAndTenantIdCall(String key, String tenantId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/decision-definition/key/{key}/tenant-id/{tenant-id}"
            .replaceAll("\\{" + "key" + "\\}", localVarApiClient.escapeString(key.toString()))
            .replaceAll("\\{" + "tenant-id" + "\\}", localVarApiClient.escapeString(tenantId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getDecisionDefinitionByKeyAndTenantIdValidateBeforeCall(String key, String tenantId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'key' is set
        if (key == null) {
            throw new ApiException("Missing the required parameter 'key' when calling getDecisionDefinitionByKeyAndTenantId(Async)");
        }
        
        // verify the required parameter 'tenantId' is set
        if (tenantId == null) {
            throw new ApiException("Missing the required parameter 'tenantId' when calling getDecisionDefinitionByKeyAndTenantId(Async)");
        }
        

        okhttp3.Call localVarCall = getDecisionDefinitionByKeyAndTenantIdCall(key, tenantId, _callback);
        return localVarCall;

    }

    /**
     * Get Decision Definition By Key And Tenant Id
     * Retrieves the latest version of the decision definition for tenant
     * @param key The key of the decision definition (the latest version thereof) to be retrieved. (required)
     * @param tenantId The id of the tenant the decision definition belongs to. (required)
     * @return DecisionDefinitionDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Decision definition with given key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public DecisionDefinitionDto getDecisionDefinitionByKeyAndTenantId(String key, String tenantId) throws ApiException {
        ApiResponse<DecisionDefinitionDto> localVarResp = getDecisionDefinitionByKeyAndTenantIdWithHttpInfo(key, tenantId);
        return localVarResp.getData();
    }

    /**
     * Get Decision Definition By Key And Tenant Id
     * Retrieves the latest version of the decision definition for tenant
     * @param key The key of the decision definition (the latest version thereof) to be retrieved. (required)
     * @param tenantId The id of the tenant the decision definition belongs to. (required)
     * @return ApiResponse&lt;DecisionDefinitionDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Decision definition with given key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<DecisionDefinitionDto> getDecisionDefinitionByKeyAndTenantIdWithHttpInfo(String key, String tenantId) throws ApiException {
        okhttp3.Call localVarCall = getDecisionDefinitionByKeyAndTenantIdValidateBeforeCall(key, tenantId, null);
        Type localVarReturnType = new TypeToken<DecisionDefinitionDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Decision Definition By Key And Tenant Id (asynchronously)
     * Retrieves the latest version of the decision definition for tenant
     * @param key The key of the decision definition (the latest version thereof) to be retrieved. (required)
     * @param tenantId The id of the tenant the decision definition belongs to. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Decision definition with given key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getDecisionDefinitionByKeyAndTenantIdAsync(String key, String tenantId, final ApiCallback<DecisionDefinitionDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = getDecisionDefinitionByKeyAndTenantIdValidateBeforeCall(key, tenantId, _callback);
        Type localVarReturnType = new TypeToken<DecisionDefinitionDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getDecisionDefinitionDiagram
     * @param id The id of the process definition. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. The image diagram of this process. </td><td>  -  </td></tr>
        <tr><td> 204 </td><td> The decision definition doesn&#39;t have an associated diagram. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Decision definition with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getDecisionDefinitionDiagramCall(String id, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/decision-definition/{id}/diagram"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/octet-stream", "*/*", "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getDecisionDefinitionDiagramValidateBeforeCall(String id, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getDecisionDefinitionDiagram(Async)");
        }
        

        okhttp3.Call localVarCall = getDecisionDefinitionDiagramCall(id, _callback);
        return localVarCall;

    }

    /**
     * Get Diagram
     * Retrieves the diagram of a decision definition.
     * @param id The id of the process definition. (required)
     * @return File
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. The image diagram of this process. </td><td>  -  </td></tr>
        <tr><td> 204 </td><td> The decision definition doesn&#39;t have an associated diagram. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Decision definition with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public File getDecisionDefinitionDiagram(String id) throws ApiException {
        ApiResponse<File> localVarResp = getDecisionDefinitionDiagramWithHttpInfo(id);
        return localVarResp.getData();
    }

    /**
     * Get Diagram
     * Retrieves the diagram of a decision definition.
     * @param id The id of the process definition. (required)
     * @return ApiResponse&lt;File&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. The image diagram of this process. </td><td>  -  </td></tr>
        <tr><td> 204 </td><td> The decision definition doesn&#39;t have an associated diagram. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Decision definition with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<File> getDecisionDefinitionDiagramWithHttpInfo(String id) throws ApiException {
        okhttp3.Call localVarCall = getDecisionDefinitionDiagramValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Diagram (asynchronously)
     * Retrieves the diagram of a decision definition.
     * @param id The id of the process definition. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. The image diagram of this process. </td><td>  -  </td></tr>
        <tr><td> 204 </td><td> The decision definition doesn&#39;t have an associated diagram. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Decision definition with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getDecisionDefinitionDiagramAsync(String id, final ApiCallback<File> _callback) throws ApiException {

        okhttp3.Call localVarCall = getDecisionDefinitionDiagramValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getDecisionDefinitionDiagramByKey
     * @param key The key of the decision definition (the latest version thereof) to be retrieved. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. The image diagram of this process. </td><td>  -  </td></tr>
        <tr><td> 204 </td><td> The decision definition doesn&#39;t have an associated diagram. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Decision definition with given key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getDecisionDefinitionDiagramByKeyCall(String key, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/decision-definition/key/{key}/diagram"
            .replaceAll("\\{" + "key" + "\\}", localVarApiClient.escapeString(key.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/octet-stream", "*/*", "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getDecisionDefinitionDiagramByKeyValidateBeforeCall(String key, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'key' is set
        if (key == null) {
            throw new ApiException("Missing the required parameter 'key' when calling getDecisionDefinitionDiagramByKey(Async)");
        }
        

        okhttp3.Call localVarCall = getDecisionDefinitionDiagramByKeyCall(key, _callback);
        return localVarCall;

    }

    /**
     * Get Diagram By Key
     * Returns the diagram for the latest version of the decision definition which belongs to no tenant
     * @param key The key of the decision definition (the latest version thereof) to be retrieved. (required)
     * @return File
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. The image diagram of this process. </td><td>  -  </td></tr>
        <tr><td> 204 </td><td> The decision definition doesn&#39;t have an associated diagram. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Decision definition with given key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public File getDecisionDefinitionDiagramByKey(String key) throws ApiException {
        ApiResponse<File> localVarResp = getDecisionDefinitionDiagramByKeyWithHttpInfo(key);
        return localVarResp.getData();
    }

    /**
     * Get Diagram By Key
     * Returns the diagram for the latest version of the decision definition which belongs to no tenant
     * @param key The key of the decision definition (the latest version thereof) to be retrieved. (required)
     * @return ApiResponse&lt;File&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. The image diagram of this process. </td><td>  -  </td></tr>
        <tr><td> 204 </td><td> The decision definition doesn&#39;t have an associated diagram. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Decision definition with given key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<File> getDecisionDefinitionDiagramByKeyWithHttpInfo(String key) throws ApiException {
        okhttp3.Call localVarCall = getDecisionDefinitionDiagramByKeyValidateBeforeCall(key, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Diagram By Key (asynchronously)
     * Returns the diagram for the latest version of the decision definition which belongs to no tenant
     * @param key The key of the decision definition (the latest version thereof) to be retrieved. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. The image diagram of this process. </td><td>  -  </td></tr>
        <tr><td> 204 </td><td> The decision definition doesn&#39;t have an associated diagram. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Decision definition with given key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getDecisionDefinitionDiagramByKeyAsync(String key, final ApiCallback<File> _callback) throws ApiException {

        okhttp3.Call localVarCall = getDecisionDefinitionDiagramByKeyValidateBeforeCall(key, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getDecisionDefinitionDiagramByKeyAndTenant
     * @param key The key of the decision definition (the latest version thereof) to be retrieved. (required)
     * @param tenantId The id of the tenant the decision definition belongs to. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. The image diagram of this process. </td><td>  -  </td></tr>
        <tr><td> 204 </td><td> The decision definition doesn&#39;t have an associated diagram. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Decision definition with given key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getDecisionDefinitionDiagramByKeyAndTenantCall(String key, String tenantId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/decision-definition/key/{key}/tenant-id/{tenant-id}/diagram"
            .replaceAll("\\{" + "key" + "\\}", localVarApiClient.escapeString(key.toString()))
            .replaceAll("\\{" + "tenant-id" + "\\}", localVarApiClient.escapeString(tenantId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/octet-stream", "*/*", "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getDecisionDefinitionDiagramByKeyAndTenantValidateBeforeCall(String key, String tenantId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'key' is set
        if (key == null) {
            throw new ApiException("Missing the required parameter 'key' when calling getDecisionDefinitionDiagramByKeyAndTenant(Async)");
        }
        
        // verify the required parameter 'tenantId' is set
        if (tenantId == null) {
            throw new ApiException("Missing the required parameter 'tenantId' when calling getDecisionDefinitionDiagramByKeyAndTenant(Async)");
        }
        

        okhttp3.Call localVarCall = getDecisionDefinitionDiagramByKeyAndTenantCall(key, tenantId, _callback);
        return localVarCall;

    }

    /**
     * Get Diagram By Key And Tenant
     * Returns the XML of the latest version of the decision definition for tenant.
     * @param key The key of the decision definition (the latest version thereof) to be retrieved. (required)
     * @param tenantId The id of the tenant the decision definition belongs to. (required)
     * @return File
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. The image diagram of this process. </td><td>  -  </td></tr>
        <tr><td> 204 </td><td> The decision definition doesn&#39;t have an associated diagram. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Decision definition with given key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public File getDecisionDefinitionDiagramByKeyAndTenant(String key, String tenantId) throws ApiException {
        ApiResponse<File> localVarResp = getDecisionDefinitionDiagramByKeyAndTenantWithHttpInfo(key, tenantId);
        return localVarResp.getData();
    }

    /**
     * Get Diagram By Key And Tenant
     * Returns the XML of the latest version of the decision definition for tenant.
     * @param key The key of the decision definition (the latest version thereof) to be retrieved. (required)
     * @param tenantId The id of the tenant the decision definition belongs to. (required)
     * @return ApiResponse&lt;File&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. The image diagram of this process. </td><td>  -  </td></tr>
        <tr><td> 204 </td><td> The decision definition doesn&#39;t have an associated diagram. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Decision definition with given key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<File> getDecisionDefinitionDiagramByKeyAndTenantWithHttpInfo(String key, String tenantId) throws ApiException {
        okhttp3.Call localVarCall = getDecisionDefinitionDiagramByKeyAndTenantValidateBeforeCall(key, tenantId, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Diagram By Key And Tenant (asynchronously)
     * Returns the XML of the latest version of the decision definition for tenant.
     * @param key The key of the decision definition (the latest version thereof) to be retrieved. (required)
     * @param tenantId The id of the tenant the decision definition belongs to. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. The image diagram of this process. </td><td>  -  </td></tr>
        <tr><td> 204 </td><td> The decision definition doesn&#39;t have an associated diagram. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Decision definition with given key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getDecisionDefinitionDiagramByKeyAndTenantAsync(String key, String tenantId, final ApiCallback<File> _callback) throws ApiException {

        okhttp3.Call localVarCall = getDecisionDefinitionDiagramByKeyAndTenantValidateBeforeCall(key, tenantId, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getDecisionDefinitionDmnXmlById
     * @param id The id of the decision definition. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Decision definition with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getDecisionDefinitionDmnXmlByIdCall(String id, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/decision-definition/{id}/xml"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getDecisionDefinitionDmnXmlByIdValidateBeforeCall(String id, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getDecisionDefinitionDmnXmlById(Async)");
        }
        

        okhttp3.Call localVarCall = getDecisionDefinitionDmnXmlByIdCall(id, _callback);
        return localVarCall;

    }

    /**
     * Get XML By Id
     * Retrieves the DMN XML of a decision definition.
     * @param id The id of the decision definition. (required)
     * @return DecisionDefinitionDiagramDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Decision definition with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public DecisionDefinitionDiagramDto getDecisionDefinitionDmnXmlById(String id) throws ApiException {
        ApiResponse<DecisionDefinitionDiagramDto> localVarResp = getDecisionDefinitionDmnXmlByIdWithHttpInfo(id);
        return localVarResp.getData();
    }

    /**
     * Get XML By Id
     * Retrieves the DMN XML of a decision definition.
     * @param id The id of the decision definition. (required)
     * @return ApiResponse&lt;DecisionDefinitionDiagramDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Decision definition with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<DecisionDefinitionDiagramDto> getDecisionDefinitionDmnXmlByIdWithHttpInfo(String id) throws ApiException {
        okhttp3.Call localVarCall = getDecisionDefinitionDmnXmlByIdValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<DecisionDefinitionDiagramDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get XML By Id (asynchronously)
     * Retrieves the DMN XML of a decision definition.
     * @param id The id of the decision definition. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Decision definition with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getDecisionDefinitionDmnXmlByIdAsync(String id, final ApiCallback<DecisionDefinitionDiagramDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = getDecisionDefinitionDmnXmlByIdValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<DecisionDefinitionDiagramDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getDecisionDefinitionDmnXmlByKey
     * @param key The key of the decision definition (the latest version thereof). (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Decision definition with given key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getDecisionDefinitionDmnXmlByKeyCall(String key, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/decision-definition/key/{key}/xml"
            .replaceAll("\\{" + "key" + "\\}", localVarApiClient.escapeString(key.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getDecisionDefinitionDmnXmlByKeyValidateBeforeCall(String key, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'key' is set
        if (key == null) {
            throw new ApiException("Missing the required parameter 'key' when calling getDecisionDefinitionDmnXmlByKey(Async)");
        }
        

        okhttp3.Call localVarCall = getDecisionDefinitionDmnXmlByKeyCall(key, _callback);
        return localVarCall;

    }

    /**
     * Get XML By Key
     * Retrieves the XML for the latest version of the decision definition which belongs to no tenant.
     * @param key The key of the decision definition (the latest version thereof). (required)
     * @return DecisionDefinitionDiagramDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Decision definition with given key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public DecisionDefinitionDiagramDto getDecisionDefinitionDmnXmlByKey(String key) throws ApiException {
        ApiResponse<DecisionDefinitionDiagramDto> localVarResp = getDecisionDefinitionDmnXmlByKeyWithHttpInfo(key);
        return localVarResp.getData();
    }

    /**
     * Get XML By Key
     * Retrieves the XML for the latest version of the decision definition which belongs to no tenant.
     * @param key The key of the decision definition (the latest version thereof). (required)
     * @return ApiResponse&lt;DecisionDefinitionDiagramDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Decision definition with given key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<DecisionDefinitionDiagramDto> getDecisionDefinitionDmnXmlByKeyWithHttpInfo(String key) throws ApiException {
        okhttp3.Call localVarCall = getDecisionDefinitionDmnXmlByKeyValidateBeforeCall(key, null);
        Type localVarReturnType = new TypeToken<DecisionDefinitionDiagramDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get XML By Key (asynchronously)
     * Retrieves the XML for the latest version of the decision definition which belongs to no tenant.
     * @param key The key of the decision definition (the latest version thereof). (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Decision definition with given key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getDecisionDefinitionDmnXmlByKeyAsync(String key, final ApiCallback<DecisionDefinitionDiagramDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = getDecisionDefinitionDmnXmlByKeyValidateBeforeCall(key, _callback);
        Type localVarReturnType = new TypeToken<DecisionDefinitionDiagramDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getDecisionDefinitionDmnXmlByKeyAndTenant
     * @param key The key of the decision definition (the latest version thereof). (required)
     * @param tenantId The id of the tenant the decision definition belongs to. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Decision definition with given key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getDecisionDefinitionDmnXmlByKeyAndTenantCall(String key, String tenantId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/decision-definition/key/{key}/tenant-id/{tenant-id}/xml"
            .replaceAll("\\{" + "key" + "\\}", localVarApiClient.escapeString(key.toString()))
            .replaceAll("\\{" + "tenant-id" + "\\}", localVarApiClient.escapeString(tenantId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getDecisionDefinitionDmnXmlByKeyAndTenantValidateBeforeCall(String key, String tenantId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'key' is set
        if (key == null) {
            throw new ApiException("Missing the required parameter 'key' when calling getDecisionDefinitionDmnXmlByKeyAndTenant(Async)");
        }
        
        // verify the required parameter 'tenantId' is set
        if (tenantId == null) {
            throw new ApiException("Missing the required parameter 'tenantId' when calling getDecisionDefinitionDmnXmlByKeyAndTenant(Async)");
        }
        

        okhttp3.Call localVarCall = getDecisionDefinitionDmnXmlByKeyAndTenantCall(key, tenantId, _callback);
        return localVarCall;

    }

    /**
     * Get XML By Key and Tenant
     * Retrieves the XML of the latest version of the decision definition for tenant
     * @param key The key of the decision definition (the latest version thereof). (required)
     * @param tenantId The id of the tenant the decision definition belongs to. (required)
     * @return DecisionDefinitionDiagramDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Decision definition with given key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public DecisionDefinitionDiagramDto getDecisionDefinitionDmnXmlByKeyAndTenant(String key, String tenantId) throws ApiException {
        ApiResponse<DecisionDefinitionDiagramDto> localVarResp = getDecisionDefinitionDmnXmlByKeyAndTenantWithHttpInfo(key, tenantId);
        return localVarResp.getData();
    }

    /**
     * Get XML By Key and Tenant
     * Retrieves the XML of the latest version of the decision definition for tenant
     * @param key The key of the decision definition (the latest version thereof). (required)
     * @param tenantId The id of the tenant the decision definition belongs to. (required)
     * @return ApiResponse&lt;DecisionDefinitionDiagramDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Decision definition with given key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<DecisionDefinitionDiagramDto> getDecisionDefinitionDmnXmlByKeyAndTenantWithHttpInfo(String key, String tenantId) throws ApiException {
        okhttp3.Call localVarCall = getDecisionDefinitionDmnXmlByKeyAndTenantValidateBeforeCall(key, tenantId, null);
        Type localVarReturnType = new TypeToken<DecisionDefinitionDiagramDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get XML By Key and Tenant (asynchronously)
     * Retrieves the XML of the latest version of the decision definition for tenant
     * @param key The key of the decision definition (the latest version thereof). (required)
     * @param tenantId The id of the tenant the decision definition belongs to. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Decision definition with given key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getDecisionDefinitionDmnXmlByKeyAndTenantAsync(String key, String tenantId, final ApiCallback<DecisionDefinitionDiagramDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = getDecisionDefinitionDmnXmlByKeyAndTenantValidateBeforeCall(key, tenantId, _callback);
        Type localVarReturnType = new TypeToken<DecisionDefinitionDiagramDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getDecisionDefinitions
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param decisionDefinitionId Filter by decision definition id. (optional)
     * @param decisionDefinitionIdIn Filter by decision definition ids. (optional)
     * @param name Filter by decision definition name. (optional)
     * @param nameLike Filter by decision definition names that the parameter is a substring of. (optional)
     * @param deploymentId Filter by the deployment the id belongs to. (optional)
     * @param deployedAfter Filter by the deploy time of the deployment the decision definition belongs to. Only selects decision definitions that have been deployed after (exclusive) a specific time. (optional)
     * @param deployedAt Filter by the deploy time of the deployment the decision definition belongs to. Only selects decision definitions that have been deployed at a specific time (exact match). (optional)
     * @param key Filter by decision definition key, i.e., the id in the DMN 1.0 XML. Exact match. (optional)
     * @param keyLike Filter by decision definition keys that the parameter is a substring of. (optional)
     * @param category Filter by decision definition category. Exact match. (optional)
     * @param categoryLike Filter by decision definition categories that the parameter is a substring of. (optional)
     * @param version Filter by decision definition version. (optional)
     * @param latestVersion Only include those decision definitions that are latest versions. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param resourceName Filter by the name of the decision definition resource. Exact match. (optional)
     * @param resourceNameLike Filter by names of those decision definition resources that the parameter is a substring of. (optional)
     * @param decisionRequirementsDefinitionId Filter by the id of the decision requirements definition this decision definition belongs to. (optional)
     * @param decisionRequirementsDefinitionKey Filter by the key of the decision requirements definition this decision definition belongs to. (optional)
     * @param withoutDecisionRequirementsDefinition Only include decision definitions which does not belongs to any decision requirements definition. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param tenantIdIn Filter by a comma-separated list of &#x60;Strings&#x60;. A decision definition must have one of the given tenant ids. (optional)
     * @param withoutTenantId Only include decision definitions which belong to no tenant. Value can effectively only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param includeDecisionDefinitionsWithoutTenantId Include decision definitions which belong to no tenant. Can be used in combination with &#x60;tenantIdIn&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param versionTag Filter by the version tag. (optional)
     * @param versionTagLike Filter by the version tags of those decision definition resources that the parameter is a substring of. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getDecisionDefinitionsCall(String sortBy, String sortOrder, Integer firstResult, Integer maxResults, String decisionDefinitionId, String decisionDefinitionIdIn, String name, String nameLike, String deploymentId, Date deployedAfter, Date deployedAt, String key, String keyLike, String category, String categoryLike, Integer version, Boolean latestVersion, String resourceName, String resourceNameLike, String decisionRequirementsDefinitionId, String decisionRequirementsDefinitionKey, Boolean withoutDecisionRequirementsDefinition, String tenantIdIn, Boolean withoutTenantId, Boolean includeDecisionDefinitionsWithoutTenantId, String versionTag, String versionTagLike, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/decision-definition";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (sortBy != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sortBy", sortBy));
        }

        if (sortOrder != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sortOrder", sortOrder));
        }

        if (firstResult != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("firstResult", firstResult));
        }

        if (maxResults != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("maxResults", maxResults));
        }

        if (decisionDefinitionId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("decisionDefinitionId", decisionDefinitionId));
        }

        if (decisionDefinitionIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("decisionDefinitionIdIn", decisionDefinitionIdIn));
        }

        if (name != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("name", name));
        }

        if (nameLike != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("nameLike", nameLike));
        }

        if (deploymentId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("deploymentId", deploymentId));
        }

        if (deployedAfter != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("deployedAfter", deployedAfter));
        }

        if (deployedAt != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("deployedAt", deployedAt));
        }

        if (key != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("key", key));
        }

        if (keyLike != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("keyLike", keyLike));
        }

        if (category != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("category", category));
        }

        if (categoryLike != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("categoryLike", categoryLike));
        }

        if (version != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("version", version));
        }

        if (latestVersion != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("latestVersion", latestVersion));
        }

        if (resourceName != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("resourceName", resourceName));
        }

        if (resourceNameLike != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("resourceNameLike", resourceNameLike));
        }

        if (decisionRequirementsDefinitionId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("decisionRequirementsDefinitionId", decisionRequirementsDefinitionId));
        }

        if (decisionRequirementsDefinitionKey != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("decisionRequirementsDefinitionKey", decisionRequirementsDefinitionKey));
        }

        if (withoutDecisionRequirementsDefinition != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("withoutDecisionRequirementsDefinition", withoutDecisionRequirementsDefinition));
        }

        if (tenantIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("tenantIdIn", tenantIdIn));
        }

        if (withoutTenantId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("withoutTenantId", withoutTenantId));
        }

        if (includeDecisionDefinitionsWithoutTenantId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("includeDecisionDefinitionsWithoutTenantId", includeDecisionDefinitionsWithoutTenantId));
        }

        if (versionTag != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("versionTag", versionTag));
        }

        if (versionTagLike != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("versionTagLike", versionTagLike));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getDecisionDefinitionsValidateBeforeCall(String sortBy, String sortOrder, Integer firstResult, Integer maxResults, String decisionDefinitionId, String decisionDefinitionIdIn, String name, String nameLike, String deploymentId, Date deployedAfter, Date deployedAt, String key, String keyLike, String category, String categoryLike, Integer version, Boolean latestVersion, String resourceName, String resourceNameLike, String decisionRequirementsDefinitionId, String decisionRequirementsDefinitionKey, Boolean withoutDecisionRequirementsDefinition, String tenantIdIn, Boolean withoutTenantId, Boolean includeDecisionDefinitionsWithoutTenantId, String versionTag, String versionTagLike, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getDecisionDefinitionsCall(sortBy, sortOrder, firstResult, maxResults, decisionDefinitionId, decisionDefinitionIdIn, name, nameLike, deploymentId, deployedAfter, deployedAt, key, keyLike, category, categoryLike, version, latestVersion, resourceName, resourceNameLike, decisionRequirementsDefinitionId, decisionRequirementsDefinitionKey, withoutDecisionRequirementsDefinition, tenantIdIn, withoutTenantId, includeDecisionDefinitionsWithoutTenantId, versionTag, versionTagLike, _callback);
        return localVarCall;

    }

    /**
     * Get List
     * Queries for decision definitions that fulfill given parameters. Parameters may be the properties of decision definitions, such as the name, key or version. The size of the result set can be retrieved by using the [Get Decision Definition Count](https://docs.camunda.org/manual/7.20/reference/rest/decision-definition/get-query-count/) method.
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param decisionDefinitionId Filter by decision definition id. (optional)
     * @param decisionDefinitionIdIn Filter by decision definition ids. (optional)
     * @param name Filter by decision definition name. (optional)
     * @param nameLike Filter by decision definition names that the parameter is a substring of. (optional)
     * @param deploymentId Filter by the deployment the id belongs to. (optional)
     * @param deployedAfter Filter by the deploy time of the deployment the decision definition belongs to. Only selects decision definitions that have been deployed after (exclusive) a specific time. (optional)
     * @param deployedAt Filter by the deploy time of the deployment the decision definition belongs to. Only selects decision definitions that have been deployed at a specific time (exact match). (optional)
     * @param key Filter by decision definition key, i.e., the id in the DMN 1.0 XML. Exact match. (optional)
     * @param keyLike Filter by decision definition keys that the parameter is a substring of. (optional)
     * @param category Filter by decision definition category. Exact match. (optional)
     * @param categoryLike Filter by decision definition categories that the parameter is a substring of. (optional)
     * @param version Filter by decision definition version. (optional)
     * @param latestVersion Only include those decision definitions that are latest versions. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param resourceName Filter by the name of the decision definition resource. Exact match. (optional)
     * @param resourceNameLike Filter by names of those decision definition resources that the parameter is a substring of. (optional)
     * @param decisionRequirementsDefinitionId Filter by the id of the decision requirements definition this decision definition belongs to. (optional)
     * @param decisionRequirementsDefinitionKey Filter by the key of the decision requirements definition this decision definition belongs to. (optional)
     * @param withoutDecisionRequirementsDefinition Only include decision definitions which does not belongs to any decision requirements definition. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param tenantIdIn Filter by a comma-separated list of &#x60;Strings&#x60;. A decision definition must have one of the given tenant ids. (optional)
     * @param withoutTenantId Only include decision definitions which belong to no tenant. Value can effectively only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param includeDecisionDefinitionsWithoutTenantId Include decision definitions which belong to no tenant. Can be used in combination with &#x60;tenantIdIn&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param versionTag Filter by the version tag. (optional)
     * @param versionTagLike Filter by the version tags of those decision definition resources that the parameter is a substring of. (optional)
     * @return List&lt;DecisionDefinitionDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public List<DecisionDefinitionDto> getDecisionDefinitions(String sortBy, String sortOrder, Integer firstResult, Integer maxResults, String decisionDefinitionId, String decisionDefinitionIdIn, String name, String nameLike, String deploymentId, Date deployedAfter, Date deployedAt, String key, String keyLike, String category, String categoryLike, Integer version, Boolean latestVersion, String resourceName, String resourceNameLike, String decisionRequirementsDefinitionId, String decisionRequirementsDefinitionKey, Boolean withoutDecisionRequirementsDefinition, String tenantIdIn, Boolean withoutTenantId, Boolean includeDecisionDefinitionsWithoutTenantId, String versionTag, String versionTagLike) throws ApiException {
        ApiResponse<List<DecisionDefinitionDto>> localVarResp = getDecisionDefinitionsWithHttpInfo(sortBy, sortOrder, firstResult, maxResults, decisionDefinitionId, decisionDefinitionIdIn, name, nameLike, deploymentId, deployedAfter, deployedAt, key, keyLike, category, categoryLike, version, latestVersion, resourceName, resourceNameLike, decisionRequirementsDefinitionId, decisionRequirementsDefinitionKey, withoutDecisionRequirementsDefinition, tenantIdIn, withoutTenantId, includeDecisionDefinitionsWithoutTenantId, versionTag, versionTagLike);
        return localVarResp.getData();
    }

    /**
     * Get List
     * Queries for decision definitions that fulfill given parameters. Parameters may be the properties of decision definitions, such as the name, key or version. The size of the result set can be retrieved by using the [Get Decision Definition Count](https://docs.camunda.org/manual/7.20/reference/rest/decision-definition/get-query-count/) method.
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param decisionDefinitionId Filter by decision definition id. (optional)
     * @param decisionDefinitionIdIn Filter by decision definition ids. (optional)
     * @param name Filter by decision definition name. (optional)
     * @param nameLike Filter by decision definition names that the parameter is a substring of. (optional)
     * @param deploymentId Filter by the deployment the id belongs to. (optional)
     * @param deployedAfter Filter by the deploy time of the deployment the decision definition belongs to. Only selects decision definitions that have been deployed after (exclusive) a specific time. (optional)
     * @param deployedAt Filter by the deploy time of the deployment the decision definition belongs to. Only selects decision definitions that have been deployed at a specific time (exact match). (optional)
     * @param key Filter by decision definition key, i.e., the id in the DMN 1.0 XML. Exact match. (optional)
     * @param keyLike Filter by decision definition keys that the parameter is a substring of. (optional)
     * @param category Filter by decision definition category. Exact match. (optional)
     * @param categoryLike Filter by decision definition categories that the parameter is a substring of. (optional)
     * @param version Filter by decision definition version. (optional)
     * @param latestVersion Only include those decision definitions that are latest versions. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param resourceName Filter by the name of the decision definition resource. Exact match. (optional)
     * @param resourceNameLike Filter by names of those decision definition resources that the parameter is a substring of. (optional)
     * @param decisionRequirementsDefinitionId Filter by the id of the decision requirements definition this decision definition belongs to. (optional)
     * @param decisionRequirementsDefinitionKey Filter by the key of the decision requirements definition this decision definition belongs to. (optional)
     * @param withoutDecisionRequirementsDefinition Only include decision definitions which does not belongs to any decision requirements definition. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param tenantIdIn Filter by a comma-separated list of &#x60;Strings&#x60;. A decision definition must have one of the given tenant ids. (optional)
     * @param withoutTenantId Only include decision definitions which belong to no tenant. Value can effectively only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param includeDecisionDefinitionsWithoutTenantId Include decision definitions which belong to no tenant. Can be used in combination with &#x60;tenantIdIn&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param versionTag Filter by the version tag. (optional)
     * @param versionTagLike Filter by the version tags of those decision definition resources that the parameter is a substring of. (optional)
     * @return ApiResponse&lt;List&lt;DecisionDefinitionDto&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<DecisionDefinitionDto>> getDecisionDefinitionsWithHttpInfo(String sortBy, String sortOrder, Integer firstResult, Integer maxResults, String decisionDefinitionId, String decisionDefinitionIdIn, String name, String nameLike, String deploymentId, Date deployedAfter, Date deployedAt, String key, String keyLike, String category, String categoryLike, Integer version, Boolean latestVersion, String resourceName, String resourceNameLike, String decisionRequirementsDefinitionId, String decisionRequirementsDefinitionKey, Boolean withoutDecisionRequirementsDefinition, String tenantIdIn, Boolean withoutTenantId, Boolean includeDecisionDefinitionsWithoutTenantId, String versionTag, String versionTagLike) throws ApiException {
        okhttp3.Call localVarCall = getDecisionDefinitionsValidateBeforeCall(sortBy, sortOrder, firstResult, maxResults, decisionDefinitionId, decisionDefinitionIdIn, name, nameLike, deploymentId, deployedAfter, deployedAt, key, keyLike, category, categoryLike, version, latestVersion, resourceName, resourceNameLike, decisionRequirementsDefinitionId, decisionRequirementsDefinitionKey, withoutDecisionRequirementsDefinition, tenantIdIn, withoutTenantId, includeDecisionDefinitionsWithoutTenantId, versionTag, versionTagLike, null);
        Type localVarReturnType = new TypeToken<List<DecisionDefinitionDto>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get List (asynchronously)
     * Queries for decision definitions that fulfill given parameters. Parameters may be the properties of decision definitions, such as the name, key or version. The size of the result set can be retrieved by using the [Get Decision Definition Count](https://docs.camunda.org/manual/7.20/reference/rest/decision-definition/get-query-count/) method.
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param decisionDefinitionId Filter by decision definition id. (optional)
     * @param decisionDefinitionIdIn Filter by decision definition ids. (optional)
     * @param name Filter by decision definition name. (optional)
     * @param nameLike Filter by decision definition names that the parameter is a substring of. (optional)
     * @param deploymentId Filter by the deployment the id belongs to. (optional)
     * @param deployedAfter Filter by the deploy time of the deployment the decision definition belongs to. Only selects decision definitions that have been deployed after (exclusive) a specific time. (optional)
     * @param deployedAt Filter by the deploy time of the deployment the decision definition belongs to. Only selects decision definitions that have been deployed at a specific time (exact match). (optional)
     * @param key Filter by decision definition key, i.e., the id in the DMN 1.0 XML. Exact match. (optional)
     * @param keyLike Filter by decision definition keys that the parameter is a substring of. (optional)
     * @param category Filter by decision definition category. Exact match. (optional)
     * @param categoryLike Filter by decision definition categories that the parameter is a substring of. (optional)
     * @param version Filter by decision definition version. (optional)
     * @param latestVersion Only include those decision definitions that are latest versions. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param resourceName Filter by the name of the decision definition resource. Exact match. (optional)
     * @param resourceNameLike Filter by names of those decision definition resources that the parameter is a substring of. (optional)
     * @param decisionRequirementsDefinitionId Filter by the id of the decision requirements definition this decision definition belongs to. (optional)
     * @param decisionRequirementsDefinitionKey Filter by the key of the decision requirements definition this decision definition belongs to. (optional)
     * @param withoutDecisionRequirementsDefinition Only include decision definitions which does not belongs to any decision requirements definition. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param tenantIdIn Filter by a comma-separated list of &#x60;Strings&#x60;. A decision definition must have one of the given tenant ids. (optional)
     * @param withoutTenantId Only include decision definitions which belong to no tenant. Value can effectively only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param includeDecisionDefinitionsWithoutTenantId Include decision definitions which belong to no tenant. Can be used in combination with &#x60;tenantIdIn&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param versionTag Filter by the version tag. (optional)
     * @param versionTagLike Filter by the version tags of those decision definition resources that the parameter is a substring of. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getDecisionDefinitionsAsync(String sortBy, String sortOrder, Integer firstResult, Integer maxResults, String decisionDefinitionId, String decisionDefinitionIdIn, String name, String nameLike, String deploymentId, Date deployedAfter, Date deployedAt, String key, String keyLike, String category, String categoryLike, Integer version, Boolean latestVersion, String resourceName, String resourceNameLike, String decisionRequirementsDefinitionId, String decisionRequirementsDefinitionKey, Boolean withoutDecisionRequirementsDefinition, String tenantIdIn, Boolean withoutTenantId, Boolean includeDecisionDefinitionsWithoutTenantId, String versionTag, String versionTagLike, final ApiCallback<List<DecisionDefinitionDto>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getDecisionDefinitionsValidateBeforeCall(sortBy, sortOrder, firstResult, maxResults, decisionDefinitionId, decisionDefinitionIdIn, name, nameLike, deploymentId, deployedAfter, deployedAt, key, keyLike, category, categoryLike, version, latestVersion, resourceName, resourceNameLike, decisionRequirementsDefinitionId, decisionRequirementsDefinitionKey, withoutDecisionRequirementsDefinition, tenantIdIn, withoutTenantId, includeDecisionDefinitionsWithoutTenantId, versionTag, versionTagLike, _callback);
        Type localVarReturnType = new TypeToken<List<DecisionDefinitionDto>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getDecisionDefinitionsCount
     * @param decisionDefinitionId Filter by decision definition id. (optional)
     * @param decisionDefinitionIdIn Filter by decision definition ids. (optional)
     * @param name Filter by decision definition name. (optional)
     * @param nameLike Filter by decision definition names that the parameter is a substring of. (optional)
     * @param deploymentId Filter by the deployment the id belongs to. (optional)
     * @param deployedAfter Filter by the deploy time of the deployment the decision definition belongs to. Only selects decision definitions that have been deployed after (exclusive) a specific time. (optional)
     * @param deployedAt Filter by the deploy time of the deployment the decision definition belongs to. Only selects decision definitions that have been deployed at a specific time (exact match). (optional)
     * @param key Filter by decision definition key, i.e., the id in the DMN 1.0 XML. Exact match. (optional)
     * @param keyLike Filter by decision definition keys that the parameter is a substring of. (optional)
     * @param category Filter by decision definition category. Exact match. (optional)
     * @param categoryLike Filter by decision definition categories that the parameter is a substring of. (optional)
     * @param version Filter by decision definition version. (optional)
     * @param latestVersion Only include those decision definitions that are latest versions. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param resourceName Filter by the name of the decision definition resource. Exact match. (optional)
     * @param resourceNameLike Filter by names of those decision definition resources that the parameter is a substring of. (optional)
     * @param decisionRequirementsDefinitionId Filter by the id of the decision requirements definition this decision definition belongs to. (optional)
     * @param decisionRequirementsDefinitionKey Filter by the key of the decision requirements definition this decision definition belongs to. (optional)
     * @param withoutDecisionRequirementsDefinition Only include decision definitions which does not belongs to any decision requirements definition. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param tenantIdIn Filter by a comma-separated list of &#x60;Strings&#x60;. A decision definition must have one of the given tenant ids. (optional)
     * @param withoutTenantId Only include decision definitions which belong to no tenant. Value can effectively only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param includeDecisionDefinitionsWithoutTenantId Include decision definitions which belong to no tenant. Can be used in combination with &#x60;tenantIdIn&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param versionTag Filter by the version tag. (optional)
     * @param versionTagLike Filter by the version tags of those decision definition resources that the parameter is a substring of. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getDecisionDefinitionsCountCall(String decisionDefinitionId, String decisionDefinitionIdIn, String name, String nameLike, String deploymentId, Date deployedAfter, Date deployedAt, String key, String keyLike, String category, String categoryLike, Integer version, Boolean latestVersion, String resourceName, String resourceNameLike, String decisionRequirementsDefinitionId, String decisionRequirementsDefinitionKey, Boolean withoutDecisionRequirementsDefinition, String tenantIdIn, Boolean withoutTenantId, Boolean includeDecisionDefinitionsWithoutTenantId, String versionTag, String versionTagLike, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/decision-definition/count";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (decisionDefinitionId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("decisionDefinitionId", decisionDefinitionId));
        }

        if (decisionDefinitionIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("decisionDefinitionIdIn", decisionDefinitionIdIn));
        }

        if (name != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("name", name));
        }

        if (nameLike != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("nameLike", nameLike));
        }

        if (deploymentId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("deploymentId", deploymentId));
        }

        if (deployedAfter != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("deployedAfter", deployedAfter));
        }

        if (deployedAt != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("deployedAt", deployedAt));
        }

        if (key != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("key", key));
        }

        if (keyLike != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("keyLike", keyLike));
        }

        if (category != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("category", category));
        }

        if (categoryLike != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("categoryLike", categoryLike));
        }

        if (version != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("version", version));
        }

        if (latestVersion != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("latestVersion", latestVersion));
        }

        if (resourceName != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("resourceName", resourceName));
        }

        if (resourceNameLike != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("resourceNameLike", resourceNameLike));
        }

        if (decisionRequirementsDefinitionId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("decisionRequirementsDefinitionId", decisionRequirementsDefinitionId));
        }

        if (decisionRequirementsDefinitionKey != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("decisionRequirementsDefinitionKey", decisionRequirementsDefinitionKey));
        }

        if (withoutDecisionRequirementsDefinition != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("withoutDecisionRequirementsDefinition", withoutDecisionRequirementsDefinition));
        }

        if (tenantIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("tenantIdIn", tenantIdIn));
        }

        if (withoutTenantId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("withoutTenantId", withoutTenantId));
        }

        if (includeDecisionDefinitionsWithoutTenantId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("includeDecisionDefinitionsWithoutTenantId", includeDecisionDefinitionsWithoutTenantId));
        }

        if (versionTag != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("versionTag", versionTag));
        }

        if (versionTagLike != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("versionTagLike", versionTagLike));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getDecisionDefinitionsCountValidateBeforeCall(String decisionDefinitionId, String decisionDefinitionIdIn, String name, String nameLike, String deploymentId, Date deployedAfter, Date deployedAt, String key, String keyLike, String category, String categoryLike, Integer version, Boolean latestVersion, String resourceName, String resourceNameLike, String decisionRequirementsDefinitionId, String decisionRequirementsDefinitionKey, Boolean withoutDecisionRequirementsDefinition, String tenantIdIn, Boolean withoutTenantId, Boolean includeDecisionDefinitionsWithoutTenantId, String versionTag, String versionTagLike, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getDecisionDefinitionsCountCall(decisionDefinitionId, decisionDefinitionIdIn, name, nameLike, deploymentId, deployedAfter, deployedAt, key, keyLike, category, categoryLike, version, latestVersion, resourceName, resourceNameLike, decisionRequirementsDefinitionId, decisionRequirementsDefinitionKey, withoutDecisionRequirementsDefinition, tenantIdIn, withoutTenantId, includeDecisionDefinitionsWithoutTenantId, versionTag, versionTagLike, _callback);
        return localVarCall;

    }

    /**
     * Get List Count
     * Requests the number of decision definitions that fulfill the query criteria. Takes the same filtering parameters as the [Get Decision Definition](https://docs.camunda.org/manual/7.20/reference/rest/decision-definition/get-query/) method.
     * @param decisionDefinitionId Filter by decision definition id. (optional)
     * @param decisionDefinitionIdIn Filter by decision definition ids. (optional)
     * @param name Filter by decision definition name. (optional)
     * @param nameLike Filter by decision definition names that the parameter is a substring of. (optional)
     * @param deploymentId Filter by the deployment the id belongs to. (optional)
     * @param deployedAfter Filter by the deploy time of the deployment the decision definition belongs to. Only selects decision definitions that have been deployed after (exclusive) a specific time. (optional)
     * @param deployedAt Filter by the deploy time of the deployment the decision definition belongs to. Only selects decision definitions that have been deployed at a specific time (exact match). (optional)
     * @param key Filter by decision definition key, i.e., the id in the DMN 1.0 XML. Exact match. (optional)
     * @param keyLike Filter by decision definition keys that the parameter is a substring of. (optional)
     * @param category Filter by decision definition category. Exact match. (optional)
     * @param categoryLike Filter by decision definition categories that the parameter is a substring of. (optional)
     * @param version Filter by decision definition version. (optional)
     * @param latestVersion Only include those decision definitions that are latest versions. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param resourceName Filter by the name of the decision definition resource. Exact match. (optional)
     * @param resourceNameLike Filter by names of those decision definition resources that the parameter is a substring of. (optional)
     * @param decisionRequirementsDefinitionId Filter by the id of the decision requirements definition this decision definition belongs to. (optional)
     * @param decisionRequirementsDefinitionKey Filter by the key of the decision requirements definition this decision definition belongs to. (optional)
     * @param withoutDecisionRequirementsDefinition Only include decision definitions which does not belongs to any decision requirements definition. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param tenantIdIn Filter by a comma-separated list of &#x60;Strings&#x60;. A decision definition must have one of the given tenant ids. (optional)
     * @param withoutTenantId Only include decision definitions which belong to no tenant. Value can effectively only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param includeDecisionDefinitionsWithoutTenantId Include decision definitions which belong to no tenant. Can be used in combination with &#x60;tenantIdIn&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param versionTag Filter by the version tag. (optional)
     * @param versionTagLike Filter by the version tags of those decision definition resources that the parameter is a substring of. (optional)
     * @return CountResultDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public CountResultDto getDecisionDefinitionsCount(String decisionDefinitionId, String decisionDefinitionIdIn, String name, String nameLike, String deploymentId, Date deployedAfter, Date deployedAt, String key, String keyLike, String category, String categoryLike, Integer version, Boolean latestVersion, String resourceName, String resourceNameLike, String decisionRequirementsDefinitionId, String decisionRequirementsDefinitionKey, Boolean withoutDecisionRequirementsDefinition, String tenantIdIn, Boolean withoutTenantId, Boolean includeDecisionDefinitionsWithoutTenantId, String versionTag, String versionTagLike) throws ApiException {
        ApiResponse<CountResultDto> localVarResp = getDecisionDefinitionsCountWithHttpInfo(decisionDefinitionId, decisionDefinitionIdIn, name, nameLike, deploymentId, deployedAfter, deployedAt, key, keyLike, category, categoryLike, version, latestVersion, resourceName, resourceNameLike, decisionRequirementsDefinitionId, decisionRequirementsDefinitionKey, withoutDecisionRequirementsDefinition, tenantIdIn, withoutTenantId, includeDecisionDefinitionsWithoutTenantId, versionTag, versionTagLike);
        return localVarResp.getData();
    }

    /**
     * Get List Count
     * Requests the number of decision definitions that fulfill the query criteria. Takes the same filtering parameters as the [Get Decision Definition](https://docs.camunda.org/manual/7.20/reference/rest/decision-definition/get-query/) method.
     * @param decisionDefinitionId Filter by decision definition id. (optional)
     * @param decisionDefinitionIdIn Filter by decision definition ids. (optional)
     * @param name Filter by decision definition name. (optional)
     * @param nameLike Filter by decision definition names that the parameter is a substring of. (optional)
     * @param deploymentId Filter by the deployment the id belongs to. (optional)
     * @param deployedAfter Filter by the deploy time of the deployment the decision definition belongs to. Only selects decision definitions that have been deployed after (exclusive) a specific time. (optional)
     * @param deployedAt Filter by the deploy time of the deployment the decision definition belongs to. Only selects decision definitions that have been deployed at a specific time (exact match). (optional)
     * @param key Filter by decision definition key, i.e., the id in the DMN 1.0 XML. Exact match. (optional)
     * @param keyLike Filter by decision definition keys that the parameter is a substring of. (optional)
     * @param category Filter by decision definition category. Exact match. (optional)
     * @param categoryLike Filter by decision definition categories that the parameter is a substring of. (optional)
     * @param version Filter by decision definition version. (optional)
     * @param latestVersion Only include those decision definitions that are latest versions. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param resourceName Filter by the name of the decision definition resource. Exact match. (optional)
     * @param resourceNameLike Filter by names of those decision definition resources that the parameter is a substring of. (optional)
     * @param decisionRequirementsDefinitionId Filter by the id of the decision requirements definition this decision definition belongs to. (optional)
     * @param decisionRequirementsDefinitionKey Filter by the key of the decision requirements definition this decision definition belongs to. (optional)
     * @param withoutDecisionRequirementsDefinition Only include decision definitions which does not belongs to any decision requirements definition. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param tenantIdIn Filter by a comma-separated list of &#x60;Strings&#x60;. A decision definition must have one of the given tenant ids. (optional)
     * @param withoutTenantId Only include decision definitions which belong to no tenant. Value can effectively only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param includeDecisionDefinitionsWithoutTenantId Include decision definitions which belong to no tenant. Can be used in combination with &#x60;tenantIdIn&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param versionTag Filter by the version tag. (optional)
     * @param versionTagLike Filter by the version tags of those decision definition resources that the parameter is a substring of. (optional)
     * @return ApiResponse&lt;CountResultDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<CountResultDto> getDecisionDefinitionsCountWithHttpInfo(String decisionDefinitionId, String decisionDefinitionIdIn, String name, String nameLike, String deploymentId, Date deployedAfter, Date deployedAt, String key, String keyLike, String category, String categoryLike, Integer version, Boolean latestVersion, String resourceName, String resourceNameLike, String decisionRequirementsDefinitionId, String decisionRequirementsDefinitionKey, Boolean withoutDecisionRequirementsDefinition, String tenantIdIn, Boolean withoutTenantId, Boolean includeDecisionDefinitionsWithoutTenantId, String versionTag, String versionTagLike) throws ApiException {
        okhttp3.Call localVarCall = getDecisionDefinitionsCountValidateBeforeCall(decisionDefinitionId, decisionDefinitionIdIn, name, nameLike, deploymentId, deployedAfter, deployedAt, key, keyLike, category, categoryLike, version, latestVersion, resourceName, resourceNameLike, decisionRequirementsDefinitionId, decisionRequirementsDefinitionKey, withoutDecisionRequirementsDefinition, tenantIdIn, withoutTenantId, includeDecisionDefinitionsWithoutTenantId, versionTag, versionTagLike, null);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get List Count (asynchronously)
     * Requests the number of decision definitions that fulfill the query criteria. Takes the same filtering parameters as the [Get Decision Definition](https://docs.camunda.org/manual/7.20/reference/rest/decision-definition/get-query/) method.
     * @param decisionDefinitionId Filter by decision definition id. (optional)
     * @param decisionDefinitionIdIn Filter by decision definition ids. (optional)
     * @param name Filter by decision definition name. (optional)
     * @param nameLike Filter by decision definition names that the parameter is a substring of. (optional)
     * @param deploymentId Filter by the deployment the id belongs to. (optional)
     * @param deployedAfter Filter by the deploy time of the deployment the decision definition belongs to. Only selects decision definitions that have been deployed after (exclusive) a specific time. (optional)
     * @param deployedAt Filter by the deploy time of the deployment the decision definition belongs to. Only selects decision definitions that have been deployed at a specific time (exact match). (optional)
     * @param key Filter by decision definition key, i.e., the id in the DMN 1.0 XML. Exact match. (optional)
     * @param keyLike Filter by decision definition keys that the parameter is a substring of. (optional)
     * @param category Filter by decision definition category. Exact match. (optional)
     * @param categoryLike Filter by decision definition categories that the parameter is a substring of. (optional)
     * @param version Filter by decision definition version. (optional)
     * @param latestVersion Only include those decision definitions that are latest versions. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param resourceName Filter by the name of the decision definition resource. Exact match. (optional)
     * @param resourceNameLike Filter by names of those decision definition resources that the parameter is a substring of. (optional)
     * @param decisionRequirementsDefinitionId Filter by the id of the decision requirements definition this decision definition belongs to. (optional)
     * @param decisionRequirementsDefinitionKey Filter by the key of the decision requirements definition this decision definition belongs to. (optional)
     * @param withoutDecisionRequirementsDefinition Only include decision definitions which does not belongs to any decision requirements definition. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param tenantIdIn Filter by a comma-separated list of &#x60;Strings&#x60;. A decision definition must have one of the given tenant ids. (optional)
     * @param withoutTenantId Only include decision definitions which belong to no tenant. Value can effectively only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param includeDecisionDefinitionsWithoutTenantId Include decision definitions which belong to no tenant. Can be used in combination with &#x60;tenantIdIn&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param versionTag Filter by the version tag. (optional)
     * @param versionTagLike Filter by the version tags of those decision definition resources that the parameter is a substring of. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getDecisionDefinitionsCountAsync(String decisionDefinitionId, String decisionDefinitionIdIn, String name, String nameLike, String deploymentId, Date deployedAfter, Date deployedAt, String key, String keyLike, String category, String categoryLike, Integer version, Boolean latestVersion, String resourceName, String resourceNameLike, String decisionRequirementsDefinitionId, String decisionRequirementsDefinitionKey, Boolean withoutDecisionRequirementsDefinition, String tenantIdIn, Boolean withoutTenantId, Boolean includeDecisionDefinitionsWithoutTenantId, String versionTag, String versionTagLike, final ApiCallback<CountResultDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = getDecisionDefinitionsCountValidateBeforeCall(decisionDefinitionId, decisionDefinitionIdIn, name, nameLike, deploymentId, deployedAfter, deployedAt, key, keyLike, category, categoryLike, version, latestVersion, resourceName, resourceNameLike, decisionRequirementsDefinitionId, decisionRequirementsDefinitionKey, withoutDecisionRequirementsDefinition, tenantIdIn, withoutTenantId, includeDecisionDefinitionsWithoutTenantId, versionTag, versionTagLike, _callback);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for updateHistoryTimeToLiveByDecisionDefinitionId
     * @param id The id of the decision definition to change history time to live. (required)
     * @param historyTimeToLiveDto  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the request parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Decision definition with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateHistoryTimeToLiveByDecisionDefinitionIdCall(String id, HistoryTimeToLiveDto historyTimeToLiveDto, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = historyTimeToLiveDto;

        // create path and map variables
        String localVarPath = "/decision-definition/{id}/history-time-to-live"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call updateHistoryTimeToLiveByDecisionDefinitionIdValidateBeforeCall(String id, HistoryTimeToLiveDto historyTimeToLiveDto, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling updateHistoryTimeToLiveByDecisionDefinitionId(Async)");
        }
        

        okhttp3.Call localVarCall = updateHistoryTimeToLiveByDecisionDefinitionIdCall(id, historyTimeToLiveDto, _callback);
        return localVarCall;

    }

    /**
     * Update History Time to Live
     * Updates history time to live for decision definition. The field is used within [History cleanup](https://docs.camunda.org/manual/7.20/user-guide/process-engine/history/#history-cleanup).
     * @param id The id of the decision definition to change history time to live. (required)
     * @param historyTimeToLiveDto  (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the request parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Decision definition with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public void updateHistoryTimeToLiveByDecisionDefinitionId(String id, HistoryTimeToLiveDto historyTimeToLiveDto) throws ApiException {
        updateHistoryTimeToLiveByDecisionDefinitionIdWithHttpInfo(id, historyTimeToLiveDto);
    }

    /**
     * Update History Time to Live
     * Updates history time to live for decision definition. The field is used within [History cleanup](https://docs.camunda.org/manual/7.20/user-guide/process-engine/history/#history-cleanup).
     * @param id The id of the decision definition to change history time to live. (required)
     * @param historyTimeToLiveDto  (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the request parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Decision definition with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> updateHistoryTimeToLiveByDecisionDefinitionIdWithHttpInfo(String id, HistoryTimeToLiveDto historyTimeToLiveDto) throws ApiException {
        okhttp3.Call localVarCall = updateHistoryTimeToLiveByDecisionDefinitionIdValidateBeforeCall(id, historyTimeToLiveDto, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Update History Time to Live (asynchronously)
     * Updates history time to live for decision definition. The field is used within [History cleanup](https://docs.camunda.org/manual/7.20/user-guide/process-engine/history/#history-cleanup).
     * @param id The id of the decision definition to change history time to live. (required)
     * @param historyTimeToLiveDto  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the request parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Decision definition with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateHistoryTimeToLiveByDecisionDefinitionIdAsync(String id, HistoryTimeToLiveDto historyTimeToLiveDto, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = updateHistoryTimeToLiveByDecisionDefinitionIdValidateBeforeCall(id, historyTimeToLiveDto, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for updateHistoryTimeToLiveByDecisionDefinitionKey
     * @param key The key of the decision definitions to change history time to live. (required)
     * @param historyTimeToLiveDto  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the request parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Decision definition with given key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateHistoryTimeToLiveByDecisionDefinitionKeyCall(String key, HistoryTimeToLiveDto historyTimeToLiveDto, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = historyTimeToLiveDto;

        // create path and map variables
        String localVarPath = "/decision-definition/key/{key}/history-time-to-live"
            .replaceAll("\\{" + "key" + "\\}", localVarApiClient.escapeString(key.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call updateHistoryTimeToLiveByDecisionDefinitionKeyValidateBeforeCall(String key, HistoryTimeToLiveDto historyTimeToLiveDto, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'key' is set
        if (key == null) {
            throw new ApiException("Missing the required parameter 'key' when calling updateHistoryTimeToLiveByDecisionDefinitionKey(Async)");
        }
        

        okhttp3.Call localVarCall = updateHistoryTimeToLiveByDecisionDefinitionKeyCall(key, historyTimeToLiveDto, _callback);
        return localVarCall;

    }

    /**
     * Update History Time to Live By Key
     * Updates the latest version of the decision definition which belongs to no tenant. The field is used within [History cleanup](https://docs.camunda.org/manual/7.20/user-guide/process-engine/history/#history-cleanup).
     * @param key The key of the decision definitions to change history time to live. (required)
     * @param historyTimeToLiveDto  (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the request parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Decision definition with given key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public void updateHistoryTimeToLiveByDecisionDefinitionKey(String key, HistoryTimeToLiveDto historyTimeToLiveDto) throws ApiException {
        updateHistoryTimeToLiveByDecisionDefinitionKeyWithHttpInfo(key, historyTimeToLiveDto);
    }

    /**
     * Update History Time to Live By Key
     * Updates the latest version of the decision definition which belongs to no tenant. The field is used within [History cleanup](https://docs.camunda.org/manual/7.20/user-guide/process-engine/history/#history-cleanup).
     * @param key The key of the decision definitions to change history time to live. (required)
     * @param historyTimeToLiveDto  (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the request parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Decision definition with given key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> updateHistoryTimeToLiveByDecisionDefinitionKeyWithHttpInfo(String key, HistoryTimeToLiveDto historyTimeToLiveDto) throws ApiException {
        okhttp3.Call localVarCall = updateHistoryTimeToLiveByDecisionDefinitionKeyValidateBeforeCall(key, historyTimeToLiveDto, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Update History Time to Live By Key (asynchronously)
     * Updates the latest version of the decision definition which belongs to no tenant. The field is used within [History cleanup](https://docs.camunda.org/manual/7.20/user-guide/process-engine/history/#history-cleanup).
     * @param key The key of the decision definitions to change history time to live. (required)
     * @param historyTimeToLiveDto  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the request parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Decision definition with given key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateHistoryTimeToLiveByDecisionDefinitionKeyAsync(String key, HistoryTimeToLiveDto historyTimeToLiveDto, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = updateHistoryTimeToLiveByDecisionDefinitionKeyValidateBeforeCall(key, historyTimeToLiveDto, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for updateHistoryTimeToLiveByDecisionDefinitionKeyAndTenant
     * @param key The key of the decision definitions to change history time to live. (required)
     * @param tenantId The id of the tenant the decision definition belongs to. (required)
     * @param historyTimeToLiveDto  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the request parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Decision definition with given key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateHistoryTimeToLiveByDecisionDefinitionKeyAndTenantCall(String key, String tenantId, HistoryTimeToLiveDto historyTimeToLiveDto, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = historyTimeToLiveDto;

        // create path and map variables
        String localVarPath = "/decision-definition/key/{key}/tenant-id/{tenant-id}/history-time-to-live"
            .replaceAll("\\{" + "key" + "\\}", localVarApiClient.escapeString(key.toString()))
            .replaceAll("\\{" + "tenant-id" + "\\}", localVarApiClient.escapeString(tenantId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call updateHistoryTimeToLiveByDecisionDefinitionKeyAndTenantValidateBeforeCall(String key, String tenantId, HistoryTimeToLiveDto historyTimeToLiveDto, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'key' is set
        if (key == null) {
            throw new ApiException("Missing the required parameter 'key' when calling updateHistoryTimeToLiveByDecisionDefinitionKeyAndTenant(Async)");
        }
        
        // verify the required parameter 'tenantId' is set
        if (tenantId == null) {
            throw new ApiException("Missing the required parameter 'tenantId' when calling updateHistoryTimeToLiveByDecisionDefinitionKeyAndTenant(Async)");
        }
        

        okhttp3.Call localVarCall = updateHistoryTimeToLiveByDecisionDefinitionKeyAndTenantCall(key, tenantId, historyTimeToLiveDto, _callback);
        return localVarCall;

    }

    /**
     * Update History Time to Live By Key And Tenant
     * Updates the latest version of the decision definition for tenant. The field is used within [History cleanup](https://docs.camunda.org/manual/7.20/user-guide/process-engine/history/#history-cleanup). The value of the update is mandatory by default and does not allow &#x60;null&#x60; values. To enable them, please set the feature flag &#x60;enforceHistoryTimeToLive&#x60; to &#x60;false&#x60;. Read more in [Configuration Properties] (https://docs.camunda.org/manual/7.20/reference/deployment-descriptors/tags/process-engine#configuration-properties)
     * @param key The key of the decision definitions to change history time to live. (required)
     * @param tenantId The id of the tenant the decision definition belongs to. (required)
     * @param historyTimeToLiveDto  (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the request parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Decision definition with given key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public void updateHistoryTimeToLiveByDecisionDefinitionKeyAndTenant(String key, String tenantId, HistoryTimeToLiveDto historyTimeToLiveDto) throws ApiException {
        updateHistoryTimeToLiveByDecisionDefinitionKeyAndTenantWithHttpInfo(key, tenantId, historyTimeToLiveDto);
    }

    /**
     * Update History Time to Live By Key And Tenant
     * Updates the latest version of the decision definition for tenant. The field is used within [History cleanup](https://docs.camunda.org/manual/7.20/user-guide/process-engine/history/#history-cleanup). The value of the update is mandatory by default and does not allow &#x60;null&#x60; values. To enable them, please set the feature flag &#x60;enforceHistoryTimeToLive&#x60; to &#x60;false&#x60;. Read more in [Configuration Properties] (https://docs.camunda.org/manual/7.20/reference/deployment-descriptors/tags/process-engine#configuration-properties)
     * @param key The key of the decision definitions to change history time to live. (required)
     * @param tenantId The id of the tenant the decision definition belongs to. (required)
     * @param historyTimeToLiveDto  (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the request parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Decision definition with given key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> updateHistoryTimeToLiveByDecisionDefinitionKeyAndTenantWithHttpInfo(String key, String tenantId, HistoryTimeToLiveDto historyTimeToLiveDto) throws ApiException {
        okhttp3.Call localVarCall = updateHistoryTimeToLiveByDecisionDefinitionKeyAndTenantValidateBeforeCall(key, tenantId, historyTimeToLiveDto, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Update History Time to Live By Key And Tenant (asynchronously)
     * Updates the latest version of the decision definition for tenant. The field is used within [History cleanup](https://docs.camunda.org/manual/7.20/user-guide/process-engine/history/#history-cleanup). The value of the update is mandatory by default and does not allow &#x60;null&#x60; values. To enable them, please set the feature flag &#x60;enforceHistoryTimeToLive&#x60; to &#x60;false&#x60;. Read more in [Configuration Properties] (https://docs.camunda.org/manual/7.20/reference/deployment-descriptors/tags/process-engine#configuration-properties)
     * @param key The key of the decision definitions to change history time to live. (required)
     * @param tenantId The id of the tenant the decision definition belongs to. (required)
     * @param historyTimeToLiveDto  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the request parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Decision definition with given key does not exist. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateHistoryTimeToLiveByDecisionDefinitionKeyAndTenantAsync(String key, String tenantId, HistoryTimeToLiveDto historyTimeToLiveDto, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = updateHistoryTimeToLiveByDecisionDefinitionKeyAndTenantValidateBeforeCall(key, tenantId, historyTimeToLiveDto, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
}
