/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.20.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.api;

import org.camunda.community.rest.client.invoker.ApiCallback;
import org.camunda.community.rest.client.invoker.ApiClient;
import org.camunda.community.rest.client.invoker.ApiException;
import org.camunda.community.rest.client.invoker.ApiResponse;
import org.camunda.community.rest.client.invoker.Configuration;
import org.camunda.community.rest.client.invoker.Pair;
import org.camunda.community.rest.client.invoker.ProgressRequestBody;
import org.camunda.community.rest.client.invoker.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import org.camunda.community.rest.client.dto.CountResultDto;
import org.camunda.community.rest.client.dto.ExceptionDto;
import org.camunda.community.rest.client.dto.JobDefinitionDto;
import org.camunda.community.rest.client.dto.JobDefinitionPriorityDto;
import org.camunda.community.rest.client.dto.JobDefinitionQueryDto;
import org.camunda.community.rest.client.dto.JobDefinitionSuspensionStateDto;
import org.camunda.community.rest.client.dto.JobDefinitionsSuspensionStateDto;
import org.camunda.community.rest.client.dto.RetriesDto;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JobDefinitionApi {
    private ApiClient localVarApiClient;

    public JobDefinitionApi() {
        this(Configuration.getDefaultApiClient());
    }

    public JobDefinitionApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    /**
     * Build call for getJobDefinition
     * @param id The id of the job definition to be retrieved. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Job definition with given id does not exist.  See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getJobDefinitionCall(String id, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/job-definition/{id}"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getJobDefinitionValidateBeforeCall(String id, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getJobDefinition(Async)");
        }
        

        okhttp3.Call localVarCall = getJobDefinitionCall(id, _callback);
        return localVarCall;

    }

    /**
     * Get Job Definition
     * Retrieves a job definition by id, according to the &#x60;JobDefinition&#x60; interface in the engine.
     * @param id The id of the job definition to be retrieved. (required)
     * @return JobDefinitionDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Job definition with given id does not exist.  See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public JobDefinitionDto getJobDefinition(String id) throws ApiException {
        ApiResponse<JobDefinitionDto> localVarResp = getJobDefinitionWithHttpInfo(id);
        return localVarResp.getData();
    }

    /**
     * Get Job Definition
     * Retrieves a job definition by id, according to the &#x60;JobDefinition&#x60; interface in the engine.
     * @param id The id of the job definition to be retrieved. (required)
     * @return ApiResponse&lt;JobDefinitionDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Job definition with given id does not exist.  See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<JobDefinitionDto> getJobDefinitionWithHttpInfo(String id) throws ApiException {
        okhttp3.Call localVarCall = getJobDefinitionValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<JobDefinitionDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Job Definition (asynchronously)
     * Retrieves a job definition by id, according to the &#x60;JobDefinition&#x60; interface in the engine.
     * @param id The id of the job definition to be retrieved. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Job definition with given id does not exist.  See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getJobDefinitionAsync(String id, final ApiCallback<JobDefinitionDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = getJobDefinitionValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<JobDefinitionDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getJobDefinitions
     * @param jobDefinitionId Filter by job definition id. (optional)
     * @param activityIdIn Only include job definitions which belong to one of the passed and comma-separated activity ids. (optional)
     * @param processDefinitionId Only include job definitions which exist for the given process definition id. (optional)
     * @param processDefinitionKey Only include job definitions which exist for the given process definition key. (optional)
     * @param jobType Only include job definitions which exist for the given job type. See the [User Guide](https://docs.camunda.org/manual/7.20/user-guide/process-engine/the-job-executor/#job-creation) for more information about job types. (optional)
     * @param jobConfiguration Only include job definitions which exist for the given job configuration. For example: for timer jobs it is the timer configuration. (optional)
     * @param active Only include active job definitions. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param suspended Only include suspended job definitions. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param withOverridingJobPriority Only include job definitions that have an overriding job priority defined. The only effective value is &#x60;true&#x60;. If set to &#x60;false&#x60;, this filter is not applied. (optional)
     * @param tenantIdIn Only include job definitions which belong to one of the passed and comma-separated tenant ids. (optional)
     * @param withoutTenantId Only include job definitions which belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param includeJobDefinitionsWithoutTenantId Include job definitions which belong to no tenant. Can be used in combination with &#x60;tenantIdIn&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getJobDefinitionsCall(String jobDefinitionId, String activityIdIn, String processDefinitionId, String processDefinitionKey, String jobType, String jobConfiguration, Boolean active, Boolean suspended, Boolean withOverridingJobPriority, String tenantIdIn, Boolean withoutTenantId, Boolean includeJobDefinitionsWithoutTenantId, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/job-definition";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (jobDefinitionId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("jobDefinitionId", jobDefinitionId));
        }

        if (activityIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("activityIdIn", activityIdIn));
        }

        if (processDefinitionId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processDefinitionId", processDefinitionId));
        }

        if (processDefinitionKey != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processDefinitionKey", processDefinitionKey));
        }

        if (jobType != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("jobType", jobType));
        }

        if (jobConfiguration != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("jobConfiguration", jobConfiguration));
        }

        if (active != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("active", active));
        }

        if (suspended != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("suspended", suspended));
        }

        if (withOverridingJobPriority != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("withOverridingJobPriority", withOverridingJobPriority));
        }

        if (tenantIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("tenantIdIn", tenantIdIn));
        }

        if (withoutTenantId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("withoutTenantId", withoutTenantId));
        }

        if (includeJobDefinitionsWithoutTenantId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("includeJobDefinitionsWithoutTenantId", includeJobDefinitionsWithoutTenantId));
        }

        if (sortBy != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sortBy", sortBy));
        }

        if (sortOrder != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sortOrder", sortOrder));
        }

        if (firstResult != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("firstResult", firstResult));
        }

        if (maxResults != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("maxResults", maxResults));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getJobDefinitionsValidateBeforeCall(String jobDefinitionId, String activityIdIn, String processDefinitionId, String processDefinitionKey, String jobType, String jobConfiguration, Boolean active, Boolean suspended, Boolean withOverridingJobPriority, String tenantIdIn, Boolean withoutTenantId, Boolean includeJobDefinitionsWithoutTenantId, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getJobDefinitionsCall(jobDefinitionId, activityIdIn, processDefinitionId, processDefinitionKey, jobType, jobConfiguration, active, suspended, withOverridingJobPriority, tenantIdIn, withoutTenantId, includeJobDefinitionsWithoutTenantId, sortBy, sortOrder, firstResult, maxResults, _callback);
        return localVarCall;

    }

    /**
     * Get Job Definitions
     * Queries for job definitions that fulfill given parameters. The size of the result set can be retrieved by using the [Get Job Definition Count](https://docs.camunda.org/manual/7.20/reference/rest/job-definition/get-query-count/) method.
     * @param jobDefinitionId Filter by job definition id. (optional)
     * @param activityIdIn Only include job definitions which belong to one of the passed and comma-separated activity ids. (optional)
     * @param processDefinitionId Only include job definitions which exist for the given process definition id. (optional)
     * @param processDefinitionKey Only include job definitions which exist for the given process definition key. (optional)
     * @param jobType Only include job definitions which exist for the given job type. See the [User Guide](https://docs.camunda.org/manual/7.20/user-guide/process-engine/the-job-executor/#job-creation) for more information about job types. (optional)
     * @param jobConfiguration Only include job definitions which exist for the given job configuration. For example: for timer jobs it is the timer configuration. (optional)
     * @param active Only include active job definitions. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param suspended Only include suspended job definitions. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param withOverridingJobPriority Only include job definitions that have an overriding job priority defined. The only effective value is &#x60;true&#x60;. If set to &#x60;false&#x60;, this filter is not applied. (optional)
     * @param tenantIdIn Only include job definitions which belong to one of the passed and comma-separated tenant ids. (optional)
     * @param withoutTenantId Only include job definitions which belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param includeJobDefinitionsWithoutTenantId Include job definitions which belong to no tenant. Can be used in combination with &#x60;tenantIdIn&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @return List&lt;JobDefinitionDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public List<JobDefinitionDto> getJobDefinitions(String jobDefinitionId, String activityIdIn, String processDefinitionId, String processDefinitionKey, String jobType, String jobConfiguration, Boolean active, Boolean suspended, Boolean withOverridingJobPriority, String tenantIdIn, Boolean withoutTenantId, Boolean includeJobDefinitionsWithoutTenantId, String sortBy, String sortOrder, Integer firstResult, Integer maxResults) throws ApiException {
        ApiResponse<List<JobDefinitionDto>> localVarResp = getJobDefinitionsWithHttpInfo(jobDefinitionId, activityIdIn, processDefinitionId, processDefinitionKey, jobType, jobConfiguration, active, suspended, withOverridingJobPriority, tenantIdIn, withoutTenantId, includeJobDefinitionsWithoutTenantId, sortBy, sortOrder, firstResult, maxResults);
        return localVarResp.getData();
    }

    /**
     * Get Job Definitions
     * Queries for job definitions that fulfill given parameters. The size of the result set can be retrieved by using the [Get Job Definition Count](https://docs.camunda.org/manual/7.20/reference/rest/job-definition/get-query-count/) method.
     * @param jobDefinitionId Filter by job definition id. (optional)
     * @param activityIdIn Only include job definitions which belong to one of the passed and comma-separated activity ids. (optional)
     * @param processDefinitionId Only include job definitions which exist for the given process definition id. (optional)
     * @param processDefinitionKey Only include job definitions which exist for the given process definition key. (optional)
     * @param jobType Only include job definitions which exist for the given job type. See the [User Guide](https://docs.camunda.org/manual/7.20/user-guide/process-engine/the-job-executor/#job-creation) for more information about job types. (optional)
     * @param jobConfiguration Only include job definitions which exist for the given job configuration. For example: for timer jobs it is the timer configuration. (optional)
     * @param active Only include active job definitions. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param suspended Only include suspended job definitions. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param withOverridingJobPriority Only include job definitions that have an overriding job priority defined. The only effective value is &#x60;true&#x60;. If set to &#x60;false&#x60;, this filter is not applied. (optional)
     * @param tenantIdIn Only include job definitions which belong to one of the passed and comma-separated tenant ids. (optional)
     * @param withoutTenantId Only include job definitions which belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param includeJobDefinitionsWithoutTenantId Include job definitions which belong to no tenant. Can be used in combination with &#x60;tenantIdIn&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @return ApiResponse&lt;List&lt;JobDefinitionDto&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<JobDefinitionDto>> getJobDefinitionsWithHttpInfo(String jobDefinitionId, String activityIdIn, String processDefinitionId, String processDefinitionKey, String jobType, String jobConfiguration, Boolean active, Boolean suspended, Boolean withOverridingJobPriority, String tenantIdIn, Boolean withoutTenantId, Boolean includeJobDefinitionsWithoutTenantId, String sortBy, String sortOrder, Integer firstResult, Integer maxResults) throws ApiException {
        okhttp3.Call localVarCall = getJobDefinitionsValidateBeforeCall(jobDefinitionId, activityIdIn, processDefinitionId, processDefinitionKey, jobType, jobConfiguration, active, suspended, withOverridingJobPriority, tenantIdIn, withoutTenantId, includeJobDefinitionsWithoutTenantId, sortBy, sortOrder, firstResult, maxResults, null);
        Type localVarReturnType = new TypeToken<List<JobDefinitionDto>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Job Definitions (asynchronously)
     * Queries for job definitions that fulfill given parameters. The size of the result set can be retrieved by using the [Get Job Definition Count](https://docs.camunda.org/manual/7.20/reference/rest/job-definition/get-query-count/) method.
     * @param jobDefinitionId Filter by job definition id. (optional)
     * @param activityIdIn Only include job definitions which belong to one of the passed and comma-separated activity ids. (optional)
     * @param processDefinitionId Only include job definitions which exist for the given process definition id. (optional)
     * @param processDefinitionKey Only include job definitions which exist for the given process definition key. (optional)
     * @param jobType Only include job definitions which exist for the given job type. See the [User Guide](https://docs.camunda.org/manual/7.20/user-guide/process-engine/the-job-executor/#job-creation) for more information about job types. (optional)
     * @param jobConfiguration Only include job definitions which exist for the given job configuration. For example: for timer jobs it is the timer configuration. (optional)
     * @param active Only include active job definitions. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param suspended Only include suspended job definitions. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param withOverridingJobPriority Only include job definitions that have an overriding job priority defined. The only effective value is &#x60;true&#x60;. If set to &#x60;false&#x60;, this filter is not applied. (optional)
     * @param tenantIdIn Only include job definitions which belong to one of the passed and comma-separated tenant ids. (optional)
     * @param withoutTenantId Only include job definitions which belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param includeJobDefinitionsWithoutTenantId Include job definitions which belong to no tenant. Can be used in combination with &#x60;tenantIdIn&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getJobDefinitionsAsync(String jobDefinitionId, String activityIdIn, String processDefinitionId, String processDefinitionKey, String jobType, String jobConfiguration, Boolean active, Boolean suspended, Boolean withOverridingJobPriority, String tenantIdIn, Boolean withoutTenantId, Boolean includeJobDefinitionsWithoutTenantId, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, final ApiCallback<List<JobDefinitionDto>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getJobDefinitionsValidateBeforeCall(jobDefinitionId, activityIdIn, processDefinitionId, processDefinitionKey, jobType, jobConfiguration, active, suspended, withOverridingJobPriority, tenantIdIn, withoutTenantId, includeJobDefinitionsWithoutTenantId, sortBy, sortOrder, firstResult, maxResults, _callback);
        Type localVarReturnType = new TypeToken<List<JobDefinitionDto>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getJobDefinitionsCount
     * @param jobDefinitionId Filter by job definition id. (optional)
     * @param activityIdIn Only include job definitions which belong to one of the passed and comma-separated activity ids. (optional)
     * @param processDefinitionId Only include job definitions which exist for the given process definition id. (optional)
     * @param processDefinitionKey Only include job definitions which exist for the given process definition key. (optional)
     * @param jobType Only include job definitions which exist for the given job type. See the [User Guide](https://docs.camunda.org/manual/7.20/user-guide/process-engine/the-job-executor/#job-creation) for more information about job types. (optional)
     * @param jobConfiguration Only include job definitions which exist for the given job configuration. For example: for timer jobs it is the timer configuration. (optional)
     * @param active Only include active job definitions. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param suspended Only include suspended job definitions. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param withOverridingJobPriority Only include job definitions that have an overriding job priority defined. The only effective value is &#x60;true&#x60;. If set to &#x60;false&#x60;, this filter is not applied. (optional)
     * @param tenantIdIn Only include job definitions which belong to one of the passed and comma-separated tenant ids. (optional)
     * @param withoutTenantId Only include job definitions which belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param includeJobDefinitionsWithoutTenantId Include job definitions which belong to no tenant. Can be used in combination with &#x60;tenantIdIn&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getJobDefinitionsCountCall(String jobDefinitionId, String activityIdIn, String processDefinitionId, String processDefinitionKey, String jobType, String jobConfiguration, Boolean active, Boolean suspended, Boolean withOverridingJobPriority, String tenantIdIn, Boolean withoutTenantId, Boolean includeJobDefinitionsWithoutTenantId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/job-definition/count";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (jobDefinitionId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("jobDefinitionId", jobDefinitionId));
        }

        if (activityIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("activityIdIn", activityIdIn));
        }

        if (processDefinitionId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processDefinitionId", processDefinitionId));
        }

        if (processDefinitionKey != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processDefinitionKey", processDefinitionKey));
        }

        if (jobType != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("jobType", jobType));
        }

        if (jobConfiguration != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("jobConfiguration", jobConfiguration));
        }

        if (active != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("active", active));
        }

        if (suspended != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("suspended", suspended));
        }

        if (withOverridingJobPriority != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("withOverridingJobPriority", withOverridingJobPriority));
        }

        if (tenantIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("tenantIdIn", tenantIdIn));
        }

        if (withoutTenantId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("withoutTenantId", withoutTenantId));
        }

        if (includeJobDefinitionsWithoutTenantId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("includeJobDefinitionsWithoutTenantId", includeJobDefinitionsWithoutTenantId));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getJobDefinitionsCountValidateBeforeCall(String jobDefinitionId, String activityIdIn, String processDefinitionId, String processDefinitionKey, String jobType, String jobConfiguration, Boolean active, Boolean suspended, Boolean withOverridingJobPriority, String tenantIdIn, Boolean withoutTenantId, Boolean includeJobDefinitionsWithoutTenantId, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getJobDefinitionsCountCall(jobDefinitionId, activityIdIn, processDefinitionId, processDefinitionKey, jobType, jobConfiguration, active, suspended, withOverridingJobPriority, tenantIdIn, withoutTenantId, includeJobDefinitionsWithoutTenantId, _callback);
        return localVarCall;

    }

    /**
     * Get Job Definition Count
     * Queries for the number of job definitions that fulfill given parameters. Takes the same parameters as the [Get Job Definitions](https://docs.camunda.org/manual/7.20/reference/rest/job-definition/get-query/) method.
     * @param jobDefinitionId Filter by job definition id. (optional)
     * @param activityIdIn Only include job definitions which belong to one of the passed and comma-separated activity ids. (optional)
     * @param processDefinitionId Only include job definitions which exist for the given process definition id. (optional)
     * @param processDefinitionKey Only include job definitions which exist for the given process definition key. (optional)
     * @param jobType Only include job definitions which exist for the given job type. See the [User Guide](https://docs.camunda.org/manual/7.20/user-guide/process-engine/the-job-executor/#job-creation) for more information about job types. (optional)
     * @param jobConfiguration Only include job definitions which exist for the given job configuration. For example: for timer jobs it is the timer configuration. (optional)
     * @param active Only include active job definitions. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param suspended Only include suspended job definitions. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param withOverridingJobPriority Only include job definitions that have an overriding job priority defined. The only effective value is &#x60;true&#x60;. If set to &#x60;false&#x60;, this filter is not applied. (optional)
     * @param tenantIdIn Only include job definitions which belong to one of the passed and comma-separated tenant ids. (optional)
     * @param withoutTenantId Only include job definitions which belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param includeJobDefinitionsWithoutTenantId Include job definitions which belong to no tenant. Can be used in combination with &#x60;tenantIdIn&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @return CountResultDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public CountResultDto getJobDefinitionsCount(String jobDefinitionId, String activityIdIn, String processDefinitionId, String processDefinitionKey, String jobType, String jobConfiguration, Boolean active, Boolean suspended, Boolean withOverridingJobPriority, String tenantIdIn, Boolean withoutTenantId, Boolean includeJobDefinitionsWithoutTenantId) throws ApiException {
        ApiResponse<CountResultDto> localVarResp = getJobDefinitionsCountWithHttpInfo(jobDefinitionId, activityIdIn, processDefinitionId, processDefinitionKey, jobType, jobConfiguration, active, suspended, withOverridingJobPriority, tenantIdIn, withoutTenantId, includeJobDefinitionsWithoutTenantId);
        return localVarResp.getData();
    }

    /**
     * Get Job Definition Count
     * Queries for the number of job definitions that fulfill given parameters. Takes the same parameters as the [Get Job Definitions](https://docs.camunda.org/manual/7.20/reference/rest/job-definition/get-query/) method.
     * @param jobDefinitionId Filter by job definition id. (optional)
     * @param activityIdIn Only include job definitions which belong to one of the passed and comma-separated activity ids. (optional)
     * @param processDefinitionId Only include job definitions which exist for the given process definition id. (optional)
     * @param processDefinitionKey Only include job definitions which exist for the given process definition key. (optional)
     * @param jobType Only include job definitions which exist for the given job type. See the [User Guide](https://docs.camunda.org/manual/7.20/user-guide/process-engine/the-job-executor/#job-creation) for more information about job types. (optional)
     * @param jobConfiguration Only include job definitions which exist for the given job configuration. For example: for timer jobs it is the timer configuration. (optional)
     * @param active Only include active job definitions. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param suspended Only include suspended job definitions. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param withOverridingJobPriority Only include job definitions that have an overriding job priority defined. The only effective value is &#x60;true&#x60;. If set to &#x60;false&#x60;, this filter is not applied. (optional)
     * @param tenantIdIn Only include job definitions which belong to one of the passed and comma-separated tenant ids. (optional)
     * @param withoutTenantId Only include job definitions which belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param includeJobDefinitionsWithoutTenantId Include job definitions which belong to no tenant. Can be used in combination with &#x60;tenantIdIn&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @return ApiResponse&lt;CountResultDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<CountResultDto> getJobDefinitionsCountWithHttpInfo(String jobDefinitionId, String activityIdIn, String processDefinitionId, String processDefinitionKey, String jobType, String jobConfiguration, Boolean active, Boolean suspended, Boolean withOverridingJobPriority, String tenantIdIn, Boolean withoutTenantId, Boolean includeJobDefinitionsWithoutTenantId) throws ApiException {
        okhttp3.Call localVarCall = getJobDefinitionsCountValidateBeforeCall(jobDefinitionId, activityIdIn, processDefinitionId, processDefinitionKey, jobType, jobConfiguration, active, suspended, withOverridingJobPriority, tenantIdIn, withoutTenantId, includeJobDefinitionsWithoutTenantId, null);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Job Definition Count (asynchronously)
     * Queries for the number of job definitions that fulfill given parameters. Takes the same parameters as the [Get Job Definitions](https://docs.camunda.org/manual/7.20/reference/rest/job-definition/get-query/) method.
     * @param jobDefinitionId Filter by job definition id. (optional)
     * @param activityIdIn Only include job definitions which belong to one of the passed and comma-separated activity ids. (optional)
     * @param processDefinitionId Only include job definitions which exist for the given process definition id. (optional)
     * @param processDefinitionKey Only include job definitions which exist for the given process definition key. (optional)
     * @param jobType Only include job definitions which exist for the given job type. See the [User Guide](https://docs.camunda.org/manual/7.20/user-guide/process-engine/the-job-executor/#job-creation) for more information about job types. (optional)
     * @param jobConfiguration Only include job definitions which exist for the given job configuration. For example: for timer jobs it is the timer configuration. (optional)
     * @param active Only include active job definitions. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param suspended Only include suspended job definitions. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param withOverridingJobPriority Only include job definitions that have an overriding job priority defined. The only effective value is &#x60;true&#x60;. If set to &#x60;false&#x60;, this filter is not applied. (optional)
     * @param tenantIdIn Only include job definitions which belong to one of the passed and comma-separated tenant ids. (optional)
     * @param withoutTenantId Only include job definitions which belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param includeJobDefinitionsWithoutTenantId Include job definitions which belong to no tenant. Can be used in combination with &#x60;tenantIdIn&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getJobDefinitionsCountAsync(String jobDefinitionId, String activityIdIn, String processDefinitionId, String processDefinitionKey, String jobType, String jobConfiguration, Boolean active, Boolean suspended, Boolean withOverridingJobPriority, String tenantIdIn, Boolean withoutTenantId, Boolean includeJobDefinitionsWithoutTenantId, final ApiCallback<CountResultDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = getJobDefinitionsCountValidateBeforeCall(jobDefinitionId, activityIdIn, processDefinitionId, processDefinitionKey, jobType, jobConfiguration, active, suspended, withOverridingJobPriority, tenantIdIn, withoutTenantId, includeJobDefinitionsWithoutTenantId, _callback);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for queryJobDefinitions
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param jobDefinitionQueryDto  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call queryJobDefinitionsCall(Integer firstResult, Integer maxResults, JobDefinitionQueryDto jobDefinitionQueryDto, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = jobDefinitionQueryDto;

        // create path and map variables
        String localVarPath = "/job-definition";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (firstResult != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("firstResult", firstResult));
        }

        if (maxResults != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("maxResults", maxResults));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call queryJobDefinitionsValidateBeforeCall(Integer firstResult, Integer maxResults, JobDefinitionQueryDto jobDefinitionQueryDto, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = queryJobDefinitionsCall(firstResult, maxResults, jobDefinitionQueryDto, _callback);
        return localVarCall;

    }

    /**
     * Get Job Definitions (POST)
     * Queries for job definitions that fulfill given parameters. This method is slightly more powerful than the [Get Job Definitions](https://docs.camunda.org/manual/7.20/reference/rest/job-definition/get-query/) method because it allows filtering by multiple job definitions of types &#x60;String&#x60;, &#x60;Number&#x60; or &#x60;Boolean&#x60;.
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param jobDefinitionQueryDto  (optional)
     * @return List&lt;JobDefinitionDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public List<JobDefinitionDto> queryJobDefinitions(Integer firstResult, Integer maxResults, JobDefinitionQueryDto jobDefinitionQueryDto) throws ApiException {
        ApiResponse<List<JobDefinitionDto>> localVarResp = queryJobDefinitionsWithHttpInfo(firstResult, maxResults, jobDefinitionQueryDto);
        return localVarResp.getData();
    }

    /**
     * Get Job Definitions (POST)
     * Queries for job definitions that fulfill given parameters. This method is slightly more powerful than the [Get Job Definitions](https://docs.camunda.org/manual/7.20/reference/rest/job-definition/get-query/) method because it allows filtering by multiple job definitions of types &#x60;String&#x60;, &#x60;Number&#x60; or &#x60;Boolean&#x60;.
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param jobDefinitionQueryDto  (optional)
     * @return ApiResponse&lt;List&lt;JobDefinitionDto&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<JobDefinitionDto>> queryJobDefinitionsWithHttpInfo(Integer firstResult, Integer maxResults, JobDefinitionQueryDto jobDefinitionQueryDto) throws ApiException {
        okhttp3.Call localVarCall = queryJobDefinitionsValidateBeforeCall(firstResult, maxResults, jobDefinitionQueryDto, null);
        Type localVarReturnType = new TypeToken<List<JobDefinitionDto>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Job Definitions (POST) (asynchronously)
     * Queries for job definitions that fulfill given parameters. This method is slightly more powerful than the [Get Job Definitions](https://docs.camunda.org/manual/7.20/reference/rest/job-definition/get-query/) method because it allows filtering by multiple job definitions of types &#x60;String&#x60;, &#x60;Number&#x60; or &#x60;Boolean&#x60;.
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param jobDefinitionQueryDto  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call queryJobDefinitionsAsync(Integer firstResult, Integer maxResults, JobDefinitionQueryDto jobDefinitionQueryDto, final ApiCallback<List<JobDefinitionDto>> _callback) throws ApiException {

        okhttp3.Call localVarCall = queryJobDefinitionsValidateBeforeCall(firstResult, maxResults, jobDefinitionQueryDto, _callback);
        Type localVarReturnType = new TypeToken<List<JobDefinitionDto>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for queryJobDefinitionsCount
     * @param jobDefinitionQueryDto  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call queryJobDefinitionsCountCall(JobDefinitionQueryDto jobDefinitionQueryDto, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = jobDefinitionQueryDto;

        // create path and map variables
        String localVarPath = "/job-definition/count";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call queryJobDefinitionsCountValidateBeforeCall(JobDefinitionQueryDto jobDefinitionQueryDto, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = queryJobDefinitionsCountCall(jobDefinitionQueryDto, _callback);
        return localVarCall;

    }

    /**
     * Get Job Definition Count (POST)
     * Queries for the number of job definitions that fulfill given parameters. This method takes the same message body as the [Get Job Definitions (POST)](https://docs.camunda.org/manual/7.20/reference/rest/job-definition/post-query/) method and therefore it is slightly more powerful than the [Get Job Definition Count](https://docs.camunda.org/manual/7.20/reference/rest/job-definition/get-query-count/) method.
     * @param jobDefinitionQueryDto  (optional)
     * @return CountResultDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public CountResultDto queryJobDefinitionsCount(JobDefinitionQueryDto jobDefinitionQueryDto) throws ApiException {
        ApiResponse<CountResultDto> localVarResp = queryJobDefinitionsCountWithHttpInfo(jobDefinitionQueryDto);
        return localVarResp.getData();
    }

    /**
     * Get Job Definition Count (POST)
     * Queries for the number of job definitions that fulfill given parameters. This method takes the same message body as the [Get Job Definitions (POST)](https://docs.camunda.org/manual/7.20/reference/rest/job-definition/post-query/) method and therefore it is slightly more powerful than the [Get Job Definition Count](https://docs.camunda.org/manual/7.20/reference/rest/job-definition/get-query-count/) method.
     * @param jobDefinitionQueryDto  (optional)
     * @return ApiResponse&lt;CountResultDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<CountResultDto> queryJobDefinitionsCountWithHttpInfo(JobDefinitionQueryDto jobDefinitionQueryDto) throws ApiException {
        okhttp3.Call localVarCall = queryJobDefinitionsCountValidateBeforeCall(jobDefinitionQueryDto, null);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Job Definition Count (POST) (asynchronously)
     * Queries for the number of job definitions that fulfill given parameters. This method takes the same message body as the [Get Job Definitions (POST)](https://docs.camunda.org/manual/7.20/reference/rest/job-definition/post-query/) method and therefore it is slightly more powerful than the [Get Job Definition Count](https://docs.camunda.org/manual/7.20/reference/rest/job-definition/get-query-count/) method.
     * @param jobDefinitionQueryDto  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call queryJobDefinitionsCountAsync(JobDefinitionQueryDto jobDefinitionQueryDto, final ApiCallback<CountResultDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = queryJobDefinitionsCountValidateBeforeCall(jobDefinitionQueryDto, _callback);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for setJobPriorityJobDefinition
     * @param id The id of the job definition to be updated. (required)
     * @param jobDefinitionPriorityDto  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Job definition with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> The retries could not be set successfully. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call setJobPriorityJobDefinitionCall(String id, JobDefinitionPriorityDto jobDefinitionPriorityDto, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = jobDefinitionPriorityDto;

        // create path and map variables
        String localVarPath = "/job-definition/{id}/jobPriority"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call setJobPriorityJobDefinitionValidateBeforeCall(String id, JobDefinitionPriorityDto jobDefinitionPriorityDto, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling setJobPriorityJobDefinition(Async)");
        }
        

        okhttp3.Call localVarCall = setJobPriorityJobDefinitionCall(id, jobDefinitionPriorityDto, _callback);
        return localVarCall;

    }

    /**
     * Set Job Definition Priority by Id
     * Sets an overriding execution priority for jobs with the given definition id. Optionally, the priorities of all the definitions&#39; existing jobs are updated accordingly. The priority can be reset by setting it to &#x60;null&#x60;, meaning that a new job&#39;s priority will not be determined based on its definition&#39;s priority any longer. See the [user guide on job prioritization](https://docs.camunda.org/manual/7.20/user-guide/process-engine/the-job-executor/#set-job-definition-priorities-via-managementservice-api) for details.
     * @param id The id of the job definition to be updated. (required)
     * @param jobDefinitionPriorityDto  (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Job definition with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> The retries could not be set successfully. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public void setJobPriorityJobDefinition(String id, JobDefinitionPriorityDto jobDefinitionPriorityDto) throws ApiException {
        setJobPriorityJobDefinitionWithHttpInfo(id, jobDefinitionPriorityDto);
    }

    /**
     * Set Job Definition Priority by Id
     * Sets an overriding execution priority for jobs with the given definition id. Optionally, the priorities of all the definitions&#39; existing jobs are updated accordingly. The priority can be reset by setting it to &#x60;null&#x60;, meaning that a new job&#39;s priority will not be determined based on its definition&#39;s priority any longer. See the [user guide on job prioritization](https://docs.camunda.org/manual/7.20/user-guide/process-engine/the-job-executor/#set-job-definition-priorities-via-managementservice-api) for details.
     * @param id The id of the job definition to be updated. (required)
     * @param jobDefinitionPriorityDto  (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Job definition with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> The retries could not be set successfully. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> setJobPriorityJobDefinitionWithHttpInfo(String id, JobDefinitionPriorityDto jobDefinitionPriorityDto) throws ApiException {
        okhttp3.Call localVarCall = setJobPriorityJobDefinitionValidateBeforeCall(id, jobDefinitionPriorityDto, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Set Job Definition Priority by Id (asynchronously)
     * Sets an overriding execution priority for jobs with the given definition id. Optionally, the priorities of all the definitions&#39; existing jobs are updated accordingly. The priority can be reset by setting it to &#x60;null&#x60;, meaning that a new job&#39;s priority will not be determined based on its definition&#39;s priority any longer. See the [user guide on job prioritization](https://docs.camunda.org/manual/7.20/user-guide/process-engine/the-job-executor/#set-job-definition-priorities-via-managementservice-api) for details.
     * @param id The id of the job definition to be updated. (required)
     * @param jobDefinitionPriorityDto  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Job definition with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> The retries could not be set successfully. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call setJobPriorityJobDefinitionAsync(String id, JobDefinitionPriorityDto jobDefinitionPriorityDto, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = setJobPriorityJobDefinitionValidateBeforeCall(id, jobDefinitionPriorityDto, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for setJobRetriesJobDefinition
     * @param id The id of the job definition to be updated. (required)
     * @param retriesDto  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> The retries could not be set successfully. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call setJobRetriesJobDefinitionCall(String id, RetriesDto retriesDto, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = retriesDto;

        // create path and map variables
        String localVarPath = "/job-definition/{id}/retries"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call setJobRetriesJobDefinitionValidateBeforeCall(String id, RetriesDto retriesDto, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling setJobRetriesJobDefinition(Async)");
        }
        

        okhttp3.Call localVarCall = setJobRetriesJobDefinitionCall(id, retriesDto, _callback);
        return localVarCall;

    }

    /**
     * Set Job Retries By Job Definition Id
     * Sets the number of retries of all **failed** jobs associated with the given job definition id.
     * @param id The id of the job definition to be updated. (required)
     * @param retriesDto  (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> The retries could not be set successfully. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public void setJobRetriesJobDefinition(String id, RetriesDto retriesDto) throws ApiException {
        setJobRetriesJobDefinitionWithHttpInfo(id, retriesDto);
    }

    /**
     * Set Job Retries By Job Definition Id
     * Sets the number of retries of all **failed** jobs associated with the given job definition id.
     * @param id The id of the job definition to be updated. (required)
     * @param retriesDto  (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> The retries could not be set successfully. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> setJobRetriesJobDefinitionWithHttpInfo(String id, RetriesDto retriesDto) throws ApiException {
        okhttp3.Call localVarCall = setJobRetriesJobDefinitionValidateBeforeCall(id, retriesDto, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Set Job Retries By Job Definition Id (asynchronously)
     * Sets the number of retries of all **failed** jobs associated with the given job definition id.
     * @param id The id of the job definition to be updated. (required)
     * @param retriesDto  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> The retries could not be set successfully. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call setJobRetriesJobDefinitionAsync(String id, RetriesDto retriesDto, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = setJobRetriesJobDefinitionValidateBeforeCall(id, retriesDto, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for updateSuspensionStateJobDefinition
     * @param id The id of the job definition to activate or suspend. (required)
     * @param jobDefinitionSuspensionStateDto  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the request parameters are invalid, for example if the provided &#x60;executionDate&#x60; parameter doesn&#39;t have the expected format. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateSuspensionStateJobDefinitionCall(String id, JobDefinitionSuspensionStateDto jobDefinitionSuspensionStateDto, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = jobDefinitionSuspensionStateDto;

        // create path and map variables
        String localVarPath = "/job-definition/{id}/suspended"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call updateSuspensionStateJobDefinitionValidateBeforeCall(String id, JobDefinitionSuspensionStateDto jobDefinitionSuspensionStateDto, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling updateSuspensionStateJobDefinition(Async)");
        }
        

        okhttp3.Call localVarCall = updateSuspensionStateJobDefinitionCall(id, jobDefinitionSuspensionStateDto, _callback);
        return localVarCall;

    }

    /**
     * Activate/Suspend Job Definition By Id
     * Activates or suspends a given job definition by id.
     * @param id The id of the job definition to activate or suspend. (required)
     * @param jobDefinitionSuspensionStateDto  (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the request parameters are invalid, for example if the provided &#x60;executionDate&#x60; parameter doesn&#39;t have the expected format. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public void updateSuspensionStateJobDefinition(String id, JobDefinitionSuspensionStateDto jobDefinitionSuspensionStateDto) throws ApiException {
        updateSuspensionStateJobDefinitionWithHttpInfo(id, jobDefinitionSuspensionStateDto);
    }

    /**
     * Activate/Suspend Job Definition By Id
     * Activates or suspends a given job definition by id.
     * @param id The id of the job definition to activate or suspend. (required)
     * @param jobDefinitionSuspensionStateDto  (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the request parameters are invalid, for example if the provided &#x60;executionDate&#x60; parameter doesn&#39;t have the expected format. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> updateSuspensionStateJobDefinitionWithHttpInfo(String id, JobDefinitionSuspensionStateDto jobDefinitionSuspensionStateDto) throws ApiException {
        okhttp3.Call localVarCall = updateSuspensionStateJobDefinitionValidateBeforeCall(id, jobDefinitionSuspensionStateDto, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Activate/Suspend Job Definition By Id (asynchronously)
     * Activates or suspends a given job definition by id.
     * @param id The id of the job definition to activate or suspend. (required)
     * @param jobDefinitionSuspensionStateDto  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the request parameters are invalid, for example if the provided &#x60;executionDate&#x60; parameter doesn&#39;t have the expected format. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateSuspensionStateJobDefinitionAsync(String id, JobDefinitionSuspensionStateDto jobDefinitionSuspensionStateDto, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = updateSuspensionStateJobDefinitionValidateBeforeCall(id, jobDefinitionSuspensionStateDto, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for updateSuspensionStateJobDefinitions
     * @param jobDefinitionsSuspensionStateDto  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the request parameters are invalid, for example if the provided &#x60;executionDate&#x60; parameter doesn&#39;t have the expected format. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateSuspensionStateJobDefinitionsCall(JobDefinitionsSuspensionStateDto jobDefinitionsSuspensionStateDto, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = jobDefinitionsSuspensionStateDto;

        // create path and map variables
        String localVarPath = "/job-definition/suspended";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call updateSuspensionStateJobDefinitionsValidateBeforeCall(JobDefinitionsSuspensionStateDto jobDefinitionsSuspensionStateDto, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = updateSuspensionStateJobDefinitionsCall(jobDefinitionsSuspensionStateDto, _callback);
        return localVarCall;

    }

    /**
     * Activate/Suspend Job Definitions
     * Activates or suspends job definitions with the given process definition id or process definition key.
     * @param jobDefinitionsSuspensionStateDto  (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the request parameters are invalid, for example if the provided &#x60;executionDate&#x60; parameter doesn&#39;t have the expected format. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public void updateSuspensionStateJobDefinitions(JobDefinitionsSuspensionStateDto jobDefinitionsSuspensionStateDto) throws ApiException {
        updateSuspensionStateJobDefinitionsWithHttpInfo(jobDefinitionsSuspensionStateDto);
    }

    /**
     * Activate/Suspend Job Definitions
     * Activates or suspends job definitions with the given process definition id or process definition key.
     * @param jobDefinitionsSuspensionStateDto  (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the request parameters are invalid, for example if the provided &#x60;executionDate&#x60; parameter doesn&#39;t have the expected format. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> updateSuspensionStateJobDefinitionsWithHttpInfo(JobDefinitionsSuspensionStateDto jobDefinitionsSuspensionStateDto) throws ApiException {
        okhttp3.Call localVarCall = updateSuspensionStateJobDefinitionsValidateBeforeCall(jobDefinitionsSuspensionStateDto, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Activate/Suspend Job Definitions (asynchronously)
     * Activates or suspends job definitions with the given process definition id or process definition key.
     * @param jobDefinitionsSuspensionStateDto  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the request parameters are invalid, for example if the provided &#x60;executionDate&#x60; parameter doesn&#39;t have the expected format. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateSuspensionStateJobDefinitionsAsync(JobDefinitionsSuspensionStateDto jobDefinitionsSuspensionStateDto, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = updateSuspensionStateJobDefinitionsValidateBeforeCall(jobDefinitionsSuspensionStateDto, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
}
