/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.20.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.dto;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Date;

/**
 * EventSubscriptionDto
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-10-27T07:19:49.896034Z[Etc/UTC]")
public class EventSubscriptionDto {
  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private String id;

  public static final String SERIALIZED_NAME_EVENT_TYPE = "eventType";
  @SerializedName(SERIALIZED_NAME_EVENT_TYPE)
  private String eventType;

  public static final String SERIALIZED_NAME_EVENT_NAME = "eventName";
  @SerializedName(SERIALIZED_NAME_EVENT_NAME)
  private String eventName;

  public static final String SERIALIZED_NAME_EXECUTION_ID = "executionId";
  @SerializedName(SERIALIZED_NAME_EXECUTION_ID)
  private String executionId;

  public static final String SERIALIZED_NAME_PROCESS_INSTANCE_ID = "processInstanceId";
  @SerializedName(SERIALIZED_NAME_PROCESS_INSTANCE_ID)
  private String processInstanceId;

  public static final String SERIALIZED_NAME_ACTIVITY_ID = "activityId";
  @SerializedName(SERIALIZED_NAME_ACTIVITY_ID)
  private String activityId;

  public static final String SERIALIZED_NAME_CREATED_DATE = "createdDate";
  @SerializedName(SERIALIZED_NAME_CREATED_DATE)
  private Date createdDate;

  public static final String SERIALIZED_NAME_TENANT_ID = "tenantId";
  @SerializedName(SERIALIZED_NAME_TENANT_ID)
  private String tenantId;


  public EventSubscriptionDto id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * The id of the event subscription.
   * @return id
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The id of the event subscription.")

  public String getId() {
    return id;
  }


  public void setId(String id) {
    this.id = id;
  }


  public EventSubscriptionDto eventType(String eventType) {
    
    this.eventType = eventType;
    return this;
  }

   /**
   * The type of the event subscription.
   * @return eventType
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The type of the event subscription.")

  public String getEventType() {
    return eventType;
  }


  public void setEventType(String eventType) {
    this.eventType = eventType;
  }


  public EventSubscriptionDto eventName(String eventName) {
    
    this.eventName = eventName;
    return this;
  }

   /**
   * The name of the event this subscription belongs to as defined in the process model.
   * @return eventName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The name of the event this subscription belongs to as defined in the process model.")

  public String getEventName() {
    return eventName;
  }


  public void setEventName(String eventName) {
    this.eventName = eventName;
  }


  public EventSubscriptionDto executionId(String executionId) {
    
    this.executionId = executionId;
    return this;
  }

   /**
   * The execution that is subscribed on the referenced event.
   * @return executionId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The execution that is subscribed on the referenced event.")

  public String getExecutionId() {
    return executionId;
  }


  public void setExecutionId(String executionId) {
    this.executionId = executionId;
  }


  public EventSubscriptionDto processInstanceId(String processInstanceId) {
    
    this.processInstanceId = processInstanceId;
    return this;
  }

   /**
   * The process instance this subscription belongs to.
   * @return processInstanceId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The process instance this subscription belongs to.")

  public String getProcessInstanceId() {
    return processInstanceId;
  }


  public void setProcessInstanceId(String processInstanceId) {
    this.processInstanceId = processInstanceId;
  }


  public EventSubscriptionDto activityId(String activityId) {
    
    this.activityId = activityId;
    return this;
  }

   /**
   * The identifier of the activity that this event subscription belongs to. This could for example be the id of a receive task.
   * @return activityId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The identifier of the activity that this event subscription belongs to. This could for example be the id of a receive task.")

  public String getActivityId() {
    return activityId;
  }


  public void setActivityId(String activityId) {
    this.activityId = activityId;
  }


  public EventSubscriptionDto createdDate(Date createdDate) {
    
    this.createdDate = createdDate;
    return this;
  }

   /**
   * The time this event subscription was created.
   * @return createdDate
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The time this event subscription was created.")

  public Date getCreatedDate() {
    return createdDate;
  }


  public void setCreatedDate(Date createdDate) {
    this.createdDate = createdDate;
  }


  public EventSubscriptionDto tenantId(String tenantId) {
    
    this.tenantId = tenantId;
    return this;
  }

   /**
   * The id of the tenant this event subscription belongs to. Can be &#x60;null&#x60; if the subscription belongs to no single tenant.
   * @return tenantId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The id of the tenant this event subscription belongs to. Can be `null` if the subscription belongs to no single tenant.")

  public String getTenantId() {
    return tenantId;
  }


  public void setTenantId(String tenantId) {
    this.tenantId = tenantId;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    EventSubscriptionDto eventSubscriptionDto = (EventSubscriptionDto) o;
    return Objects.equals(this.id, eventSubscriptionDto.id) &&
        Objects.equals(this.eventType, eventSubscriptionDto.eventType) &&
        Objects.equals(this.eventName, eventSubscriptionDto.eventName) &&
        Objects.equals(this.executionId, eventSubscriptionDto.executionId) &&
        Objects.equals(this.processInstanceId, eventSubscriptionDto.processInstanceId) &&
        Objects.equals(this.activityId, eventSubscriptionDto.activityId) &&
        Objects.equals(this.createdDate, eventSubscriptionDto.createdDate) &&
        Objects.equals(this.tenantId, eventSubscriptionDto.tenantId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, eventType, eventName, executionId, processInstanceId, activityId, createdDate, tenantId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class EventSubscriptionDto {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    eventType: ").append(toIndentedString(eventType)).append("\n");
    sb.append("    eventName: ").append(toIndentedString(eventName)).append("\n");
    sb.append("    executionId: ").append(toIndentedString(executionId)).append("\n");
    sb.append("    processInstanceId: ").append(toIndentedString(processInstanceId)).append("\n");
    sb.append("    activityId: ").append(toIndentedString(activityId)).append("\n");
    sb.append("    createdDate: ").append(toIndentedString(createdDate)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

