/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.20.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.dto;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.camunda.community.rest.client.dto.GroupQueryDtoSorting;

/**
 * A group instance query which defines a list of group instances
 */
@ApiModel(description = "A group instance query which defines a list of group instances")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-10-27T07:19:49.896034Z[Etc/UTC]")
public class GroupQueryDto {
  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private String id;

  public static final String SERIALIZED_NAME_ID_IN = "idIn";
  @SerializedName(SERIALIZED_NAME_ID_IN)
  private List<String> idIn = null;

  public static final String SERIALIZED_NAME_NAME = "name";
  @SerializedName(SERIALIZED_NAME_NAME)
  private String name;

  public static final String SERIALIZED_NAME_NAME_LIKE = "nameLike";
  @SerializedName(SERIALIZED_NAME_NAME_LIKE)
  private String nameLike;

  public static final String SERIALIZED_NAME_TYPE = "type";
  @SerializedName(SERIALIZED_NAME_TYPE)
  private String type;

  public static final String SERIALIZED_NAME_MEMBER = "member";
  @SerializedName(SERIALIZED_NAME_MEMBER)
  private String member;

  public static final String SERIALIZED_NAME_MEMBER_OF_TENANT = "memberOfTenant";
  @SerializedName(SERIALIZED_NAME_MEMBER_OF_TENANT)
  private String memberOfTenant;

  public static final String SERIALIZED_NAME_SORTING = "sorting";
  @SerializedName(SERIALIZED_NAME_SORTING)
  private List<GroupQueryDtoSorting> sorting = null;


  public GroupQueryDto id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * Filter by the id of the group.
   * @return id
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Filter by the id of the group.")

  public String getId() {
    return id;
  }


  public void setId(String id) {
    this.id = id;
  }


  public GroupQueryDto idIn(List<String> idIn) {
    
    this.idIn = idIn;
    return this;
  }

  public GroupQueryDto addIdInItem(String idInItem) {
    if (this.idIn == null) {
      this.idIn = new ArrayList<String>();
    }
    this.idIn.add(idInItem);
    return this;
  }

   /**
   * Filter by a JSON string array of group ids.
   * @return idIn
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Filter by a JSON string array of group ids.")

  public List<String> getIdIn() {
    return idIn;
  }


  public void setIdIn(List<String> idIn) {
    this.idIn = idIn;
  }


  public GroupQueryDto name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Filter by the name of the group.
   * @return name
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Filter by the name of the group.")

  public String getName() {
    return name;
  }


  public void setName(String name) {
    this.name = name;
  }


  public GroupQueryDto nameLike(String nameLike) {
    
    this.nameLike = nameLike;
    return this;
  }

   /**
   * Filter by the name that the parameter is a substring of.
   * @return nameLike
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Filter by the name that the parameter is a substring of.")

  public String getNameLike() {
    return nameLike;
  }


  public void setNameLike(String nameLike) {
    this.nameLike = nameLike;
  }


  public GroupQueryDto type(String type) {
    
    this.type = type;
    return this;
  }

   /**
   * Filter by the type of the group.
   * @return type
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Filter by the type of the group.")

  public String getType() {
    return type;
  }


  public void setType(String type) {
    this.type = type;
  }


  public GroupQueryDto member(String member) {
    
    this.member = member;
    return this;
  }

   /**
   * Only retrieve groups where the given user id is a member of.
   * @return member
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Only retrieve groups where the given user id is a member of.")

  public String getMember() {
    return member;
  }


  public void setMember(String member) {
    this.member = member;
  }


  public GroupQueryDto memberOfTenant(String memberOfTenant) {
    
    this.memberOfTenant = memberOfTenant;
    return this;
  }

   /**
   * Only retrieve groups which are members of the given tenant.
   * @return memberOfTenant
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Only retrieve groups which are members of the given tenant.")

  public String getMemberOfTenant() {
    return memberOfTenant;
  }


  public void setMemberOfTenant(String memberOfTenant) {
    this.memberOfTenant = memberOfTenant;
  }


  public GroupQueryDto sorting(List<GroupQueryDtoSorting> sorting) {
    
    this.sorting = sorting;
    return this;
  }

  public GroupQueryDto addSortingItem(GroupQueryDtoSorting sortingItem) {
    if (this.sorting == null) {
      this.sorting = new ArrayList<GroupQueryDtoSorting>();
    }
    this.sorting.add(sortingItem);
    return this;
  }

   /**
   * Apply sorting of the result
   * @return sorting
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Apply sorting of the result")

  public List<GroupQueryDtoSorting> getSorting() {
    return sorting;
  }


  public void setSorting(List<GroupQueryDtoSorting> sorting) {
    this.sorting = sorting;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GroupQueryDto groupQueryDto = (GroupQueryDto) o;
    return Objects.equals(this.id, groupQueryDto.id) &&
        Objects.equals(this.idIn, groupQueryDto.idIn) &&
        Objects.equals(this.name, groupQueryDto.name) &&
        Objects.equals(this.nameLike, groupQueryDto.nameLike) &&
        Objects.equals(this.type, groupQueryDto.type) &&
        Objects.equals(this.member, groupQueryDto.member) &&
        Objects.equals(this.memberOfTenant, groupQueryDto.memberOfTenant) &&
        Objects.equals(this.sorting, groupQueryDto.sorting);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, idIn, name, nameLike, type, member, memberOfTenant, sorting);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GroupQueryDto {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    idIn: ").append(toIndentedString(idIn)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    nameLike: ").append(toIndentedString(nameLike)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    member: ").append(toIndentedString(member)).append("\n");
    sb.append("    memberOfTenant: ").append(toIndentedString(memberOfTenant)).append("\n");
    sb.append("    sorting: ").append(toIndentedString(sorting)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

