/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.20.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.dto;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

/**
 * HistoricActivityStatisticsDto
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-10-27T07:19:49.896034Z[Etc/UTC]")
public class HistoricActivityStatisticsDto {
  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private String id;

  public static final String SERIALIZED_NAME_INSTANCES = "instances";
  @SerializedName(SERIALIZED_NAME_INSTANCES)
  private Long instances;

  public static final String SERIALIZED_NAME_CANCELED = "canceled";
  @SerializedName(SERIALIZED_NAME_CANCELED)
  private Long canceled;

  public static final String SERIALIZED_NAME_FINISHED = "finished";
  @SerializedName(SERIALIZED_NAME_FINISHED)
  private Long finished;

  public static final String SERIALIZED_NAME_COMPLETE_SCOPE = "completeScope";
  @SerializedName(SERIALIZED_NAME_COMPLETE_SCOPE)
  private Long completeScope;

  public static final String SERIALIZED_NAME_OPEN_INCIDENTS = "openIncidents";
  @SerializedName(SERIALIZED_NAME_OPEN_INCIDENTS)
  private Long openIncidents;

  public static final String SERIALIZED_NAME_RESOLVED_INCIDENTS = "resolvedIncidents";
  @SerializedName(SERIALIZED_NAME_RESOLVED_INCIDENTS)
  private Long resolvedIncidents;

  public static final String SERIALIZED_NAME_DELETED_INCIDENTS = "deletedIncidents";
  @SerializedName(SERIALIZED_NAME_DELETED_INCIDENTS)
  private Long deletedIncidents;


  public HistoricActivityStatisticsDto id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * The id of the activity the results are aggregated for.
   * @return id
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The id of the activity the results are aggregated for.")

  public String getId() {
    return id;
  }


  public void setId(String id) {
    this.id = id;
  }


  public HistoricActivityStatisticsDto instances(Long instances) {
    
    this.instances = instances;
    return this;
  }

   /**
   * The total number of all running instances of the activity.
   * @return instances
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The total number of all running instances of the activity.")

  public Long getInstances() {
    return instances;
  }


  public void setInstances(Long instances) {
    this.instances = instances;
  }


  public HistoricActivityStatisticsDto canceled(Long canceled) {
    
    this.canceled = canceled;
    return this;
  }

   /**
   * The total number of all canceled instances of the activity. **Note:** Will be &#x60;0&#x60; (not &#x60;null&#x60;), if canceled activity instances were excluded.
   * @return canceled
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The total number of all canceled instances of the activity. **Note:** Will be `0` (not `null`), if canceled activity instances were excluded.")

  public Long getCanceled() {
    return canceled;
  }


  public void setCanceled(Long canceled) {
    this.canceled = canceled;
  }


  public HistoricActivityStatisticsDto finished(Long finished) {
    
    this.finished = finished;
    return this;
  }

   /**
   * The total number of all finished instances of the activity. **Note:** Will be &#x60;0&#x60; (not &#x60;null&#x60;), if finished activity instances were excluded.
   * @return finished
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The total number of all finished instances of the activity. **Note:** Will be `0` (not `null`), if finished activity instances were excluded.")

  public Long getFinished() {
    return finished;
  }


  public void setFinished(Long finished) {
    this.finished = finished;
  }


  public HistoricActivityStatisticsDto completeScope(Long completeScope) {
    
    this.completeScope = completeScope;
    return this;
  }

   /**
   * The total number of all instances which completed a scope of the activity. **Note:** Will be &#x60;0&#x60; (not &#x60;null&#x60;), if activity instances which completed a scope were excluded.
   * @return completeScope
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The total number of all instances which completed a scope of the activity. **Note:** Will be `0` (not `null`), if activity instances which completed a scope were excluded.")

  public Long getCompleteScope() {
    return completeScope;
  }


  public void setCompleteScope(Long completeScope) {
    this.completeScope = completeScope;
  }


  public HistoricActivityStatisticsDto openIncidents(Long openIncidents) {
    
    this.openIncidents = openIncidents;
    return this;
  }

   /**
   * The total number of open incidents for the activity. **Note:** Will be &#x60;0&#x60; (not &#x60;null&#x60;), if &#x60;incidents&#x60; is set to &#x60;false&#x60;.
   * @return openIncidents
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The total number of open incidents for the activity. **Note:** Will be `0` (not `null`), if `incidents` is set to `false`.")

  public Long getOpenIncidents() {
    return openIncidents;
  }


  public void setOpenIncidents(Long openIncidents) {
    this.openIncidents = openIncidents;
  }


  public HistoricActivityStatisticsDto resolvedIncidents(Long resolvedIncidents) {
    
    this.resolvedIncidents = resolvedIncidents;
    return this;
  }

   /**
   * The total number of resolved incidents for the activity. **Note:** Will be &#x60;0&#x60; (not &#x60;null&#x60;), if &#x60;incidents&#x60; is set to &#x60;false&#x60;.
   * @return resolvedIncidents
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The total number of resolved incidents for the activity. **Note:** Will be `0` (not `null`), if `incidents` is set to `false`.")

  public Long getResolvedIncidents() {
    return resolvedIncidents;
  }


  public void setResolvedIncidents(Long resolvedIncidents) {
    this.resolvedIncidents = resolvedIncidents;
  }


  public HistoricActivityStatisticsDto deletedIncidents(Long deletedIncidents) {
    
    this.deletedIncidents = deletedIncidents;
    return this;
  }

   /**
   * The total number of deleted incidents for the activity. **Note:** Will be &#x60;0&#x60; (not &#x60;null&#x60;), if &#x60;incidents&#x60; is set to &#x60;false&#x60;.
   * @return deletedIncidents
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The total number of deleted incidents for the activity. **Note:** Will be `0` (not `null`), if `incidents` is set to `false`.")

  public Long getDeletedIncidents() {
    return deletedIncidents;
  }


  public void setDeletedIncidents(Long deletedIncidents) {
    this.deletedIncidents = deletedIncidents;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    HistoricActivityStatisticsDto historicActivityStatisticsDto = (HistoricActivityStatisticsDto) o;
    return Objects.equals(this.id, historicActivityStatisticsDto.id) &&
        Objects.equals(this.instances, historicActivityStatisticsDto.instances) &&
        Objects.equals(this.canceled, historicActivityStatisticsDto.canceled) &&
        Objects.equals(this.finished, historicActivityStatisticsDto.finished) &&
        Objects.equals(this.completeScope, historicActivityStatisticsDto.completeScope) &&
        Objects.equals(this.openIncidents, historicActivityStatisticsDto.openIncidents) &&
        Objects.equals(this.resolvedIncidents, historicActivityStatisticsDto.resolvedIncidents) &&
        Objects.equals(this.deletedIncidents, historicActivityStatisticsDto.deletedIncidents);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, instances, canceled, finished, completeScope, openIncidents, resolvedIncidents, deletedIncidents);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class HistoricActivityStatisticsDto {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    instances: ").append(toIndentedString(instances)).append("\n");
    sb.append("    canceled: ").append(toIndentedString(canceled)).append("\n");
    sb.append("    finished: ").append(toIndentedString(finished)).append("\n");
    sb.append("    completeScope: ").append(toIndentedString(completeScope)).append("\n");
    sb.append("    openIncidents: ").append(toIndentedString(openIncidents)).append("\n");
    sb.append("    resolvedIncidents: ").append(toIndentedString(resolvedIncidents)).append("\n");
    sb.append("    deletedIncidents: ").append(toIndentedString(deletedIncidents)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

