/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.20.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.dto;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Date;

/**
 * HistoricJobLogDto
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-10-27T07:19:49.896034Z[Etc/UTC]")
public class HistoricJobLogDto {
  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private String id;

  public static final String SERIALIZED_NAME_TIMESTAMP = "timestamp";
  @SerializedName(SERIALIZED_NAME_TIMESTAMP)
  private Date timestamp;

  public static final String SERIALIZED_NAME_REMOVAL_TIME = "removalTime";
  @SerializedName(SERIALIZED_NAME_REMOVAL_TIME)
  private Date removalTime;

  public static final String SERIALIZED_NAME_JOB_ID = "jobId";
  @SerializedName(SERIALIZED_NAME_JOB_ID)
  private String jobId;

  public static final String SERIALIZED_NAME_JOB_DUE_DATE = "jobDueDate";
  @SerializedName(SERIALIZED_NAME_JOB_DUE_DATE)
  private Date jobDueDate;

  public static final String SERIALIZED_NAME_JOB_RETRIES = "jobRetries";
  @SerializedName(SERIALIZED_NAME_JOB_RETRIES)
  private Integer jobRetries;

  public static final String SERIALIZED_NAME_JOB_PRIORITY = "jobPriority";
  @SerializedName(SERIALIZED_NAME_JOB_PRIORITY)
  private Long jobPriority;

  public static final String SERIALIZED_NAME_JOB_EXCEPTION_MESSAGE = "jobExceptionMessage";
  @SerializedName(SERIALIZED_NAME_JOB_EXCEPTION_MESSAGE)
  private String jobExceptionMessage;

  public static final String SERIALIZED_NAME_FAILED_ACTIVITY_ID = "failedActivityId";
  @SerializedName(SERIALIZED_NAME_FAILED_ACTIVITY_ID)
  private String failedActivityId;

  public static final String SERIALIZED_NAME_JOB_DEFINITION_ID = "jobDefinitionId";
  @SerializedName(SERIALIZED_NAME_JOB_DEFINITION_ID)
  private String jobDefinitionId;

  public static final String SERIALIZED_NAME_JOB_DEFINITION_TYPE = "jobDefinitionType";
  @SerializedName(SERIALIZED_NAME_JOB_DEFINITION_TYPE)
  private String jobDefinitionType;

  public static final String SERIALIZED_NAME_JOB_DEFINITION_CONFIGURATION = "jobDefinitionConfiguration";
  @SerializedName(SERIALIZED_NAME_JOB_DEFINITION_CONFIGURATION)
  private String jobDefinitionConfiguration;

  public static final String SERIALIZED_NAME_ACTIVITY_ID = "activityId";
  @SerializedName(SERIALIZED_NAME_ACTIVITY_ID)
  private String activityId;

  public static final String SERIALIZED_NAME_EXECUTION_ID = "executionId";
  @SerializedName(SERIALIZED_NAME_EXECUTION_ID)
  private String executionId;

  public static final String SERIALIZED_NAME_PROCESS_INSTANCE_ID = "processInstanceId";
  @SerializedName(SERIALIZED_NAME_PROCESS_INSTANCE_ID)
  private String processInstanceId;

  public static final String SERIALIZED_NAME_PROCESS_DEFINITION_ID = "processDefinitionId";
  @SerializedName(SERIALIZED_NAME_PROCESS_DEFINITION_ID)
  private String processDefinitionId;

  public static final String SERIALIZED_NAME_PROCESS_DEFINITION_KEY = "processDefinitionKey";
  @SerializedName(SERIALIZED_NAME_PROCESS_DEFINITION_KEY)
  private String processDefinitionKey;

  public static final String SERIALIZED_NAME_DEPLOYMENT_ID = "deploymentId";
  @SerializedName(SERIALIZED_NAME_DEPLOYMENT_ID)
  private String deploymentId;

  public static final String SERIALIZED_NAME_ROOT_PROCESS_INSTANCE_ID = "rootProcessInstanceId";
  @SerializedName(SERIALIZED_NAME_ROOT_PROCESS_INSTANCE_ID)
  private String rootProcessInstanceId;

  public static final String SERIALIZED_NAME_TENANT_ID = "tenantId";
  @SerializedName(SERIALIZED_NAME_TENANT_ID)
  private String tenantId;

  public static final String SERIALIZED_NAME_HOSTNAME = "hostname";
  @SerializedName(SERIALIZED_NAME_HOSTNAME)
  private String hostname;

  public static final String SERIALIZED_NAME_CREATION_LOG = "creationLog";
  @SerializedName(SERIALIZED_NAME_CREATION_LOG)
  private Boolean creationLog;

  public static final String SERIALIZED_NAME_FAILURE_LOG = "failureLog";
  @SerializedName(SERIALIZED_NAME_FAILURE_LOG)
  private Boolean failureLog;

  public static final String SERIALIZED_NAME_SUCCESS_LOG = "successLog";
  @SerializedName(SERIALIZED_NAME_SUCCESS_LOG)
  private Boolean successLog;

  public static final String SERIALIZED_NAME_DELETION_LOG = "deletionLog";
  @SerializedName(SERIALIZED_NAME_DELETION_LOG)
  private Boolean deletionLog;


  public HistoricJobLogDto id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * The id of the log entry.
   * @return id
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The id of the log entry.")

  public String getId() {
    return id;
  }


  public void setId(String id) {
    this.id = id;
  }


  public HistoricJobLogDto timestamp(Date timestamp) {
    
    this.timestamp = timestamp;
    return this;
  }

   /**
   * The time when the log entry has been written.
   * @return timestamp
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The time when the log entry has been written.")

  public Date getTimestamp() {
    return timestamp;
  }


  public void setTimestamp(Date timestamp) {
    this.timestamp = timestamp;
  }


  public HistoricJobLogDto removalTime(Date removalTime) {
    
    this.removalTime = removalTime;
    return this;
  }

   /**
   * The time after which the log entry should be removed by the History Cleanup job. Default format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;. For further info see the [docs](https://docs.camunda.org/manual/7.20/reference/rest/overview/date-format/)
   * @return removalTime
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The time after which the log entry should be removed by the History Cleanup job. Default format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`. For further info see the [docs](https://docs.camunda.org/manual/7.20/reference/rest/overview/date-format/)")

  public Date getRemovalTime() {
    return removalTime;
  }


  public void setRemovalTime(Date removalTime) {
    this.removalTime = removalTime;
  }


  public HistoricJobLogDto jobId(String jobId) {
    
    this.jobId = jobId;
    return this;
  }

   /**
   * The id of the associated job.
   * @return jobId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The id of the associated job.")

  public String getJobId() {
    return jobId;
  }


  public void setJobId(String jobId) {
    this.jobId = jobId;
  }


  public HistoricJobLogDto jobDueDate(Date jobDueDate) {
    
    this.jobDueDate = jobDueDate;
    return this;
  }

   /**
   * The date on which the associated job is supposed to be processed.
   * @return jobDueDate
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The date on which the associated job is supposed to be processed.")

  public Date getJobDueDate() {
    return jobDueDate;
  }


  public void setJobDueDate(Date jobDueDate) {
    this.jobDueDate = jobDueDate;
  }


  public HistoricJobLogDto jobRetries(Integer jobRetries) {
    
    this.jobRetries = jobRetries;
    return this;
  }

   /**
   * The number of retries the associated job has left.
   * @return jobRetries
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The number of retries the associated job has left.")

  public Integer getJobRetries() {
    return jobRetries;
  }


  public void setJobRetries(Integer jobRetries) {
    this.jobRetries = jobRetries;
  }


  public HistoricJobLogDto jobPriority(Long jobPriority) {
    
    this.jobPriority = jobPriority;
    return this;
  }

   /**
   * The execution priority the job had when the log entry was created.
   * @return jobPriority
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The execution priority the job had when the log entry was created.")

  public Long getJobPriority() {
    return jobPriority;
  }


  public void setJobPriority(Long jobPriority) {
    this.jobPriority = jobPriority;
  }


  public HistoricJobLogDto jobExceptionMessage(String jobExceptionMessage) {
    
    this.jobExceptionMessage = jobExceptionMessage;
    return this;
  }

   /**
   * The message of the exception that occurred by executing the associated job.
   * @return jobExceptionMessage
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The message of the exception that occurred by executing the associated job.")

  public String getJobExceptionMessage() {
    return jobExceptionMessage;
  }


  public void setJobExceptionMessage(String jobExceptionMessage) {
    this.jobExceptionMessage = jobExceptionMessage;
  }


  public HistoricJobLogDto failedActivityId(String failedActivityId) {
    
    this.failedActivityId = failedActivityId;
    return this;
  }

   /**
   * The id of the activity on which the last exception occurred by executing the associated job.
   * @return failedActivityId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The id of the activity on which the last exception occurred by executing the associated job.")

  public String getFailedActivityId() {
    return failedActivityId;
  }


  public void setFailedActivityId(String failedActivityId) {
    this.failedActivityId = failedActivityId;
  }


  public HistoricJobLogDto jobDefinitionId(String jobDefinitionId) {
    
    this.jobDefinitionId = jobDefinitionId;
    return this;
  }

   /**
   * The id of the job definition on which the associated job was created.
   * @return jobDefinitionId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The id of the job definition on which the associated job was created.")

  public String getJobDefinitionId() {
    return jobDefinitionId;
  }


  public void setJobDefinitionId(String jobDefinitionId) {
    this.jobDefinitionId = jobDefinitionId;
  }


  public HistoricJobLogDto jobDefinitionType(String jobDefinitionType) {
    
    this.jobDefinitionType = jobDefinitionType;
    return this;
  }

   /**
   * The job definition type of the associated job. See the [User Guide](https://docs.camunda.org/manual/7.20/user-guide/process-engine/the-job-executor/#job-creation) for more information about job definition types.
   * @return jobDefinitionType
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The job definition type of the associated job. See the [User Guide](https://docs.camunda.org/manual/7.20/user-guide/process-engine/the-job-executor/#job-creation) for more information about job definition types.")

  public String getJobDefinitionType() {
    return jobDefinitionType;
  }


  public void setJobDefinitionType(String jobDefinitionType) {
    this.jobDefinitionType = jobDefinitionType;
  }


  public HistoricJobLogDto jobDefinitionConfiguration(String jobDefinitionConfiguration) {
    
    this.jobDefinitionConfiguration = jobDefinitionConfiguration;
    return this;
  }

   /**
   * The job definition configuration type of the associated job.
   * @return jobDefinitionConfiguration
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The job definition configuration type of the associated job.")

  public String getJobDefinitionConfiguration() {
    return jobDefinitionConfiguration;
  }


  public void setJobDefinitionConfiguration(String jobDefinitionConfiguration) {
    this.jobDefinitionConfiguration = jobDefinitionConfiguration;
  }


  public HistoricJobLogDto activityId(String activityId) {
    
    this.activityId = activityId;
    return this;
  }

   /**
   * The id of the activity on which the associated job was created.
   * @return activityId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The id of the activity on which the associated job was created.")

  public String getActivityId() {
    return activityId;
  }


  public void setActivityId(String activityId) {
    this.activityId = activityId;
  }


  public HistoricJobLogDto executionId(String executionId) {
    
    this.executionId = executionId;
    return this;
  }

   /**
   * The execution id on which the associated job was created.
   * @return executionId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The execution id on which the associated job was created.")

  public String getExecutionId() {
    return executionId;
  }


  public void setExecutionId(String executionId) {
    this.executionId = executionId;
  }


  public HistoricJobLogDto processInstanceId(String processInstanceId) {
    
    this.processInstanceId = processInstanceId;
    return this;
  }

   /**
   * The id of the process instance on which the associated job was created.
   * @return processInstanceId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The id of the process instance on which the associated job was created.")

  public String getProcessInstanceId() {
    return processInstanceId;
  }


  public void setProcessInstanceId(String processInstanceId) {
    this.processInstanceId = processInstanceId;
  }


  public HistoricJobLogDto processDefinitionId(String processDefinitionId) {
    
    this.processDefinitionId = processDefinitionId;
    return this;
  }

   /**
   * The id of the process definition which the associated job belongs to.
   * @return processDefinitionId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The id of the process definition which the associated job belongs to.")

  public String getProcessDefinitionId() {
    return processDefinitionId;
  }


  public void setProcessDefinitionId(String processDefinitionId) {
    this.processDefinitionId = processDefinitionId;
  }


  public HistoricJobLogDto processDefinitionKey(String processDefinitionKey) {
    
    this.processDefinitionKey = processDefinitionKey;
    return this;
  }

   /**
   * The key of the process definition which the associated job belongs to.
   * @return processDefinitionKey
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The key of the process definition which the associated job belongs to.")

  public String getProcessDefinitionKey() {
    return processDefinitionKey;
  }


  public void setProcessDefinitionKey(String processDefinitionKey) {
    this.processDefinitionKey = processDefinitionKey;
  }


  public HistoricJobLogDto deploymentId(String deploymentId) {
    
    this.deploymentId = deploymentId;
    return this;
  }

   /**
   * The id of the deployment which the associated job belongs to.
   * @return deploymentId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The id of the deployment which the associated job belongs to.")

  public String getDeploymentId() {
    return deploymentId;
  }


  public void setDeploymentId(String deploymentId) {
    this.deploymentId = deploymentId;
  }


  public HistoricJobLogDto rootProcessInstanceId(String rootProcessInstanceId) {
    
    this.rootProcessInstanceId = rootProcessInstanceId;
    return this;
  }

   /**
   * The process instance id of the root process instance that initiated the process which the associated job belongs to.
   * @return rootProcessInstanceId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The process instance id of the root process instance that initiated the process which the associated job belongs to.")

  public String getRootProcessInstanceId() {
    return rootProcessInstanceId;
  }


  public void setRootProcessInstanceId(String rootProcessInstanceId) {
    this.rootProcessInstanceId = rootProcessInstanceId;
  }


  public HistoricJobLogDto tenantId(String tenantId) {
    
    this.tenantId = tenantId;
    return this;
  }

   /**
   * The id of the tenant that this historic job log entry belongs to.
   * @return tenantId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The id of the tenant that this historic job log entry belongs to.")

  public String getTenantId() {
    return tenantId;
  }


  public void setTenantId(String tenantId) {
    this.tenantId = tenantId;
  }


  public HistoricJobLogDto hostname(String hostname) {
    
    this.hostname = hostname;
    return this;
  }

   /**
   *  The name of the host of the Process Engine where the job of this historic job log entry was executed.
   * @return hostname
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = " The name of the host of the Process Engine where the job of this historic job log entry was executed.")

  public String getHostname() {
    return hostname;
  }


  public void setHostname(String hostname) {
    this.hostname = hostname;
  }


  public HistoricJobLogDto creationLog(Boolean creationLog) {
    
    this.creationLog = creationLog;
    return this;
  }

   /**
   * A flag indicating whether this log represents the creation of the associated job.
   * @return creationLog
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "A flag indicating whether this log represents the creation of the associated job.")

  public Boolean getCreationLog() {
    return creationLog;
  }


  public void setCreationLog(Boolean creationLog) {
    this.creationLog = creationLog;
  }


  public HistoricJobLogDto failureLog(Boolean failureLog) {
    
    this.failureLog = failureLog;
    return this;
  }

   /**
   * A flag indicating whether this log represents the failed execution of the associated job.
   * @return failureLog
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "A flag indicating whether this log represents the failed execution of the associated job.")

  public Boolean getFailureLog() {
    return failureLog;
  }


  public void setFailureLog(Boolean failureLog) {
    this.failureLog = failureLog;
  }


  public HistoricJobLogDto successLog(Boolean successLog) {
    
    this.successLog = successLog;
    return this;
  }

   /**
   * A flag indicating whether this log represents the successful execution of the associated job.
   * @return successLog
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "A flag indicating whether this log represents the successful execution of the associated job.")

  public Boolean getSuccessLog() {
    return successLog;
  }


  public void setSuccessLog(Boolean successLog) {
    this.successLog = successLog;
  }


  public HistoricJobLogDto deletionLog(Boolean deletionLog) {
    
    this.deletionLog = deletionLog;
    return this;
  }

   /**
   * A flag indicating whether this log represents the deletion of the associated job.
   * @return deletionLog
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "A flag indicating whether this log represents the deletion of the associated job.")

  public Boolean getDeletionLog() {
    return deletionLog;
  }


  public void setDeletionLog(Boolean deletionLog) {
    this.deletionLog = deletionLog;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    HistoricJobLogDto historicJobLogDto = (HistoricJobLogDto) o;
    return Objects.equals(this.id, historicJobLogDto.id) &&
        Objects.equals(this.timestamp, historicJobLogDto.timestamp) &&
        Objects.equals(this.removalTime, historicJobLogDto.removalTime) &&
        Objects.equals(this.jobId, historicJobLogDto.jobId) &&
        Objects.equals(this.jobDueDate, historicJobLogDto.jobDueDate) &&
        Objects.equals(this.jobRetries, historicJobLogDto.jobRetries) &&
        Objects.equals(this.jobPriority, historicJobLogDto.jobPriority) &&
        Objects.equals(this.jobExceptionMessage, historicJobLogDto.jobExceptionMessage) &&
        Objects.equals(this.failedActivityId, historicJobLogDto.failedActivityId) &&
        Objects.equals(this.jobDefinitionId, historicJobLogDto.jobDefinitionId) &&
        Objects.equals(this.jobDefinitionType, historicJobLogDto.jobDefinitionType) &&
        Objects.equals(this.jobDefinitionConfiguration, historicJobLogDto.jobDefinitionConfiguration) &&
        Objects.equals(this.activityId, historicJobLogDto.activityId) &&
        Objects.equals(this.executionId, historicJobLogDto.executionId) &&
        Objects.equals(this.processInstanceId, historicJobLogDto.processInstanceId) &&
        Objects.equals(this.processDefinitionId, historicJobLogDto.processDefinitionId) &&
        Objects.equals(this.processDefinitionKey, historicJobLogDto.processDefinitionKey) &&
        Objects.equals(this.deploymentId, historicJobLogDto.deploymentId) &&
        Objects.equals(this.rootProcessInstanceId, historicJobLogDto.rootProcessInstanceId) &&
        Objects.equals(this.tenantId, historicJobLogDto.tenantId) &&
        Objects.equals(this.hostname, historicJobLogDto.hostname) &&
        Objects.equals(this.creationLog, historicJobLogDto.creationLog) &&
        Objects.equals(this.failureLog, historicJobLogDto.failureLog) &&
        Objects.equals(this.successLog, historicJobLogDto.successLog) &&
        Objects.equals(this.deletionLog, historicJobLogDto.deletionLog);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, timestamp, removalTime, jobId, jobDueDate, jobRetries, jobPriority, jobExceptionMessage, failedActivityId, jobDefinitionId, jobDefinitionType, jobDefinitionConfiguration, activityId, executionId, processInstanceId, processDefinitionId, processDefinitionKey, deploymentId, rootProcessInstanceId, tenantId, hostname, creationLog, failureLog, successLog, deletionLog);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class HistoricJobLogDto {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    timestamp: ").append(toIndentedString(timestamp)).append("\n");
    sb.append("    removalTime: ").append(toIndentedString(removalTime)).append("\n");
    sb.append("    jobId: ").append(toIndentedString(jobId)).append("\n");
    sb.append("    jobDueDate: ").append(toIndentedString(jobDueDate)).append("\n");
    sb.append("    jobRetries: ").append(toIndentedString(jobRetries)).append("\n");
    sb.append("    jobPriority: ").append(toIndentedString(jobPriority)).append("\n");
    sb.append("    jobExceptionMessage: ").append(toIndentedString(jobExceptionMessage)).append("\n");
    sb.append("    failedActivityId: ").append(toIndentedString(failedActivityId)).append("\n");
    sb.append("    jobDefinitionId: ").append(toIndentedString(jobDefinitionId)).append("\n");
    sb.append("    jobDefinitionType: ").append(toIndentedString(jobDefinitionType)).append("\n");
    sb.append("    jobDefinitionConfiguration: ").append(toIndentedString(jobDefinitionConfiguration)).append("\n");
    sb.append("    activityId: ").append(toIndentedString(activityId)).append("\n");
    sb.append("    executionId: ").append(toIndentedString(executionId)).append("\n");
    sb.append("    processInstanceId: ").append(toIndentedString(processInstanceId)).append("\n");
    sb.append("    processDefinitionId: ").append(toIndentedString(processDefinitionId)).append("\n");
    sb.append("    processDefinitionKey: ").append(toIndentedString(processDefinitionKey)).append("\n");
    sb.append("    deploymentId: ").append(toIndentedString(deploymentId)).append("\n");
    sb.append("    rootProcessInstanceId: ").append(toIndentedString(rootProcessInstanceId)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    hostname: ").append(toIndentedString(hostname)).append("\n");
    sb.append("    creationLog: ").append(toIndentedString(creationLog)).append("\n");
    sb.append("    failureLog: ").append(toIndentedString(failureLog)).append("\n");
    sb.append("    successLog: ").append(toIndentedString(successLog)).append("\n");
    sb.append("    deletionLog: ").append(toIndentedString(deletionLog)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

