/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.20.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.dto;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.camunda.community.rest.client.dto.HistoricTaskInstanceQueryDtoSorting;
import org.camunda.community.rest.client.dto.VariableQueryParameterDto;

/**
 * A Historic Task instance query which defines a list of Historic Task instances
 */
@ApiModel(description = "A Historic Task instance query which defines a list of Historic Task instances")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-10-27T07:19:49.896034Z[Etc/UTC]")
public class HistoricTaskInstanceQueryDto {
  public static final String SERIALIZED_NAME_TASK_ID = "taskId";
  @SerializedName(SERIALIZED_NAME_TASK_ID)
  private String taskId;

  public static final String SERIALIZED_NAME_TASK_PARENT_TASK_ID = "taskParentTaskId";
  @SerializedName(SERIALIZED_NAME_TASK_PARENT_TASK_ID)
  private String taskParentTaskId;

  public static final String SERIALIZED_NAME_PROCESS_INSTANCE_ID = "processInstanceId";
  @SerializedName(SERIALIZED_NAME_PROCESS_INSTANCE_ID)
  private String processInstanceId;

  public static final String SERIALIZED_NAME_PROCESS_INSTANCE_BUSINESS_KEY = "processInstanceBusinessKey";
  @SerializedName(SERIALIZED_NAME_PROCESS_INSTANCE_BUSINESS_KEY)
  private String processInstanceBusinessKey;

  public static final String SERIALIZED_NAME_PROCESS_INSTANCE_BUSINESS_KEY_IN = "processInstanceBusinessKeyIn";
  @SerializedName(SERIALIZED_NAME_PROCESS_INSTANCE_BUSINESS_KEY_IN)
  private List<String> processInstanceBusinessKeyIn = null;

  public static final String SERIALIZED_NAME_PROCESS_INSTANCE_BUSINESS_KEY_LIKE = "processInstanceBusinessKeyLike";
  @SerializedName(SERIALIZED_NAME_PROCESS_INSTANCE_BUSINESS_KEY_LIKE)
  private String processInstanceBusinessKeyLike;

  public static final String SERIALIZED_NAME_EXECUTION_ID = "executionId";
  @SerializedName(SERIALIZED_NAME_EXECUTION_ID)
  private String executionId;

  public static final String SERIALIZED_NAME_PROCESS_DEFINITION_ID = "processDefinitionId";
  @SerializedName(SERIALIZED_NAME_PROCESS_DEFINITION_ID)
  private String processDefinitionId;

  public static final String SERIALIZED_NAME_PROCESS_DEFINITION_KEY = "processDefinitionKey";
  @SerializedName(SERIALIZED_NAME_PROCESS_DEFINITION_KEY)
  private String processDefinitionKey;

  public static final String SERIALIZED_NAME_PROCESS_DEFINITION_NAME = "processDefinitionName";
  @SerializedName(SERIALIZED_NAME_PROCESS_DEFINITION_NAME)
  private String processDefinitionName;

  public static final String SERIALIZED_NAME_CASE_INSTANCE_ID = "caseInstanceId";
  @SerializedName(SERIALIZED_NAME_CASE_INSTANCE_ID)
  private String caseInstanceId;

  public static final String SERIALIZED_NAME_CASE_EXECUTION_ID = "caseExecutionId";
  @SerializedName(SERIALIZED_NAME_CASE_EXECUTION_ID)
  private String caseExecutionId;

  public static final String SERIALIZED_NAME_CASE_DEFINITION_ID = "caseDefinitionId";
  @SerializedName(SERIALIZED_NAME_CASE_DEFINITION_ID)
  private String caseDefinitionId;

  public static final String SERIALIZED_NAME_CASE_DEFINITION_KEY = "caseDefinitionKey";
  @SerializedName(SERIALIZED_NAME_CASE_DEFINITION_KEY)
  private String caseDefinitionKey;

  public static final String SERIALIZED_NAME_CASE_DEFINITION_NAME = "caseDefinitionName";
  @SerializedName(SERIALIZED_NAME_CASE_DEFINITION_NAME)
  private String caseDefinitionName;

  public static final String SERIALIZED_NAME_ACTIVITY_INSTANCE_ID_IN = "activityInstanceIdIn";
  @SerializedName(SERIALIZED_NAME_ACTIVITY_INSTANCE_ID_IN)
  private List<String> activityInstanceIdIn = null;

  public static final String SERIALIZED_NAME_TASK_NAME = "taskName";
  @SerializedName(SERIALIZED_NAME_TASK_NAME)
  private String taskName;

  public static final String SERIALIZED_NAME_TASK_NAME_LIKE = "taskNameLike";
  @SerializedName(SERIALIZED_NAME_TASK_NAME_LIKE)
  private String taskNameLike;

  public static final String SERIALIZED_NAME_TASK_DESCRIPTION = "taskDescription";
  @SerializedName(SERIALIZED_NAME_TASK_DESCRIPTION)
  private String taskDescription;

  public static final String SERIALIZED_NAME_TASK_DESCRIPTION_LIKE = "taskDescriptionLike";
  @SerializedName(SERIALIZED_NAME_TASK_DESCRIPTION_LIKE)
  private String taskDescriptionLike;

  public static final String SERIALIZED_NAME_TASK_DEFINITION_KEY = "taskDefinitionKey";
  @SerializedName(SERIALIZED_NAME_TASK_DEFINITION_KEY)
  private String taskDefinitionKey;

  public static final String SERIALIZED_NAME_TASK_DEFINITION_KEY_IN = "taskDefinitionKeyIn";
  @SerializedName(SERIALIZED_NAME_TASK_DEFINITION_KEY_IN)
  private List<String> taskDefinitionKeyIn = null;

  public static final String SERIALIZED_NAME_TASK_DELETE_REASON = "taskDeleteReason";
  @SerializedName(SERIALIZED_NAME_TASK_DELETE_REASON)
  private String taskDeleteReason;

  public static final String SERIALIZED_NAME_TASK_DELETE_REASON_LIKE = "taskDeleteReasonLike";
  @SerializedName(SERIALIZED_NAME_TASK_DELETE_REASON_LIKE)
  private String taskDeleteReasonLike;

  public static final String SERIALIZED_NAME_TASK_ASSIGNEE = "taskAssignee";
  @SerializedName(SERIALIZED_NAME_TASK_ASSIGNEE)
  private String taskAssignee;

  public static final String SERIALIZED_NAME_TASK_ASSIGNEE_LIKE = "taskAssigneeLike";
  @SerializedName(SERIALIZED_NAME_TASK_ASSIGNEE_LIKE)
  private String taskAssigneeLike;

  public static final String SERIALIZED_NAME_TASK_OWNER = "taskOwner";
  @SerializedName(SERIALIZED_NAME_TASK_OWNER)
  private String taskOwner;

  public static final String SERIALIZED_NAME_TASK_OWNER_LIKE = "taskOwnerLike";
  @SerializedName(SERIALIZED_NAME_TASK_OWNER_LIKE)
  private String taskOwnerLike;

  public static final String SERIALIZED_NAME_TASK_PRIORITY = "taskPriority";
  @SerializedName(SERIALIZED_NAME_TASK_PRIORITY)
  private Integer taskPriority;

  public static final String SERIALIZED_NAME_ASSIGNED = "assigned";
  @SerializedName(SERIALIZED_NAME_ASSIGNED)
  private Boolean assigned;

  public static final String SERIALIZED_NAME_UNASSIGNED = "unassigned";
  @SerializedName(SERIALIZED_NAME_UNASSIGNED)
  private Boolean unassigned;

  public static final String SERIALIZED_NAME_FINISHED = "finished";
  @SerializedName(SERIALIZED_NAME_FINISHED)
  private Boolean finished;

  public static final String SERIALIZED_NAME_UNFINISHED = "unfinished";
  @SerializedName(SERIALIZED_NAME_UNFINISHED)
  private Boolean unfinished;

  public static final String SERIALIZED_NAME_PROCESS_FINISHED = "processFinished";
  @SerializedName(SERIALIZED_NAME_PROCESS_FINISHED)
  private Boolean processFinished;

  public static final String SERIALIZED_NAME_PROCESS_UNFINISHED = "processUnfinished";
  @SerializedName(SERIALIZED_NAME_PROCESS_UNFINISHED)
  private Boolean processUnfinished;

  public static final String SERIALIZED_NAME_TASK_DUE_DATE = "taskDueDate";
  @SerializedName(SERIALIZED_NAME_TASK_DUE_DATE)
  private Date taskDueDate;

  public static final String SERIALIZED_NAME_TASK_DUE_DATE_BEFORE = "taskDueDateBefore";
  @SerializedName(SERIALIZED_NAME_TASK_DUE_DATE_BEFORE)
  private Date taskDueDateBefore;

  public static final String SERIALIZED_NAME_TASK_DUE_DATE_AFTER = "taskDueDateAfter";
  @SerializedName(SERIALIZED_NAME_TASK_DUE_DATE_AFTER)
  private Date taskDueDateAfter;

  public static final String SERIALIZED_NAME_WITHOUT_TASK_DUE_DATE = "withoutTaskDueDate";
  @SerializedName(SERIALIZED_NAME_WITHOUT_TASK_DUE_DATE)
  private Boolean withoutTaskDueDate;

  public static final String SERIALIZED_NAME_TASK_FOLLOW_UP_DATE = "taskFollowUpDate";
  @SerializedName(SERIALIZED_NAME_TASK_FOLLOW_UP_DATE)
  private Date taskFollowUpDate;

  public static final String SERIALIZED_NAME_TASK_FOLLOW_UP_DATE_BEFORE = "taskFollowUpDateBefore";
  @SerializedName(SERIALIZED_NAME_TASK_FOLLOW_UP_DATE_BEFORE)
  private Date taskFollowUpDateBefore;

  public static final String SERIALIZED_NAME_TASK_FOLLOW_UP_DATE_AFTER = "taskFollowUpDateAfter";
  @SerializedName(SERIALIZED_NAME_TASK_FOLLOW_UP_DATE_AFTER)
  private Date taskFollowUpDateAfter;

  public static final String SERIALIZED_NAME_STARTED_BEFORE = "startedBefore";
  @SerializedName(SERIALIZED_NAME_STARTED_BEFORE)
  private Date startedBefore;

  public static final String SERIALIZED_NAME_STARTED_AFTER = "startedAfter";
  @SerializedName(SERIALIZED_NAME_STARTED_AFTER)
  private Date startedAfter;

  public static final String SERIALIZED_NAME_FINISHED_BEFORE = "finishedBefore";
  @SerializedName(SERIALIZED_NAME_FINISHED_BEFORE)
  private Date finishedBefore;

  public static final String SERIALIZED_NAME_FINISHED_AFTER = "finishedAfter";
  @SerializedName(SERIALIZED_NAME_FINISHED_AFTER)
  private Date finishedAfter;

  public static final String SERIALIZED_NAME_TENANT_ID_IN = "tenantIdIn";
  @SerializedName(SERIALIZED_NAME_TENANT_ID_IN)
  private List<String> tenantIdIn = null;

  public static final String SERIALIZED_NAME_WITHOUT_TENANT_ID = "withoutTenantId";
  @SerializedName(SERIALIZED_NAME_WITHOUT_TENANT_ID)
  private Boolean withoutTenantId;

  public static final String SERIALIZED_NAME_TASK_VARIABLES = "taskVariables";
  @SerializedName(SERIALIZED_NAME_TASK_VARIABLES)
  private List<VariableQueryParameterDto> taskVariables = null;

  public static final String SERIALIZED_NAME_PROCESS_VARIABLES = "processVariables";
  @SerializedName(SERIALIZED_NAME_PROCESS_VARIABLES)
  private List<VariableQueryParameterDto> processVariables = null;

  public static final String SERIALIZED_NAME_VARIABLE_NAMES_IGNORE_CASE = "variableNamesIgnoreCase";
  @SerializedName(SERIALIZED_NAME_VARIABLE_NAMES_IGNORE_CASE)
  private Boolean variableNamesIgnoreCase;

  public static final String SERIALIZED_NAME_VARIABLE_VALUES_IGNORE_CASE = "variableValuesIgnoreCase";
  @SerializedName(SERIALIZED_NAME_VARIABLE_VALUES_IGNORE_CASE)
  private Boolean variableValuesIgnoreCase;

  public static final String SERIALIZED_NAME_TASK_INVOLVED_USER = "taskInvolvedUser";
  @SerializedName(SERIALIZED_NAME_TASK_INVOLVED_USER)
  private String taskInvolvedUser;

  public static final String SERIALIZED_NAME_TASK_INVOLVED_GROUP = "taskInvolvedGroup";
  @SerializedName(SERIALIZED_NAME_TASK_INVOLVED_GROUP)
  private String taskInvolvedGroup;

  public static final String SERIALIZED_NAME_TASK_HAD_CANDIDATE_USER = "taskHadCandidateUser";
  @SerializedName(SERIALIZED_NAME_TASK_HAD_CANDIDATE_USER)
  private String taskHadCandidateUser;

  public static final String SERIALIZED_NAME_TASK_HAD_CANDIDATE_GROUP = "taskHadCandidateGroup";
  @SerializedName(SERIALIZED_NAME_TASK_HAD_CANDIDATE_GROUP)
  private String taskHadCandidateGroup;

  public static final String SERIALIZED_NAME_WITH_CANDIDATE_GROUPS = "withCandidateGroups";
  @SerializedName(SERIALIZED_NAME_WITH_CANDIDATE_GROUPS)
  private Boolean withCandidateGroups;

  public static final String SERIALIZED_NAME_WITHOUT_CANDIDATE_GROUPS = "withoutCandidateGroups";
  @SerializedName(SERIALIZED_NAME_WITHOUT_CANDIDATE_GROUPS)
  private Boolean withoutCandidateGroups;

  public static final String SERIALIZED_NAME_OR_QUERIES = "orQueries";
  @SerializedName(SERIALIZED_NAME_OR_QUERIES)
  private List<HistoricTaskInstanceQueryDto> orQueries = null;

  public static final String SERIALIZED_NAME_SORTING = "sorting";
  @SerializedName(SERIALIZED_NAME_SORTING)
  private List<HistoricTaskInstanceQueryDtoSorting> sorting = null;


  public HistoricTaskInstanceQueryDto taskId(String taskId) {
    
    this.taskId = taskId;
    return this;
  }

   /**
   * Filter by task id.
   * @return taskId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Filter by task id.")

  public String getTaskId() {
    return taskId;
  }


  public void setTaskId(String taskId) {
    this.taskId = taskId;
  }


  public HistoricTaskInstanceQueryDto taskParentTaskId(String taskParentTaskId) {
    
    this.taskParentTaskId = taskParentTaskId;
    return this;
  }

   /**
   * Filter by parent task id.
   * @return taskParentTaskId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Filter by parent task id.")

  public String getTaskParentTaskId() {
    return taskParentTaskId;
  }


  public void setTaskParentTaskId(String taskParentTaskId) {
    this.taskParentTaskId = taskParentTaskId;
  }


  public HistoricTaskInstanceQueryDto processInstanceId(String processInstanceId) {
    
    this.processInstanceId = processInstanceId;
    return this;
  }

   /**
   * Filter by process instance id.
   * @return processInstanceId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Filter by process instance id.")

  public String getProcessInstanceId() {
    return processInstanceId;
  }


  public void setProcessInstanceId(String processInstanceId) {
    this.processInstanceId = processInstanceId;
  }


  public HistoricTaskInstanceQueryDto processInstanceBusinessKey(String processInstanceBusinessKey) {
    
    this.processInstanceBusinessKey = processInstanceBusinessKey;
    return this;
  }

   /**
   * Filter by process instance business key.
   * @return processInstanceBusinessKey
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Filter by process instance business key.")

  public String getProcessInstanceBusinessKey() {
    return processInstanceBusinessKey;
  }


  public void setProcessInstanceBusinessKey(String processInstanceBusinessKey) {
    this.processInstanceBusinessKey = processInstanceBusinessKey;
  }


  public HistoricTaskInstanceQueryDto processInstanceBusinessKeyIn(List<String> processInstanceBusinessKeyIn) {
    
    this.processInstanceBusinessKeyIn = processInstanceBusinessKeyIn;
    return this;
  }

  public HistoricTaskInstanceQueryDto addProcessInstanceBusinessKeyInItem(String processInstanceBusinessKeyInItem) {
    if (this.processInstanceBusinessKeyIn == null) {
      this.processInstanceBusinessKeyIn = new ArrayList<String>();
    }
    this.processInstanceBusinessKeyIn.add(processInstanceBusinessKeyInItem);
    return this;
  }

   /**
   * Filter by process instances with one of the give business keys. The keys need to be in a comma-separated list.
   * @return processInstanceBusinessKeyIn
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Filter by process instances with one of the give business keys. The keys need to be in a comma-separated list.")

  public List<String> getProcessInstanceBusinessKeyIn() {
    return processInstanceBusinessKeyIn;
  }


  public void setProcessInstanceBusinessKeyIn(List<String> processInstanceBusinessKeyIn) {
    this.processInstanceBusinessKeyIn = processInstanceBusinessKeyIn;
  }


  public HistoricTaskInstanceQueryDto processInstanceBusinessKeyLike(String processInstanceBusinessKeyLike) {
    
    this.processInstanceBusinessKeyLike = processInstanceBusinessKeyLike;
    return this;
  }

   /**
   * Filter by  process instance business key that has the parameter value as a substring.
   * @return processInstanceBusinessKeyLike
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Filter by  process instance business key that has the parameter value as a substring.")

  public String getProcessInstanceBusinessKeyLike() {
    return processInstanceBusinessKeyLike;
  }


  public void setProcessInstanceBusinessKeyLike(String processInstanceBusinessKeyLike) {
    this.processInstanceBusinessKeyLike = processInstanceBusinessKeyLike;
  }


  public HistoricTaskInstanceQueryDto executionId(String executionId) {
    
    this.executionId = executionId;
    return this;
  }

   /**
   * Filter by the id of the execution that executed the task.
   * @return executionId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Filter by the id of the execution that executed the task.")

  public String getExecutionId() {
    return executionId;
  }


  public void setExecutionId(String executionId) {
    this.executionId = executionId;
  }


  public HistoricTaskInstanceQueryDto processDefinitionId(String processDefinitionId) {
    
    this.processDefinitionId = processDefinitionId;
    return this;
  }

   /**
   * Filter by process definition id.
   * @return processDefinitionId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Filter by process definition id.")

  public String getProcessDefinitionId() {
    return processDefinitionId;
  }


  public void setProcessDefinitionId(String processDefinitionId) {
    this.processDefinitionId = processDefinitionId;
  }


  public HistoricTaskInstanceQueryDto processDefinitionKey(String processDefinitionKey) {
    
    this.processDefinitionKey = processDefinitionKey;
    return this;
  }

   /**
   * Restrict to tasks that belong to a process definition with the given key.
   * @return processDefinitionKey
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Restrict to tasks that belong to a process definition with the given key.")

  public String getProcessDefinitionKey() {
    return processDefinitionKey;
  }


  public void setProcessDefinitionKey(String processDefinitionKey) {
    this.processDefinitionKey = processDefinitionKey;
  }


  public HistoricTaskInstanceQueryDto processDefinitionName(String processDefinitionName) {
    
    this.processDefinitionName = processDefinitionName;
    return this;
  }

   /**
   * Restrict to tasks that belong to a process definition with the given name.
   * @return processDefinitionName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Restrict to tasks that belong to a process definition with the given name.")

  public String getProcessDefinitionName() {
    return processDefinitionName;
  }


  public void setProcessDefinitionName(String processDefinitionName) {
    this.processDefinitionName = processDefinitionName;
  }


  public HistoricTaskInstanceQueryDto caseInstanceId(String caseInstanceId) {
    
    this.caseInstanceId = caseInstanceId;
    return this;
  }

   /**
   * Filter by case instance id.
   * @return caseInstanceId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Filter by case instance id.")

  public String getCaseInstanceId() {
    return caseInstanceId;
  }


  public void setCaseInstanceId(String caseInstanceId) {
    this.caseInstanceId = caseInstanceId;
  }


  public HistoricTaskInstanceQueryDto caseExecutionId(String caseExecutionId) {
    
    this.caseExecutionId = caseExecutionId;
    return this;
  }

   /**
   * Filter by the id of the case execution that executed the task.
   * @return caseExecutionId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Filter by the id of the case execution that executed the task.")

  public String getCaseExecutionId() {
    return caseExecutionId;
  }


  public void setCaseExecutionId(String caseExecutionId) {
    this.caseExecutionId = caseExecutionId;
  }


  public HistoricTaskInstanceQueryDto caseDefinitionId(String caseDefinitionId) {
    
    this.caseDefinitionId = caseDefinitionId;
    return this;
  }

   /**
   * Filter by case definition id.
   * @return caseDefinitionId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Filter by case definition id.")

  public String getCaseDefinitionId() {
    return caseDefinitionId;
  }


  public void setCaseDefinitionId(String caseDefinitionId) {
    this.caseDefinitionId = caseDefinitionId;
  }


  public HistoricTaskInstanceQueryDto caseDefinitionKey(String caseDefinitionKey) {
    
    this.caseDefinitionKey = caseDefinitionKey;
    return this;
  }

   /**
   * Restrict to tasks that belong to a case definition with the given key.
   * @return caseDefinitionKey
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Restrict to tasks that belong to a case definition with the given key.")

  public String getCaseDefinitionKey() {
    return caseDefinitionKey;
  }


  public void setCaseDefinitionKey(String caseDefinitionKey) {
    this.caseDefinitionKey = caseDefinitionKey;
  }


  public HistoricTaskInstanceQueryDto caseDefinitionName(String caseDefinitionName) {
    
    this.caseDefinitionName = caseDefinitionName;
    return this;
  }

   /**
   * Restrict to tasks that belong to a case definition with the given name.
   * @return caseDefinitionName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Restrict to tasks that belong to a case definition with the given name.")

  public String getCaseDefinitionName() {
    return caseDefinitionName;
  }


  public void setCaseDefinitionName(String caseDefinitionName) {
    this.caseDefinitionName = caseDefinitionName;
  }


  public HistoricTaskInstanceQueryDto activityInstanceIdIn(List<String> activityInstanceIdIn) {
    
    this.activityInstanceIdIn = activityInstanceIdIn;
    return this;
  }

  public HistoricTaskInstanceQueryDto addActivityInstanceIdInItem(String activityInstanceIdInItem) {
    if (this.activityInstanceIdIn == null) {
      this.activityInstanceIdIn = new ArrayList<String>();
    }
    this.activityInstanceIdIn.add(activityInstanceIdInItem);
    return this;
  }

   /**
   * Only include tasks which belong to one of the passed  activity instance ids.
   * @return activityInstanceIdIn
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Only include tasks which belong to one of the passed  activity instance ids.")

  public List<String> getActivityInstanceIdIn() {
    return activityInstanceIdIn;
  }


  public void setActivityInstanceIdIn(List<String> activityInstanceIdIn) {
    this.activityInstanceIdIn = activityInstanceIdIn;
  }


  public HistoricTaskInstanceQueryDto taskName(String taskName) {
    
    this.taskName = taskName;
    return this;
  }

   /**
   * Restrict to tasks that have the given name.
   * @return taskName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Restrict to tasks that have the given name.")

  public String getTaskName() {
    return taskName;
  }


  public void setTaskName(String taskName) {
    this.taskName = taskName;
  }


  public HistoricTaskInstanceQueryDto taskNameLike(String taskNameLike) {
    
    this.taskNameLike = taskNameLike;
    return this;
  }

   /**
   * Restrict to tasks that have a name with the given parameter value as substring.
   * @return taskNameLike
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Restrict to tasks that have a name with the given parameter value as substring.")

  public String getTaskNameLike() {
    return taskNameLike;
  }


  public void setTaskNameLike(String taskNameLike) {
    this.taskNameLike = taskNameLike;
  }


  public HistoricTaskInstanceQueryDto taskDescription(String taskDescription) {
    
    this.taskDescription = taskDescription;
    return this;
  }

   /**
   * Restrict to tasks that have the given description.
   * @return taskDescription
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Restrict to tasks that have the given description.")

  public String getTaskDescription() {
    return taskDescription;
  }


  public void setTaskDescription(String taskDescription) {
    this.taskDescription = taskDescription;
  }


  public HistoricTaskInstanceQueryDto taskDescriptionLike(String taskDescriptionLike) {
    
    this.taskDescriptionLike = taskDescriptionLike;
    return this;
  }

   /**
   * Restrict to tasks that have a description that has the parameter value as a substring.
   * @return taskDescriptionLike
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Restrict to tasks that have a description that has the parameter value as a substring.")

  public String getTaskDescriptionLike() {
    return taskDescriptionLike;
  }


  public void setTaskDescriptionLike(String taskDescriptionLike) {
    this.taskDescriptionLike = taskDescriptionLike;
  }


  public HistoricTaskInstanceQueryDto taskDefinitionKey(String taskDefinitionKey) {
    
    this.taskDefinitionKey = taskDefinitionKey;
    return this;
  }

   /**
   * Restrict to tasks that have the given key.
   * @return taskDefinitionKey
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Restrict to tasks that have the given key.")

  public String getTaskDefinitionKey() {
    return taskDefinitionKey;
  }


  public void setTaskDefinitionKey(String taskDefinitionKey) {
    this.taskDefinitionKey = taskDefinitionKey;
  }


  public HistoricTaskInstanceQueryDto taskDefinitionKeyIn(List<String> taskDefinitionKeyIn) {
    
    this.taskDefinitionKeyIn = taskDefinitionKeyIn;
    return this;
  }

  public HistoricTaskInstanceQueryDto addTaskDefinitionKeyInItem(String taskDefinitionKeyInItem) {
    if (this.taskDefinitionKeyIn == null) {
      this.taskDefinitionKeyIn = new ArrayList<String>();
    }
    this.taskDefinitionKeyIn.add(taskDefinitionKeyInItem);
    return this;
  }

   /**
   * Restrict to tasks that have one of the passed  task definition keys.
   * @return taskDefinitionKeyIn
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Restrict to tasks that have one of the passed  task definition keys.")

  public List<String> getTaskDefinitionKeyIn() {
    return taskDefinitionKeyIn;
  }


  public void setTaskDefinitionKeyIn(List<String> taskDefinitionKeyIn) {
    this.taskDefinitionKeyIn = taskDefinitionKeyIn;
  }


  public HistoricTaskInstanceQueryDto taskDeleteReason(String taskDeleteReason) {
    
    this.taskDeleteReason = taskDeleteReason;
    return this;
  }

   /**
   * Restrict to tasks that have the given delete reason.
   * @return taskDeleteReason
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Restrict to tasks that have the given delete reason.")

  public String getTaskDeleteReason() {
    return taskDeleteReason;
  }


  public void setTaskDeleteReason(String taskDeleteReason) {
    this.taskDeleteReason = taskDeleteReason;
  }


  public HistoricTaskInstanceQueryDto taskDeleteReasonLike(String taskDeleteReasonLike) {
    
    this.taskDeleteReasonLike = taskDeleteReasonLike;
    return this;
  }

   /**
   * Restrict to tasks that have a delete reason that has the parameter value as a substring.
   * @return taskDeleteReasonLike
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Restrict to tasks that have a delete reason that has the parameter value as a substring.")

  public String getTaskDeleteReasonLike() {
    return taskDeleteReasonLike;
  }


  public void setTaskDeleteReasonLike(String taskDeleteReasonLike) {
    this.taskDeleteReasonLike = taskDeleteReasonLike;
  }


  public HistoricTaskInstanceQueryDto taskAssignee(String taskAssignee) {
    
    this.taskAssignee = taskAssignee;
    return this;
  }

   /**
   * Restrict to tasks that the given user is assigned to.
   * @return taskAssignee
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Restrict to tasks that the given user is assigned to.")

  public String getTaskAssignee() {
    return taskAssignee;
  }


  public void setTaskAssignee(String taskAssignee) {
    this.taskAssignee = taskAssignee;
  }


  public HistoricTaskInstanceQueryDto taskAssigneeLike(String taskAssigneeLike) {
    
    this.taskAssigneeLike = taskAssigneeLike;
    return this;
  }

   /**
   * Restrict to tasks that are assigned to users with the parameter value as a substring.
   * @return taskAssigneeLike
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Restrict to tasks that are assigned to users with the parameter value as a substring.")

  public String getTaskAssigneeLike() {
    return taskAssigneeLike;
  }


  public void setTaskAssigneeLike(String taskAssigneeLike) {
    this.taskAssigneeLike = taskAssigneeLike;
  }


  public HistoricTaskInstanceQueryDto taskOwner(String taskOwner) {
    
    this.taskOwner = taskOwner;
    return this;
  }

   /**
   * Restrict to tasks that the given user owns.
   * @return taskOwner
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Restrict to tasks that the given user owns.")

  public String getTaskOwner() {
    return taskOwner;
  }


  public void setTaskOwner(String taskOwner) {
    this.taskOwner = taskOwner;
  }


  public HistoricTaskInstanceQueryDto taskOwnerLike(String taskOwnerLike) {
    
    this.taskOwnerLike = taskOwnerLike;
    return this;
  }

   /**
   * Restrict to tasks that are owned by users with the parameter value as a substring.
   * @return taskOwnerLike
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Restrict to tasks that are owned by users with the parameter value as a substring.")

  public String getTaskOwnerLike() {
    return taskOwnerLike;
  }


  public void setTaskOwnerLike(String taskOwnerLike) {
    this.taskOwnerLike = taskOwnerLike;
  }


  public HistoricTaskInstanceQueryDto taskPriority(Integer taskPriority) {
    
    this.taskPriority = taskPriority;
    return this;
  }

   /**
   * Restrict to tasks that have the given priority.
   * @return taskPriority
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Restrict to tasks that have the given priority.")

  public Integer getTaskPriority() {
    return taskPriority;
  }


  public void setTaskPriority(Integer taskPriority) {
    this.taskPriority = taskPriority;
  }


  public HistoricTaskInstanceQueryDto assigned(Boolean assigned) {
    
    this.assigned = assigned;
    return this;
  }

   /**
   * If set to &#x60;true&#x60;, restricts the query to all tasks that are assigned.
   * @return assigned
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "If set to `true`, restricts the query to all tasks that are assigned.")

  public Boolean getAssigned() {
    return assigned;
  }


  public void setAssigned(Boolean assigned) {
    this.assigned = assigned;
  }


  public HistoricTaskInstanceQueryDto unassigned(Boolean unassigned) {
    
    this.unassigned = unassigned;
    return this;
  }

   /**
   * If set to &#x60;true&#x60;, restricts the query to all tasks that are unassigned.
   * @return unassigned
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "If set to `true`, restricts the query to all tasks that are unassigned.")

  public Boolean getUnassigned() {
    return unassigned;
  }


  public void setUnassigned(Boolean unassigned) {
    this.unassigned = unassigned;
  }


  public HistoricTaskInstanceQueryDto finished(Boolean finished) {
    
    this.finished = finished;
    return this;
  }

   /**
   * Only include finished tasks. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior.
   * @return finished
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Only include finished tasks. Value may only be `true`, as `false` is the default behavior.")

  public Boolean getFinished() {
    return finished;
  }


  public void setFinished(Boolean finished) {
    this.finished = finished;
  }


  public HistoricTaskInstanceQueryDto unfinished(Boolean unfinished) {
    
    this.unfinished = unfinished;
    return this;
  }

   /**
   * Only include unfinished tasks. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior.
   * @return unfinished
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Only include unfinished tasks. Value may only be `true`, as `false` is the default behavior.")

  public Boolean getUnfinished() {
    return unfinished;
  }


  public void setUnfinished(Boolean unfinished) {
    this.unfinished = unfinished;
  }


  public HistoricTaskInstanceQueryDto processFinished(Boolean processFinished) {
    
    this.processFinished = processFinished;
    return this;
  }

   /**
   * Only include tasks of finished processes. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior.
   * @return processFinished
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Only include tasks of finished processes. Value may only be `true`, as `false` is the default behavior.")

  public Boolean getProcessFinished() {
    return processFinished;
  }


  public void setProcessFinished(Boolean processFinished) {
    this.processFinished = processFinished;
  }


  public HistoricTaskInstanceQueryDto processUnfinished(Boolean processUnfinished) {
    
    this.processUnfinished = processUnfinished;
    return this;
  }

   /**
   * Only include tasks of unfinished processes. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior.
   * @return processUnfinished
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Only include tasks of unfinished processes. Value may only be `true`, as `false` is the default behavior.")

  public Boolean getProcessUnfinished() {
    return processUnfinished;
  }


  public void setProcessUnfinished(Boolean processUnfinished) {
    this.processUnfinished = processUnfinished;
  }


  public HistoricTaskInstanceQueryDto taskDueDate(Date taskDueDate) {
    
    this.taskDueDate = taskDueDate;
    return this;
  }

   /**
   * Restrict to tasks that are due on the given date. By [default](https://docs.camunda.org/manual/7.20/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;.
   * @return taskDueDate
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Restrict to tasks that are due on the given date. By [default](https://docs.camunda.org/manual/7.20/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.")

  public Date getTaskDueDate() {
    return taskDueDate;
  }


  public void setTaskDueDate(Date taskDueDate) {
    this.taskDueDate = taskDueDate;
  }


  public HistoricTaskInstanceQueryDto taskDueDateBefore(Date taskDueDateBefore) {
    
    this.taskDueDateBefore = taskDueDateBefore;
    return this;
  }

   /**
   * Restrict to tasks that are due before the given date. By [default](https://docs.camunda.org/manual/7.20/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;.
   * @return taskDueDateBefore
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Restrict to tasks that are due before the given date. By [default](https://docs.camunda.org/manual/7.20/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.")

  public Date getTaskDueDateBefore() {
    return taskDueDateBefore;
  }


  public void setTaskDueDateBefore(Date taskDueDateBefore) {
    this.taskDueDateBefore = taskDueDateBefore;
  }


  public HistoricTaskInstanceQueryDto taskDueDateAfter(Date taskDueDateAfter) {
    
    this.taskDueDateAfter = taskDueDateAfter;
    return this;
  }

   /**
   * Restrict to tasks that are due after the given date. By [default](https://docs.camunda.org/manual/7.20/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;.
   * @return taskDueDateAfter
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Restrict to tasks that are due after the given date. By [default](https://docs.camunda.org/manual/7.20/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.")

  public Date getTaskDueDateAfter() {
    return taskDueDateAfter;
  }


  public void setTaskDueDateAfter(Date taskDueDateAfter) {
    this.taskDueDateAfter = taskDueDateAfter;
  }


  public HistoricTaskInstanceQueryDto withoutTaskDueDate(Boolean withoutTaskDueDate) {
    
    this.withoutTaskDueDate = withoutTaskDueDate;
    return this;
  }

   /**
   * Only include tasks which have no due date. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior.
   * @return withoutTaskDueDate
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Only include tasks which have no due date. Value may only be `true`, as `false` is the default behavior.")

  public Boolean getWithoutTaskDueDate() {
    return withoutTaskDueDate;
  }


  public void setWithoutTaskDueDate(Boolean withoutTaskDueDate) {
    this.withoutTaskDueDate = withoutTaskDueDate;
  }


  public HistoricTaskInstanceQueryDto taskFollowUpDate(Date taskFollowUpDate) {
    
    this.taskFollowUpDate = taskFollowUpDate;
    return this;
  }

   /**
   * Restrict to tasks that have a followUp date on the given date. By [default](https://docs.camunda.org/manual/7.20/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;.
   * @return taskFollowUpDate
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Restrict to tasks that have a followUp date on the given date. By [default](https://docs.camunda.org/manual/7.20/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.")

  public Date getTaskFollowUpDate() {
    return taskFollowUpDate;
  }


  public void setTaskFollowUpDate(Date taskFollowUpDate) {
    this.taskFollowUpDate = taskFollowUpDate;
  }


  public HistoricTaskInstanceQueryDto taskFollowUpDateBefore(Date taskFollowUpDateBefore) {
    
    this.taskFollowUpDateBefore = taskFollowUpDateBefore;
    return this;
  }

   /**
   * Restrict to tasks that have a followUp date before the given date. By [default](https://docs.camunda.org/manual/7.20/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;.
   * @return taskFollowUpDateBefore
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Restrict to tasks that have a followUp date before the given date. By [default](https://docs.camunda.org/manual/7.20/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.")

  public Date getTaskFollowUpDateBefore() {
    return taskFollowUpDateBefore;
  }


  public void setTaskFollowUpDateBefore(Date taskFollowUpDateBefore) {
    this.taskFollowUpDateBefore = taskFollowUpDateBefore;
  }


  public HistoricTaskInstanceQueryDto taskFollowUpDateAfter(Date taskFollowUpDateAfter) {
    
    this.taskFollowUpDateAfter = taskFollowUpDateAfter;
    return this;
  }

   /**
   * Restrict to tasks that have a followUp date after the given date. By [default](https://docs.camunda.org/manual/7.20/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;.
   * @return taskFollowUpDateAfter
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Restrict to tasks that have a followUp date after the given date. By [default](https://docs.camunda.org/manual/7.20/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.")

  public Date getTaskFollowUpDateAfter() {
    return taskFollowUpDateAfter;
  }


  public void setTaskFollowUpDateAfter(Date taskFollowUpDateAfter) {
    this.taskFollowUpDateAfter = taskFollowUpDateAfter;
  }


  public HistoricTaskInstanceQueryDto startedBefore(Date startedBefore) {
    
    this.startedBefore = startedBefore;
    return this;
  }

   /**
   * Restrict to tasks that were started before the given date. By [default](https://docs.camunda.org/manual/7.20/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;.
   * @return startedBefore
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Restrict to tasks that were started before the given date. By [default](https://docs.camunda.org/manual/7.20/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.")

  public Date getStartedBefore() {
    return startedBefore;
  }


  public void setStartedBefore(Date startedBefore) {
    this.startedBefore = startedBefore;
  }


  public HistoricTaskInstanceQueryDto startedAfter(Date startedAfter) {
    
    this.startedAfter = startedAfter;
    return this;
  }

   /**
   * Restrict to tasks that were started after the given date. By [default](https://docs.camunda.org/manual/7.20/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;.
   * @return startedAfter
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Restrict to tasks that were started after the given date. By [default](https://docs.camunda.org/manual/7.20/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.")

  public Date getStartedAfter() {
    return startedAfter;
  }


  public void setStartedAfter(Date startedAfter) {
    this.startedAfter = startedAfter;
  }


  public HistoricTaskInstanceQueryDto finishedBefore(Date finishedBefore) {
    
    this.finishedBefore = finishedBefore;
    return this;
  }

   /**
   * Restrict to tasks that were finished before the given date. By [default](https://docs.camunda.org/manual/7.20/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;.
   * @return finishedBefore
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Restrict to tasks that were finished before the given date. By [default](https://docs.camunda.org/manual/7.20/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.")

  public Date getFinishedBefore() {
    return finishedBefore;
  }


  public void setFinishedBefore(Date finishedBefore) {
    this.finishedBefore = finishedBefore;
  }


  public HistoricTaskInstanceQueryDto finishedAfter(Date finishedAfter) {
    
    this.finishedAfter = finishedAfter;
    return this;
  }

   /**
   * Restrict to tasks that were finished after the given date. By [default](https://docs.camunda.org/manual/7.20/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;.
   * @return finishedAfter
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Restrict to tasks that were finished after the given date. By [default](https://docs.camunda.org/manual/7.20/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.")

  public Date getFinishedAfter() {
    return finishedAfter;
  }


  public void setFinishedAfter(Date finishedAfter) {
    this.finishedAfter = finishedAfter;
  }


  public HistoricTaskInstanceQueryDto tenantIdIn(List<String> tenantIdIn) {
    
    this.tenantIdIn = tenantIdIn;
    return this;
  }

  public HistoricTaskInstanceQueryDto addTenantIdInItem(String tenantIdInItem) {
    if (this.tenantIdIn == null) {
      this.tenantIdIn = new ArrayList<String>();
    }
    this.tenantIdIn.add(tenantIdInItem);
    return this;
  }

   /**
   * Filter by a  list of tenant ids. A task instance must have one of the given tenant ids.
   * @return tenantIdIn
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Filter by a  list of tenant ids. A task instance must have one of the given tenant ids.")

  public List<String> getTenantIdIn() {
    return tenantIdIn;
  }


  public void setTenantIdIn(List<String> tenantIdIn) {
    this.tenantIdIn = tenantIdIn;
  }


  public HistoricTaskInstanceQueryDto withoutTenantId(Boolean withoutTenantId) {
    
    this.withoutTenantId = withoutTenantId;
    return this;
  }

   /**
   * Only include historic task instances that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior.
   * @return withoutTenantId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Only include historic task instances that belong to no tenant. Value may only be `true`, as `false` is the default behavior.")

  public Boolean getWithoutTenantId() {
    return withoutTenantId;
  }


  public void setWithoutTenantId(Boolean withoutTenantId) {
    this.withoutTenantId = withoutTenantId;
  }


  public HistoricTaskInstanceQueryDto taskVariables(List<VariableQueryParameterDto> taskVariables) {
    
    this.taskVariables = taskVariables;
    return this;
  }

  public HistoricTaskInstanceQueryDto addTaskVariablesItem(VariableQueryParameterDto taskVariablesItem) {
    if (this.taskVariables == null) {
      this.taskVariables = new ArrayList<VariableQueryParameterDto>();
    }
    this.taskVariables.add(taskVariablesItem);
    return this;
  }

   /**
   * Only include tasks that have variables with certain values. Variable filtering expressions are comma-separated and are structured as follows:  A valid parameter value has the form &#x60;key_operator_value&#x60;. &#x60;key&#x60; is the variable name, &#x60;operator&#x60; is the comparison operator to be used and &#x60;value&#x60; the variable value. **Note:** Values are always treated as &#x60;String&#x60; objects on server side.   Valid operator values are: * &#x60;eq&#x60; - equal to; * &#x60;neq&#x60; - not equal to; * &#x60;gt&#x60; - greater than; * &#x60;gteq&#x60; - greater than or equal to; * &#x60;lt&#x60; - lower than; * &#x60;lteq&#x60; - lower than or equal to; * &#x60;like&#x60;.  &#x60;key&#x60; and &#x60;value&#x60; may not contain underscore or comma characters.
   * @return taskVariables
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Only include tasks that have variables with certain values. Variable filtering expressions are comma-separated and are structured as follows:  A valid parameter value has the form `key_operator_value`. `key` is the variable name, `operator` is the comparison operator to be used and `value` the variable value. **Note:** Values are always treated as `String` objects on server side.   Valid operator values are: * `eq` - equal to; * `neq` - not equal to; * `gt` - greater than; * `gteq` - greater than or equal to; * `lt` - lower than; * `lteq` - lower than or equal to; * `like`.  `key` and `value` may not contain underscore or comma characters.")

  public List<VariableQueryParameterDto> getTaskVariables() {
    return taskVariables;
  }


  public void setTaskVariables(List<VariableQueryParameterDto> taskVariables) {
    this.taskVariables = taskVariables;
  }


  public HistoricTaskInstanceQueryDto processVariables(List<VariableQueryParameterDto> processVariables) {
    
    this.processVariables = processVariables;
    return this;
  }

  public HistoricTaskInstanceQueryDto addProcessVariablesItem(VariableQueryParameterDto processVariablesItem) {
    if (this.processVariables == null) {
      this.processVariables = new ArrayList<VariableQueryParameterDto>();
    }
    this.processVariables.add(processVariablesItem);
    return this;
  }

   /**
   * Only include tasks that belong to process instances that have variables with certain values. Variable filtering expressions are comma-separated and are structured as follows:  A valid parameter value has the form &#x60;key_operator_value&#x60;. &#x60;key&#x60; is the variable name, &#x60;operator&#x60; is the comparison operator to be used and &#x60;value&#x60; the variable value. **Note:** Values are always treated as &#x60;String&#x60; objects on server side.   Valid operator values are: * &#x60;eq&#x60; - equal to; * &#x60;neq&#x60; - not equal to; * &#x60;gt&#x60; - greater than; * &#x60;gteq&#x60; - greater than or equal to; * &#x60;lt&#x60; - lower than; * &#x60;lteq&#x60; - lower than or equal to; * &#x60;like&#x60;; * &#x60;notLike&#x60;.  &#x60;key&#x60; and &#x60;value&#x60; may not contain underscore or comma characters.
   * @return processVariables
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Only include tasks that belong to process instances that have variables with certain values. Variable filtering expressions are comma-separated and are structured as follows:  A valid parameter value has the form `key_operator_value`. `key` is the variable name, `operator` is the comparison operator to be used and `value` the variable value. **Note:** Values are always treated as `String` objects on server side.   Valid operator values are: * `eq` - equal to; * `neq` - not equal to; * `gt` - greater than; * `gteq` - greater than or equal to; * `lt` - lower than; * `lteq` - lower than or equal to; * `like`; * `notLike`.  `key` and `value` may not contain underscore or comma characters.")

  public List<VariableQueryParameterDto> getProcessVariables() {
    return processVariables;
  }


  public void setProcessVariables(List<VariableQueryParameterDto> processVariables) {
    this.processVariables = processVariables;
  }


  public HistoricTaskInstanceQueryDto variableNamesIgnoreCase(Boolean variableNamesIgnoreCase) {
    
    this.variableNamesIgnoreCase = variableNamesIgnoreCase;
    return this;
  }

   /**
   * Match the variable name provided in &#x60;taskVariables&#x60; and &#x60;processVariables&#x60; case- insensitively. If set to &#x60;true&#x60; **variableName** and **variablename** are treated as equal.
   * @return variableNamesIgnoreCase
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Match the variable name provided in `taskVariables` and `processVariables` case- insensitively. If set to `true` **variableName** and **variablename** are treated as equal.")

  public Boolean getVariableNamesIgnoreCase() {
    return variableNamesIgnoreCase;
  }


  public void setVariableNamesIgnoreCase(Boolean variableNamesIgnoreCase) {
    this.variableNamesIgnoreCase = variableNamesIgnoreCase;
  }


  public HistoricTaskInstanceQueryDto variableValuesIgnoreCase(Boolean variableValuesIgnoreCase) {
    
    this.variableValuesIgnoreCase = variableValuesIgnoreCase;
    return this;
  }

   /**
   * Match the variable value provided in &#x60;taskVariables&#x60; and &#x60;processVariables&#x60; case- insensitively. If set to &#x60;true&#x60; **variableValue** and **variablevalue** are treated as equal.
   * @return variableValuesIgnoreCase
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Match the variable value provided in `taskVariables` and `processVariables` case- insensitively. If set to `true` **variableValue** and **variablevalue** are treated as equal.")

  public Boolean getVariableValuesIgnoreCase() {
    return variableValuesIgnoreCase;
  }


  public void setVariableValuesIgnoreCase(Boolean variableValuesIgnoreCase) {
    this.variableValuesIgnoreCase = variableValuesIgnoreCase;
  }


  public HistoricTaskInstanceQueryDto taskInvolvedUser(String taskInvolvedUser) {
    
    this.taskInvolvedUser = taskInvolvedUser;
    return this;
  }

   /**
   * Restrict to tasks with a historic identity link to the given user.
   * @return taskInvolvedUser
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Restrict to tasks with a historic identity link to the given user.")

  public String getTaskInvolvedUser() {
    return taskInvolvedUser;
  }


  public void setTaskInvolvedUser(String taskInvolvedUser) {
    this.taskInvolvedUser = taskInvolvedUser;
  }


  public HistoricTaskInstanceQueryDto taskInvolvedGroup(String taskInvolvedGroup) {
    
    this.taskInvolvedGroup = taskInvolvedGroup;
    return this;
  }

   /**
   * Restrict to tasks with a historic identity link to the given group.
   * @return taskInvolvedGroup
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Restrict to tasks with a historic identity link to the given group.")

  public String getTaskInvolvedGroup() {
    return taskInvolvedGroup;
  }


  public void setTaskInvolvedGroup(String taskInvolvedGroup) {
    this.taskInvolvedGroup = taskInvolvedGroup;
  }


  public HistoricTaskInstanceQueryDto taskHadCandidateUser(String taskHadCandidateUser) {
    
    this.taskHadCandidateUser = taskHadCandidateUser;
    return this;
  }

   /**
   * Restrict to tasks with a historic identity link to the given candidate user.
   * @return taskHadCandidateUser
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Restrict to tasks with a historic identity link to the given candidate user.")

  public String getTaskHadCandidateUser() {
    return taskHadCandidateUser;
  }


  public void setTaskHadCandidateUser(String taskHadCandidateUser) {
    this.taskHadCandidateUser = taskHadCandidateUser;
  }


  public HistoricTaskInstanceQueryDto taskHadCandidateGroup(String taskHadCandidateGroup) {
    
    this.taskHadCandidateGroup = taskHadCandidateGroup;
    return this;
  }

   /**
   * Restrict to tasks with a historic identity link to the given candidate group.
   * @return taskHadCandidateGroup
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Restrict to tasks with a historic identity link to the given candidate group.")

  public String getTaskHadCandidateGroup() {
    return taskHadCandidateGroup;
  }


  public void setTaskHadCandidateGroup(String taskHadCandidateGroup) {
    this.taskHadCandidateGroup = taskHadCandidateGroup;
  }


  public HistoricTaskInstanceQueryDto withCandidateGroups(Boolean withCandidateGroups) {
    
    this.withCandidateGroups = withCandidateGroups;
    return this;
  }

   /**
   * Only include tasks which have a candidate group. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior.
   * @return withCandidateGroups
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Only include tasks which have a candidate group. Value may only be `true`, as `false` is the default behavior.")

  public Boolean getWithCandidateGroups() {
    return withCandidateGroups;
  }


  public void setWithCandidateGroups(Boolean withCandidateGroups) {
    this.withCandidateGroups = withCandidateGroups;
  }


  public HistoricTaskInstanceQueryDto withoutCandidateGroups(Boolean withoutCandidateGroups) {
    
    this.withoutCandidateGroups = withoutCandidateGroups;
    return this;
  }

   /**
   * Only include tasks which have no candidate group. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior.
   * @return withoutCandidateGroups
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Only include tasks which have no candidate group. Value may only be `true`, as `false` is the default behavior.")

  public Boolean getWithoutCandidateGroups() {
    return withoutCandidateGroups;
  }


  public void setWithoutCandidateGroups(Boolean withoutCandidateGroups) {
    this.withoutCandidateGroups = withoutCandidateGroups;
  }


  public HistoricTaskInstanceQueryDto orQueries(List<HistoricTaskInstanceQueryDto> orQueries) {
    
    this.orQueries = orQueries;
    return this;
  }

  public HistoricTaskInstanceQueryDto addOrQueriesItem(HistoricTaskInstanceQueryDto orQueriesItem) {
    if (this.orQueries == null) {
      this.orQueries = new ArrayList<HistoricTaskInstanceQueryDto>();
    }
    this.orQueries.add(orQueriesItem);
    return this;
  }

   /**
   * A JSON array of nested historic task instance queries with OR semantics.  A task instance matches a nested query if it fulfills at least one of the query&#39;s predicates.  With multiple nested queries, a task instance must fulfill at least one predicate of each query ([Conjunctive Normal Form](https://en.wikipedia.org/wiki/Conjunctive_normal_form)).  All task instance query properties can be used except for: &#x60;sorting&#x60;, &#x60;withCandidateGroups&#x60;, &#x60; withoutCandidateGroups&#x60;.  See the [User Guide](https://docs.camunda.org/manual/7.20/user-guide/process-engine/process-engine-api/#or-queries) for more information about OR queries.
   * @return orQueries
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "A JSON array of nested historic task instance queries with OR semantics.  A task instance matches a nested query if it fulfills at least one of the query's predicates.  With multiple nested queries, a task instance must fulfill at least one predicate of each query ([Conjunctive Normal Form](https://en.wikipedia.org/wiki/Conjunctive_normal_form)).  All task instance query properties can be used except for: `sorting`, `withCandidateGroups`, ` withoutCandidateGroups`.  See the [User Guide](https://docs.camunda.org/manual/7.20/user-guide/process-engine/process-engine-api/#or-queries) for more information about OR queries.")

  public List<HistoricTaskInstanceQueryDto> getOrQueries() {
    return orQueries;
  }


  public void setOrQueries(List<HistoricTaskInstanceQueryDto> orQueries) {
    this.orQueries = orQueries;
  }


  public HistoricTaskInstanceQueryDto sorting(List<HistoricTaskInstanceQueryDtoSorting> sorting) {
    
    this.sorting = sorting;
    return this;
  }

  public HistoricTaskInstanceQueryDto addSortingItem(HistoricTaskInstanceQueryDtoSorting sortingItem) {
    if (this.sorting == null) {
      this.sorting = new ArrayList<HistoricTaskInstanceQueryDtoSorting>();
    }
    this.sorting.add(sortingItem);
    return this;
  }

   /**
   * An array of criteria to sort the result by. Each element of the array is                     an object that specifies one ordering. The position in the array                     identifies the rank of an ordering, i.e., whether it is primary, secondary,                     etc. Sorting has no effect for &#x60;count&#x60; endpoints
   * @return sorting
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "An array of criteria to sort the result by. Each element of the array is                     an object that specifies one ordering. The position in the array                     identifies the rank of an ordering, i.e., whether it is primary, secondary,                     etc. Sorting has no effect for `count` endpoints")

  public List<HistoricTaskInstanceQueryDtoSorting> getSorting() {
    return sorting;
  }


  public void setSorting(List<HistoricTaskInstanceQueryDtoSorting> sorting) {
    this.sorting = sorting;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    HistoricTaskInstanceQueryDto historicTaskInstanceQueryDto = (HistoricTaskInstanceQueryDto) o;
    return Objects.equals(this.taskId, historicTaskInstanceQueryDto.taskId) &&
        Objects.equals(this.taskParentTaskId, historicTaskInstanceQueryDto.taskParentTaskId) &&
        Objects.equals(this.processInstanceId, historicTaskInstanceQueryDto.processInstanceId) &&
        Objects.equals(this.processInstanceBusinessKey, historicTaskInstanceQueryDto.processInstanceBusinessKey) &&
        Objects.equals(this.processInstanceBusinessKeyIn, historicTaskInstanceQueryDto.processInstanceBusinessKeyIn) &&
        Objects.equals(this.processInstanceBusinessKeyLike, historicTaskInstanceQueryDto.processInstanceBusinessKeyLike) &&
        Objects.equals(this.executionId, historicTaskInstanceQueryDto.executionId) &&
        Objects.equals(this.processDefinitionId, historicTaskInstanceQueryDto.processDefinitionId) &&
        Objects.equals(this.processDefinitionKey, historicTaskInstanceQueryDto.processDefinitionKey) &&
        Objects.equals(this.processDefinitionName, historicTaskInstanceQueryDto.processDefinitionName) &&
        Objects.equals(this.caseInstanceId, historicTaskInstanceQueryDto.caseInstanceId) &&
        Objects.equals(this.caseExecutionId, historicTaskInstanceQueryDto.caseExecutionId) &&
        Objects.equals(this.caseDefinitionId, historicTaskInstanceQueryDto.caseDefinitionId) &&
        Objects.equals(this.caseDefinitionKey, historicTaskInstanceQueryDto.caseDefinitionKey) &&
        Objects.equals(this.caseDefinitionName, historicTaskInstanceQueryDto.caseDefinitionName) &&
        Objects.equals(this.activityInstanceIdIn, historicTaskInstanceQueryDto.activityInstanceIdIn) &&
        Objects.equals(this.taskName, historicTaskInstanceQueryDto.taskName) &&
        Objects.equals(this.taskNameLike, historicTaskInstanceQueryDto.taskNameLike) &&
        Objects.equals(this.taskDescription, historicTaskInstanceQueryDto.taskDescription) &&
        Objects.equals(this.taskDescriptionLike, historicTaskInstanceQueryDto.taskDescriptionLike) &&
        Objects.equals(this.taskDefinitionKey, historicTaskInstanceQueryDto.taskDefinitionKey) &&
        Objects.equals(this.taskDefinitionKeyIn, historicTaskInstanceQueryDto.taskDefinitionKeyIn) &&
        Objects.equals(this.taskDeleteReason, historicTaskInstanceQueryDto.taskDeleteReason) &&
        Objects.equals(this.taskDeleteReasonLike, historicTaskInstanceQueryDto.taskDeleteReasonLike) &&
        Objects.equals(this.taskAssignee, historicTaskInstanceQueryDto.taskAssignee) &&
        Objects.equals(this.taskAssigneeLike, historicTaskInstanceQueryDto.taskAssigneeLike) &&
        Objects.equals(this.taskOwner, historicTaskInstanceQueryDto.taskOwner) &&
        Objects.equals(this.taskOwnerLike, historicTaskInstanceQueryDto.taskOwnerLike) &&
        Objects.equals(this.taskPriority, historicTaskInstanceQueryDto.taskPriority) &&
        Objects.equals(this.assigned, historicTaskInstanceQueryDto.assigned) &&
        Objects.equals(this.unassigned, historicTaskInstanceQueryDto.unassigned) &&
        Objects.equals(this.finished, historicTaskInstanceQueryDto.finished) &&
        Objects.equals(this.unfinished, historicTaskInstanceQueryDto.unfinished) &&
        Objects.equals(this.processFinished, historicTaskInstanceQueryDto.processFinished) &&
        Objects.equals(this.processUnfinished, historicTaskInstanceQueryDto.processUnfinished) &&
        Objects.equals(this.taskDueDate, historicTaskInstanceQueryDto.taskDueDate) &&
        Objects.equals(this.taskDueDateBefore, historicTaskInstanceQueryDto.taskDueDateBefore) &&
        Objects.equals(this.taskDueDateAfter, historicTaskInstanceQueryDto.taskDueDateAfter) &&
        Objects.equals(this.withoutTaskDueDate, historicTaskInstanceQueryDto.withoutTaskDueDate) &&
        Objects.equals(this.taskFollowUpDate, historicTaskInstanceQueryDto.taskFollowUpDate) &&
        Objects.equals(this.taskFollowUpDateBefore, historicTaskInstanceQueryDto.taskFollowUpDateBefore) &&
        Objects.equals(this.taskFollowUpDateAfter, historicTaskInstanceQueryDto.taskFollowUpDateAfter) &&
        Objects.equals(this.startedBefore, historicTaskInstanceQueryDto.startedBefore) &&
        Objects.equals(this.startedAfter, historicTaskInstanceQueryDto.startedAfter) &&
        Objects.equals(this.finishedBefore, historicTaskInstanceQueryDto.finishedBefore) &&
        Objects.equals(this.finishedAfter, historicTaskInstanceQueryDto.finishedAfter) &&
        Objects.equals(this.tenantIdIn, historicTaskInstanceQueryDto.tenantIdIn) &&
        Objects.equals(this.withoutTenantId, historicTaskInstanceQueryDto.withoutTenantId) &&
        Objects.equals(this.taskVariables, historicTaskInstanceQueryDto.taskVariables) &&
        Objects.equals(this.processVariables, historicTaskInstanceQueryDto.processVariables) &&
        Objects.equals(this.variableNamesIgnoreCase, historicTaskInstanceQueryDto.variableNamesIgnoreCase) &&
        Objects.equals(this.variableValuesIgnoreCase, historicTaskInstanceQueryDto.variableValuesIgnoreCase) &&
        Objects.equals(this.taskInvolvedUser, historicTaskInstanceQueryDto.taskInvolvedUser) &&
        Objects.equals(this.taskInvolvedGroup, historicTaskInstanceQueryDto.taskInvolvedGroup) &&
        Objects.equals(this.taskHadCandidateUser, historicTaskInstanceQueryDto.taskHadCandidateUser) &&
        Objects.equals(this.taskHadCandidateGroup, historicTaskInstanceQueryDto.taskHadCandidateGroup) &&
        Objects.equals(this.withCandidateGroups, historicTaskInstanceQueryDto.withCandidateGroups) &&
        Objects.equals(this.withoutCandidateGroups, historicTaskInstanceQueryDto.withoutCandidateGroups) &&
        Objects.equals(this.orQueries, historicTaskInstanceQueryDto.orQueries) &&
        Objects.equals(this.sorting, historicTaskInstanceQueryDto.sorting);
  }

  @Override
  public int hashCode() {
    return Objects.hash(taskId, taskParentTaskId, processInstanceId, processInstanceBusinessKey, processInstanceBusinessKeyIn, processInstanceBusinessKeyLike, executionId, processDefinitionId, processDefinitionKey, processDefinitionName, caseInstanceId, caseExecutionId, caseDefinitionId, caseDefinitionKey, caseDefinitionName, activityInstanceIdIn, taskName, taskNameLike, taskDescription, taskDescriptionLike, taskDefinitionKey, taskDefinitionKeyIn, taskDeleteReason, taskDeleteReasonLike, taskAssignee, taskAssigneeLike, taskOwner, taskOwnerLike, taskPriority, assigned, unassigned, finished, unfinished, processFinished, processUnfinished, taskDueDate, taskDueDateBefore, taskDueDateAfter, withoutTaskDueDate, taskFollowUpDate, taskFollowUpDateBefore, taskFollowUpDateAfter, startedBefore, startedAfter, finishedBefore, finishedAfter, tenantIdIn, withoutTenantId, taskVariables, processVariables, variableNamesIgnoreCase, variableValuesIgnoreCase, taskInvolvedUser, taskInvolvedGroup, taskHadCandidateUser, taskHadCandidateGroup, withCandidateGroups, withoutCandidateGroups, orQueries, sorting);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class HistoricTaskInstanceQueryDto {\n");
    sb.append("    taskId: ").append(toIndentedString(taskId)).append("\n");
    sb.append("    taskParentTaskId: ").append(toIndentedString(taskParentTaskId)).append("\n");
    sb.append("    processInstanceId: ").append(toIndentedString(processInstanceId)).append("\n");
    sb.append("    processInstanceBusinessKey: ").append(toIndentedString(processInstanceBusinessKey)).append("\n");
    sb.append("    processInstanceBusinessKeyIn: ").append(toIndentedString(processInstanceBusinessKeyIn)).append("\n");
    sb.append("    processInstanceBusinessKeyLike: ").append(toIndentedString(processInstanceBusinessKeyLike)).append("\n");
    sb.append("    executionId: ").append(toIndentedString(executionId)).append("\n");
    sb.append("    processDefinitionId: ").append(toIndentedString(processDefinitionId)).append("\n");
    sb.append("    processDefinitionKey: ").append(toIndentedString(processDefinitionKey)).append("\n");
    sb.append("    processDefinitionName: ").append(toIndentedString(processDefinitionName)).append("\n");
    sb.append("    caseInstanceId: ").append(toIndentedString(caseInstanceId)).append("\n");
    sb.append("    caseExecutionId: ").append(toIndentedString(caseExecutionId)).append("\n");
    sb.append("    caseDefinitionId: ").append(toIndentedString(caseDefinitionId)).append("\n");
    sb.append("    caseDefinitionKey: ").append(toIndentedString(caseDefinitionKey)).append("\n");
    sb.append("    caseDefinitionName: ").append(toIndentedString(caseDefinitionName)).append("\n");
    sb.append("    activityInstanceIdIn: ").append(toIndentedString(activityInstanceIdIn)).append("\n");
    sb.append("    taskName: ").append(toIndentedString(taskName)).append("\n");
    sb.append("    taskNameLike: ").append(toIndentedString(taskNameLike)).append("\n");
    sb.append("    taskDescription: ").append(toIndentedString(taskDescription)).append("\n");
    sb.append("    taskDescriptionLike: ").append(toIndentedString(taskDescriptionLike)).append("\n");
    sb.append("    taskDefinitionKey: ").append(toIndentedString(taskDefinitionKey)).append("\n");
    sb.append("    taskDefinitionKeyIn: ").append(toIndentedString(taskDefinitionKeyIn)).append("\n");
    sb.append("    taskDeleteReason: ").append(toIndentedString(taskDeleteReason)).append("\n");
    sb.append("    taskDeleteReasonLike: ").append(toIndentedString(taskDeleteReasonLike)).append("\n");
    sb.append("    taskAssignee: ").append(toIndentedString(taskAssignee)).append("\n");
    sb.append("    taskAssigneeLike: ").append(toIndentedString(taskAssigneeLike)).append("\n");
    sb.append("    taskOwner: ").append(toIndentedString(taskOwner)).append("\n");
    sb.append("    taskOwnerLike: ").append(toIndentedString(taskOwnerLike)).append("\n");
    sb.append("    taskPriority: ").append(toIndentedString(taskPriority)).append("\n");
    sb.append("    assigned: ").append(toIndentedString(assigned)).append("\n");
    sb.append("    unassigned: ").append(toIndentedString(unassigned)).append("\n");
    sb.append("    finished: ").append(toIndentedString(finished)).append("\n");
    sb.append("    unfinished: ").append(toIndentedString(unfinished)).append("\n");
    sb.append("    processFinished: ").append(toIndentedString(processFinished)).append("\n");
    sb.append("    processUnfinished: ").append(toIndentedString(processUnfinished)).append("\n");
    sb.append("    taskDueDate: ").append(toIndentedString(taskDueDate)).append("\n");
    sb.append("    taskDueDateBefore: ").append(toIndentedString(taskDueDateBefore)).append("\n");
    sb.append("    taskDueDateAfter: ").append(toIndentedString(taskDueDateAfter)).append("\n");
    sb.append("    withoutTaskDueDate: ").append(toIndentedString(withoutTaskDueDate)).append("\n");
    sb.append("    taskFollowUpDate: ").append(toIndentedString(taskFollowUpDate)).append("\n");
    sb.append("    taskFollowUpDateBefore: ").append(toIndentedString(taskFollowUpDateBefore)).append("\n");
    sb.append("    taskFollowUpDateAfter: ").append(toIndentedString(taskFollowUpDateAfter)).append("\n");
    sb.append("    startedBefore: ").append(toIndentedString(startedBefore)).append("\n");
    sb.append("    startedAfter: ").append(toIndentedString(startedAfter)).append("\n");
    sb.append("    finishedBefore: ").append(toIndentedString(finishedBefore)).append("\n");
    sb.append("    finishedAfter: ").append(toIndentedString(finishedAfter)).append("\n");
    sb.append("    tenantIdIn: ").append(toIndentedString(tenantIdIn)).append("\n");
    sb.append("    withoutTenantId: ").append(toIndentedString(withoutTenantId)).append("\n");
    sb.append("    taskVariables: ").append(toIndentedString(taskVariables)).append("\n");
    sb.append("    processVariables: ").append(toIndentedString(processVariables)).append("\n");
    sb.append("    variableNamesIgnoreCase: ").append(toIndentedString(variableNamesIgnoreCase)).append("\n");
    sb.append("    variableValuesIgnoreCase: ").append(toIndentedString(variableValuesIgnoreCase)).append("\n");
    sb.append("    taskInvolvedUser: ").append(toIndentedString(taskInvolvedUser)).append("\n");
    sb.append("    taskInvolvedGroup: ").append(toIndentedString(taskInvolvedGroup)).append("\n");
    sb.append("    taskHadCandidateUser: ").append(toIndentedString(taskHadCandidateUser)).append("\n");
    sb.append("    taskHadCandidateGroup: ").append(toIndentedString(taskHadCandidateGroup)).append("\n");
    sb.append("    withCandidateGroups: ").append(toIndentedString(withCandidateGroups)).append("\n");
    sb.append("    withoutCandidateGroups: ").append(toIndentedString(withoutCandidateGroups)).append("\n");
    sb.append("    orQueries: ").append(toIndentedString(orQueries)).append("\n");
    sb.append("    sorting: ").append(toIndentedString(sorting)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

