/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.20.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.dto;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.community.rest.client.dto.VariableValueDto;

/**
 * MigrationPlanGenerationDto
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-10-27T07:19:49.896034Z[Etc/UTC]")
public class MigrationPlanGenerationDto {
  public static final String SERIALIZED_NAME_SOURCE_PROCESS_DEFINITION_ID = "sourceProcessDefinitionId";
  @SerializedName(SERIALIZED_NAME_SOURCE_PROCESS_DEFINITION_ID)
  private String sourceProcessDefinitionId;

  public static final String SERIALIZED_NAME_TARGET_PROCESS_DEFINITION_ID = "targetProcessDefinitionId";
  @SerializedName(SERIALIZED_NAME_TARGET_PROCESS_DEFINITION_ID)
  private String targetProcessDefinitionId;

  public static final String SERIALIZED_NAME_UPDATE_EVENT_TRIGGERS = "updateEventTriggers";
  @SerializedName(SERIALIZED_NAME_UPDATE_EVENT_TRIGGERS)
  private Boolean updateEventTriggers;

  public static final String SERIALIZED_NAME_VARIABLES = "variables";
  @SerializedName(SERIALIZED_NAME_VARIABLES)
  private Map<String, VariableValueDto> variables = null;


  public MigrationPlanGenerationDto sourceProcessDefinitionId(String sourceProcessDefinitionId) {
    
    this.sourceProcessDefinitionId = sourceProcessDefinitionId;
    return this;
  }

   /**
   * The id of the source process definition for the migration.
   * @return sourceProcessDefinitionId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The id of the source process definition for the migration.")

  public String getSourceProcessDefinitionId() {
    return sourceProcessDefinitionId;
  }


  public void setSourceProcessDefinitionId(String sourceProcessDefinitionId) {
    this.sourceProcessDefinitionId = sourceProcessDefinitionId;
  }


  public MigrationPlanGenerationDto targetProcessDefinitionId(String targetProcessDefinitionId) {
    
    this.targetProcessDefinitionId = targetProcessDefinitionId;
    return this;
  }

   /**
   * The id of the target process definition for the migration.
   * @return targetProcessDefinitionId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The id of the target process definition for the migration.")

  public String getTargetProcessDefinitionId() {
    return targetProcessDefinitionId;
  }


  public void setTargetProcessDefinitionId(String targetProcessDefinitionId) {
    this.targetProcessDefinitionId = targetProcessDefinitionId;
  }


  public MigrationPlanGenerationDto updateEventTriggers(Boolean updateEventTriggers) {
    
    this.updateEventTriggers = updateEventTriggers;
    return this;
  }

   /**
   * A boolean flag indicating whether instructions between events should be configured to update the event triggers.
   * @return updateEventTriggers
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "A boolean flag indicating whether instructions between events should be configured to update the event triggers.")

  public Boolean getUpdateEventTriggers() {
    return updateEventTriggers;
  }


  public void setUpdateEventTriggers(Boolean updateEventTriggers) {
    this.updateEventTriggers = updateEventTriggers;
  }


  public MigrationPlanGenerationDto variables(Map<String, VariableValueDto> variables) {
    
    this.variables = variables;
    return this;
  }

  public MigrationPlanGenerationDto putVariablesItem(String key, VariableValueDto variablesItem) {
    if (this.variables == null) {
      this.variables = new HashMap<String, VariableValueDto>();
    }
    this.variables.put(key, variablesItem);
    return this;
  }

   /**
   * A map of variables which will be set into the process instances&#39; scope. Each key is a variable name and each value a JSON variable value object.
   * @return variables
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "A map of variables which will be set into the process instances' scope. Each key is a variable name and each value a JSON variable value object.")

  public Map<String, VariableValueDto> getVariables() {
    return variables;
  }


  public void setVariables(Map<String, VariableValueDto> variables) {
    this.variables = variables;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MigrationPlanGenerationDto migrationPlanGenerationDto = (MigrationPlanGenerationDto) o;
    return Objects.equals(this.sourceProcessDefinitionId, migrationPlanGenerationDto.sourceProcessDefinitionId) &&
        Objects.equals(this.targetProcessDefinitionId, migrationPlanGenerationDto.targetProcessDefinitionId) &&
        Objects.equals(this.updateEventTriggers, migrationPlanGenerationDto.updateEventTriggers) &&
        Objects.equals(this.variables, migrationPlanGenerationDto.variables);
  }

  @Override
  public int hashCode() {
    return Objects.hash(sourceProcessDefinitionId, targetProcessDefinitionId, updateEventTriggers, variables);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MigrationPlanGenerationDto {\n");
    sb.append("    sourceProcessDefinitionId: ").append(toIndentedString(sourceProcessDefinitionId)).append("\n");
    sb.append("    targetProcessDefinitionId: ").append(toIndentedString(targetProcessDefinitionId)).append("\n");
    sb.append("    updateEventTriggers: ").append(toIndentedString(updateEventTriggers)).append("\n");
    sb.append("    variables: ").append(toIndentedString(variables)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

