/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import java.util.Objects;
import javax.annotation.Nullable;

public class HistoricActivityInstanceDto {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_PARENT_ACTIVITY_INSTANCE_ID = "parentActivityInstanceId";
    @SerializedName(value="parentActivityInstanceId")
    private String parentActivityInstanceId;
    public static final String SERIALIZED_NAME_ACTIVITY_ID = "activityId";
    @SerializedName(value="activityId")
    private String activityId;
    public static final String SERIALIZED_NAME_ACTIVITY_NAME = "activityName";
    @SerializedName(value="activityName")
    private String activityName;
    public static final String SERIALIZED_NAME_ACTIVITY_TYPE = "activityType";
    @SerializedName(value="activityType")
    private String activityType;
    public static final String SERIALIZED_NAME_PROCESS_DEFINITION_KEY = "processDefinitionKey";
    @SerializedName(value="processDefinitionKey")
    private String processDefinitionKey;
    public static final String SERIALIZED_NAME_PROCESS_DEFINITION_ID = "processDefinitionId";
    @SerializedName(value="processDefinitionId")
    private String processDefinitionId;
    public static final String SERIALIZED_NAME_PROCESS_INSTANCE_ID = "processInstanceId";
    @SerializedName(value="processInstanceId")
    private String processInstanceId;
    public static final String SERIALIZED_NAME_EXECUTION_ID = "executionId";
    @SerializedName(value="executionId")
    private String executionId;
    public static final String SERIALIZED_NAME_TASK_ID = "taskId";
    @SerializedName(value="taskId")
    private String taskId;
    public static final String SERIALIZED_NAME_ASSIGNEE = "assignee";
    @SerializedName(value="assignee")
    private String assignee;
    public static final String SERIALIZED_NAME_CALLED_PROCESS_INSTANCE_ID = "calledProcessInstanceId";
    @SerializedName(value="calledProcessInstanceId")
    private String calledProcessInstanceId;
    public static final String SERIALIZED_NAME_CALLED_CASE_INSTANCE_ID = "calledCaseInstanceId";
    @SerializedName(value="calledCaseInstanceId")
    private String calledCaseInstanceId;
    public static final String SERIALIZED_NAME_START_TIME = "startTime";
    @SerializedName(value="startTime")
    private Date startTime;
    public static final String SERIALIZED_NAME_END_TIME = "endTime";
    @SerializedName(value="endTime")
    private Date endTime;
    public static final String SERIALIZED_NAME_DURATION_IN_MILLIS = "durationInMillis";
    @SerializedName(value="durationInMillis")
    private Long durationInMillis;
    public static final String SERIALIZED_NAME_CANCELED = "canceled";
    @SerializedName(value="canceled")
    private Boolean canceled;
    public static final String SERIALIZED_NAME_COMPLETE_SCOPE = "completeScope";
    @SerializedName(value="completeScope")
    private Boolean completeScope;
    public static final String SERIALIZED_NAME_TENANT_ID = "tenantId";
    @SerializedName(value="tenantId")
    private String tenantId;
    public static final String SERIALIZED_NAME_REMOVAL_TIME = "removalTime";
    @SerializedName(value="removalTime")
    private Date removalTime;
    public static final String SERIALIZED_NAME_ROOT_PROCESS_INSTANCE_ID = "rootProcessInstanceId";
    @SerializedName(value="rootProcessInstanceId")
    private String rootProcessInstanceId;

    public HistoricActivityInstanceDto id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the activity instance.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public HistoricActivityInstanceDto parentActivityInstanceId(String parentActivityInstanceId) {
        this.parentActivityInstanceId = parentActivityInstanceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the parent activity instance, for example a sub process instance.")
    public String getParentActivityInstanceId() {
        return this.parentActivityInstanceId;
    }

    public void setParentActivityInstanceId(String parentActivityInstanceId) {
        this.parentActivityInstanceId = parentActivityInstanceId;
    }

    public HistoricActivityInstanceDto activityId(String activityId) {
        this.activityId = activityId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the activity that this object is an instance of.")
    public String getActivityId() {
        return this.activityId;
    }

    public void setActivityId(String activityId) {
        this.activityId = activityId;
    }

    public HistoricActivityInstanceDto activityName(String activityName) {
        this.activityName = activityName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of the activity that this object is an instance of.")
    public String getActivityName() {
        return this.activityName;
    }

    public void setActivityName(String activityName) {
        this.activityName = activityName;
    }

    public HistoricActivityInstanceDto activityType(String activityType) {
        this.activityType = activityType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The type of the activity that this object is an instance of.")
    public String getActivityType() {
        return this.activityType;
    }

    public void setActivityType(String activityType) {
        this.activityType = activityType;
    }

    public HistoricActivityInstanceDto processDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The key of the process definition that this activity instance belongs to.")
    public String getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public void setProcessDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    public HistoricActivityInstanceDto processDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the process definition that this activity instance belongs to.")
    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    public HistoricActivityInstanceDto processInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the process instance that this activity instance belongs to.")
    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public HistoricActivityInstanceDto executionId(String executionId) {
        this.executionId = executionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the execution that executed this activity instance.")
    public String getExecutionId() {
        return this.executionId;
    }

    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    public HistoricActivityInstanceDto taskId(String taskId) {
        this.taskId = taskId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the task that is associated to this activity instance. Is only set if the activity is a user task.")
    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public HistoricActivityInstanceDto assignee(String assignee) {
        this.assignee = assignee;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The assignee of the task that is associated to this activity instance. Is only set if the activity is a user task.")
    public String getAssignee() {
        return this.assignee;
    }

    public void setAssignee(String assignee) {
        this.assignee = assignee;
    }

    public HistoricActivityInstanceDto calledProcessInstanceId(String calledProcessInstanceId) {
        this.calledProcessInstanceId = calledProcessInstanceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the called process instance. Is only set if the activity is a call activity and the called instance a process instance.")
    public String getCalledProcessInstanceId() {
        return this.calledProcessInstanceId;
    }

    public void setCalledProcessInstanceId(String calledProcessInstanceId) {
        this.calledProcessInstanceId = calledProcessInstanceId;
    }

    public HistoricActivityInstanceDto calledCaseInstanceId(String calledCaseInstanceId) {
        this.calledCaseInstanceId = calledCaseInstanceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the called case instance. Is only set if the activity is a call activity and the called instance a case instance.")
    public String getCalledCaseInstanceId() {
        return this.calledCaseInstanceId;
    }

    public void setCalledCaseInstanceId(String calledCaseInstanceId) {
        this.calledCaseInstanceId = calledCaseInstanceId;
    }

    public HistoricActivityInstanceDto startTime(Date startTime) {
        this.startTime = startTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The time the instance was started. By [default](https://docs.camunda.org/manual/7.20/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.")
    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public HistoricActivityInstanceDto endTime(Date endTime) {
        this.endTime = endTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The time the instance ended. By [default](https://docs.camunda.org/manual/7.20/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.")
    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public HistoricActivityInstanceDto durationInMillis(Long durationInMillis) {
        this.durationInMillis = durationInMillis;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The time the instance took to finish (in milliseconds).")
    public Long getDurationInMillis() {
        return this.durationInMillis;
    }

    public void setDurationInMillis(Long durationInMillis) {
        this.durationInMillis = durationInMillis;
    }

    public HistoricActivityInstanceDto canceled(Boolean canceled) {
        this.canceled = canceled;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If `true`, this activity instance is canceled.")
    public Boolean getCanceled() {
        return this.canceled;
    }

    public void setCanceled(Boolean canceled) {
        this.canceled = canceled;
    }

    public HistoricActivityInstanceDto completeScope(Boolean completeScope) {
        this.completeScope = completeScope;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If `true`, this activity instance did complete a BPMN 2.0 scope.")
    public Boolean getCompleteScope() {
        return this.completeScope;
    }

    public void setCompleteScope(Boolean completeScope) {
        this.completeScope = completeScope;
    }

    public HistoricActivityInstanceDto tenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The tenant id of the activity instance.")
    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public HistoricActivityInstanceDto removalTime(Date removalTime) {
        this.removalTime = removalTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The time after which the activity instance should be removed by the History Cleanup job. By [default](https://docs.camunda.org/manual/7.20/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.")
    public Date getRemovalTime() {
        return this.removalTime;
    }

    public void setRemovalTime(Date removalTime) {
        this.removalTime = removalTime;
    }

    public HistoricActivityInstanceDto rootProcessInstanceId(String rootProcessInstanceId) {
        this.rootProcessInstanceId = rootProcessInstanceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The process instance id of the root process instance that initiated the process containing this activity instance.")
    public String getRootProcessInstanceId() {
        return this.rootProcessInstanceId;
    }

    public void setRootProcessInstanceId(String rootProcessInstanceId) {
        this.rootProcessInstanceId = rootProcessInstanceId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HistoricActivityInstanceDto historicActivityInstanceDto = (HistoricActivityInstanceDto)o;
        return Objects.equals(this.id, historicActivityInstanceDto.id) && Objects.equals(this.parentActivityInstanceId, historicActivityInstanceDto.parentActivityInstanceId) && Objects.equals(this.activityId, historicActivityInstanceDto.activityId) && Objects.equals(this.activityName, historicActivityInstanceDto.activityName) && Objects.equals(this.activityType, historicActivityInstanceDto.activityType) && Objects.equals(this.processDefinitionKey, historicActivityInstanceDto.processDefinitionKey) && Objects.equals(this.processDefinitionId, historicActivityInstanceDto.processDefinitionId) && Objects.equals(this.processInstanceId, historicActivityInstanceDto.processInstanceId) && Objects.equals(this.executionId, historicActivityInstanceDto.executionId) && Objects.equals(this.taskId, historicActivityInstanceDto.taskId) && Objects.equals(this.assignee, historicActivityInstanceDto.assignee) && Objects.equals(this.calledProcessInstanceId, historicActivityInstanceDto.calledProcessInstanceId) && Objects.equals(this.calledCaseInstanceId, historicActivityInstanceDto.calledCaseInstanceId) && Objects.equals(this.startTime, historicActivityInstanceDto.startTime) && Objects.equals(this.endTime, historicActivityInstanceDto.endTime) && Objects.equals(this.durationInMillis, historicActivityInstanceDto.durationInMillis) && Objects.equals(this.canceled, historicActivityInstanceDto.canceled) && Objects.equals(this.completeScope, historicActivityInstanceDto.completeScope) && Objects.equals(this.tenantId, historicActivityInstanceDto.tenantId) && Objects.equals(this.removalTime, historicActivityInstanceDto.removalTime) && Objects.equals(this.rootProcessInstanceId, historicActivityInstanceDto.rootProcessInstanceId);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.parentActivityInstanceId, this.activityId, this.activityName, this.activityType, this.processDefinitionKey, this.processDefinitionId, this.processInstanceId, this.executionId, this.taskId, this.assignee, this.calledProcessInstanceId, this.calledCaseInstanceId, this.startTime, this.endTime, this.durationInMillis, this.canceled, this.completeScope, this.tenantId, this.removalTime, this.rootProcessInstanceId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HistoricActivityInstanceDto {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    parentActivityInstanceId: ").append(this.toIndentedString(this.parentActivityInstanceId)).append("\n");
        sb.append("    activityId: ").append(this.toIndentedString(this.activityId)).append("\n");
        sb.append("    activityName: ").append(this.toIndentedString(this.activityName)).append("\n");
        sb.append("    activityType: ").append(this.toIndentedString(this.activityType)).append("\n");
        sb.append("    processDefinitionKey: ").append(this.toIndentedString(this.processDefinitionKey)).append("\n");
        sb.append("    processDefinitionId: ").append(this.toIndentedString(this.processDefinitionId)).append("\n");
        sb.append("    processInstanceId: ").append(this.toIndentedString(this.processInstanceId)).append("\n");
        sb.append("    executionId: ").append(this.toIndentedString(this.executionId)).append("\n");
        sb.append("    taskId: ").append(this.toIndentedString(this.taskId)).append("\n");
        sb.append("    assignee: ").append(this.toIndentedString(this.assignee)).append("\n");
        sb.append("    calledProcessInstanceId: ").append(this.toIndentedString(this.calledProcessInstanceId)).append("\n");
        sb.append("    calledCaseInstanceId: ").append(this.toIndentedString(this.calledCaseInstanceId)).append("\n");
        sb.append("    startTime: ").append(this.toIndentedString(this.startTime)).append("\n");
        sb.append("    endTime: ").append(this.toIndentedString(this.endTime)).append("\n");
        sb.append("    durationInMillis: ").append(this.toIndentedString(this.durationInMillis)).append("\n");
        sb.append("    canceled: ").append(this.toIndentedString(this.canceled)).append("\n");
        sb.append("    completeScope: ").append(this.toIndentedString(this.completeScope)).append("\n");
        sb.append("    tenantId: ").append(this.toIndentedString(this.tenantId)).append("\n");
        sb.append("    removalTime: ").append(this.toIndentedString(this.removalTime)).append("\n");
        sb.append("    rootProcessInstanceId: ").append(this.toIndentedString(this.rootProcessInstanceId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

