/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.camunda.community.rest.client.dto.HistoricDetailQueryDtoSorting;

@ApiModel(description="A historic detail query which defines a group of historic details.")
public class HistoricDetailQueryDto {
    public static final String SERIALIZED_NAME_PROCESS_INSTANCE_ID = "processInstanceId";
    @SerializedName(value="processInstanceId")
    private String processInstanceId;
    public static final String SERIALIZED_NAME_PROCESS_INSTANCE_ID_IN = "processInstanceIdIn";
    @SerializedName(value="processInstanceIdIn")
    private List<String> processInstanceIdIn = null;
    public static final String SERIALIZED_NAME_EXECUTION_ID = "executionId";
    @SerializedName(value="executionId")
    private String executionId;
    public static final String SERIALIZED_NAME_TASK_ID = "taskId";
    @SerializedName(value="taskId")
    private String taskId;
    public static final String SERIALIZED_NAME_ACTIVITY_INSTANCE_ID = "activityInstanceId";
    @SerializedName(value="activityInstanceId")
    private String activityInstanceId;
    public static final String SERIALIZED_NAME_CASE_INSTANCE_ID = "caseInstanceId";
    @SerializedName(value="caseInstanceId")
    private String caseInstanceId;
    public static final String SERIALIZED_NAME_CASE_EXECUTION_ID = "caseExecutionId";
    @SerializedName(value="caseExecutionId")
    private String caseExecutionId;
    public static final String SERIALIZED_NAME_VARIABLE_INSTANCE_ID = "variableInstanceId";
    @SerializedName(value="variableInstanceId")
    private String variableInstanceId;
    public static final String SERIALIZED_NAME_VARIABLE_TYPE_IN = "variableTypeIn";
    @SerializedName(value="variableTypeIn")
    private List<String> variableTypeIn = null;
    public static final String SERIALIZED_NAME_TENANT_ID_IN = "tenantIdIn";
    @SerializedName(value="tenantIdIn")
    private List<String> tenantIdIn = null;
    public static final String SERIALIZED_NAME_WITHOUT_TENANT_ID = "withoutTenantId";
    @SerializedName(value="withoutTenantId")
    private Boolean withoutTenantId;
    public static final String SERIALIZED_NAME_USER_OPERATION_ID = "userOperationId";
    @SerializedName(value="userOperationId")
    private String userOperationId;
    public static final String SERIALIZED_NAME_FORM_FIELDS = "formFields";
    @SerializedName(value="formFields")
    private Boolean formFields;
    public static final String SERIALIZED_NAME_VARIABLE_UPDATES = "variableUpdates";
    @SerializedName(value="variableUpdates")
    private Boolean variableUpdates;
    public static final String SERIALIZED_NAME_EXCLUDE_TASK_DETAILS = "excludeTaskDetails";
    @SerializedName(value="excludeTaskDetails")
    private Boolean excludeTaskDetails;
    public static final String SERIALIZED_NAME_INITIAL = "initial";
    @SerializedName(value="initial")
    private Boolean initial;
    public static final String SERIALIZED_NAME_OCCURRED_BEFORE = "occurredBefore";
    @SerializedName(value="occurredBefore")
    private Date occurredBefore;
    public static final String SERIALIZED_NAME_OCCURRED_AFTER = "occurredAfter";
    @SerializedName(value="occurredAfter")
    private Date occurredAfter;
    public static final String SERIALIZED_NAME_SORTING = "sorting";
    @SerializedName(value="sorting")
    private List<HistoricDetailQueryDtoSorting> sorting = null;

    public HistoricDetailQueryDto processInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by process instance id.")
    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public HistoricDetailQueryDto processInstanceIdIn(List<String> processInstanceIdIn) {
        this.processInstanceIdIn = processInstanceIdIn;
        return this;
    }

    public HistoricDetailQueryDto addProcessInstanceIdInItem(String processInstanceIdInItem) {
        if (this.processInstanceIdIn == null) {
            this.processInstanceIdIn = new ArrayList<String>();
        }
        this.processInstanceIdIn.add(processInstanceIdInItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include historic details which belong to one of the passed  process instance ids.")
    public List<String> getProcessInstanceIdIn() {
        return this.processInstanceIdIn;
    }

    public void setProcessInstanceIdIn(List<String> processInstanceIdIn) {
        this.processInstanceIdIn = processInstanceIdIn;
    }

    public HistoricDetailQueryDto executionId(String executionId) {
        this.executionId = executionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by execution id.")
    public String getExecutionId() {
        return this.executionId;
    }

    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    public HistoricDetailQueryDto taskId(String taskId) {
        this.taskId = taskId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by task id.")
    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public HistoricDetailQueryDto activityInstanceId(String activityInstanceId) {
        this.activityInstanceId = activityInstanceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by activity instance id.")
    public String getActivityInstanceId() {
        return this.activityInstanceId;
    }

    public void setActivityInstanceId(String activityInstanceId) {
        this.activityInstanceId = activityInstanceId;
    }

    public HistoricDetailQueryDto caseInstanceId(String caseInstanceId) {
        this.caseInstanceId = caseInstanceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by case instance id.")
    public String getCaseInstanceId() {
        return this.caseInstanceId;
    }

    public void setCaseInstanceId(String caseInstanceId) {
        this.caseInstanceId = caseInstanceId;
    }

    public HistoricDetailQueryDto caseExecutionId(String caseExecutionId) {
        this.caseExecutionId = caseExecutionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by case execution id.")
    public String getCaseExecutionId() {
        return this.caseExecutionId;
    }

    public void setCaseExecutionId(String caseExecutionId) {
        this.caseExecutionId = caseExecutionId;
    }

    public HistoricDetailQueryDto variableInstanceId(String variableInstanceId) {
        this.variableInstanceId = variableInstanceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by variable instance id.")
    public String getVariableInstanceId() {
        return this.variableInstanceId;
    }

    public void setVariableInstanceId(String variableInstanceId) {
        this.variableInstanceId = variableInstanceId;
    }

    public HistoricDetailQueryDto variableTypeIn(List<String> variableTypeIn) {
        this.variableTypeIn = variableTypeIn;
        return this;
    }

    public HistoricDetailQueryDto addVariableTypeInItem(String variableTypeInItem) {
        if (this.variableTypeIn == null) {
            this.variableTypeIn = new ArrayList<String>();
        }
        this.variableTypeIn.add(variableTypeInItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include historic details where the variable updates belong to one of the passed  list of variable types. A list of all supported variable types can be found [here](https://docs.camunda.org/manual/7.20/user-guide/process-engine/variables/#supported-variable-values). **Note:** All non-primitive variables are associated with the type `serializable`.")
    public List<String> getVariableTypeIn() {
        return this.variableTypeIn;
    }

    public void setVariableTypeIn(List<String> variableTypeIn) {
        this.variableTypeIn = variableTypeIn;
    }

    public HistoricDetailQueryDto tenantIdIn(List<String> tenantIdIn) {
        this.tenantIdIn = tenantIdIn;
        return this;
    }

    public HistoricDetailQueryDto addTenantIdInItem(String tenantIdInItem) {
        if (this.tenantIdIn == null) {
            this.tenantIdIn = new ArrayList<String>();
        }
        this.tenantIdIn.add(tenantIdInItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by a  list of tenant ids.")
    public List<String> getTenantIdIn() {
        return this.tenantIdIn;
    }

    public void setTenantIdIn(List<String> tenantIdIn) {
        this.tenantIdIn = tenantIdIn;
    }

    public HistoricDetailQueryDto withoutTenantId(Boolean withoutTenantId) {
        this.withoutTenantId = withoutTenantId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include historic details that belong to no tenant. Value may only be `true`, as `false` is the default behavior.")
    public Boolean getWithoutTenantId() {
        return this.withoutTenantId;
    }

    public void setWithoutTenantId(Boolean withoutTenantId) {
        this.withoutTenantId = withoutTenantId;
    }

    public HistoricDetailQueryDto userOperationId(String userOperationId) {
        this.userOperationId = userOperationId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by a user operation id.")
    public String getUserOperationId() {
        return this.userOperationId;
    }

    public void setUserOperationId(String userOperationId) {
        this.userOperationId = userOperationId;
    }

    public HistoricDetailQueryDto formFields(Boolean formFields) {
        this.formFields = formFields;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include `HistoricFormFields`. Value may only be `true`, as `false` is the default behavior.")
    public Boolean getFormFields() {
        return this.formFields;
    }

    public void setFormFields(Boolean formFields) {
        this.formFields = formFields;
    }

    public HistoricDetailQueryDto variableUpdates(Boolean variableUpdates) {
        this.variableUpdates = variableUpdates;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include `HistoricVariableUpdates`. Value may only be `true`, as `false` is the default behavior.")
    public Boolean getVariableUpdates() {
        return this.variableUpdates;
    }

    public void setVariableUpdates(Boolean variableUpdates) {
        this.variableUpdates = variableUpdates;
    }

    public HistoricDetailQueryDto excludeTaskDetails(Boolean excludeTaskDetails) {
        this.excludeTaskDetails = excludeTaskDetails;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Excludes all task-related `HistoricDetails`, so only items which have no task id set will be selected. When this parameter is used together with `taskId`, this call is ignored and task details are not excluded. Value may only be `true`, as `false` is the default behavior.")
    public Boolean getExcludeTaskDetails() {
        return this.excludeTaskDetails;
    }

    public void setExcludeTaskDetails(Boolean excludeTaskDetails) {
        this.excludeTaskDetails = excludeTaskDetails;
    }

    public HistoricDetailQueryDto initial(Boolean initial) {
        this.initial = initial;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to historic variable updates that contain only initial variable values. Value may only be `true`, as `false` is the default behavior.")
    public Boolean getInitial() {
        return this.initial;
    }

    public void setInitial(Boolean initial) {
        this.initial = initial;
    }

    public HistoricDetailQueryDto occurredBefore(Date occurredBefore) {
        this.occurredBefore = occurredBefore;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to historic details that occured before the given date (including the date). Default [format](https://docs.camunda.org/manual/7.20/reference/rest/overview/date-format/) `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., 2013-01-23T14:42:45.000+0200.")
    public Date getOccurredBefore() {
        return this.occurredBefore;
    }

    public void setOccurredBefore(Date occurredBefore) {
        this.occurredBefore = occurredBefore;
    }

    public HistoricDetailQueryDto occurredAfter(Date occurredAfter) {
        this.occurredAfter = occurredAfter;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to historic details that occured after the given date (including the date). Default [format](https://docs.camunda.org/manual/7.20/reference/rest/overview/date-format/) `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., 2013-01-23T14:42:45.000+0200.")
    public Date getOccurredAfter() {
        return this.occurredAfter;
    }

    public void setOccurredAfter(Date occurredAfter) {
        this.occurredAfter = occurredAfter;
    }

    public HistoricDetailQueryDto sorting(List<HistoricDetailQueryDtoSorting> sorting) {
        this.sorting = sorting;
        return this;
    }

    public HistoricDetailQueryDto addSortingItem(HistoricDetailQueryDtoSorting sortingItem) {
        if (this.sorting == null) {
            this.sorting = new ArrayList<HistoricDetailQueryDtoSorting>();
        }
        this.sorting.add(sortingItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A JSON array of criteria to sort the result by. Each element of the array is                     a JSON object that specifies one ordering. The position in the array                     identifies the rank of an ordering, i.e., whether it is primary, secondary,                     etc. Does not have an effect for the `count` endpoint.")
    public List<HistoricDetailQueryDtoSorting> getSorting() {
        return this.sorting;
    }

    public void setSorting(List<HistoricDetailQueryDtoSorting> sorting) {
        this.sorting = sorting;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HistoricDetailQueryDto historicDetailQueryDto = (HistoricDetailQueryDto)o;
        return Objects.equals(this.processInstanceId, historicDetailQueryDto.processInstanceId) && Objects.equals(this.processInstanceIdIn, historicDetailQueryDto.processInstanceIdIn) && Objects.equals(this.executionId, historicDetailQueryDto.executionId) && Objects.equals(this.taskId, historicDetailQueryDto.taskId) && Objects.equals(this.activityInstanceId, historicDetailQueryDto.activityInstanceId) && Objects.equals(this.caseInstanceId, historicDetailQueryDto.caseInstanceId) && Objects.equals(this.caseExecutionId, historicDetailQueryDto.caseExecutionId) && Objects.equals(this.variableInstanceId, historicDetailQueryDto.variableInstanceId) && Objects.equals(this.variableTypeIn, historicDetailQueryDto.variableTypeIn) && Objects.equals(this.tenantIdIn, historicDetailQueryDto.tenantIdIn) && Objects.equals(this.withoutTenantId, historicDetailQueryDto.withoutTenantId) && Objects.equals(this.userOperationId, historicDetailQueryDto.userOperationId) && Objects.equals(this.formFields, historicDetailQueryDto.formFields) && Objects.equals(this.variableUpdates, historicDetailQueryDto.variableUpdates) && Objects.equals(this.excludeTaskDetails, historicDetailQueryDto.excludeTaskDetails) && Objects.equals(this.initial, historicDetailQueryDto.initial) && Objects.equals(this.occurredBefore, historicDetailQueryDto.occurredBefore) && Objects.equals(this.occurredAfter, historicDetailQueryDto.occurredAfter) && Objects.equals(this.sorting, historicDetailQueryDto.sorting);
    }

    public int hashCode() {
        return Objects.hash(this.processInstanceId, this.processInstanceIdIn, this.executionId, this.taskId, this.activityInstanceId, this.caseInstanceId, this.caseExecutionId, this.variableInstanceId, this.variableTypeIn, this.tenantIdIn, this.withoutTenantId, this.userOperationId, this.formFields, this.variableUpdates, this.excludeTaskDetails, this.initial, this.occurredBefore, this.occurredAfter, this.sorting);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HistoricDetailQueryDto {\n");
        sb.append("    processInstanceId: ").append(this.toIndentedString(this.processInstanceId)).append("\n");
        sb.append("    processInstanceIdIn: ").append(this.toIndentedString(this.processInstanceIdIn)).append("\n");
        sb.append("    executionId: ").append(this.toIndentedString(this.executionId)).append("\n");
        sb.append("    taskId: ").append(this.toIndentedString(this.taskId)).append("\n");
        sb.append("    activityInstanceId: ").append(this.toIndentedString(this.activityInstanceId)).append("\n");
        sb.append("    caseInstanceId: ").append(this.toIndentedString(this.caseInstanceId)).append("\n");
        sb.append("    caseExecutionId: ").append(this.toIndentedString(this.caseExecutionId)).append("\n");
        sb.append("    variableInstanceId: ").append(this.toIndentedString(this.variableInstanceId)).append("\n");
        sb.append("    variableTypeIn: ").append(this.toIndentedString(this.variableTypeIn)).append("\n");
        sb.append("    tenantIdIn: ").append(this.toIndentedString(this.tenantIdIn)).append("\n");
        sb.append("    withoutTenantId: ").append(this.toIndentedString(this.withoutTenantId)).append("\n");
        sb.append("    userOperationId: ").append(this.toIndentedString(this.userOperationId)).append("\n");
        sb.append("    formFields: ").append(this.toIndentedString(this.formFields)).append("\n");
        sb.append("    variableUpdates: ").append(this.toIndentedString(this.variableUpdates)).append("\n");
        sb.append("    excludeTaskDetails: ").append(this.toIndentedString(this.excludeTaskDetails)).append("\n");
        sb.append("    initial: ").append(this.toIndentedString(this.initial)).append("\n");
        sb.append("    occurredBefore: ").append(this.toIndentedString(this.occurredBefore)).append("\n");
        sb.append("    occurredAfter: ").append(this.toIndentedString(this.occurredAfter)).append("\n");
        sb.append("    sorting: ").append(this.toIndentedString(this.sorting)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

