/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.camunda.community.rest.client.dto.HistoricJobLogQueryDtoSorting;

@ApiModel(description="A Historic Job Log instance query which defines a list of Historic Job Log instances")
public class HistoricJobLogQueryDto {
    public static final String SERIALIZED_NAME_LOG_ID = "logId";
    @SerializedName(value="logId")
    private String logId;
    public static final String SERIALIZED_NAME_JOB_ID = "jobId";
    @SerializedName(value="jobId")
    private String jobId;
    public static final String SERIALIZED_NAME_JOB_EXCEPTION_MESSAGE = "jobExceptionMessage";
    @SerializedName(value="jobExceptionMessage")
    private String jobExceptionMessage;
    public static final String SERIALIZED_NAME_JOB_DEFINITION_ID = "jobDefinitionId";
    @SerializedName(value="jobDefinitionId")
    private String jobDefinitionId;
    public static final String SERIALIZED_NAME_JOB_DEFINITION_TYPE = "jobDefinitionType";
    @SerializedName(value="jobDefinitionType")
    private String jobDefinitionType;
    public static final String SERIALIZED_NAME_JOB_DEFINITION_CONFIGURATION = "jobDefinitionConfiguration";
    @SerializedName(value="jobDefinitionConfiguration")
    private String jobDefinitionConfiguration;
    public static final String SERIALIZED_NAME_ACTIVITY_ID_IN = "activityIdIn";
    @SerializedName(value="activityIdIn")
    private List<String> activityIdIn = null;
    public static final String SERIALIZED_NAME_FAILED_ACTIVITY_ID_IN = "failedActivityIdIn";
    @SerializedName(value="failedActivityIdIn")
    private List<String> failedActivityIdIn = null;
    public static final String SERIALIZED_NAME_EXECUTION_ID_IN = "executionIdIn";
    @SerializedName(value="executionIdIn")
    private List<String> executionIdIn = null;
    public static final String SERIALIZED_NAME_PROCESS_INSTANCE_ID = "processInstanceId";
    @SerializedName(value="processInstanceId")
    private String processInstanceId;
    public static final String SERIALIZED_NAME_PROCESS_DEFINITION_ID = "processDefinitionId";
    @SerializedName(value="processDefinitionId")
    private String processDefinitionId;
    public static final String SERIALIZED_NAME_PROCESS_DEFINITION_KEY = "processDefinitionKey";
    @SerializedName(value="processDefinitionKey")
    private String processDefinitionKey;
    public static final String SERIALIZED_NAME_DEPLOYMENT_ID = "deploymentId";
    @SerializedName(value="deploymentId")
    private String deploymentId;
    public static final String SERIALIZED_NAME_TENANT_ID_IN = "tenantIdIn";
    @SerializedName(value="tenantIdIn")
    private List<String> tenantIdIn = null;
    public static final String SERIALIZED_NAME_WITHOUT_TENANT_ID = "withoutTenantId";
    @SerializedName(value="withoutTenantId")
    private Boolean withoutTenantId;
    public static final String SERIALIZED_NAME_HOSTNAME = "hostname";
    @SerializedName(value="hostname")
    private String hostname;
    public static final String SERIALIZED_NAME_JOB_PRIORITY_LOWER_THAN_OR_EQUALS = "jobPriorityLowerThanOrEquals";
    @SerializedName(value="jobPriorityLowerThanOrEquals")
    private Long jobPriorityLowerThanOrEquals;
    public static final String SERIALIZED_NAME_JOB_PRIORITY_HIGHER_THAN_OR_EQUALS = "jobPriorityHigherThanOrEquals";
    @SerializedName(value="jobPriorityHigherThanOrEquals")
    private Long jobPriorityHigherThanOrEquals;
    public static final String SERIALIZED_NAME_CREATION_LOG = "creationLog";
    @SerializedName(value="creationLog")
    private Boolean creationLog;
    public static final String SERIALIZED_NAME_FAILURE_LOG = "failureLog";
    @SerializedName(value="failureLog")
    private Boolean failureLog;
    public static final String SERIALIZED_NAME_SUCCESS_LOG = "successLog";
    @SerializedName(value="successLog")
    private Boolean successLog;
    public static final String SERIALIZED_NAME_DELETION_LOG = "deletionLog";
    @SerializedName(value="deletionLog")
    private Boolean deletionLog;
    public static final String SERIALIZED_NAME_SORTING = "sorting";
    @SerializedName(value="sorting")
    private List<HistoricJobLogQueryDtoSorting> sorting = null;

    public HistoricJobLogQueryDto logId(String logId) {
        this.logId = logId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by historic job log id.")
    public String getLogId() {
        return this.logId;
    }

    public void setLogId(String logId) {
        this.logId = logId;
    }

    public HistoricJobLogQueryDto jobId(String jobId) {
        this.jobId = jobId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by job id.")
    public String getJobId() {
        return this.jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public HistoricJobLogQueryDto jobExceptionMessage(String jobExceptionMessage) {
        this.jobExceptionMessage = jobExceptionMessage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by job exception message.")
    public String getJobExceptionMessage() {
        return this.jobExceptionMessage;
    }

    public void setJobExceptionMessage(String jobExceptionMessage) {
        this.jobExceptionMessage = jobExceptionMessage;
    }

    public HistoricJobLogQueryDto jobDefinitionId(String jobDefinitionId) {
        this.jobDefinitionId = jobDefinitionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by job definition id.")
    public String getJobDefinitionId() {
        return this.jobDefinitionId;
    }

    public void setJobDefinitionId(String jobDefinitionId) {
        this.jobDefinitionId = jobDefinitionId;
    }

    public HistoricJobLogQueryDto jobDefinitionType(String jobDefinitionType) {
        this.jobDefinitionType = jobDefinitionType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by job definition type. See the [User Guide](https://docs.camunda.org/manual/7.20/user-guide/process-engine/the-job-executor/#job-creation) for more information about job definition types.")
    public String getJobDefinitionType() {
        return this.jobDefinitionType;
    }

    public void setJobDefinitionType(String jobDefinitionType) {
        this.jobDefinitionType = jobDefinitionType;
    }

    public HistoricJobLogQueryDto jobDefinitionConfiguration(String jobDefinitionConfiguration) {
        this.jobDefinitionConfiguration = jobDefinitionConfiguration;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by job definition configuration.")
    public String getJobDefinitionConfiguration() {
        return this.jobDefinitionConfiguration;
    }

    public void setJobDefinitionConfiguration(String jobDefinitionConfiguration) {
        this.jobDefinitionConfiguration = jobDefinitionConfiguration;
    }

    public HistoricJobLogQueryDto activityIdIn(List<String> activityIdIn) {
        this.activityIdIn = activityIdIn;
        return this;
    }

    public HistoricJobLogQueryDto addActivityIdInItem(String activityIdInItem) {
        if (this.activityIdIn == null) {
            this.activityIdIn = new ArrayList<String>();
        }
        this.activityIdIn.add(activityIdInItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include historic job logs which belong to one of the passed activity ids.")
    public List<String> getActivityIdIn() {
        return this.activityIdIn;
    }

    public void setActivityIdIn(List<String> activityIdIn) {
        this.activityIdIn = activityIdIn;
    }

    public HistoricJobLogQueryDto failedActivityIdIn(List<String> failedActivityIdIn) {
        this.failedActivityIdIn = failedActivityIdIn;
        return this;
    }

    public HistoricJobLogQueryDto addFailedActivityIdInItem(String failedActivityIdInItem) {
        if (this.failedActivityIdIn == null) {
            this.failedActivityIdIn = new ArrayList<String>();
        }
        this.failedActivityIdIn.add(failedActivityIdInItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include historic job logs which belong to failures of one of the passed activity ids.")
    public List<String> getFailedActivityIdIn() {
        return this.failedActivityIdIn;
    }

    public void setFailedActivityIdIn(List<String> failedActivityIdIn) {
        this.failedActivityIdIn = failedActivityIdIn;
    }

    public HistoricJobLogQueryDto executionIdIn(List<String> executionIdIn) {
        this.executionIdIn = executionIdIn;
        return this;
    }

    public HistoricJobLogQueryDto addExecutionIdInItem(String executionIdInItem) {
        if (this.executionIdIn == null) {
            this.executionIdIn = new ArrayList<String>();
        }
        this.executionIdIn.add(executionIdInItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include historic job logs which belong to one of the passed execution ids.")
    public List<String> getExecutionIdIn() {
        return this.executionIdIn;
    }

    public void setExecutionIdIn(List<String> executionIdIn) {
        this.executionIdIn = executionIdIn;
    }

    public HistoricJobLogQueryDto processInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by process instance id.")
    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public HistoricJobLogQueryDto processDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by process definition id.")
    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    public HistoricJobLogQueryDto processDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by process definition key.")
    public String getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public void setProcessDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    public HistoricJobLogQueryDto deploymentId(String deploymentId) {
        this.deploymentId = deploymentId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by deployment id.")
    public String getDeploymentId() {
        return this.deploymentId;
    }

    public void setDeploymentId(String deploymentId) {
        this.deploymentId = deploymentId;
    }

    public HistoricJobLogQueryDto tenantIdIn(List<String> tenantIdIn) {
        this.tenantIdIn = tenantIdIn;
        return this;
    }

    public HistoricJobLogQueryDto addTenantIdInItem(String tenantIdInItem) {
        if (this.tenantIdIn == null) {
            this.tenantIdIn = new ArrayList<String>();
        }
        this.tenantIdIn.add(tenantIdInItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include historic job log entries which belong to one of the passed and comma- separated tenant ids.")
    public List<String> getTenantIdIn() {
        return this.tenantIdIn;
    }

    public void setTenantIdIn(List<String> tenantIdIn) {
        this.tenantIdIn = tenantIdIn;
    }

    public HistoricJobLogQueryDto withoutTenantId(Boolean withoutTenantId) {
        this.withoutTenantId = withoutTenantId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include historic job log entries that belong to no tenant. Value may only be `true`, as `false` is the default behavior.")
    public Boolean getWithoutTenantId() {
        return this.withoutTenantId;
    }

    public void setWithoutTenantId(Boolean withoutTenantId) {
        this.withoutTenantId = withoutTenantId;
    }

    public HistoricJobLogQueryDto hostname(String hostname) {
        this.hostname = hostname;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by hostname.")
    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public HistoricJobLogQueryDto jobPriorityLowerThanOrEquals(Long jobPriorityLowerThanOrEquals) {
        this.jobPriorityLowerThanOrEquals = jobPriorityLowerThanOrEquals;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include logs for which the associated job had a priority lower than or equal to the given value. Value must be a valid `long` value.")
    public Long getJobPriorityLowerThanOrEquals() {
        return this.jobPriorityLowerThanOrEquals;
    }

    public void setJobPriorityLowerThanOrEquals(Long jobPriorityLowerThanOrEquals) {
        this.jobPriorityLowerThanOrEquals = jobPriorityLowerThanOrEquals;
    }

    public HistoricJobLogQueryDto jobPriorityHigherThanOrEquals(Long jobPriorityHigherThanOrEquals) {
        this.jobPriorityHigherThanOrEquals = jobPriorityHigherThanOrEquals;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include logs for which the associated job had a priority higher than or equal to the given value. Value must be a valid `long` value.")
    public Long getJobPriorityHigherThanOrEquals() {
        return this.jobPriorityHigherThanOrEquals;
    }

    public void setJobPriorityHigherThanOrEquals(Long jobPriorityHigherThanOrEquals) {
        this.jobPriorityHigherThanOrEquals = jobPriorityHigherThanOrEquals;
    }

    public HistoricJobLogQueryDto creationLog(Boolean creationLog) {
        this.creationLog = creationLog;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include creation logs. Value may only be `true`, as `false` is the default behavior.")
    public Boolean getCreationLog() {
        return this.creationLog;
    }

    public void setCreationLog(Boolean creationLog) {
        this.creationLog = creationLog;
    }

    public HistoricJobLogQueryDto failureLog(Boolean failureLog) {
        this.failureLog = failureLog;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include failure logs. Value may only be `true`, as `false` is the default behavior.")
    public Boolean getFailureLog() {
        return this.failureLog;
    }

    public void setFailureLog(Boolean failureLog) {
        this.failureLog = failureLog;
    }

    public HistoricJobLogQueryDto successLog(Boolean successLog) {
        this.successLog = successLog;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include success logs. Value may only be `true`, as `false` is the default behavior.")
    public Boolean getSuccessLog() {
        return this.successLog;
    }

    public void setSuccessLog(Boolean successLog) {
        this.successLog = successLog;
    }

    public HistoricJobLogQueryDto deletionLog(Boolean deletionLog) {
        this.deletionLog = deletionLog;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include deletion logs. Value may only be `true`, as `false` is the default behavior.")
    public Boolean getDeletionLog() {
        return this.deletionLog;
    }

    public void setDeletionLog(Boolean deletionLog) {
        this.deletionLog = deletionLog;
    }

    public HistoricJobLogQueryDto sorting(List<HistoricJobLogQueryDtoSorting> sorting) {
        this.sorting = sorting;
        return this;
    }

    public HistoricJobLogQueryDto addSortingItem(HistoricJobLogQueryDtoSorting sortingItem) {
        if (this.sorting == null) {
            this.sorting = new ArrayList<HistoricJobLogQueryDtoSorting>();
        }
        this.sorting.add(sortingItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An array of criteria to sort the result by. Each element of the array is                        an object that specifies one ordering. The position in the array                        identifies the rank of an ordering, i.e., whether it is primary, secondary,                        etc. Sorting has no effect for `count` endpoints")
    public List<HistoricJobLogQueryDtoSorting> getSorting() {
        return this.sorting;
    }

    public void setSorting(List<HistoricJobLogQueryDtoSorting> sorting) {
        this.sorting = sorting;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HistoricJobLogQueryDto historicJobLogQueryDto = (HistoricJobLogQueryDto)o;
        return Objects.equals(this.logId, historicJobLogQueryDto.logId) && Objects.equals(this.jobId, historicJobLogQueryDto.jobId) && Objects.equals(this.jobExceptionMessage, historicJobLogQueryDto.jobExceptionMessage) && Objects.equals(this.jobDefinitionId, historicJobLogQueryDto.jobDefinitionId) && Objects.equals(this.jobDefinitionType, historicJobLogQueryDto.jobDefinitionType) && Objects.equals(this.jobDefinitionConfiguration, historicJobLogQueryDto.jobDefinitionConfiguration) && Objects.equals(this.activityIdIn, historicJobLogQueryDto.activityIdIn) && Objects.equals(this.failedActivityIdIn, historicJobLogQueryDto.failedActivityIdIn) && Objects.equals(this.executionIdIn, historicJobLogQueryDto.executionIdIn) && Objects.equals(this.processInstanceId, historicJobLogQueryDto.processInstanceId) && Objects.equals(this.processDefinitionId, historicJobLogQueryDto.processDefinitionId) && Objects.equals(this.processDefinitionKey, historicJobLogQueryDto.processDefinitionKey) && Objects.equals(this.deploymentId, historicJobLogQueryDto.deploymentId) && Objects.equals(this.tenantIdIn, historicJobLogQueryDto.tenantIdIn) && Objects.equals(this.withoutTenantId, historicJobLogQueryDto.withoutTenantId) && Objects.equals(this.hostname, historicJobLogQueryDto.hostname) && Objects.equals(this.jobPriorityLowerThanOrEquals, historicJobLogQueryDto.jobPriorityLowerThanOrEquals) && Objects.equals(this.jobPriorityHigherThanOrEquals, historicJobLogQueryDto.jobPriorityHigherThanOrEquals) && Objects.equals(this.creationLog, historicJobLogQueryDto.creationLog) && Objects.equals(this.failureLog, historicJobLogQueryDto.failureLog) && Objects.equals(this.successLog, historicJobLogQueryDto.successLog) && Objects.equals(this.deletionLog, historicJobLogQueryDto.deletionLog) && Objects.equals(this.sorting, historicJobLogQueryDto.sorting);
    }

    public int hashCode() {
        return Objects.hash(this.logId, this.jobId, this.jobExceptionMessage, this.jobDefinitionId, this.jobDefinitionType, this.jobDefinitionConfiguration, this.activityIdIn, this.failedActivityIdIn, this.executionIdIn, this.processInstanceId, this.processDefinitionId, this.processDefinitionKey, this.deploymentId, this.tenantIdIn, this.withoutTenantId, this.hostname, this.jobPriorityLowerThanOrEquals, this.jobPriorityHigherThanOrEquals, this.creationLog, this.failureLog, this.successLog, this.deletionLog, this.sorting);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HistoricJobLogQueryDto {\n");
        sb.append("    logId: ").append(this.toIndentedString(this.logId)).append("\n");
        sb.append("    jobId: ").append(this.toIndentedString(this.jobId)).append("\n");
        sb.append("    jobExceptionMessage: ").append(this.toIndentedString(this.jobExceptionMessage)).append("\n");
        sb.append("    jobDefinitionId: ").append(this.toIndentedString(this.jobDefinitionId)).append("\n");
        sb.append("    jobDefinitionType: ").append(this.toIndentedString(this.jobDefinitionType)).append("\n");
        sb.append("    jobDefinitionConfiguration: ").append(this.toIndentedString(this.jobDefinitionConfiguration)).append("\n");
        sb.append("    activityIdIn: ").append(this.toIndentedString(this.activityIdIn)).append("\n");
        sb.append("    failedActivityIdIn: ").append(this.toIndentedString(this.failedActivityIdIn)).append("\n");
        sb.append("    executionIdIn: ").append(this.toIndentedString(this.executionIdIn)).append("\n");
        sb.append("    processInstanceId: ").append(this.toIndentedString(this.processInstanceId)).append("\n");
        sb.append("    processDefinitionId: ").append(this.toIndentedString(this.processDefinitionId)).append("\n");
        sb.append("    processDefinitionKey: ").append(this.toIndentedString(this.processDefinitionKey)).append("\n");
        sb.append("    deploymentId: ").append(this.toIndentedString(this.deploymentId)).append("\n");
        sb.append("    tenantIdIn: ").append(this.toIndentedString(this.tenantIdIn)).append("\n");
        sb.append("    withoutTenantId: ").append(this.toIndentedString(this.withoutTenantId)).append("\n");
        sb.append("    hostname: ").append(this.toIndentedString(this.hostname)).append("\n");
        sb.append("    jobPriorityLowerThanOrEquals: ").append(this.toIndentedString(this.jobPriorityLowerThanOrEquals)).append("\n");
        sb.append("    jobPriorityHigherThanOrEquals: ").append(this.toIndentedString(this.jobPriorityHigherThanOrEquals)).append("\n");
        sb.append("    creationLog: ").append(this.toIndentedString(this.creationLog)).append("\n");
        sb.append("    failureLog: ").append(this.toIndentedString(this.failureLog)).append("\n");
        sb.append("    successLog: ").append(this.toIndentedString(this.successLog)).append("\n");
        sb.append("    deletionLog: ").append(this.toIndentedString(this.deletionLog)).append("\n");
        sb.append("    sorting: ").append(this.toIndentedString(this.sorting)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

