/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.camunda.community.rest.client.dto.HistoricTaskInstanceQueryDtoSorting;
import org.camunda.community.rest.client.dto.VariableQueryParameterDto;

@ApiModel(description="A Historic Task instance query which defines a list of Historic Task instances")
public class HistoricTaskInstanceQueryDto {
    public static final String SERIALIZED_NAME_TASK_ID = "taskId";
    @SerializedName(value="taskId")
    private String taskId;
    public static final String SERIALIZED_NAME_TASK_PARENT_TASK_ID = "taskParentTaskId";
    @SerializedName(value="taskParentTaskId")
    private String taskParentTaskId;
    public static final String SERIALIZED_NAME_PROCESS_INSTANCE_ID = "processInstanceId";
    @SerializedName(value="processInstanceId")
    private String processInstanceId;
    public static final String SERIALIZED_NAME_PROCESS_INSTANCE_BUSINESS_KEY = "processInstanceBusinessKey";
    @SerializedName(value="processInstanceBusinessKey")
    private String processInstanceBusinessKey;
    public static final String SERIALIZED_NAME_PROCESS_INSTANCE_BUSINESS_KEY_IN = "processInstanceBusinessKeyIn";
    @SerializedName(value="processInstanceBusinessKeyIn")
    private List<String> processInstanceBusinessKeyIn = null;
    public static final String SERIALIZED_NAME_PROCESS_INSTANCE_BUSINESS_KEY_LIKE = "processInstanceBusinessKeyLike";
    @SerializedName(value="processInstanceBusinessKeyLike")
    private String processInstanceBusinessKeyLike;
    public static final String SERIALIZED_NAME_EXECUTION_ID = "executionId";
    @SerializedName(value="executionId")
    private String executionId;
    public static final String SERIALIZED_NAME_PROCESS_DEFINITION_ID = "processDefinitionId";
    @SerializedName(value="processDefinitionId")
    private String processDefinitionId;
    public static final String SERIALIZED_NAME_PROCESS_DEFINITION_KEY = "processDefinitionKey";
    @SerializedName(value="processDefinitionKey")
    private String processDefinitionKey;
    public static final String SERIALIZED_NAME_PROCESS_DEFINITION_NAME = "processDefinitionName";
    @SerializedName(value="processDefinitionName")
    private String processDefinitionName;
    public static final String SERIALIZED_NAME_CASE_INSTANCE_ID = "caseInstanceId";
    @SerializedName(value="caseInstanceId")
    private String caseInstanceId;
    public static final String SERIALIZED_NAME_CASE_EXECUTION_ID = "caseExecutionId";
    @SerializedName(value="caseExecutionId")
    private String caseExecutionId;
    public static final String SERIALIZED_NAME_CASE_DEFINITION_ID = "caseDefinitionId";
    @SerializedName(value="caseDefinitionId")
    private String caseDefinitionId;
    public static final String SERIALIZED_NAME_CASE_DEFINITION_KEY = "caseDefinitionKey";
    @SerializedName(value="caseDefinitionKey")
    private String caseDefinitionKey;
    public static final String SERIALIZED_NAME_CASE_DEFINITION_NAME = "caseDefinitionName";
    @SerializedName(value="caseDefinitionName")
    private String caseDefinitionName;
    public static final String SERIALIZED_NAME_ACTIVITY_INSTANCE_ID_IN = "activityInstanceIdIn";
    @SerializedName(value="activityInstanceIdIn")
    private List<String> activityInstanceIdIn = null;
    public static final String SERIALIZED_NAME_TASK_NAME = "taskName";
    @SerializedName(value="taskName")
    private String taskName;
    public static final String SERIALIZED_NAME_TASK_NAME_LIKE = "taskNameLike";
    @SerializedName(value="taskNameLike")
    private String taskNameLike;
    public static final String SERIALIZED_NAME_TASK_DESCRIPTION = "taskDescription";
    @SerializedName(value="taskDescription")
    private String taskDescription;
    public static final String SERIALIZED_NAME_TASK_DESCRIPTION_LIKE = "taskDescriptionLike";
    @SerializedName(value="taskDescriptionLike")
    private String taskDescriptionLike;
    public static final String SERIALIZED_NAME_TASK_DEFINITION_KEY = "taskDefinitionKey";
    @SerializedName(value="taskDefinitionKey")
    private String taskDefinitionKey;
    public static final String SERIALIZED_NAME_TASK_DEFINITION_KEY_IN = "taskDefinitionKeyIn";
    @SerializedName(value="taskDefinitionKeyIn")
    private List<String> taskDefinitionKeyIn = null;
    public static final String SERIALIZED_NAME_TASK_DELETE_REASON = "taskDeleteReason";
    @SerializedName(value="taskDeleteReason")
    private String taskDeleteReason;
    public static final String SERIALIZED_NAME_TASK_DELETE_REASON_LIKE = "taskDeleteReasonLike";
    @SerializedName(value="taskDeleteReasonLike")
    private String taskDeleteReasonLike;
    public static final String SERIALIZED_NAME_TASK_ASSIGNEE = "taskAssignee";
    @SerializedName(value="taskAssignee")
    private String taskAssignee;
    public static final String SERIALIZED_NAME_TASK_ASSIGNEE_LIKE = "taskAssigneeLike";
    @SerializedName(value="taskAssigneeLike")
    private String taskAssigneeLike;
    public static final String SERIALIZED_NAME_TASK_OWNER = "taskOwner";
    @SerializedName(value="taskOwner")
    private String taskOwner;
    public static final String SERIALIZED_NAME_TASK_OWNER_LIKE = "taskOwnerLike";
    @SerializedName(value="taskOwnerLike")
    private String taskOwnerLike;
    public static final String SERIALIZED_NAME_TASK_PRIORITY = "taskPriority";
    @SerializedName(value="taskPriority")
    private Integer taskPriority;
    public static final String SERIALIZED_NAME_ASSIGNED = "assigned";
    @SerializedName(value="assigned")
    private Boolean assigned;
    public static final String SERIALIZED_NAME_UNASSIGNED = "unassigned";
    @SerializedName(value="unassigned")
    private Boolean unassigned;
    public static final String SERIALIZED_NAME_FINISHED = "finished";
    @SerializedName(value="finished")
    private Boolean finished;
    public static final String SERIALIZED_NAME_UNFINISHED = "unfinished";
    @SerializedName(value="unfinished")
    private Boolean unfinished;
    public static final String SERIALIZED_NAME_PROCESS_FINISHED = "processFinished";
    @SerializedName(value="processFinished")
    private Boolean processFinished;
    public static final String SERIALIZED_NAME_PROCESS_UNFINISHED = "processUnfinished";
    @SerializedName(value="processUnfinished")
    private Boolean processUnfinished;
    public static final String SERIALIZED_NAME_TASK_DUE_DATE = "taskDueDate";
    @SerializedName(value="taskDueDate")
    private Date taskDueDate;
    public static final String SERIALIZED_NAME_TASK_DUE_DATE_BEFORE = "taskDueDateBefore";
    @SerializedName(value="taskDueDateBefore")
    private Date taskDueDateBefore;
    public static final String SERIALIZED_NAME_TASK_DUE_DATE_AFTER = "taskDueDateAfter";
    @SerializedName(value="taskDueDateAfter")
    private Date taskDueDateAfter;
    public static final String SERIALIZED_NAME_WITHOUT_TASK_DUE_DATE = "withoutTaskDueDate";
    @SerializedName(value="withoutTaskDueDate")
    private Boolean withoutTaskDueDate;
    public static final String SERIALIZED_NAME_TASK_FOLLOW_UP_DATE = "taskFollowUpDate";
    @SerializedName(value="taskFollowUpDate")
    private Date taskFollowUpDate;
    public static final String SERIALIZED_NAME_TASK_FOLLOW_UP_DATE_BEFORE = "taskFollowUpDateBefore";
    @SerializedName(value="taskFollowUpDateBefore")
    private Date taskFollowUpDateBefore;
    public static final String SERIALIZED_NAME_TASK_FOLLOW_UP_DATE_AFTER = "taskFollowUpDateAfter";
    @SerializedName(value="taskFollowUpDateAfter")
    private Date taskFollowUpDateAfter;
    public static final String SERIALIZED_NAME_STARTED_BEFORE = "startedBefore";
    @SerializedName(value="startedBefore")
    private Date startedBefore;
    public static final String SERIALIZED_NAME_STARTED_AFTER = "startedAfter";
    @SerializedName(value="startedAfter")
    private Date startedAfter;
    public static final String SERIALIZED_NAME_FINISHED_BEFORE = "finishedBefore";
    @SerializedName(value="finishedBefore")
    private Date finishedBefore;
    public static final String SERIALIZED_NAME_FINISHED_AFTER = "finishedAfter";
    @SerializedName(value="finishedAfter")
    private Date finishedAfter;
    public static final String SERIALIZED_NAME_TENANT_ID_IN = "tenantIdIn";
    @SerializedName(value="tenantIdIn")
    private List<String> tenantIdIn = null;
    public static final String SERIALIZED_NAME_WITHOUT_TENANT_ID = "withoutTenantId";
    @SerializedName(value="withoutTenantId")
    private Boolean withoutTenantId;
    public static final String SERIALIZED_NAME_TASK_VARIABLES = "taskVariables";
    @SerializedName(value="taskVariables")
    private List<VariableQueryParameterDto> taskVariables = null;
    public static final String SERIALIZED_NAME_PROCESS_VARIABLES = "processVariables";
    @SerializedName(value="processVariables")
    private List<VariableQueryParameterDto> processVariables = null;
    public static final String SERIALIZED_NAME_VARIABLE_NAMES_IGNORE_CASE = "variableNamesIgnoreCase";
    @SerializedName(value="variableNamesIgnoreCase")
    private Boolean variableNamesIgnoreCase;
    public static final String SERIALIZED_NAME_VARIABLE_VALUES_IGNORE_CASE = "variableValuesIgnoreCase";
    @SerializedName(value="variableValuesIgnoreCase")
    private Boolean variableValuesIgnoreCase;
    public static final String SERIALIZED_NAME_TASK_INVOLVED_USER = "taskInvolvedUser";
    @SerializedName(value="taskInvolvedUser")
    private String taskInvolvedUser;
    public static final String SERIALIZED_NAME_TASK_INVOLVED_GROUP = "taskInvolvedGroup";
    @SerializedName(value="taskInvolvedGroup")
    private String taskInvolvedGroup;
    public static final String SERIALIZED_NAME_TASK_HAD_CANDIDATE_USER = "taskHadCandidateUser";
    @SerializedName(value="taskHadCandidateUser")
    private String taskHadCandidateUser;
    public static final String SERIALIZED_NAME_TASK_HAD_CANDIDATE_GROUP = "taskHadCandidateGroup";
    @SerializedName(value="taskHadCandidateGroup")
    private String taskHadCandidateGroup;
    public static final String SERIALIZED_NAME_WITH_CANDIDATE_GROUPS = "withCandidateGroups";
    @SerializedName(value="withCandidateGroups")
    private Boolean withCandidateGroups;
    public static final String SERIALIZED_NAME_WITHOUT_CANDIDATE_GROUPS = "withoutCandidateGroups";
    @SerializedName(value="withoutCandidateGroups")
    private Boolean withoutCandidateGroups;
    public static final String SERIALIZED_NAME_OR_QUERIES = "orQueries";
    @SerializedName(value="orQueries")
    private List<HistoricTaskInstanceQueryDto> orQueries = null;
    public static final String SERIALIZED_NAME_SORTING = "sorting";
    @SerializedName(value="sorting")
    private List<HistoricTaskInstanceQueryDtoSorting> sorting = null;

    public HistoricTaskInstanceQueryDto taskId(String taskId) {
        this.taskId = taskId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by task id.")
    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public HistoricTaskInstanceQueryDto taskParentTaskId(String taskParentTaskId) {
        this.taskParentTaskId = taskParentTaskId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by parent task id.")
    public String getTaskParentTaskId() {
        return this.taskParentTaskId;
    }

    public void setTaskParentTaskId(String taskParentTaskId) {
        this.taskParentTaskId = taskParentTaskId;
    }

    public HistoricTaskInstanceQueryDto processInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by process instance id.")
    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public HistoricTaskInstanceQueryDto processInstanceBusinessKey(String processInstanceBusinessKey) {
        this.processInstanceBusinessKey = processInstanceBusinessKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by process instance business key.")
    public String getProcessInstanceBusinessKey() {
        return this.processInstanceBusinessKey;
    }

    public void setProcessInstanceBusinessKey(String processInstanceBusinessKey) {
        this.processInstanceBusinessKey = processInstanceBusinessKey;
    }

    public HistoricTaskInstanceQueryDto processInstanceBusinessKeyIn(List<String> processInstanceBusinessKeyIn) {
        this.processInstanceBusinessKeyIn = processInstanceBusinessKeyIn;
        return this;
    }

    public HistoricTaskInstanceQueryDto addProcessInstanceBusinessKeyInItem(String processInstanceBusinessKeyInItem) {
        if (this.processInstanceBusinessKeyIn == null) {
            this.processInstanceBusinessKeyIn = new ArrayList<String>();
        }
        this.processInstanceBusinessKeyIn.add(processInstanceBusinessKeyInItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by process instances with one of the give business keys. The keys need to be in a comma-separated list.")
    public List<String> getProcessInstanceBusinessKeyIn() {
        return this.processInstanceBusinessKeyIn;
    }

    public void setProcessInstanceBusinessKeyIn(List<String> processInstanceBusinessKeyIn) {
        this.processInstanceBusinessKeyIn = processInstanceBusinessKeyIn;
    }

    public HistoricTaskInstanceQueryDto processInstanceBusinessKeyLike(String processInstanceBusinessKeyLike) {
        this.processInstanceBusinessKeyLike = processInstanceBusinessKeyLike;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by  process instance business key that has the parameter value as a substring.")
    public String getProcessInstanceBusinessKeyLike() {
        return this.processInstanceBusinessKeyLike;
    }

    public void setProcessInstanceBusinessKeyLike(String processInstanceBusinessKeyLike) {
        this.processInstanceBusinessKeyLike = processInstanceBusinessKeyLike;
    }

    public HistoricTaskInstanceQueryDto executionId(String executionId) {
        this.executionId = executionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by the id of the execution that executed the task.")
    public String getExecutionId() {
        return this.executionId;
    }

    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    public HistoricTaskInstanceQueryDto processDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by process definition id.")
    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    public HistoricTaskInstanceQueryDto processDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to tasks that belong to a process definition with the given key.")
    public String getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public void setProcessDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    public HistoricTaskInstanceQueryDto processDefinitionName(String processDefinitionName) {
        this.processDefinitionName = processDefinitionName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to tasks that belong to a process definition with the given name.")
    public String getProcessDefinitionName() {
        return this.processDefinitionName;
    }

    public void setProcessDefinitionName(String processDefinitionName) {
        this.processDefinitionName = processDefinitionName;
    }

    public HistoricTaskInstanceQueryDto caseInstanceId(String caseInstanceId) {
        this.caseInstanceId = caseInstanceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by case instance id.")
    public String getCaseInstanceId() {
        return this.caseInstanceId;
    }

    public void setCaseInstanceId(String caseInstanceId) {
        this.caseInstanceId = caseInstanceId;
    }

    public HistoricTaskInstanceQueryDto caseExecutionId(String caseExecutionId) {
        this.caseExecutionId = caseExecutionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by the id of the case execution that executed the task.")
    public String getCaseExecutionId() {
        return this.caseExecutionId;
    }

    public void setCaseExecutionId(String caseExecutionId) {
        this.caseExecutionId = caseExecutionId;
    }

    public HistoricTaskInstanceQueryDto caseDefinitionId(String caseDefinitionId) {
        this.caseDefinitionId = caseDefinitionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by case definition id.")
    public String getCaseDefinitionId() {
        return this.caseDefinitionId;
    }

    public void setCaseDefinitionId(String caseDefinitionId) {
        this.caseDefinitionId = caseDefinitionId;
    }

    public HistoricTaskInstanceQueryDto caseDefinitionKey(String caseDefinitionKey) {
        this.caseDefinitionKey = caseDefinitionKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to tasks that belong to a case definition with the given key.")
    public String getCaseDefinitionKey() {
        return this.caseDefinitionKey;
    }

    public void setCaseDefinitionKey(String caseDefinitionKey) {
        this.caseDefinitionKey = caseDefinitionKey;
    }

    public HistoricTaskInstanceQueryDto caseDefinitionName(String caseDefinitionName) {
        this.caseDefinitionName = caseDefinitionName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to tasks that belong to a case definition with the given name.")
    public String getCaseDefinitionName() {
        return this.caseDefinitionName;
    }

    public void setCaseDefinitionName(String caseDefinitionName) {
        this.caseDefinitionName = caseDefinitionName;
    }

    public HistoricTaskInstanceQueryDto activityInstanceIdIn(List<String> activityInstanceIdIn) {
        this.activityInstanceIdIn = activityInstanceIdIn;
        return this;
    }

    public HistoricTaskInstanceQueryDto addActivityInstanceIdInItem(String activityInstanceIdInItem) {
        if (this.activityInstanceIdIn == null) {
            this.activityInstanceIdIn = new ArrayList<String>();
        }
        this.activityInstanceIdIn.add(activityInstanceIdInItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include tasks which belong to one of the passed  activity instance ids.")
    public List<String> getActivityInstanceIdIn() {
        return this.activityInstanceIdIn;
    }

    public void setActivityInstanceIdIn(List<String> activityInstanceIdIn) {
        this.activityInstanceIdIn = activityInstanceIdIn;
    }

    public HistoricTaskInstanceQueryDto taskName(String taskName) {
        this.taskName = taskName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to tasks that have the given name.")
    public String getTaskName() {
        return this.taskName;
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    public HistoricTaskInstanceQueryDto taskNameLike(String taskNameLike) {
        this.taskNameLike = taskNameLike;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to tasks that have a name with the given parameter value as substring.")
    public String getTaskNameLike() {
        return this.taskNameLike;
    }

    public void setTaskNameLike(String taskNameLike) {
        this.taskNameLike = taskNameLike;
    }

    public HistoricTaskInstanceQueryDto taskDescription(String taskDescription) {
        this.taskDescription = taskDescription;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to tasks that have the given description.")
    public String getTaskDescription() {
        return this.taskDescription;
    }

    public void setTaskDescription(String taskDescription) {
        this.taskDescription = taskDescription;
    }

    public HistoricTaskInstanceQueryDto taskDescriptionLike(String taskDescriptionLike) {
        this.taskDescriptionLike = taskDescriptionLike;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to tasks that have a description that has the parameter value as a substring.")
    public String getTaskDescriptionLike() {
        return this.taskDescriptionLike;
    }

    public void setTaskDescriptionLike(String taskDescriptionLike) {
        this.taskDescriptionLike = taskDescriptionLike;
    }

    public HistoricTaskInstanceQueryDto taskDefinitionKey(String taskDefinitionKey) {
        this.taskDefinitionKey = taskDefinitionKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to tasks that have the given key.")
    public String getTaskDefinitionKey() {
        return this.taskDefinitionKey;
    }

    public void setTaskDefinitionKey(String taskDefinitionKey) {
        this.taskDefinitionKey = taskDefinitionKey;
    }

    public HistoricTaskInstanceQueryDto taskDefinitionKeyIn(List<String> taskDefinitionKeyIn) {
        this.taskDefinitionKeyIn = taskDefinitionKeyIn;
        return this;
    }

    public HistoricTaskInstanceQueryDto addTaskDefinitionKeyInItem(String taskDefinitionKeyInItem) {
        if (this.taskDefinitionKeyIn == null) {
            this.taskDefinitionKeyIn = new ArrayList<String>();
        }
        this.taskDefinitionKeyIn.add(taskDefinitionKeyInItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to tasks that have one of the passed  task definition keys.")
    public List<String> getTaskDefinitionKeyIn() {
        return this.taskDefinitionKeyIn;
    }

    public void setTaskDefinitionKeyIn(List<String> taskDefinitionKeyIn) {
        this.taskDefinitionKeyIn = taskDefinitionKeyIn;
    }

    public HistoricTaskInstanceQueryDto taskDeleteReason(String taskDeleteReason) {
        this.taskDeleteReason = taskDeleteReason;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to tasks that have the given delete reason.")
    public String getTaskDeleteReason() {
        return this.taskDeleteReason;
    }

    public void setTaskDeleteReason(String taskDeleteReason) {
        this.taskDeleteReason = taskDeleteReason;
    }

    public HistoricTaskInstanceQueryDto taskDeleteReasonLike(String taskDeleteReasonLike) {
        this.taskDeleteReasonLike = taskDeleteReasonLike;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to tasks that have a delete reason that has the parameter value as a substring.")
    public String getTaskDeleteReasonLike() {
        return this.taskDeleteReasonLike;
    }

    public void setTaskDeleteReasonLike(String taskDeleteReasonLike) {
        this.taskDeleteReasonLike = taskDeleteReasonLike;
    }

    public HistoricTaskInstanceQueryDto taskAssignee(String taskAssignee) {
        this.taskAssignee = taskAssignee;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to tasks that the given user is assigned to.")
    public String getTaskAssignee() {
        return this.taskAssignee;
    }

    public void setTaskAssignee(String taskAssignee) {
        this.taskAssignee = taskAssignee;
    }

    public HistoricTaskInstanceQueryDto taskAssigneeLike(String taskAssigneeLike) {
        this.taskAssigneeLike = taskAssigneeLike;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to tasks that are assigned to users with the parameter value as a substring.")
    public String getTaskAssigneeLike() {
        return this.taskAssigneeLike;
    }

    public void setTaskAssigneeLike(String taskAssigneeLike) {
        this.taskAssigneeLike = taskAssigneeLike;
    }

    public HistoricTaskInstanceQueryDto taskOwner(String taskOwner) {
        this.taskOwner = taskOwner;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to tasks that the given user owns.")
    public String getTaskOwner() {
        return this.taskOwner;
    }

    public void setTaskOwner(String taskOwner) {
        this.taskOwner = taskOwner;
    }

    public HistoricTaskInstanceQueryDto taskOwnerLike(String taskOwnerLike) {
        this.taskOwnerLike = taskOwnerLike;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to tasks that are owned by users with the parameter value as a substring.")
    public String getTaskOwnerLike() {
        return this.taskOwnerLike;
    }

    public void setTaskOwnerLike(String taskOwnerLike) {
        this.taskOwnerLike = taskOwnerLike;
    }

    public HistoricTaskInstanceQueryDto taskPriority(Integer taskPriority) {
        this.taskPriority = taskPriority;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to tasks that have the given priority.")
    public Integer getTaskPriority() {
        return this.taskPriority;
    }

    public void setTaskPriority(Integer taskPriority) {
        this.taskPriority = taskPriority;
    }

    public HistoricTaskInstanceQueryDto assigned(Boolean assigned) {
        this.assigned = assigned;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If set to `true`, restricts the query to all tasks that are assigned.")
    public Boolean getAssigned() {
        return this.assigned;
    }

    public void setAssigned(Boolean assigned) {
        this.assigned = assigned;
    }

    public HistoricTaskInstanceQueryDto unassigned(Boolean unassigned) {
        this.unassigned = unassigned;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If set to `true`, restricts the query to all tasks that are unassigned.")
    public Boolean getUnassigned() {
        return this.unassigned;
    }

    public void setUnassigned(Boolean unassigned) {
        this.unassigned = unassigned;
    }

    public HistoricTaskInstanceQueryDto finished(Boolean finished) {
        this.finished = finished;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include finished tasks. Value may only be `true`, as `false` is the default behavior.")
    public Boolean getFinished() {
        return this.finished;
    }

    public void setFinished(Boolean finished) {
        this.finished = finished;
    }

    public HistoricTaskInstanceQueryDto unfinished(Boolean unfinished) {
        this.unfinished = unfinished;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include unfinished tasks. Value may only be `true`, as `false` is the default behavior.")
    public Boolean getUnfinished() {
        return this.unfinished;
    }

    public void setUnfinished(Boolean unfinished) {
        this.unfinished = unfinished;
    }

    public HistoricTaskInstanceQueryDto processFinished(Boolean processFinished) {
        this.processFinished = processFinished;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include tasks of finished processes. Value may only be `true`, as `false` is the default behavior.")
    public Boolean getProcessFinished() {
        return this.processFinished;
    }

    public void setProcessFinished(Boolean processFinished) {
        this.processFinished = processFinished;
    }

    public HistoricTaskInstanceQueryDto processUnfinished(Boolean processUnfinished) {
        this.processUnfinished = processUnfinished;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include tasks of unfinished processes. Value may only be `true`, as `false` is the default behavior.")
    public Boolean getProcessUnfinished() {
        return this.processUnfinished;
    }

    public void setProcessUnfinished(Boolean processUnfinished) {
        this.processUnfinished = processUnfinished;
    }

    public HistoricTaskInstanceQueryDto taskDueDate(Date taskDueDate) {
        this.taskDueDate = taskDueDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to tasks that are due on the given date. By [default](https://docs.camunda.org/manual/7.20/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.")
    public Date getTaskDueDate() {
        return this.taskDueDate;
    }

    public void setTaskDueDate(Date taskDueDate) {
        this.taskDueDate = taskDueDate;
    }

    public HistoricTaskInstanceQueryDto taskDueDateBefore(Date taskDueDateBefore) {
        this.taskDueDateBefore = taskDueDateBefore;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to tasks that are due before the given date. By [default](https://docs.camunda.org/manual/7.20/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.")
    public Date getTaskDueDateBefore() {
        return this.taskDueDateBefore;
    }

    public void setTaskDueDateBefore(Date taskDueDateBefore) {
        this.taskDueDateBefore = taskDueDateBefore;
    }

    public HistoricTaskInstanceQueryDto taskDueDateAfter(Date taskDueDateAfter) {
        this.taskDueDateAfter = taskDueDateAfter;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to tasks that are due after the given date. By [default](https://docs.camunda.org/manual/7.20/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.")
    public Date getTaskDueDateAfter() {
        return this.taskDueDateAfter;
    }

    public void setTaskDueDateAfter(Date taskDueDateAfter) {
        this.taskDueDateAfter = taskDueDateAfter;
    }

    public HistoricTaskInstanceQueryDto withoutTaskDueDate(Boolean withoutTaskDueDate) {
        this.withoutTaskDueDate = withoutTaskDueDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include tasks which have no due date. Value may only be `true`, as `false` is the default behavior.")
    public Boolean getWithoutTaskDueDate() {
        return this.withoutTaskDueDate;
    }

    public void setWithoutTaskDueDate(Boolean withoutTaskDueDate) {
        this.withoutTaskDueDate = withoutTaskDueDate;
    }

    public HistoricTaskInstanceQueryDto taskFollowUpDate(Date taskFollowUpDate) {
        this.taskFollowUpDate = taskFollowUpDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to tasks that have a followUp date on the given date. By [default](https://docs.camunda.org/manual/7.20/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.")
    public Date getTaskFollowUpDate() {
        return this.taskFollowUpDate;
    }

    public void setTaskFollowUpDate(Date taskFollowUpDate) {
        this.taskFollowUpDate = taskFollowUpDate;
    }

    public HistoricTaskInstanceQueryDto taskFollowUpDateBefore(Date taskFollowUpDateBefore) {
        this.taskFollowUpDateBefore = taskFollowUpDateBefore;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to tasks that have a followUp date before the given date. By [default](https://docs.camunda.org/manual/7.20/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.")
    public Date getTaskFollowUpDateBefore() {
        return this.taskFollowUpDateBefore;
    }

    public void setTaskFollowUpDateBefore(Date taskFollowUpDateBefore) {
        this.taskFollowUpDateBefore = taskFollowUpDateBefore;
    }

    public HistoricTaskInstanceQueryDto taskFollowUpDateAfter(Date taskFollowUpDateAfter) {
        this.taskFollowUpDateAfter = taskFollowUpDateAfter;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to tasks that have a followUp date after the given date. By [default](https://docs.camunda.org/manual/7.20/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.")
    public Date getTaskFollowUpDateAfter() {
        return this.taskFollowUpDateAfter;
    }

    public void setTaskFollowUpDateAfter(Date taskFollowUpDateAfter) {
        this.taskFollowUpDateAfter = taskFollowUpDateAfter;
    }

    public HistoricTaskInstanceQueryDto startedBefore(Date startedBefore) {
        this.startedBefore = startedBefore;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to tasks that were started before the given date. By [default](https://docs.camunda.org/manual/7.20/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.")
    public Date getStartedBefore() {
        return this.startedBefore;
    }

    public void setStartedBefore(Date startedBefore) {
        this.startedBefore = startedBefore;
    }

    public HistoricTaskInstanceQueryDto startedAfter(Date startedAfter) {
        this.startedAfter = startedAfter;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to tasks that were started after the given date. By [default](https://docs.camunda.org/manual/7.20/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.")
    public Date getStartedAfter() {
        return this.startedAfter;
    }

    public void setStartedAfter(Date startedAfter) {
        this.startedAfter = startedAfter;
    }

    public HistoricTaskInstanceQueryDto finishedBefore(Date finishedBefore) {
        this.finishedBefore = finishedBefore;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to tasks that were finished before the given date. By [default](https://docs.camunda.org/manual/7.20/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.")
    public Date getFinishedBefore() {
        return this.finishedBefore;
    }

    public void setFinishedBefore(Date finishedBefore) {
        this.finishedBefore = finishedBefore;
    }

    public HistoricTaskInstanceQueryDto finishedAfter(Date finishedAfter) {
        this.finishedAfter = finishedAfter;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to tasks that were finished after the given date. By [default](https://docs.camunda.org/manual/7.20/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.")
    public Date getFinishedAfter() {
        return this.finishedAfter;
    }

    public void setFinishedAfter(Date finishedAfter) {
        this.finishedAfter = finishedAfter;
    }

    public HistoricTaskInstanceQueryDto tenantIdIn(List<String> tenantIdIn) {
        this.tenantIdIn = tenantIdIn;
        return this;
    }

    public HistoricTaskInstanceQueryDto addTenantIdInItem(String tenantIdInItem) {
        if (this.tenantIdIn == null) {
            this.tenantIdIn = new ArrayList<String>();
        }
        this.tenantIdIn.add(tenantIdInItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by a  list of tenant ids. A task instance must have one of the given tenant ids.")
    public List<String> getTenantIdIn() {
        return this.tenantIdIn;
    }

    public void setTenantIdIn(List<String> tenantIdIn) {
        this.tenantIdIn = tenantIdIn;
    }

    public HistoricTaskInstanceQueryDto withoutTenantId(Boolean withoutTenantId) {
        this.withoutTenantId = withoutTenantId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include historic task instances that belong to no tenant. Value may only be `true`, as `false` is the default behavior.")
    public Boolean getWithoutTenantId() {
        return this.withoutTenantId;
    }

    public void setWithoutTenantId(Boolean withoutTenantId) {
        this.withoutTenantId = withoutTenantId;
    }

    public HistoricTaskInstanceQueryDto taskVariables(List<VariableQueryParameterDto> taskVariables) {
        this.taskVariables = taskVariables;
        return this;
    }

    public HistoricTaskInstanceQueryDto addTaskVariablesItem(VariableQueryParameterDto taskVariablesItem) {
        if (this.taskVariables == null) {
            this.taskVariables = new ArrayList<VariableQueryParameterDto>();
        }
        this.taskVariables.add(taskVariablesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include tasks that have variables with certain values. Variable filtering expressions are comma-separated and are structured as follows:  A valid parameter value has the form `key_operator_value`. `key` is the variable name, `operator` is the comparison operator to be used and `value` the variable value. **Note:** Values are always treated as `String` objects on server side.   Valid operator values are: * `eq` - equal to; * `neq` - not equal to; * `gt` - greater than; * `gteq` - greater than or equal to; * `lt` - lower than; * `lteq` - lower than or equal to; * `like`.  `key` and `value` may not contain underscore or comma characters.")
    public List<VariableQueryParameterDto> getTaskVariables() {
        return this.taskVariables;
    }

    public void setTaskVariables(List<VariableQueryParameterDto> taskVariables) {
        this.taskVariables = taskVariables;
    }

    public HistoricTaskInstanceQueryDto processVariables(List<VariableQueryParameterDto> processVariables) {
        this.processVariables = processVariables;
        return this;
    }

    public HistoricTaskInstanceQueryDto addProcessVariablesItem(VariableQueryParameterDto processVariablesItem) {
        if (this.processVariables == null) {
            this.processVariables = new ArrayList<VariableQueryParameterDto>();
        }
        this.processVariables.add(processVariablesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include tasks that belong to process instances that have variables with certain values. Variable filtering expressions are comma-separated and are structured as follows:  A valid parameter value has the form `key_operator_value`. `key` is the variable name, `operator` is the comparison operator to be used and `value` the variable value. **Note:** Values are always treated as `String` objects on server side.   Valid operator values are: * `eq` - equal to; * `neq` - not equal to; * `gt` - greater than; * `gteq` - greater than or equal to; * `lt` - lower than; * `lteq` - lower than or equal to; * `like`; * `notLike`.  `key` and `value` may not contain underscore or comma characters.")
    public List<VariableQueryParameterDto> getProcessVariables() {
        return this.processVariables;
    }

    public void setProcessVariables(List<VariableQueryParameterDto> processVariables) {
        this.processVariables = processVariables;
    }

    public HistoricTaskInstanceQueryDto variableNamesIgnoreCase(Boolean variableNamesIgnoreCase) {
        this.variableNamesIgnoreCase = variableNamesIgnoreCase;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Match the variable name provided in `taskVariables` and `processVariables` case- insensitively. If set to `true` **variableName** and **variablename** are treated as equal.")
    public Boolean getVariableNamesIgnoreCase() {
        return this.variableNamesIgnoreCase;
    }

    public void setVariableNamesIgnoreCase(Boolean variableNamesIgnoreCase) {
        this.variableNamesIgnoreCase = variableNamesIgnoreCase;
    }

    public HistoricTaskInstanceQueryDto variableValuesIgnoreCase(Boolean variableValuesIgnoreCase) {
        this.variableValuesIgnoreCase = variableValuesIgnoreCase;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Match the variable value provided in `taskVariables` and `processVariables` case- insensitively. If set to `true` **variableValue** and **variablevalue** are treated as equal.")
    public Boolean getVariableValuesIgnoreCase() {
        return this.variableValuesIgnoreCase;
    }

    public void setVariableValuesIgnoreCase(Boolean variableValuesIgnoreCase) {
        this.variableValuesIgnoreCase = variableValuesIgnoreCase;
    }

    public HistoricTaskInstanceQueryDto taskInvolvedUser(String taskInvolvedUser) {
        this.taskInvolvedUser = taskInvolvedUser;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to tasks with a historic identity link to the given user.")
    public String getTaskInvolvedUser() {
        return this.taskInvolvedUser;
    }

    public void setTaskInvolvedUser(String taskInvolvedUser) {
        this.taskInvolvedUser = taskInvolvedUser;
    }

    public HistoricTaskInstanceQueryDto taskInvolvedGroup(String taskInvolvedGroup) {
        this.taskInvolvedGroup = taskInvolvedGroup;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to tasks with a historic identity link to the given group.")
    public String getTaskInvolvedGroup() {
        return this.taskInvolvedGroup;
    }

    public void setTaskInvolvedGroup(String taskInvolvedGroup) {
        this.taskInvolvedGroup = taskInvolvedGroup;
    }

    public HistoricTaskInstanceQueryDto taskHadCandidateUser(String taskHadCandidateUser) {
        this.taskHadCandidateUser = taskHadCandidateUser;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to tasks with a historic identity link to the given candidate user.")
    public String getTaskHadCandidateUser() {
        return this.taskHadCandidateUser;
    }

    public void setTaskHadCandidateUser(String taskHadCandidateUser) {
        this.taskHadCandidateUser = taskHadCandidateUser;
    }

    public HistoricTaskInstanceQueryDto taskHadCandidateGroup(String taskHadCandidateGroup) {
        this.taskHadCandidateGroup = taskHadCandidateGroup;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to tasks with a historic identity link to the given candidate group.")
    public String getTaskHadCandidateGroup() {
        return this.taskHadCandidateGroup;
    }

    public void setTaskHadCandidateGroup(String taskHadCandidateGroup) {
        this.taskHadCandidateGroup = taskHadCandidateGroup;
    }

    public HistoricTaskInstanceQueryDto withCandidateGroups(Boolean withCandidateGroups) {
        this.withCandidateGroups = withCandidateGroups;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include tasks which have a candidate group. Value may only be `true`, as `false` is the default behavior.")
    public Boolean getWithCandidateGroups() {
        return this.withCandidateGroups;
    }

    public void setWithCandidateGroups(Boolean withCandidateGroups) {
        this.withCandidateGroups = withCandidateGroups;
    }

    public HistoricTaskInstanceQueryDto withoutCandidateGroups(Boolean withoutCandidateGroups) {
        this.withoutCandidateGroups = withoutCandidateGroups;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include tasks which have no candidate group. Value may only be `true`, as `false` is the default behavior.")
    public Boolean getWithoutCandidateGroups() {
        return this.withoutCandidateGroups;
    }

    public void setWithoutCandidateGroups(Boolean withoutCandidateGroups) {
        this.withoutCandidateGroups = withoutCandidateGroups;
    }

    public HistoricTaskInstanceQueryDto orQueries(List<HistoricTaskInstanceQueryDto> orQueries) {
        this.orQueries = orQueries;
        return this;
    }

    public HistoricTaskInstanceQueryDto addOrQueriesItem(HistoricTaskInstanceQueryDto orQueriesItem) {
        if (this.orQueries == null) {
            this.orQueries = new ArrayList<HistoricTaskInstanceQueryDto>();
        }
        this.orQueries.add(orQueriesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A JSON array of nested historic task instance queries with OR semantics.  A task instance matches a nested query if it fulfills at least one of the query's predicates.  With multiple nested queries, a task instance must fulfill at least one predicate of each query ([Conjunctive Normal Form](https://en.wikipedia.org/wiki/Conjunctive_normal_form)).  All task instance query properties can be used except for: `sorting`, `withCandidateGroups`, ` withoutCandidateGroups`.  See the [User Guide](https://docs.camunda.org/manual/7.20/user-guide/process-engine/process-engine-api/#or-queries) for more information about OR queries.")
    public List<HistoricTaskInstanceQueryDto> getOrQueries() {
        return this.orQueries;
    }

    public void setOrQueries(List<HistoricTaskInstanceQueryDto> orQueries) {
        this.orQueries = orQueries;
    }

    public HistoricTaskInstanceQueryDto sorting(List<HistoricTaskInstanceQueryDtoSorting> sorting) {
        this.sorting = sorting;
        return this;
    }

    public HistoricTaskInstanceQueryDto addSortingItem(HistoricTaskInstanceQueryDtoSorting sortingItem) {
        if (this.sorting == null) {
            this.sorting = new ArrayList<HistoricTaskInstanceQueryDtoSorting>();
        }
        this.sorting.add(sortingItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An array of criteria to sort the result by. Each element of the array is                     an object that specifies one ordering. The position in the array                     identifies the rank of an ordering, i.e., whether it is primary, secondary,                     etc. Sorting has no effect for `count` endpoints")
    public List<HistoricTaskInstanceQueryDtoSorting> getSorting() {
        return this.sorting;
    }

    public void setSorting(List<HistoricTaskInstanceQueryDtoSorting> sorting) {
        this.sorting = sorting;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HistoricTaskInstanceQueryDto historicTaskInstanceQueryDto = (HistoricTaskInstanceQueryDto)o;
        return Objects.equals(this.taskId, historicTaskInstanceQueryDto.taskId) && Objects.equals(this.taskParentTaskId, historicTaskInstanceQueryDto.taskParentTaskId) && Objects.equals(this.processInstanceId, historicTaskInstanceQueryDto.processInstanceId) && Objects.equals(this.processInstanceBusinessKey, historicTaskInstanceQueryDto.processInstanceBusinessKey) && Objects.equals(this.processInstanceBusinessKeyIn, historicTaskInstanceQueryDto.processInstanceBusinessKeyIn) && Objects.equals(this.processInstanceBusinessKeyLike, historicTaskInstanceQueryDto.processInstanceBusinessKeyLike) && Objects.equals(this.executionId, historicTaskInstanceQueryDto.executionId) && Objects.equals(this.processDefinitionId, historicTaskInstanceQueryDto.processDefinitionId) && Objects.equals(this.processDefinitionKey, historicTaskInstanceQueryDto.processDefinitionKey) && Objects.equals(this.processDefinitionName, historicTaskInstanceQueryDto.processDefinitionName) && Objects.equals(this.caseInstanceId, historicTaskInstanceQueryDto.caseInstanceId) && Objects.equals(this.caseExecutionId, historicTaskInstanceQueryDto.caseExecutionId) && Objects.equals(this.caseDefinitionId, historicTaskInstanceQueryDto.caseDefinitionId) && Objects.equals(this.caseDefinitionKey, historicTaskInstanceQueryDto.caseDefinitionKey) && Objects.equals(this.caseDefinitionName, historicTaskInstanceQueryDto.caseDefinitionName) && Objects.equals(this.activityInstanceIdIn, historicTaskInstanceQueryDto.activityInstanceIdIn) && Objects.equals(this.taskName, historicTaskInstanceQueryDto.taskName) && Objects.equals(this.taskNameLike, historicTaskInstanceQueryDto.taskNameLike) && Objects.equals(this.taskDescription, historicTaskInstanceQueryDto.taskDescription) && Objects.equals(this.taskDescriptionLike, historicTaskInstanceQueryDto.taskDescriptionLike) && Objects.equals(this.taskDefinitionKey, historicTaskInstanceQueryDto.taskDefinitionKey) && Objects.equals(this.taskDefinitionKeyIn, historicTaskInstanceQueryDto.taskDefinitionKeyIn) && Objects.equals(this.taskDeleteReason, historicTaskInstanceQueryDto.taskDeleteReason) && Objects.equals(this.taskDeleteReasonLike, historicTaskInstanceQueryDto.taskDeleteReasonLike) && Objects.equals(this.taskAssignee, historicTaskInstanceQueryDto.taskAssignee) && Objects.equals(this.taskAssigneeLike, historicTaskInstanceQueryDto.taskAssigneeLike) && Objects.equals(this.taskOwner, historicTaskInstanceQueryDto.taskOwner) && Objects.equals(this.taskOwnerLike, historicTaskInstanceQueryDto.taskOwnerLike) && Objects.equals(this.taskPriority, historicTaskInstanceQueryDto.taskPriority) && Objects.equals(this.assigned, historicTaskInstanceQueryDto.assigned) && Objects.equals(this.unassigned, historicTaskInstanceQueryDto.unassigned) && Objects.equals(this.finished, historicTaskInstanceQueryDto.finished) && Objects.equals(this.unfinished, historicTaskInstanceQueryDto.unfinished) && Objects.equals(this.processFinished, historicTaskInstanceQueryDto.processFinished) && Objects.equals(this.processUnfinished, historicTaskInstanceQueryDto.processUnfinished) && Objects.equals(this.taskDueDate, historicTaskInstanceQueryDto.taskDueDate) && Objects.equals(this.taskDueDateBefore, historicTaskInstanceQueryDto.taskDueDateBefore) && Objects.equals(this.taskDueDateAfter, historicTaskInstanceQueryDto.taskDueDateAfter) && Objects.equals(this.withoutTaskDueDate, historicTaskInstanceQueryDto.withoutTaskDueDate) && Objects.equals(this.taskFollowUpDate, historicTaskInstanceQueryDto.taskFollowUpDate) && Objects.equals(this.taskFollowUpDateBefore, historicTaskInstanceQueryDto.taskFollowUpDateBefore) && Objects.equals(this.taskFollowUpDateAfter, historicTaskInstanceQueryDto.taskFollowUpDateAfter) && Objects.equals(this.startedBefore, historicTaskInstanceQueryDto.startedBefore) && Objects.equals(this.startedAfter, historicTaskInstanceQueryDto.startedAfter) && Objects.equals(this.finishedBefore, historicTaskInstanceQueryDto.finishedBefore) && Objects.equals(this.finishedAfter, historicTaskInstanceQueryDto.finishedAfter) && Objects.equals(this.tenantIdIn, historicTaskInstanceQueryDto.tenantIdIn) && Objects.equals(this.withoutTenantId, historicTaskInstanceQueryDto.withoutTenantId) && Objects.equals(this.taskVariables, historicTaskInstanceQueryDto.taskVariables) && Objects.equals(this.processVariables, historicTaskInstanceQueryDto.processVariables) && Objects.equals(this.variableNamesIgnoreCase, historicTaskInstanceQueryDto.variableNamesIgnoreCase) && Objects.equals(this.variableValuesIgnoreCase, historicTaskInstanceQueryDto.variableValuesIgnoreCase) && Objects.equals(this.taskInvolvedUser, historicTaskInstanceQueryDto.taskInvolvedUser) && Objects.equals(this.taskInvolvedGroup, historicTaskInstanceQueryDto.taskInvolvedGroup) && Objects.equals(this.taskHadCandidateUser, historicTaskInstanceQueryDto.taskHadCandidateUser) && Objects.equals(this.taskHadCandidateGroup, historicTaskInstanceQueryDto.taskHadCandidateGroup) && Objects.equals(this.withCandidateGroups, historicTaskInstanceQueryDto.withCandidateGroups) && Objects.equals(this.withoutCandidateGroups, historicTaskInstanceQueryDto.withoutCandidateGroups) && Objects.equals(this.orQueries, historicTaskInstanceQueryDto.orQueries) && Objects.equals(this.sorting, historicTaskInstanceQueryDto.sorting);
    }

    public int hashCode() {
        return Objects.hash(this.taskId, this.taskParentTaskId, this.processInstanceId, this.processInstanceBusinessKey, this.processInstanceBusinessKeyIn, this.processInstanceBusinessKeyLike, this.executionId, this.processDefinitionId, this.processDefinitionKey, this.processDefinitionName, this.caseInstanceId, this.caseExecutionId, this.caseDefinitionId, this.caseDefinitionKey, this.caseDefinitionName, this.activityInstanceIdIn, this.taskName, this.taskNameLike, this.taskDescription, this.taskDescriptionLike, this.taskDefinitionKey, this.taskDefinitionKeyIn, this.taskDeleteReason, this.taskDeleteReasonLike, this.taskAssignee, this.taskAssigneeLike, this.taskOwner, this.taskOwnerLike, this.taskPriority, this.assigned, this.unassigned, this.finished, this.unfinished, this.processFinished, this.processUnfinished, this.taskDueDate, this.taskDueDateBefore, this.taskDueDateAfter, this.withoutTaskDueDate, this.taskFollowUpDate, this.taskFollowUpDateBefore, this.taskFollowUpDateAfter, this.startedBefore, this.startedAfter, this.finishedBefore, this.finishedAfter, this.tenantIdIn, this.withoutTenantId, this.taskVariables, this.processVariables, this.variableNamesIgnoreCase, this.variableValuesIgnoreCase, this.taskInvolvedUser, this.taskInvolvedGroup, this.taskHadCandidateUser, this.taskHadCandidateGroup, this.withCandidateGroups, this.withoutCandidateGroups, this.orQueries, this.sorting);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HistoricTaskInstanceQueryDto {\n");
        sb.append("    taskId: ").append(this.toIndentedString(this.taskId)).append("\n");
        sb.append("    taskParentTaskId: ").append(this.toIndentedString(this.taskParentTaskId)).append("\n");
        sb.append("    processInstanceId: ").append(this.toIndentedString(this.processInstanceId)).append("\n");
        sb.append("    processInstanceBusinessKey: ").append(this.toIndentedString(this.processInstanceBusinessKey)).append("\n");
        sb.append("    processInstanceBusinessKeyIn: ").append(this.toIndentedString(this.processInstanceBusinessKeyIn)).append("\n");
        sb.append("    processInstanceBusinessKeyLike: ").append(this.toIndentedString(this.processInstanceBusinessKeyLike)).append("\n");
        sb.append("    executionId: ").append(this.toIndentedString(this.executionId)).append("\n");
        sb.append("    processDefinitionId: ").append(this.toIndentedString(this.processDefinitionId)).append("\n");
        sb.append("    processDefinitionKey: ").append(this.toIndentedString(this.processDefinitionKey)).append("\n");
        sb.append("    processDefinitionName: ").append(this.toIndentedString(this.processDefinitionName)).append("\n");
        sb.append("    caseInstanceId: ").append(this.toIndentedString(this.caseInstanceId)).append("\n");
        sb.append("    caseExecutionId: ").append(this.toIndentedString(this.caseExecutionId)).append("\n");
        sb.append("    caseDefinitionId: ").append(this.toIndentedString(this.caseDefinitionId)).append("\n");
        sb.append("    caseDefinitionKey: ").append(this.toIndentedString(this.caseDefinitionKey)).append("\n");
        sb.append("    caseDefinitionName: ").append(this.toIndentedString(this.caseDefinitionName)).append("\n");
        sb.append("    activityInstanceIdIn: ").append(this.toIndentedString(this.activityInstanceIdIn)).append("\n");
        sb.append("    taskName: ").append(this.toIndentedString(this.taskName)).append("\n");
        sb.append("    taskNameLike: ").append(this.toIndentedString(this.taskNameLike)).append("\n");
        sb.append("    taskDescription: ").append(this.toIndentedString(this.taskDescription)).append("\n");
        sb.append("    taskDescriptionLike: ").append(this.toIndentedString(this.taskDescriptionLike)).append("\n");
        sb.append("    taskDefinitionKey: ").append(this.toIndentedString(this.taskDefinitionKey)).append("\n");
        sb.append("    taskDefinitionKeyIn: ").append(this.toIndentedString(this.taskDefinitionKeyIn)).append("\n");
        sb.append("    taskDeleteReason: ").append(this.toIndentedString(this.taskDeleteReason)).append("\n");
        sb.append("    taskDeleteReasonLike: ").append(this.toIndentedString(this.taskDeleteReasonLike)).append("\n");
        sb.append("    taskAssignee: ").append(this.toIndentedString(this.taskAssignee)).append("\n");
        sb.append("    taskAssigneeLike: ").append(this.toIndentedString(this.taskAssigneeLike)).append("\n");
        sb.append("    taskOwner: ").append(this.toIndentedString(this.taskOwner)).append("\n");
        sb.append("    taskOwnerLike: ").append(this.toIndentedString(this.taskOwnerLike)).append("\n");
        sb.append("    taskPriority: ").append(this.toIndentedString(this.taskPriority)).append("\n");
        sb.append("    assigned: ").append(this.toIndentedString(this.assigned)).append("\n");
        sb.append("    unassigned: ").append(this.toIndentedString(this.unassigned)).append("\n");
        sb.append("    finished: ").append(this.toIndentedString(this.finished)).append("\n");
        sb.append("    unfinished: ").append(this.toIndentedString(this.unfinished)).append("\n");
        sb.append("    processFinished: ").append(this.toIndentedString(this.processFinished)).append("\n");
        sb.append("    processUnfinished: ").append(this.toIndentedString(this.processUnfinished)).append("\n");
        sb.append("    taskDueDate: ").append(this.toIndentedString(this.taskDueDate)).append("\n");
        sb.append("    taskDueDateBefore: ").append(this.toIndentedString(this.taskDueDateBefore)).append("\n");
        sb.append("    taskDueDateAfter: ").append(this.toIndentedString(this.taskDueDateAfter)).append("\n");
        sb.append("    withoutTaskDueDate: ").append(this.toIndentedString(this.withoutTaskDueDate)).append("\n");
        sb.append("    taskFollowUpDate: ").append(this.toIndentedString(this.taskFollowUpDate)).append("\n");
        sb.append("    taskFollowUpDateBefore: ").append(this.toIndentedString(this.taskFollowUpDateBefore)).append("\n");
        sb.append("    taskFollowUpDateAfter: ").append(this.toIndentedString(this.taskFollowUpDateAfter)).append("\n");
        sb.append("    startedBefore: ").append(this.toIndentedString(this.startedBefore)).append("\n");
        sb.append("    startedAfter: ").append(this.toIndentedString(this.startedAfter)).append("\n");
        sb.append("    finishedBefore: ").append(this.toIndentedString(this.finishedBefore)).append("\n");
        sb.append("    finishedAfter: ").append(this.toIndentedString(this.finishedAfter)).append("\n");
        sb.append("    tenantIdIn: ").append(this.toIndentedString(this.tenantIdIn)).append("\n");
        sb.append("    withoutTenantId: ").append(this.toIndentedString(this.withoutTenantId)).append("\n");
        sb.append("    taskVariables: ").append(this.toIndentedString(this.taskVariables)).append("\n");
        sb.append("    processVariables: ").append(this.toIndentedString(this.processVariables)).append("\n");
        sb.append("    variableNamesIgnoreCase: ").append(this.toIndentedString(this.variableNamesIgnoreCase)).append("\n");
        sb.append("    variableValuesIgnoreCase: ").append(this.toIndentedString(this.variableValuesIgnoreCase)).append("\n");
        sb.append("    taskInvolvedUser: ").append(this.toIndentedString(this.taskInvolvedUser)).append("\n");
        sb.append("    taskInvolvedGroup: ").append(this.toIndentedString(this.taskInvolvedGroup)).append("\n");
        sb.append("    taskHadCandidateUser: ").append(this.toIndentedString(this.taskHadCandidateUser)).append("\n");
        sb.append("    taskHadCandidateGroup: ").append(this.toIndentedString(this.taskHadCandidateGroup)).append("\n");
        sb.append("    withCandidateGroups: ").append(this.toIndentedString(this.withCandidateGroups)).append("\n");
        sb.append("    withoutCandidateGroups: ").append(this.toIndentedString(this.withoutCandidateGroups)).append("\n");
        sb.append("    orQueries: ").append(this.toIndentedString(this.orQueries)).append("\n");
        sb.append("    sorting: ").append(this.toIndentedString(this.sorting)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

