/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.dto;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nullable;

public class HistoricTaskInstanceReportResultDto {
    public static final String SERIALIZED_NAME_TASK_NAME = "taskName";
    @SerializedName(value="taskName")
    private String taskName;
    public static final String SERIALIZED_NAME_COUNT = "count";
    @SerializedName(value="count")
    private Long count;
    public static final String SERIALIZED_NAME_PROCESS_DEFINITION_KEY = "processDefinitionKey";
    @SerializedName(value="processDefinitionKey")
    private String processDefinitionKey;
    public static final String SERIALIZED_NAME_PROCESS_DEFINITION_ID = "processDefinitionId";
    @SerializedName(value="processDefinitionId")
    private String processDefinitionId;
    public static final String SERIALIZED_NAME_PROCESS_DEFINITION_NAME = "processDefinitionName";
    @SerializedName(value="processDefinitionName")
    private String processDefinitionName;
    public static final String SERIALIZED_NAME_PERIOD = "period";
    @SerializedName(value="period")
    private Integer period;
    public static final String SERIALIZED_NAME_PERIOD_UNIT = "periodUnit";
    @SerializedName(value="periodUnit")
    private PeriodUnitEnum periodUnit;
    public static final String SERIALIZED_NAME_MINIMUM = "minimum";
    @SerializedName(value="minimum")
    private Long minimum;
    public static final String SERIALIZED_NAME_MAXIMUM = "maximum";
    @SerializedName(value="maximum")
    private Long maximum;
    public static final String SERIALIZED_NAME_AVERAGE = "average";
    @SerializedName(value="average")
    private Long average;
    public static final String SERIALIZED_NAME_TENANT_ID = "tenantId";
    @SerializedName(value="tenantId")
    private String tenantId;

    public HistoricTaskInstanceReportResultDto taskName(String taskName) {
        this.taskName = taskName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of the task. It is only available when the `groupBy` parameter is set to `taskName`. Else the value is `null`.  **Note:** This property is only set for a historic task report object. In these cases, the value of the `reportType` query parameter is `count`.")
    public String getTaskName() {
        return this.taskName;
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    public HistoricTaskInstanceReportResultDto count(Long count) {
        this.count = count;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of tasks which have the given definition.  **Note:** This property is only set for a historic task report object. In these cases, the value of the `reportType` query parameter is `count`.")
    public Long getCount() {
        return this.count;
    }

    public void setCount(Long count) {
        this.count = count;
    }

    public HistoricTaskInstanceReportResultDto processDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The key of the process definition.  **Note:** This property is only set for a historic task report object. In these cases, the value of the `reportType` query parameter is `count`.")
    public String getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public void setProcessDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    public HistoricTaskInstanceReportResultDto processDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the process definition.  **Note:** This property is only set for a historic task report object. In these cases, the value of the `reportType` query parameter is `count`.")
    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    public HistoricTaskInstanceReportResultDto processDefinitionName(String processDefinitionName) {
        this.processDefinitionName = processDefinitionName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of the process definition.  **Note:** This property is only set for a historic task report object. In these cases, the value of the `reportType` query parameter is `count`.")
    public String getProcessDefinitionName() {
        return this.processDefinitionName;
    }

    public void setProcessDefinitionName(String processDefinitionName) {
        this.processDefinitionName = processDefinitionName;
    }

    public HistoricTaskInstanceReportResultDto period(Integer period) {
        this.period = period;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Specifies a span of time within a year. **Note:** The period must be interpreted in conjunction with the returned `periodUnit`.  **Note:** This property is only set for a duration report object. In these cases, the value of the `reportType` query parameter is `duration`.")
    public Integer getPeriod() {
        return this.period;
    }

    public void setPeriod(Integer period) {
        this.period = period;
    }

    public HistoricTaskInstanceReportResultDto periodUnit(PeriodUnitEnum periodUnit) {
        this.periodUnit = periodUnit;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The unit of the given period. Possible values are `MONTH` and `QUARTER`.  **Note:** This property is only set for a duration report object. In these cases, the value of the `reportType` query parameter is `duration`.")
    public PeriodUnitEnum getPeriodUnit() {
        return this.periodUnit;
    }

    public void setPeriodUnit(PeriodUnitEnum periodUnit) {
        this.periodUnit = periodUnit;
    }

    public HistoricTaskInstanceReportResultDto minimum(Long minimum) {
        this.minimum = minimum;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The smallest duration in milliseconds of all completed process instances which were started in the given period.  **Note:** This property is only set for a duration report object. In these cases, the value of the `reportType` query parameter is `duration`.")
    public Long getMinimum() {
        return this.minimum;
    }

    public void setMinimum(Long minimum) {
        this.minimum = minimum;
    }

    public HistoricTaskInstanceReportResultDto maximum(Long maximum) {
        this.maximum = maximum;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The greatest duration in milliseconds of all completed process instances which were started in the given period.  **Note:** This property is only set for a duration report object. In these cases, the value of the `reportType` query parameter is `duration`.")
    public Long getMaximum() {
        return this.maximum;
    }

    public void setMaximum(Long maximum) {
        this.maximum = maximum;
    }

    public HistoricTaskInstanceReportResultDto average(Long average) {
        this.average = average;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The average duration in milliseconds of all completed process instances which were started in the given period.  **Note:** This property is only set for a duration report object. In these cases, the value of the `reportType` query parameter is `duration`.")
    public Long getAverage() {
        return this.average;
    }

    public void setAverage(Long average) {
        this.average = average;
    }

    public HistoricTaskInstanceReportResultDto tenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the tenant.")
    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HistoricTaskInstanceReportResultDto historicTaskInstanceReportResultDto = (HistoricTaskInstanceReportResultDto)o;
        return Objects.equals(this.taskName, historicTaskInstanceReportResultDto.taskName) && Objects.equals(this.count, historicTaskInstanceReportResultDto.count) && Objects.equals(this.processDefinitionKey, historicTaskInstanceReportResultDto.processDefinitionKey) && Objects.equals(this.processDefinitionId, historicTaskInstanceReportResultDto.processDefinitionId) && Objects.equals(this.processDefinitionName, historicTaskInstanceReportResultDto.processDefinitionName) && Objects.equals(this.period, historicTaskInstanceReportResultDto.period) && Objects.equals((Object)this.periodUnit, (Object)historicTaskInstanceReportResultDto.periodUnit) && Objects.equals(this.minimum, historicTaskInstanceReportResultDto.minimum) && Objects.equals(this.maximum, historicTaskInstanceReportResultDto.maximum) && Objects.equals(this.average, historicTaskInstanceReportResultDto.average) && Objects.equals(this.tenantId, historicTaskInstanceReportResultDto.tenantId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.taskName, this.count, this.processDefinitionKey, this.processDefinitionId, this.processDefinitionName, this.period, this.periodUnit, this.minimum, this.maximum, this.average, this.tenantId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HistoricTaskInstanceReportResultDto {\n");
        sb.append("    taskName: ").append(this.toIndentedString(this.taskName)).append("\n");
        sb.append("    count: ").append(this.toIndentedString(this.count)).append("\n");
        sb.append("    processDefinitionKey: ").append(this.toIndentedString(this.processDefinitionKey)).append("\n");
        sb.append("    processDefinitionId: ").append(this.toIndentedString(this.processDefinitionId)).append("\n");
        sb.append("    processDefinitionName: ").append(this.toIndentedString(this.processDefinitionName)).append("\n");
        sb.append("    period: ").append(this.toIndentedString(this.period)).append("\n");
        sb.append("    periodUnit: ").append(this.toIndentedString((Object)this.periodUnit)).append("\n");
        sb.append("    minimum: ").append(this.toIndentedString(this.minimum)).append("\n");
        sb.append("    maximum: ").append(this.toIndentedString(this.maximum)).append("\n");
        sb.append("    average: ").append(this.toIndentedString(this.average)).append("\n");
        sb.append("    tenantId: ").append(this.toIndentedString(this.tenantId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum PeriodUnitEnum {
        MONTH("MONTH"),
        QUARTER("QUARTER");

        private String value;

        private PeriodUnitEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static PeriodUnitEnum fromValue(String value) {
            for (PeriodUnitEnum b : PeriodUnitEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<PeriodUnitEnum> {
            public void write(JsonWriter jsonWriter, PeriodUnitEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public PeriodUnitEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return PeriodUnitEnum.fromValue(value);
            }
        }
    }
}

