/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import java.util.Objects;
import javax.annotation.Nullable;

public class JobRetriesDto {
    public static final String SERIALIZED_NAME_DUE_DATE = "dueDate";
    @SerializedName(value="dueDate")
    private Date dueDate;
    public static final String SERIALIZED_NAME_RETRIES = "retries";
    @SerializedName(value="retries")
    private Integer retries;

    public JobRetriesDto dueDate(Date dueDate) {
        this.dueDate = dueDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The due date to set for the job. A due date indicates when this job is ready for execution. Jobs with due dates in the past will be scheduled for execution.")
    public Date getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(Date dueDate) {
        this.dueDate = dueDate;
    }

    public JobRetriesDto retries(Integer retries) {
        this.retries = retries;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of retries to set for the resource.  Must be >= 0. If this is 0, an incident is created and the task, or job, cannot be fetched, or acquired anymore unless the retries are increased again. Can not be null.")
    public Integer getRetries() {
        return this.retries;
    }

    public void setRetries(Integer retries) {
        this.retries = retries;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobRetriesDto jobRetriesDto = (JobRetriesDto)o;
        return Objects.equals(this.dueDate, jobRetriesDto.dueDate) && Objects.equals(this.retries, jobRetriesDto.retries);
    }

    public int hashCode() {
        return Objects.hash(this.dueDate, this.retries);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class JobRetriesDto {\n");
        sb.append("    dueDate: ").append(this.toIndentedString(this.dueDate)).append("\n");
        sb.append("    retries: ").append(this.toIndentedString(this.retries)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

