/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;
import org.camunda.community.rest.client.dto.TelemetryProductDto;

public class TelemetryDataDto {
    public static final String SERIALIZED_NAME_INSTALLATION = "installation";
    @SerializedName(value="installation")
    private String installation;
    public static final String SERIALIZED_NAME_PRODUCT = "product";
    @SerializedName(value="product")
    private TelemetryProductDto product;

    public TelemetryDataDto installation(String installation) {
        this.installation = installation;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An id which is unique for each installation of Camunda. It is stored once per database so all engines connected to the same database will have the same installation ID. The ID is used to identify a single installation of Camunda Platform.")
    public String getInstallation() {
        return this.installation;
    }

    public void setInstallation(String installation) {
        this.installation = installation;
    }

    public TelemetryDataDto product(TelemetryProductDto product) {
        this.product = product;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public TelemetryProductDto getProduct() {
        return this.product;
    }

    public void setProduct(TelemetryProductDto product) {
        this.product = product;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TelemetryDataDto telemetryDataDto = (TelemetryDataDto)o;
        return Objects.equals(this.installation, telemetryDataDto.installation) && Objects.equals(this.product, telemetryDataDto.product);
    }

    public int hashCode() {
        return Objects.hash(this.installation, this.product);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TelemetryDataDto {\n");
        sb.append("    installation: ").append(this.toIndentedString(this.installation)).append("\n");
        sb.append("    product: ").append(this.toIndentedString(this.product)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

