/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.camunda.community.rest.client.dto.AbstractVendorVersionInformationDto;
import org.camunda.community.rest.client.dto.TelemetryCountDto;
import org.camunda.community.rest.client.dto.TelemetryLicenseKeyDto;

public class TelemetryInternalsDto {
    public static final String SERIALIZED_NAME_DATABASE = "database";
    @SerializedName(value="database")
    private AbstractVendorVersionInformationDto database;
    public static final String SERIALIZED_NAME_APPLICATION_SERVER = "application-server";
    @SerializedName(value="application-server")
    private AbstractVendorVersionInformationDto applicationServer;
    public static final String SERIALIZED_NAME_LICENSE_KEY = "license-key";
    @SerializedName(value="license-key")
    private TelemetryLicenseKeyDto licenseKey;
    public static final String SERIALIZED_NAME_CAMUNDA_INTEGRATION = "camunda-integration";
    @SerializedName(value="camunda-integration")
    private List<String> camundaIntegration = null;
    public static final String SERIALIZED_NAME_COMMANDS = "commands";
    @SerializedName(value="commands")
    private Map<String, TelemetryCountDto> commands = null;
    public static final String SERIALIZED_NAME_METRICS = "metrics";
    @SerializedName(value="metrics")
    private Map<String, TelemetryCountDto> metrics = null;
    public static final String SERIALIZED_NAME_WEBAPPS = "webapps";
    @SerializedName(value="webapps")
    private List<String> webapps = null;
    public static final String SERIALIZED_NAME_JDK = "jdk";
    @SerializedName(value="jdk")
    private AbstractVendorVersionInformationDto jdk;
    public static final String SERIALIZED_NAME_DATA_COLLECTION_START_DATE = "data-collection-start-date";
    @SerializedName(value="data-collection-start-date")
    private Date dataCollectionStartDate;

    public TelemetryInternalsDto database(AbstractVendorVersionInformationDto database) {
        this.database = database;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public AbstractVendorVersionInformationDto getDatabase() {
        return this.database;
    }

    public void setDatabase(AbstractVendorVersionInformationDto database) {
        this.database = database;
    }

    public TelemetryInternalsDto applicationServer(AbstractVendorVersionInformationDto applicationServer) {
        this.applicationServer = applicationServer;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public AbstractVendorVersionInformationDto getApplicationServer() {
        return this.applicationServer;
    }

    public void setApplicationServer(AbstractVendorVersionInformationDto applicationServer) {
        this.applicationServer = applicationServer;
    }

    public TelemetryInternalsDto licenseKey(TelemetryLicenseKeyDto licenseKey) {
        this.licenseKey = licenseKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public TelemetryLicenseKeyDto getLicenseKey() {
        return this.licenseKey;
    }

    public void setLicenseKey(TelemetryLicenseKeyDto licenseKey) {
        this.licenseKey = licenseKey;
    }

    public TelemetryInternalsDto camundaIntegration(List<String> camundaIntegration) {
        this.camundaIntegration = camundaIntegration;
        return this;
    }

    public TelemetryInternalsDto addCamundaIntegrationItem(String camundaIntegrationItem) {
        if (this.camundaIntegration == null) {
            this.camundaIntegration = new ArrayList<String>();
        }
        this.camundaIntegration.add(camundaIntegrationItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of Camunda integrations used (e.g., Camunda Spring Boot Starter, Camunda Run, WildFly/JBoss subsystem, Camunda EJB).")
    public List<String> getCamundaIntegration() {
        return this.camundaIntegration;
    }

    public void setCamundaIntegration(List<String> camundaIntegration) {
        this.camundaIntegration = camundaIntegration;
    }

    public TelemetryInternalsDto commands(Map<String, TelemetryCountDto> commands) {
        this.commands = commands;
        return this;
    }

    public TelemetryInternalsDto putCommandsItem(String key, TelemetryCountDto commandsItem) {
        if (this.commands == null) {
            this.commands = new HashMap<String, TelemetryCountDto>();
        }
        this.commands.put(key, commandsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The count of executed commands after the last retrieved data.")
    public Map<String, TelemetryCountDto> getCommands() {
        return this.commands;
    }

    public void setCommands(Map<String, TelemetryCountDto> commands) {
        this.commands = commands;
    }

    public TelemetryInternalsDto metrics(Map<String, TelemetryCountDto> metrics) {
        this.metrics = metrics;
        return this;
    }

    public TelemetryInternalsDto putMetricsItem(String key, TelemetryCountDto metricsItem) {
        if (this.metrics == null) {
            this.metrics = new HashMap<String, TelemetryCountDto>();
        }
        this.metrics.put(key, metricsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The collected metrics are the number of root process instance executions started, the number of activity instances started or also known as flow node instances, and the number of executed decision instances and elements.")
    public Map<String, TelemetryCountDto> getMetrics() {
        return this.metrics;
    }

    public void setMetrics(Map<String, TelemetryCountDto> metrics) {
        this.metrics = metrics;
    }

    public TelemetryInternalsDto webapps(List<String> webapps) {
        this.webapps = webapps;
        return this;
    }

    public TelemetryInternalsDto addWebappsItem(String webappsItem) {
        if (this.webapps == null) {
            this.webapps = new ArrayList<String>();
        }
        this.webapps.add(webappsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The webapps enabled in this installation of Camunda.")
    public List<String> getWebapps() {
        return this.webapps;
    }

    public void setWebapps(List<String> webapps) {
        this.webapps = webapps;
    }

    public TelemetryInternalsDto jdk(AbstractVendorVersionInformationDto jdk) {
        this.jdk = jdk;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public AbstractVendorVersionInformationDto getJdk() {
        return this.jdk;
    }

    public void setJdk(AbstractVendorVersionInformationDto jdk) {
        this.jdk = jdk;
    }

    public TelemetryInternalsDto dataCollectionStartDate(Date dataCollectionStartDate) {
        this.dataCollectionStartDate = dataCollectionStartDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The date when the engine started to collect dynamic data, such as command executions and metrics. If telemetry sending is enabled, dynamic data resets on sending the data to Camunda. Dynamic data and the date returned by this method are reset in three cases: engine startup, after engine start when sending telemetry data to Camunda is enabled via API, after sending telemetry data to Camunda (only when this was enabled) The date is in the format <code>YYYY-MM-DD'T'HH:mm:ss.SSSZ</code>.")
    public Date getDataCollectionStartDate() {
        return this.dataCollectionStartDate;
    }

    public void setDataCollectionStartDate(Date dataCollectionStartDate) {
        this.dataCollectionStartDate = dataCollectionStartDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TelemetryInternalsDto telemetryInternalsDto = (TelemetryInternalsDto)o;
        return Objects.equals(this.database, telemetryInternalsDto.database) && Objects.equals(this.applicationServer, telemetryInternalsDto.applicationServer) && Objects.equals(this.licenseKey, telemetryInternalsDto.licenseKey) && Objects.equals(this.camundaIntegration, telemetryInternalsDto.camundaIntegration) && Objects.equals(this.commands, telemetryInternalsDto.commands) && Objects.equals(this.metrics, telemetryInternalsDto.metrics) && Objects.equals(this.webapps, telemetryInternalsDto.webapps) && Objects.equals(this.jdk, telemetryInternalsDto.jdk) && Objects.equals(this.dataCollectionStartDate, telemetryInternalsDto.dataCollectionStartDate);
    }

    public int hashCode() {
        return Objects.hash(this.database, this.applicationServer, this.licenseKey, this.camundaIntegration, this.commands, this.metrics, this.webapps, this.jdk, this.dataCollectionStartDate);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TelemetryInternalsDto {\n");
        sb.append("    database: ").append(this.toIndentedString(this.database)).append("\n");
        sb.append("    applicationServer: ").append(this.toIndentedString(this.applicationServer)).append("\n");
        sb.append("    licenseKey: ").append(this.toIndentedString(this.licenseKey)).append("\n");
        sb.append("    camundaIntegration: ").append(this.toIndentedString(this.camundaIntegration)).append("\n");
        sb.append("    commands: ").append(this.toIndentedString(this.commands)).append("\n");
        sb.append("    metrics: ").append(this.toIndentedString(this.metrics)).append("\n");
        sb.append("    webapps: ").append(this.toIndentedString(this.webapps)).append("\n");
        sb.append("    jdk: ").append(this.toIndentedString(this.jdk)).append("\n");
        sb.append("    dataCollectionStartDate: ").append(this.toIndentedString(this.dataCollectionStartDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

