/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.api;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.camunda.community.rest.client.dto.BatchDto;
import org.camunda.community.rest.client.dto.CleanableHistoricBatchReportResultDto;
import org.camunda.community.rest.client.dto.CountResultDto;
import org.camunda.community.rest.client.dto.HistoricBatchDto;
import org.camunda.community.rest.client.dto.SetRemovalTimeToHistoricBatchesDto;
import org.camunda.community.rest.client.invoker.ApiClient;
import org.camunda.community.rest.client.invoker.ApiException;
import org.camunda.community.rest.client.invoker.Configuration;
import org.camunda.community.rest.client.invoker.Pair;

public class HistoricBatchApi {
    private ApiClient apiClient;

    public HistoricBatchApi() {
        this(Configuration.getDefaultApiClient());
    }

    public HistoricBatchApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public void deleteHistoricBatch(String id) throws ApiException {
        this.deleteHistoricBatch(id, Collections.emptyMap());
    }

    public void deleteHistoricBatch(String id, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling deleteHistoricBatch");
        }
        String localVarPath = "/history/batch/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public List<CleanableHistoricBatchReportResultDto> getCleanableHistoricBatchesReport(String sortBy, String sortOrder, Integer firstResult, Integer maxResults) throws ApiException {
        return this.getCleanableHistoricBatchesReport(sortBy, sortOrder, firstResult, maxResults, Collections.emptyMap());
    }

    public List<CleanableHistoricBatchReportResultDto> getCleanableHistoricBatchesReport(String sortBy, String sortOrder, Integer firstResult, Integer maxResults, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/history/batch/cleanable-batch-report";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("sortBy", sortBy));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("sortOrder", sortOrder));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("firstResult", firstResult));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("maxResults", maxResults));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<List<CleanableHistoricBatchReportResultDto>> localVarReturnType = new TypeReference<List<CleanableHistoricBatchReportResultDto>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public CountResultDto getCleanableHistoricBatchesReportCount() throws ApiException {
        return this.getCleanableHistoricBatchesReportCount(Collections.emptyMap());
    }

    public CountResultDto getCleanableHistoricBatchesReportCount(Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/history/batch/cleanable-batch-report/count";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<CountResultDto> localVarReturnType = new TypeReference<CountResultDto>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public HistoricBatchDto getHistoricBatch(String id) throws ApiException {
        return this.getHistoricBatch(id, Collections.emptyMap());
    }

    public HistoricBatchDto getHistoricBatch(String id, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling getHistoricBatch");
        }
        String localVarPath = "/history/batch/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<HistoricBatchDto> localVarReturnType = new TypeReference<HistoricBatchDto>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<HistoricBatchDto> getHistoricBatches(String batchId, String type, Boolean completed, String tenantIdIn, Boolean withoutTenantId, String sortBy, String sortOrder, Integer firstResult, Integer maxResults) throws ApiException {
        return this.getHistoricBatches(batchId, type, completed, tenantIdIn, withoutTenantId, sortBy, sortOrder, firstResult, maxResults, Collections.emptyMap());
    }

    public List<HistoricBatchDto> getHistoricBatches(String batchId, String type, Boolean completed, String tenantIdIn, Boolean withoutTenantId, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/history/batch";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("batchId", batchId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("type", type));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("completed", completed));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("tenantIdIn", tenantIdIn));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("withoutTenantId", withoutTenantId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("sortBy", sortBy));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("sortOrder", sortOrder));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("firstResult", firstResult));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("maxResults", maxResults));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<List<HistoricBatchDto>> localVarReturnType = new TypeReference<List<HistoricBatchDto>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public CountResultDto getHistoricBatchesCount(String batchId, String type, Boolean completed, String tenantIdIn, Boolean withoutTenantId) throws ApiException {
        return this.getHistoricBatchesCount(batchId, type, completed, tenantIdIn, withoutTenantId, Collections.emptyMap());
    }

    public CountResultDto getHistoricBatchesCount(String batchId, String type, Boolean completed, String tenantIdIn, Boolean withoutTenantId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/history/batch/count";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("batchId", batchId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("type", type));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("completed", completed));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("tenantIdIn", tenantIdIn));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("withoutTenantId", withoutTenantId));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<CountResultDto> localVarReturnType = new TypeReference<CountResultDto>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public BatchDto setRemovalTimeAsyncHistoricBatch(SetRemovalTimeToHistoricBatchesDto setRemovalTimeToHistoricBatchesDto) throws ApiException {
        return this.setRemovalTimeAsyncHistoricBatch(setRemovalTimeToHistoricBatchesDto, Collections.emptyMap());
    }

    public BatchDto setRemovalTimeAsyncHistoricBatch(SetRemovalTimeToHistoricBatchesDto setRemovalTimeToHistoricBatchesDto, Map<String, String> additionalHeaders) throws ApiException {
        SetRemovalTimeToHistoricBatchesDto localVarPostBody = setRemovalTimeToHistoricBatchesDto;
        String localVarPath = "/history/batch/set-removal-time";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<BatchDto> localVarReturnType = new TypeReference<BatchDto>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

