/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.connect.httpclient.impl;

import java.util.HashMap;
import java.util.Map;
import org.camunda.connect.httpclient.HttpBaseRequest;
import org.camunda.connect.httpclient.HttpResponse;
import org.camunda.connect.httpclient.impl.HttpConnectorLogger;
import org.camunda.connect.httpclient.impl.HttpLogger;
import org.camunda.connect.impl.AbstractConnectorRequest;
import org.camunda.connect.spi.Connector;

public class AbstractHttpRequest<Q extends HttpBaseRequest<?, ?>, R extends HttpResponse>
extends AbstractConnectorRequest<R> {
    private final HttpConnectorLogger LOG = HttpLogger.HTTP_LOGGER;

    public AbstractHttpRequest(Connector connector) {
        super(connector);
    }

    public Q url(String url) {
        this.setRequestParameter("url", url);
        return (Q)((HttpBaseRequest)((Object)this));
    }

    public String getUrl() {
        return (String)this.getRequestParameter("url");
    }

    public Q method(String method) {
        this.setRequestParameter("method", method);
        return (Q)((HttpBaseRequest)((Object)this));
    }

    public String getMethod() {
        return (String)this.getRequestParameter("method");
    }

    public Q header(String field, String value) {
        if (field == null || field.isEmpty() || value == null || value.isEmpty()) {
            this.LOG.ignoreHeader(field, value);
        } else {
            HashMap<String, String> headers = (HashMap<String, String>)this.getRequestParameter("headers");
            if (headers == null) {
                headers = new HashMap<String, String>();
                this.setRequestParameter("headers", headers);
            }
            headers.put(field, value);
        }
        return (Q)((HttpBaseRequest)((Object)this));
    }

    public String getHeader(String field) {
        Map<String, String> headers = this.getHeaders();
        if (headers != null) {
            return headers.get(field);
        }
        return null;
    }

    public Map<String, String> getHeaders() {
        return (Map)this.getRequestParameter("headers");
    }

    public Q contentType(String contentType) {
        return this.header("Content-Type", contentType);
    }

    public String getContentType() {
        return this.getHeader("Content-Type");
    }

    public Q payload(String payload) {
        this.setRequestParameter("payload", payload);
        return (Q)((HttpBaseRequest)((Object)this));
    }

    public String getPayload() {
        return (String)this.getRequestParameter("payload");
    }

    public Q get() {
        return this.method("GET");
    }

    public Q post() {
        return this.method("POST");
    }

    public Q put() {
        return this.method("PUT");
    }

    public Q delete() {
        return this.method("DELETE");
    }

    public Q patch() {
        return this.method("PATCH");
    }

    public Q head() {
        return this.method("HEAD");
    }

    public Q options() {
        return this.method("OPTIONS");
    }

    public Q trace() {
        return this.method("TRACE");
    }

    public Map<String, Object> getConfigOptions() {
        return (Map)this.getRequestParameter("request-config");
    }

    public Object getConfigOption(String field) {
        Map<String, Object> config = this.getConfigOptions();
        if (config != null) {
            return config.get(field);
        }
        return null;
    }

    public Q configOption(String field, Object value) {
        if (field == null || field.isEmpty() || value == null) {
            this.LOG.ignoreConfig(field, value);
        } else {
            Map<String, Object> config = this.getConfigOptions();
            if (config == null) {
                config = new HashMap<String, Object>();
                this.setRequestParameter("request-config", config);
            }
            config.put(field, value);
        }
        return (Q)((HttpBaseRequest)((Object)this));
    }
}

