/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.spin.impl.json.jackson.format;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.lang.reflect.TypeVariable;
import java.util.Map;
import org.camunda.spin.impl.json.jackson.format.AbstractJacksonJsonTypeDetector;

public class MapJacksonJsonTypeDetector
extends AbstractJacksonJsonTypeDetector {
    public boolean canHandle(Object object) {
        return object instanceof Map;
    }

    public String detectType(Object object) {
        return this.constructType(object).toCanonical();
    }

    protected JavaType constructType(Object object) {
        TypeFactory typeFactory = TypeFactory.defaultInstance();
        if (object instanceof Map && !((Map)object).isEmpty()) {
            Map map = (Map)object;
            Object keyElement = map.keySet().iterator().next();
            Object valueElement = map.get(keyElement);
            if (this.bindingsArePresent(map.getClass())) {
                JavaType keyType = this.constructType(keyElement);
                JavaType valueType = this.constructType(valueElement);
                return typeFactory.constructMapType(map.getClass(), keyType, valueType);
            }
        }
        return typeFactory.constructType(object.getClass());
    }

    private boolean bindingsArePresent(Class<?> erasedType) {
        int varLen;
        TypeVariable<Class<?>>[] vars = erasedType.getTypeParameters();
        int n = varLen = vars == null ? 0 : vars.length;
        if (varLen == 0) {
            return false;
        }
        if (varLen != 2) {
            throw new IllegalArgumentException("Cannot create TypeBindings for class " + erasedType.getName() + " with 2 type parameter: class expects " + varLen);
        }
        return true;
    }
}

