/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.text.clustering;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.carrot2.core.Cluster;
import org.carrot2.core.Document;
import org.carrot2.core.LanguageCode;
import org.carrot2.core.attribute.Processing;
import org.carrot2.text.clustering.IMonolingualClusteringAlgorithm;
import org.carrot2.util.attribute.Attribute;
import org.carrot2.util.attribute.AttributeLevel;
import org.carrot2.util.attribute.Bindable;
import org.carrot2.util.attribute.Group;
import org.carrot2.util.attribute.Input;
import org.carrot2.util.attribute.Level;
import org.carrot2.util.attribute.Required;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Bindable(prefix="MultilingualClustering")
public class MultilingualClustering {
    private static final String MULTILINGUAL_CLUSTERING = "Multilingual clustering";
    private static final Logger logger = LoggerFactory.getLogger(MultilingualClustering.class);
    @Input
    @Processing
    @Attribute
    @Required
    @Group(value="Multilingual clustering")
    @Level(value=AttributeLevel.MEDIUM)
    public LanguageAggregationStrategy languageAggregationStrategy = LanguageAggregationStrategy.FLATTEN_MAJOR_LANGUAGE;
    @Input
    @Processing
    @Attribute
    @Required
    @Group(value="Multilingual clustering")
    @Level(value=AttributeLevel.MEDIUM)
    public LanguageCode defaultLanguage = LanguageCode.ENGLISH;

    public List<Cluster> process(List<Document> documents, IMonolingualClusteringAlgorithm algorithm) {
        if (documents.isEmpty()) {
            return Lists.newArrayList();
        }
        Map<LanguageCode, Cluster> clustersByLanguage = this.clusterByLanguage(documents, algorithm);
        ArrayList clusters = Lists.newArrayList(clustersByLanguage.values());
        if (clustersByLanguage.size() == 1 || LanguageAggregationStrategy.FLATTEN_ALL.equals((Object)this.languageAggregationStrategy)) {
            ArrayList flattenedClusters = Lists.newArrayList();
            for (Cluster cluster : clusters) {
                List<Cluster> subclusters = cluster.getSubclusters();
                for (Cluster subcluster : subclusters) {
                    if (subcluster.isOtherTopics()) continue;
                    flattenedClusters.add(subcluster);
                }
            }
            if (clustersByLanguage.size() > 1) {
                Collections.sort(flattenedClusters, Cluster.BY_REVERSED_SIZE_AND_LABEL_COMPARATOR);
            }
            Cluster.appendOtherTopics(documents, flattenedClusters);
            return flattenedClusters;
        }
        Collections.sort(clusters, Collections.reverseOrder(Cluster.BY_SIZE_COMPARATOR));
        if (LanguageAggregationStrategy.FLATTEN_MAJOR_LANGUAGE.equals((Object)this.languageAggregationStrategy)) {
            Iterator iterator = clusters.iterator();
            Cluster majorLanguageCluster = null;
            try {
                majorLanguageCluster = (Cluster)Iterators.find(iterator, (Predicate)new Predicate<Cluster>(){

                    public boolean apply(Cluster cluster) {
                        return !cluster.getSubclusters().isEmpty();
                    }
                });
            }
            catch (NoSuchElementException ignored) {
                // empty catch block
            }
            if (majorLanguageCluster != null) {
                iterator.remove();
                ArrayList flattenedClusters = Lists.newArrayList();
                flattenedClusters.addAll(majorLanguageCluster.getSubclusters());
                Cluster otherLanguages = new Cluster("Other Languages", new Document[0]);
                otherLanguages.addSubclusters(clusters);
                flattenedClusters.add(otherLanguages);
                return flattenedClusters;
            }
            return clusters;
        }
        return clusters;
    }

    private Map<LanguageCode, Cluster> clusterByLanguage(List<Document> documents, IMonolingualClusteringAlgorithm algorithm) {
        ImmutableListMultimap documentsByLanguage = Multimaps.index(documents, (Function)new Function<Document, String>(){

            public String apply(Document document) {
                LanguageCode language = document.getLanguage();
                return language != null ? language.name() : "";
            }
        });
        HashMap clusters = Maps.newHashMap();
        for (String language : documentsByLanguage.keySet()) {
            ImmutableList languageDocuments = documentsByLanguage.get((Object)language);
            LanguageCode languageCode = language.equals("") ? null : LanguageCode.valueOf(language);
            Cluster languageCluster = new Cluster(languageCode != null ? languageCode.toString() : "Unknown Language", new Document[0]);
            LanguageCode currentLanguage = languageCode != null ? languageCode : this.defaultLanguage;
            logger.debug("Performing monolingual clustering in: " + (Object)((Object)currentLanguage));
            List<Cluster> clustersForLanguage = algorithm.process((List<Document>)languageDocuments, currentLanguage);
            if (clustersForLanguage.size() == 0 || clustersForLanguage.size() == 1 && clustersForLanguage.get(0).isOtherTopics()) {
                languageCluster.addDocuments((Iterable<Document>)languageDocuments);
            } else {
                languageCluster.addSubclusters(clustersForLanguage);
            }
            clusters.put(languageCode, languageCluster);
        }
        return clusters;
    }

    public static enum LanguageAggregationStrategy {
        FLATTEN_ALL("Flatten clusters from all languages"),
        FLATTEN_MAJOR_LANGUAGE("Flatten clusters from the majority language"),
        FLATTEN_NONE("Dedicated parent cluster for each language");

        private String label;

        private LanguageAggregationStrategy(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }
}

