/*
 * Decompiled with CFR 0.152.
 */
package ceylon.language;

import ceylon.language.AliasesAnnotation$annotation$;
import ceylon.language.ArraySequence;
import ceylon.language.AssertionError;
import ceylon.language.Boolean;
import ceylon.language.Byte;
import ceylon.language.Callable;
import ceylon.language.Category$impl;
import ceylon.language.Character;
import ceylon.language.Collection$impl;
import ceylon.language.Comparison;
import ceylon.language.Correspondence$impl;
import ceylon.language.Entry;
import ceylon.language.FinalAnnotation$annotation$;
import ceylon.language.Finished;
import ceylon.language.Float;
import ceylon.language.IndexedCorrespondenceMutator;
import ceylon.language.Integer;
import ceylon.language.Iterable;
import ceylon.language.Iterable$impl;
import ceylon.language.Iterator;
import ceylon.language.List;
import ceylon.language.List$impl;
import ceylon.language.Map;
import ceylon.language.NativeAnnotation$annotation$;
import ceylon.language.Null;
import ceylon.language.Object;
import ceylon.language.SearchableList;
import ceylon.language.SearchableList$impl;
import ceylon.language.Sequence;
import ceylon.language.Sequential;
import ceylon.language.SerializableAnnotation$annotation$;
import ceylon.language.SharedAnnotation$annotation$;
import ceylon.language.String;
import ceylon.language.empty_;
import ceylon.language.finished_;
import ceylon.language.impl.BaseIterable;
import ceylon.language.impl.BaseIterator;
import ceylon.language.impl.MemberImpl;
import ceylon.language.impl.rethrow_;
import ceylon.language.larger_;
import ceylon.language.meta.declaration.ClassDeclaration;
import ceylon.language.meta.declaration.ValueDeclaration;
import ceylon.language.runtime_;
import ceylon.language.serialization.Element;
import ceylon.language.serialization.Member;
import ceylon.language.serialization.ReachableReference;
import ceylon.language.smaller_;
import com.redhat.ceylon.compiler.java.Util;
import com.redhat.ceylon.compiler.java.language.AbstractArrayIterable;
import com.redhat.ceylon.compiler.java.metadata.Annotation;
import com.redhat.ceylon.compiler.java.metadata.Annotations;
import com.redhat.ceylon.compiler.java.metadata.Ceylon;
import com.redhat.ceylon.compiler.java.metadata.Class;
import com.redhat.ceylon.compiler.java.metadata.ConstructorName;
import com.redhat.ceylon.compiler.java.metadata.Defaulted;
import com.redhat.ceylon.compiler.java.metadata.FunctionalParameter;
import com.redhat.ceylon.compiler.java.metadata.Ignore;
import com.redhat.ceylon.compiler.java.metadata.Name;
import com.redhat.ceylon.compiler.java.metadata.SatisfiedTypes;
import com.redhat.ceylon.compiler.java.metadata.Transient;
import com.redhat.ceylon.compiler.java.metadata.TypeInfo;
import com.redhat.ceylon.compiler.java.metadata.TypeParameter;
import com.redhat.ceylon.compiler.java.metadata.TypeParameters;
import com.redhat.ceylon.compiler.java.runtime.metamodel.Metamodel;
import com.redhat.ceylon.compiler.java.runtime.model.ReifiedType;
import com.redhat.ceylon.compiler.java.runtime.model.TypeDescriptor;
import com.redhat.ceylon.compiler.java.runtime.serialization.$Serialization$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;

@Ceylon(major=8)
@Class(constructors=true, extendsType="ceylon.language::Basic")
@TypeParameters(value={@TypeParameter(value="Element")})
@SatisfiedTypes(value={"ceylon.language::SearchableList<Element>", "ceylon.language::Ranged<ceylon.language::Integer,Element,ceylon.language::Array<Element>>", "ceylon.language::IndexedCorrespondenceMutator<Element>"})
@SharedAnnotation$annotation$
@FinalAnnotation$annotation$
@SerializableAnnotation$annotation$
@NativeAnnotation$annotation$(backends={})
public final class Array<Element>
implements com.redhat.ceylon.compiler.java.runtime.serialization.Serializable,
SearchableList<Element>,
IndexedCorrespondenceMutator<Element>,
ReifiedType,
Serializable {
    private static final long serialVersionUID = 8612707712992151156L;
    private static final Finished FIN = finished_.get_();
    private static final java.lang.Object[] EMPTY_ARRAY = new java.lang.Object[0];
    private static final java.lang.String[] EMPTY_STRING_ARRAY = new java.lang.String[0];
    private static final boolean[] EMPTY_BOOLEAN_ARRAY = new boolean[0];
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private static final double[] EMPTY_DOUBLE_ARRAY = new double[0];
    private static final long[] EMPTY_LONG_ARRAY = new long[0];
    private final java.lang.Object array;
    private final java.lang.Object[] objectArray;
    private final java.lang.String[] stringArray;
    private final long[] longArray;
    private final double[] doubleArray;
    private final boolean[] booleanArray;
    private final int[] intArray;
    private final byte[] byteArray;
    private final int size;
    private final TypeDescriptor $reifiedElement;
    private final ArrayType elementType;
    @Ignore
    public static final ofSize_ ofSize_ = null;
    private static long maxArraySize = runtime_.get_().getMaxArraySize();
    private static final TypeDescriptor CHAR_TYPE = TypeDescriptor.klass(java.lang.Character.class, new TypeDescriptor[0]);
    private static final TypeDescriptor BYTE_TYPE = TypeDescriptor.klass(java.lang.Byte.class, new TypeDescriptor[0]);
    private static final TypeDescriptor SHORT_TYPE = TypeDescriptor.klass(Short.class, new TypeDescriptor[0]);
    private static final TypeDescriptor INT_TYPE = TypeDescriptor.klass(java.lang.Integer.class, new TypeDescriptor[0]);
    private static final TypeDescriptor LONG_TYPE = TypeDescriptor.klass(Long.class, new TypeDescriptor[0]);
    private static final TypeDescriptor FLOAT_TYPE = TypeDescriptor.klass(java.lang.Float.class, new TypeDescriptor[0]);
    private static final TypeDescriptor DOUBLE_TYPE = TypeDescriptor.klass(Double.class, new TypeDescriptor[0]);
    private static final TypeDescriptor BOOLEAN_TYPE = TypeDescriptor.klass(java.lang.Boolean.class, new TypeDescriptor[0]);

    @Ignore
    public Array(TypeDescriptor $reifiedElement, int size, Element element) {
        this($reifiedElement, Array.createArrayWithElement($reifiedElement, size, element));
    }

    public Array(@Ignore TypeDescriptor $reifiedElement, @Name(value="elements") @TypeInfo(value="ceylon.language::Iterable<Element,ceylon.language::Null>") Iterable<? extends Element, ?> elements) {
        this($reifiedElement, Array.createArrayFromIterable($reifiedElement, elements));
    }

    @Name(value="ofSize")
    public Array(@Ignore TypeDescriptor $reifiedElement, @Ignore ofSize_ $name$, @Name(value="size") @TypeInfo(value="ceylon.language::Integer") long size, @Name(value="element") @TypeInfo(value="Element") Element element) {
        this($reifiedElement, Array.toSize(size), element);
    }

    private static int toSize(long size) {
        if (size > maxArraySize) {
            throw new AssertionError("array size must be no larger than " + maxArraySize);
        }
        if (size < 0L) {
            return 0;
        }
        return (int)size;
    }

    private static <Element> java.lang.Object createArrayFromIterable(TypeDescriptor $reifiedElement, Iterable<? extends Element, ?> elements) {
        java.lang.Object elem;
        if (elements instanceof List) {
            return Array.createArrayFromList($reifiedElement, (List)elements);
        }
        ArrayList<java.lang.Object> list = new ArrayList<java.lang.Object>();
        Iterator<Element> iterator = elements.iterator();
        while ((elem = iterator.next()) != FIN) {
            list.add(elem);
        }
        int size = list.size();
        switch (Array.elementType($reifiedElement)) {
            case CeylonString: {
                java.lang.String[] stringArray = new java.lang.String[size];
                for (int i = 0; i < size; ++i) {
                    String string = (String)list.get(i);
                    stringArray[i] = string == null ? null : string.value;
                }
                return stringArray;
            }
            case CeylonInteger: {
                long[] longPrecisionArray = new long[size];
                for (int i = 0; i < size; ++i) {
                    longPrecisionArray[i] = ((Integer)list.get((int)i)).value;
                }
                return longPrecisionArray;
            }
            case CeylonFloat: {
                double[] doublePrecisionArray = new double[size];
                for (int i = 0; i < size; ++i) {
                    doublePrecisionArray[i] = ((Float)list.get((int)i)).value;
                }
                return doublePrecisionArray;
            }
            case CeylonCharacter: {
                int[] codepointArray = new int[size];
                for (int i = 0; i < size; ++i) {
                    codepointArray[i] = ((Character)list.get((int)i)).codePoint;
                }
                return codepointArray;
            }
            case CeylonBoolean: {
                boolean[] boolArray = new boolean[size];
                for (int i = 0; i < size; ++i) {
                    boolArray[i] = ((Boolean)list.get(i)).booleanValue();
                }
                return boolArray;
            }
            case CeylonByte: {
                byte[] bitsArray = new byte[size];
                for (int i = 0; i < size; ++i) {
                    bitsArray[i] = ((Byte)list.get((int)i)).value;
                }
                return bitsArray;
            }
            case JavaBoolean: {
                boolean[] booleanArray = new boolean[size];
                for (int i = 0; i < size; ++i) {
                    booleanArray[i] = (java.lang.Boolean)list.get(i);
                }
                return booleanArray;
            }
            case JavaCharacter: {
                char[] charArray = new char[size];
                for (int i = 0; i < size; ++i) {
                    charArray[i] = ((java.lang.Character)list.get(i)).charValue();
                }
                return charArray;
            }
            case JavaFloat: {
                float[] floatArray = new float[size];
                for (int i = 0; i < size; ++i) {
                    floatArray[i] = ((java.lang.Float)list.get(i)).floatValue();
                }
                return floatArray;
            }
            case JavaDouble: {
                double[] doubleArray = new double[size];
                for (int i = 0; i < size; ++i) {
                    doubleArray[i] = (Double)list.get(i);
                }
                return doubleArray;
            }
            case JavaByte: {
                byte[] byteArray = new byte[size];
                for (int i = 0; i < size; ++i) {
                    byteArray[i] = (java.lang.Byte)list.get(i);
                }
                return byteArray;
            }
            case JavaShort: {
                short[] shortArray = new short[size];
                for (int i = 0; i < size; ++i) {
                    shortArray[i] = (Short)list.get(i);
                }
                return shortArray;
            }
            case JavaInteger: {
                int[] intArray = new int[size];
                for (int i = 0; i < size; ++i) {
                    intArray[i] = (java.lang.Integer)list.get(i);
                }
                return intArray;
            }
            case JavaLong: {
                long[] longArray = new long[size];
                for (int i = 0; i < size; ++i) {
                    longArray[i] = (Long)list.get(i);
                }
                return longArray;
            }
        }
        java.lang.Class<?> clazz = $reifiedElement.getArrayElementClass();
        java.lang.Object[] array = (java.lang.Object[])java.lang.reflect.Array.newInstance(clazz, size);
        for (int i = 0; i < size; ++i) {
            array[i] = list.get(i);
        }
        return array;
    }

    private static <Element> java.lang.Object createArrayFromList(TypeDescriptor $reifiedElement, List<? extends Element> elements) {
        if (elements instanceof Array) {
            return Array.createArrayFromArray($reifiedElement, (Array)elements);
        }
        int size = Util.toInt(elements.getSize());
        if (elements instanceof String && !$reifiedElement.containsNull() && $reifiedElement.getArrayElementClass() == Character.class) {
            int[] array = new int[size];
            java.lang.String string = elements.toString();
            int offset = 0;
            for (int i = 0; i < size; ++i) {
                int codePoint = string.codePointAt(offset);
                offset += java.lang.Character.charCount(codePoint);
                array[i] = codePoint;
            }
            return array;
        }
        switch (Array.elementType($reifiedElement)) {
            case CeylonString: {
                java.lang.String[] stringArray = new java.lang.String[size];
                for (int i = 0; i < size; ++i) {
                    String e = (String)elements.getFromFirst(i);
                    Array.checkElement(e);
                    stringArray[i] = e.value;
                }
                return stringArray;
            }
            case CeylonInteger: {
                long[] longPrecisionArray = new long[size];
                for (int i = 0; i < size; ++i) {
                    Integer e = (Integer)elements.getFromFirst(i);
                    Array.checkElement(e);
                    longPrecisionArray[i] = e.value;
                }
                return longPrecisionArray;
            }
            case CeylonFloat: {
                double[] doublePrecisionArray = new double[size];
                for (int i = 0; i < size; ++i) {
                    Float e = (Float)elements.getFromFirst(i);
                    Array.checkElement(e);
                    doublePrecisionArray[i] = e.value;
                }
                return doublePrecisionArray;
            }
            case CeylonCharacter: {
                int[] codepointArray = new int[size];
                for (int i = 0; i < size; ++i) {
                    Character e = (Character)elements.getFromFirst(i);
                    Array.checkElement(e);
                    codepointArray[i] = e.codePoint;
                }
                return codepointArray;
            }
            case CeylonBoolean: {
                boolean[] boolArray = new boolean[size];
                for (int i = 0; i < size; ++i) {
                    Boolean e = (Boolean)elements.getFromFirst(i);
                    Array.checkElement(e);
                    boolArray[i] = e.booleanValue();
                }
                return boolArray;
            }
            case CeylonByte: {
                byte[] bitsArray = new byte[size];
                for (int i = 0; i < size; ++i) {
                    Byte e = (Byte)elements.getFromFirst(i);
                    Array.checkElement(e);
                    bitsArray[i] = e.value;
                }
                return bitsArray;
            }
            case JavaBoolean: {
                boolean[] booleanArray = new boolean[size];
                for (int i = 0; i < size; ++i) {
                    java.lang.Boolean e = (java.lang.Boolean)elements.getFromFirst(i);
                    Array.checkElement(e);
                    booleanArray[i] = e;
                }
                return booleanArray;
            }
            case JavaCharacter: {
                char[] charArray = new char[size];
                for (int i = 0; i < size; ++i) {
                    java.lang.Character e = (java.lang.Character)elements.getFromFirst(i);
                    Array.checkElement(e);
                    charArray[i] = e.charValue();
                }
                return charArray;
            }
            case JavaFloat: {
                float[] floatArray = new float[size];
                for (int i = 0; i < size; ++i) {
                    java.lang.Float e = (java.lang.Float)elements.getFromFirst(i);
                    Array.checkElement(e);
                    floatArray[i] = e.floatValue();
                }
                return floatArray;
            }
            case JavaDouble: {
                double[] doubleArray = new double[size];
                for (int i = 0; i < size; ++i) {
                    Double e = (Double)elements.getFromFirst(i);
                    Array.checkElement(e);
                    doubleArray[i] = e;
                }
                return doubleArray;
            }
            case JavaByte: {
                byte[] byteArray = new byte[size];
                for (int i = 0; i < size; ++i) {
                    java.lang.Byte e = (java.lang.Byte)elements.getFromFirst(i);
                    Array.checkElement(e);
                    byteArray[i] = e;
                }
                return byteArray;
            }
            case JavaShort: {
                short[] shortArray = new short[size];
                for (int i = 0; i < size; ++i) {
                    Short e = (Short)elements.getFromFirst(i);
                    Array.checkElement(e);
                    shortArray[i] = e;
                }
                return shortArray;
            }
            case JavaInteger: {
                int[] intArray = new int[size];
                for (int i = 0; i < size; ++i) {
                    java.lang.Integer e = (java.lang.Integer)elements.getFromFirst(i);
                    Array.checkElement(e);
                    intArray[i] = e;
                }
                return intArray;
            }
            case JavaLong: {
                long[] longArray = new long[size];
                for (int i = 0; i < size; ++i) {
                    Long e = (Long)elements.getFromFirst(i);
                    Array.checkElement(e);
                    longArray[i] = e;
                }
                return longArray;
            }
        }
        java.lang.Class<?> clazz = $reifiedElement.getArrayElementClass();
        java.lang.Object[] objectArray = (java.lang.Object[])java.lang.reflect.Array.newInstance(clazz, size);
        boolean containsNull = $reifiedElement.containsNull();
        for (int i = 0; i < size; ++i) {
            Element e = elements.getFromFirst(i);
            if (!containsNull) {
                Array.checkElement(e);
            }
            objectArray[i] = e;
        }
        return objectArray;
    }

    private static void checkElement(java.lang.Object e) {
        if (e == null) {
            throw new AssertionError("missing element");
        }
    }

    private static <Element> java.lang.Object createArrayFromArray(TypeDescriptor $reifiedElement, Array<? extends Element> elements) {
        int size = Util.toInt(elements.getSize());
        java.lang.Class<?> clazz = $reifiedElement.getArrayElementClass();
        switch (Array.elementType($reifiedElement)) {
            case CeylonString: {
                java.lang.String[] stringArray = new java.lang.String[size];
                System.arraycopy(elements.array, 0, stringArray, 0, size);
                return stringArray;
            }
            case CeylonInteger: {
                long[] longPrecisionArray = new long[size];
                System.arraycopy(elements.array, 0, longPrecisionArray, 0, size);
                return longPrecisionArray;
            }
            case CeylonFloat: {
                double[] doublePrecisionArray = new double[size];
                System.arraycopy(elements.array, 0, doublePrecisionArray, 0, size);
                return doublePrecisionArray;
            }
            case CeylonCharacter: {
                int[] codepointArray = new int[size];
                System.arraycopy(elements.array, 0, codepointArray, 0, size);
                return codepointArray;
            }
            case CeylonBoolean: {
                boolean[] boolArray = new boolean[size];
                System.arraycopy(elements.array, 0, boolArray, 0, size);
                return boolArray;
            }
            case CeylonByte: {
                byte[] bitsArray = new byte[size];
                System.arraycopy(elements.array, 0, bitsArray, 0, size);
                return bitsArray;
            }
            case JavaBoolean: {
                boolean[] booleanArray = new boolean[size];
                System.arraycopy(elements.array, 0, booleanArray, 0, size);
                return booleanArray;
            }
            case JavaCharacter: {
                char[] charArray = new char[size];
                System.arraycopy(elements.array, 0, charArray, 0, size);
                return charArray;
            }
            case JavaFloat: {
                float[] floatArray = new float[size];
                System.arraycopy(elements.array, 0, floatArray, 0, size);
                return floatArray;
            }
            case JavaDouble: {
                double[] doubleArray = new double[size];
                System.arraycopy(elements.array, 0, doubleArray, 0, size);
                return doubleArray;
            }
            case JavaByte: {
                byte[] byteArray = new byte[size];
                System.arraycopy(elements.array, 0, byteArray, 0, size);
                return byteArray;
            }
            case JavaShort: {
                short[] shortArray = new short[size];
                System.arraycopy(elements.array, 0, shortArray, 0, size);
                return shortArray;
            }
            case JavaInteger: {
                int[] intArray = new int[size];
                System.arraycopy(elements.array, 0, intArray, 0, size);
                return intArray;
            }
            case JavaLong: {
                long[] longArray = new long[size];
                System.arraycopy(elements.array, 0, longArray, 0, size);
                return longArray;
            }
        }
        java.lang.Object[] objectArray = (java.lang.Object[])java.lang.reflect.Array.newInstance(clazz, size);
        java.lang.Object otherArray = elements.array;
        if (otherArray.getClass() == objectArray.getClass()) {
            System.arraycopy(otherArray, 0, objectArray, 0, size);
        } else {
            for (int i = 0; i < size; ++i) {
                objectArray[i] = elements.getFromFirst(i);
            }
        }
        return objectArray;
    }

    private static <Element> java.lang.Object createArrayWithElement(TypeDescriptor $reifiedElement, int size, Element element) {
        switch (Array.elementType($reifiedElement)) {
            case CeylonInteger: {
                long value;
                long[] longPrecisionArray = new long[size];
                if (element != null && (value = ((Integer)element).value) != 0L) {
                    Arrays.fill(longPrecisionArray, value);
                }
                return longPrecisionArray;
            }
            case JavaLong: {
                long longValue;
                long[] longArray = new long[size];
                if (element != null && (longValue = ((Long)element).longValue()) != 0L) {
                    Arrays.fill(longArray, longValue);
                }
                return longArray;
            }
            case CeylonFloat: {
                double value;
                double[] doublePrecisionArray = new double[size];
                if (element != null && (value = ((Float)element).value) != 0.0) {
                    Arrays.fill(doublePrecisionArray, value);
                }
                return doublePrecisionArray;
            }
            case JavaDouble: {
                double value;
                double[] doubleArray = new double[size];
                if (element != null && (value = ((Double)element).doubleValue()) != 0.0) {
                    Arrays.fill(doubleArray, value);
                }
                return doubleArray;
            }
            case CeylonCharacter: {
                int value;
                int[] codepointArray = new int[size];
                if (element != null && (value = ((Character)element).codePoint) != 0) {
                    Arrays.fill(codepointArray, value);
                }
                return codepointArray;
            }
            case JavaInteger: {
                int intValue;
                int[] intArray = new int[size];
                if (element != null && (intValue = ((java.lang.Integer)element).intValue()) != 0) {
                    Arrays.fill(intArray, intValue);
                }
                return intArray;
            }
            case CeylonByte: {
                byte value;
                byte[] byteArray = new byte[size];
                if (element != null && (value = ((Byte)element).value) != 0) {
                    Arrays.fill(byteArray, value);
                }
                return byteArray;
            }
            case JavaByte: {
                byte[] bitsArray = new byte[size];
                byte value = (java.lang.Byte)element;
                if (value != 0) {
                    Arrays.fill(bitsArray, value);
                }
                return bitsArray;
            }
            case CeylonBoolean: {
                boolean boolValue;
                boolean[] boolArray = new boolean[size];
                if (element != null && (boolValue = ((Boolean)element).booleanValue())) {
                    Arrays.fill(boolArray, boolValue);
                }
                return boolArray;
            }
            case JavaBoolean: {
                boolean booleanValue;
                boolean[] booleanArray = new boolean[size];
                if (element != null && (booleanValue = ((java.lang.Boolean)element).booleanValue())) {
                    Arrays.fill(booleanArray, booleanValue);
                }
                return booleanArray;
            }
            case JavaCharacter: {
                char charValue;
                char[] charArray = new char[size];
                if (element != null && (charValue = ((java.lang.Character)element).charValue()) != '\u0000') {
                    Arrays.fill(charArray, charValue);
                }
                return charArray;
            }
            case JavaShort: {
                short shortValue;
                short[] shortArray = new short[size];
                if (element != null && (shortValue = ((Short)element).shortValue()) != 0) {
                    Arrays.fill(shortArray, shortValue);
                }
                return shortArray;
            }
            case JavaFloat: {
                float floatValue;
                float[] floatArray = new float[size];
                if (element != null && (floatValue = ((java.lang.Float)element).floatValue()) != 0.0f) {
                    Arrays.fill(floatArray, floatValue);
                }
                return floatArray;
            }
            case CeylonString: {
                java.lang.Object[] stringArray = new java.lang.String[size];
                if (element != null) {
                    String string = (String)element;
                    Arrays.fill(stringArray, string.value);
                }
                return stringArray;
            }
        }
        java.lang.Class<?> elementClass = $reifiedElement.getArrayElementClass();
        java.lang.Object[] objectArray = (java.lang.Object[])java.lang.reflect.Array.newInstance(elementClass, size);
        if (element != null) {
            Arrays.fill(objectArray, element);
        }
        return objectArray;
    }

    @Ignore
    private Array(@Ignore TypeDescriptor $reifiedElement, java.lang.Object array) {
        this.$reifiedElement = $reifiedElement;
        assert (array.getClass().isArray());
        this.elementType = Array.elementType($reifiedElement);
        switch (this.elementType) {
            case Other: {
                this.objectArray = array;
                this.size = this.objectArray.length;
                this.longArray = null;
                this.doubleArray = null;
                this.intArray = null;
                this.booleanArray = null;
                this.byteArray = null;
                this.stringArray = null;
                break;
            }
            case CeylonInteger: {
                if (array == EMPTY_ARRAY) {
                    array = (java.lang.String[])EMPTY_LONG_ARRAY;
                }
                this.longArray = (long[])array;
                this.size = this.longArray.length;
                this.objectArray = null;
                this.doubleArray = null;
                this.intArray = null;
                this.booleanArray = null;
                this.byteArray = null;
                this.stringArray = null;
                break;
            }
            case CeylonFloat: {
                if (array == EMPTY_ARRAY) {
                    array = (java.lang.String[])EMPTY_DOUBLE_ARRAY;
                }
                this.doubleArray = (double[])array;
                this.size = this.doubleArray.length;
                this.objectArray = null;
                this.longArray = null;
                this.intArray = null;
                this.booleanArray = null;
                this.byteArray = null;
                this.stringArray = null;
                break;
            }
            case CeylonByte: {
                if (array == EMPTY_ARRAY) {
                    array = (java.lang.String[])EMPTY_BYTE_ARRAY;
                }
                this.byteArray = (byte[])array;
                this.intArray = null;
                this.size = this.byteArray.length;
                this.objectArray = null;
                this.longArray = null;
                this.doubleArray = null;
                this.booleanArray = null;
                this.stringArray = null;
                break;
            }
            case CeylonCharacter: {
                if (array == EMPTY_ARRAY) {
                    array = (java.lang.String[])EMPTY_INT_ARRAY;
                }
                this.intArray = (int[])array;
                this.size = this.intArray.length;
                this.objectArray = null;
                this.longArray = null;
                this.doubleArray = null;
                this.booleanArray = null;
                this.byteArray = null;
                this.stringArray = null;
                break;
            }
            case CeylonBoolean: {
                if (array == EMPTY_ARRAY) {
                    array = (java.lang.String[])EMPTY_BOOLEAN_ARRAY;
                }
                this.booleanArray = (boolean[])array;
                this.size = this.booleanArray.length;
                this.objectArray = null;
                this.longArray = null;
                this.doubleArray = null;
                this.intArray = null;
                this.byteArray = null;
                this.stringArray = null;
                break;
            }
            case CeylonString: {
                if (array == EMPTY_ARRAY) {
                    array = EMPTY_STRING_ARRAY;
                }
                this.stringArray = array;
                this.size = this.stringArray.length;
                this.objectArray = null;
                this.longArray = null;
                this.doubleArray = null;
                this.intArray = null;
                this.byteArray = null;
                this.booleanArray = null;
                break;
            }
            default: {
                this.size = java.lang.reflect.Array.getLength(array);
                this.objectArray = null;
                this.longArray = null;
                this.doubleArray = null;
                this.booleanArray = null;
                this.intArray = null;
                this.byteArray = null;
                this.stringArray = null;
            }
        }
        this.array = array;
    }

    @Ignore
    public static <T> Array<T> instance(T[] array) {
        if (array == null) {
            return null;
        }
        java.lang.Class<?> componentType = array.getClass().getComponentType();
        TypeDescriptor optionalType = TypeDescriptor.union(Null.$TypeDescriptor$, TypeDescriptor.klass(componentType, new TypeDescriptor[0]));
        return new Array(optionalType, array);
    }

    @Ignore
    public static Array<java.lang.Character> instance(char[] array) {
        if (array == null) {
            return null;
        }
        return new Array<java.lang.Character>(CHAR_TYPE, array);
    }

    @Ignore
    public static Array<java.lang.Byte> instance(byte[] array) {
        if (array == null) {
            return null;
        }
        return new Array<java.lang.Byte>(BYTE_TYPE, array);
    }

    @Ignore
    public static Array<Short> instance(short[] array) {
        if (array == null) {
            return null;
        }
        return new Array<Short>(SHORT_TYPE, array);
    }

    @Ignore
    public static Array<java.lang.Integer> instance(int[] array) {
        if (array == null) {
            return null;
        }
        return new Array<java.lang.Integer>(INT_TYPE, array);
    }

    @Ignore
    public static Array<Long> instance(long[] array) {
        if (array == null) {
            return null;
        }
        return new Array<Long>(LONG_TYPE, array);
    }

    @Ignore
    public static Array<java.lang.Float> instance(float[] array) {
        if (array == null) {
            return null;
        }
        return new Array<java.lang.Float>(FLOAT_TYPE, array);
    }

    @Ignore
    public static Array<Double> instance(double[] array) {
        if (array == null) {
            return null;
        }
        return new Array<Double>(DOUBLE_TYPE, array);
    }

    @Ignore
    public static Array<java.lang.Boolean> instance(boolean[] array) {
        if (array == null) {
            return null;
        }
        return new Array<java.lang.Boolean>(BOOLEAN_TYPE, array);
    }

    @Ignore
    public static Array<Float> instanceForFloats(double[] array) {
        if (array == null) {
            return null;
        }
        return new Array<Float>(Float.$TypeDescriptor$, array);
    }

    @Ignore
    public static Array<Boolean> instanceForBooleans(boolean[] array) {
        if (array == null) {
            return null;
        }
        return new Array<Boolean>(Boolean.$TypeDescriptor$, array);
    }

    @Ignore
    public static Array<Byte> instanceForBytes(byte[] array) {
        if (array == null) {
            return null;
        }
        return new Array<Byte>(Byte.$TypeDescriptor$, array);
    }

    @Ignore
    public static Array<Character> instanceForCodePoints(int[] array) {
        if (array == null) {
            return null;
        }
        return new Array<Character>(Character.$TypeDescriptor$, array);
    }

    @Ignore
    public static Array<Integer> instanceForIntegers(long[] array) {
        if (array == null) {
            return null;
        }
        return new Array<Integer>(Integer.$TypeDescriptor$, array);
    }

    @Override
    public Array<Element> spanFrom(@Name(value="from") Integer from) {
        return this.span(from, Integer.instance(this.size));
    }

    @Override
    public Array<Element> spanTo(@Name(value="to") Integer to) {
        return this.span(Integer.instance(0L), to);
    }

    @Override
    public Array<Element> span(@Name(value="from") Integer from, @Name(value="to") Integer to) {
        java.lang.Object[] newArray;
        boolean revert;
        long fromIndex = from.longValue();
        long toIndex = to.longValue();
        boolean bl = revert = toIndex < fromIndex;
        if (revert) {
            long swap = toIndex;
            toIndex = fromIndex;
            fromIndex = swap;
        }
        if (fromIndex < 0L) {
            fromIndex = 0L;
        }
        if (toIndex >= (long)this.size) {
            toIndex = this.size - 1;
        }
        if (fromIndex >= (long)this.size || toIndex < 0L || toIndex < fromIndex) {
            return new Array<Element>(this.$reifiedElement, EMPTY_ARRAY);
        }
        int resultFromIndex = Util.toInt(fromIndex);
        int resultToIndex = Util.toInt(toIndex + 1L);
        if (this.array instanceof char[]) {
            char[] copy = Arrays.copyOfRange((char[])this.array, resultFromIndex, resultToIndex);
            if (revert) {
                for (int i = 0; i < copy.length / 2; ++i) {
                    char temp = copy[i];
                    copy[i] = copy[copy.length - 1 - i];
                    copy[copy.length - 1 - i] = temp;
                }
            }
            newArray = copy;
        } else if (this.array instanceof byte[]) {
            byte[] copy = Arrays.copyOfRange((byte[])this.array, resultFromIndex, resultToIndex);
            if (revert) {
                for (int i = 0; i < copy.length / 2; ++i) {
                    byte temp = copy[i];
                    copy[i] = copy[copy.length - 1 - i];
                    copy[copy.length - 1 - i] = temp;
                }
            }
            newArray = copy;
        } else if (this.array instanceof short[]) {
            short[] copy = Arrays.copyOfRange((short[])this.array, resultFromIndex, resultToIndex);
            if (revert) {
                for (int i = 0; i < copy.length / 2; ++i) {
                    short temp = copy[i];
                    copy[i] = copy[copy.length - 1 - i];
                    copy[copy.length - 1 - i] = temp;
                }
            }
            newArray = copy;
        } else if (this.array instanceof int[]) {
            int[] copy = Arrays.copyOfRange((int[])this.array, resultFromIndex, resultToIndex);
            if (revert) {
                for (int i = 0; i < copy.length / 2; ++i) {
                    int temp = copy[i];
                    copy[i] = copy[copy.length - 1 - i];
                    copy[copy.length - 1 - i] = temp;
                }
            }
            newArray = copy;
        } else if (this.array instanceof long[]) {
            long[] copy = Arrays.copyOfRange((long[])this.array, resultFromIndex, resultToIndex);
            if (revert) {
                for (int i = 0; i < copy.length / 2; ++i) {
                    long temp = copy[i];
                    copy[i] = copy[copy.length - 1 - i];
                    copy[copy.length - 1 - i] = temp;
                }
            }
            newArray = copy;
        } else if (this.array instanceof float[]) {
            float[] copy = Arrays.copyOfRange((float[])this.array, resultFromIndex, resultToIndex);
            if (revert) {
                for (int i = 0; i < copy.length / 2; ++i) {
                    float temp = copy[i];
                    copy[i] = copy[copy.length - 1 - i];
                    copy[copy.length - 1 - i] = temp;
                }
            }
            newArray = copy;
        } else if (this.array instanceof double[]) {
            double[] copy = Arrays.copyOfRange((double[])this.array, resultFromIndex, resultToIndex);
            if (revert) {
                for (int i = 0; i < copy.length / 2; ++i) {
                    double temp = copy[i];
                    copy[i] = copy[copy.length - 1 - i];
                    copy[copy.length - 1 - i] = temp;
                }
            }
            newArray = copy;
        } else if (this.array instanceof boolean[]) {
            boolean[] copy = Arrays.copyOfRange((boolean[])this.array, resultFromIndex, resultToIndex);
            if (revert) {
                for (int i = 0; i < copy.length / 2; ++i) {
                    boolean temp = copy[i];
                    copy[i] = copy[copy.length - 1 - i];
                    copy[copy.length - 1 - i] = temp;
                }
            }
            newArray = copy;
        } else {
            java.lang.Object[] copy = Arrays.copyOfRange((java.lang.Object[])this.array, resultFromIndex, resultToIndex);
            if (revert) {
                for (int i = 0; i < copy.length / 2; ++i) {
                    java.lang.Object temp = copy[i];
                    copy[i] = copy[copy.length - 1 - i];
                    copy[copy.length - 1 - i] = temp;
                }
            }
            newArray = copy;
        }
        return new Array<Element>(this.$reifiedElement, newArray);
    }

    @Override
    public Array<Element> measure(@Name(value="from") Integer from, @Name(value="length") long length) {
        long fromIndex = from.longValue();
        long toIndex = fromIndex + length;
        if (fromIndex < 0L) {
            fromIndex = 0L;
        }
        if (toIndex > (long)this.size) {
            toIndex = this.size;
        }
        if (fromIndex >= (long)this.size || toIndex <= 0L) {
            return new Array<Element>(this.$reifiedElement, EMPTY_ARRAY);
        }
        int resultToIndex = Util.toInt(toIndex);
        int resultFromIndex = Util.toInt(fromIndex);
        java.lang.Object[] newArray = this.array instanceof char[] ? Arrays.copyOfRange((char[])this.array, resultFromIndex, resultToIndex) : (this.array instanceof byte[] ? (java.lang.Object[])Arrays.copyOfRange((byte[])this.array, resultFromIndex, resultToIndex) : (this.array instanceof short[] ? (java.lang.Object[])Arrays.copyOfRange((short[])this.array, resultFromIndex, resultToIndex) : (this.array instanceof int[] ? (java.lang.Object[])Arrays.copyOfRange((int[])this.array, resultFromIndex, resultToIndex) : (this.array instanceof long[] ? (java.lang.Object[])Arrays.copyOfRange((long[])this.array, resultFromIndex, resultToIndex) : (this.array instanceof float[] ? (java.lang.Object[])Arrays.copyOfRange((float[])this.array, resultFromIndex, resultToIndex) : (this.array instanceof double[] ? (java.lang.Object[])Arrays.copyOfRange((double[])this.array, resultFromIndex, resultToIndex) : (this.array instanceof boolean[] ? (java.lang.Object[])Arrays.copyOfRange((boolean[])this.array, resultFromIndex, resultToIndex) : (java.lang.Object[])Arrays.copyOfRange((java.lang.Object[])this.array, resultFromIndex, resultToIndex))))))));
        return new Array<Element>(this.$reifiedElement, newArray);
    }

    @Override
    @TypeInfo(value="ceylon.language::Null|ceylon.language::Integer")
    public Integer getLastIndex() {
        return this.getEmpty() ? null : Integer.instance(this.size - 1);
    }

    @Override
    public boolean getEmpty() {
        return this.size == 0;
    }

    @Override
    @AliasesAnnotation$annotation$(aliases={"length"})
    public long getSize() {
        return this.size;
    }

    @Override
    public boolean defines(@Name(value="index") Integer key) {
        long ind = key.longValue();
        return ind >= 0L && ind < (long)this.size;
    }

    @Override
    @TypeInfo(value="ceylon.language::Iterable<Element&ceylon.language::Object,ceylon.language::Null>")
    public Iterable<? extends Element, ? extends java.lang.Object> getCoalesced() {
        return new CoalescedArrayIterable(TypeDescriptor.intersection(this.$reifiedElement, Object.$TypeDescriptor$));
    }

    @Override
    public Iterator<Element> iterator() {
        return new ArrayIterator(this.$reifiedElement);
    }

    @Override
    @TypeInfo(value="ceylon.language::Null|Element")
    public Element getFromLast(@Name(value="index") long index) {
        if (index < 0L || index >= (long)this.size) {
            return null;
        }
        return this.unsafeItem(this.size - 1 - (int)index);
    }

    @Override
    @TypeInfo(value="ceylon.language::Null|Element")
    public Element getFromFirst(@Name(value="index") long index) {
        if (index < 0L || index >= (long)this.size) {
            return null;
        }
        int i = (int)index;
        if (this.objectArray != null) {
            return (Element)this.objectArray[i];
        }
        if (this.longArray != null) {
            return (Element)Integer.instance(this.longArray[i]);
        }
        if (this.doubleArray != null) {
            return (Element)Float.instance(this.doubleArray[i]);
        }
        if (this.byteArray != null) {
            return (Element)Byte.instance(this.byteArray[i]);
        }
        if (this.booleanArray != null) {
            return (Element)Boolean.instance(this.booleanArray[i]);
        }
        if (this.intArray != null) {
            return (Element)Character.instance(this.intArray[i]);
        }
        if (this.stringArray != null) {
            return (Element)String.instance(this.stringArray[i]);
        }
        return this.getJavaItem(i);
    }

    @Ignore
    public final Element unsafeItem(int index) {
        if (this.objectArray != null) {
            return (Element)this.objectArray[index];
        }
        if (this.longArray != null) {
            return (Element)Integer.instance(this.longArray[index]);
        }
        if (this.doubleArray != null) {
            return (Element)Float.instance(this.doubleArray[index]);
        }
        if (this.byteArray != null) {
            return (Element)Byte.instance(this.byteArray[index]);
        }
        if (this.booleanArray != null) {
            return (Element)Boolean.instance(this.booleanArray[index]);
        }
        if (this.intArray != null) {
            return (Element)Character.instance(this.intArray[index]);
        }
        if (this.stringArray != null) {
            return (Element)String.instance(this.stringArray[index]);
        }
        return this.getJavaItem(index);
    }

    private Element getJavaItem(int index) {
        switch (this.elementType) {
            case JavaLong: {
                return (Element)Long.valueOf(((long[])this.array)[index]);
            }
            case JavaDouble: {
                return (Element)Double.valueOf(((double[])this.array)[index]);
            }
            case JavaInteger: {
                return (Element)java.lang.Integer.valueOf(((int[])this.array)[index]);
            }
            case JavaByte: {
                return (Element)java.lang.Byte.valueOf(((byte[])this.array)[index]);
            }
            case JavaBoolean: {
                return (Element)java.lang.Boolean.valueOf(((boolean[])this.array)[index]);
            }
            case JavaCharacter: {
                return (Element)java.lang.Character.valueOf(((char[])this.array)[index]);
            }
            case JavaShort: {
                return (Element)Short.valueOf(((short[])this.array)[index]);
            }
            case JavaFloat: {
                return (Element)java.lang.Float.valueOf(((float[])this.array)[index]);
            }
            case JavaString: {
                return (Element)((java.lang.String[])this.array)[index];
            }
        }
        throw new AssertionError("unknown element type");
    }

    @Override
    public boolean occursAt(@Name(value="index") long ind, @Name(value="element") Element element) {
        if (ind < 0L || ind >= (long)this.size) {
            return false;
        }
        int index = (int)ind;
        if (this.objectArray != null) {
            java.lang.Object obj = this.objectArray[index];
            return obj == element || obj != null && element != null && obj.equals(element);
        }
        if (this.longArray != null) {
            return Integer.equals(this.longArray[index], element);
        }
        if (this.doubleArray != null) {
            return Float.equals(this.doubleArray[index], element);
        }
        if (this.byteArray != null) {
            return Byte.equals(this.byteArray[index], element);
        }
        if (this.booleanArray != null) {
            return Boolean.equals(this.booleanArray[index], element);
        }
        if (this.intArray != null) {
            return Character.equals(this.intArray[index], element);
        }
        if (this.stringArray != null) {
            return String.equals(this.stringArray[index], element);
        }
        return this.javaItemOccursAt(index, element);
    }

    private boolean javaItemOccursAt(int index, Element element) {
        switch (this.elementType) {
            case JavaLong: {
                if (element instanceof Long) {
                    return ((long[])this.array)[index] == (Long)element;
                }
            }
            case JavaDouble: {
                if (element instanceof Double) {
                    return ((double[])this.array)[index] == (Double)element;
                }
            }
            case JavaInteger: {
                if (element instanceof java.lang.Integer) {
                    return ((int[])this.array)[index] == (java.lang.Integer)element;
                }
            }
            case JavaByte: {
                if (element instanceof java.lang.Byte) {
                    return ((byte[])this.array)[index] == (java.lang.Byte)element;
                }
            }
            case JavaBoolean: {
                if (element instanceof java.lang.Boolean) {
                    return ((boolean[])this.array)[index] == (java.lang.Boolean)element;
                }
            }
            case JavaCharacter: {
                if (element instanceof java.lang.Character) {
                    return ((char[])this.array)[index] == ((java.lang.Character)element).charValue();
                }
            }
            case JavaShort: {
                if (element instanceof Short) {
                    return ((short[])this.array)[index] == (Short)element;
                }
            }
            case JavaFloat: {
                if (element instanceof java.lang.Float) {
                    return ((float[])this.array)[index] == ((java.lang.Float)element).floatValue();
                }
            }
            case JavaString: {
                if (!(element instanceof java.lang.String)) break;
                return ((java.lang.String[])this.array)[index].equals(element);
            }
        }
        return false;
    }

    @Override
    @TypeInfo(declaredVoid=true, value="ceylon.language::Anything")
    public java.lang.Object set(@Name(value="index") @TypeInfo(value="ceylon.language::Integer") long index, @Name(value="element") @TypeInfo(value="Element") Element element) {
        if (index < 0L) {
            throw new AssertionError("array index " + index + " may not be negative");
        }
        if (index >= (long)this.size) {
            throw new AssertionError("array index " + index + " must be less than size of array " + this.size);
        }
        int idx = (int)index;
        if (this.objectArray != null) {
            this.objectArray[idx] = element;
        } else if (this.longArray != null) {
            this.longArray[idx] = ((Integer)element).value;
        } else if (this.doubleArray != null) {
            this.doubleArray[idx] = ((Float)element).value;
        } else if (this.byteArray != null) {
            this.byteArray[idx] = ((Byte)element).value;
        } else if (this.booleanArray != null) {
            this.booleanArray[idx] = ((Boolean)element).booleanValue();
        } else if (this.intArray != null) {
            this.intArray[idx] = ((Character)element).codePoint;
        } else if (this.stringArray != null) {
            this.stringArray[idx] = ((String)element).value;
        } else {
            this.setJavaItem(element, idx);
        }
        return null;
    }

    public void swap(@Name(value="i") @TypeInfo(value="ceylon.language::Integer") long p, @Name(value="j") @TypeInfo(value="ceylon.language::Integer") long q) {
        if (p < 0L || q < 0L) {
            throw new AssertionError("array index may not be negative");
        }
        if (p >= (long)this.size || q >= (long)this.size) {
            throw new AssertionError("array index must be less than size of array " + this.size);
        }
        int i = (int)p;
        int j = (int)q;
        if (i == j) {
            return;
        }
        if (this.array instanceof java.lang.Object[]) {
            java.lang.Object[] objectArray = (java.lang.Object[])this.array;
            java.lang.Object x = objectArray[i];
            java.lang.Object y = objectArray[j];
            objectArray[j] = x;
            objectArray[i] = y;
        } else if (this.array instanceof long[]) {
            long[] longArray = (long[])this.array;
            long x = longArray[i];
            long y = longArray[j];
            longArray[j] = x;
            longArray[i] = y;
        } else if (this.array instanceof int[]) {
            int[] intArray = (int[])this.array;
            int x = intArray[i];
            int y = intArray[j];
            intArray[j] = x;
            intArray[i] = y;
        } else if (this.array instanceof short[]) {
            short[] shortArray = (short[])this.array;
            short x = shortArray[i];
            short y = shortArray[j];
            shortArray[j] = x;
            shortArray[i] = y;
        } else if (this.array instanceof byte[]) {
            byte[] byteArray = (byte[])this.array;
            byte x = byteArray[i];
            byte y = byteArray[j];
            byteArray[j] = x;
            byteArray[i] = y;
        } else if (this.array instanceof boolean[]) {
            boolean[] booleanArray = (boolean[])this.array;
            boolean x = booleanArray[i];
            boolean y = booleanArray[j];
            booleanArray[j] = x;
            booleanArray[i] = y;
        } else if (this.array instanceof double[]) {
            double[] doubleArray = (double[])this.array;
            double x = doubleArray[i];
            double y = doubleArray[j];
            doubleArray[j] = x;
            doubleArray[i] = y;
        } else if (this.array instanceof float[]) {
            float[] floatArray = (float[])this.array;
            float x = floatArray[i];
            float y = floatArray[j];
            floatArray[j] = x;
            floatArray[i] = y;
        } else {
            throw new AssertionError("impossible array type");
        }
    }

    public void move(@Name(value="from") @TypeInfo(value="ceylon.language::Integer") long f, @Name(value="to") @TypeInfo(value="ceylon.language::Integer") long t) {
        int destPos;
        int srcPos;
        int len;
        if (f < 0L || t < 0L) {
            throw new AssertionError("array index may not be negative");
        }
        if (f >= (long)this.size || t >= (long)this.size) {
            throw new AssertionError("array index must be less than size of array " + this.size);
        }
        int from = (int)f;
        int to = (int)t;
        if (from == to) {
            return;
        }
        if (from > to) {
            len = from - to;
            srcPos = to;
            destPos = to + 1;
        } else {
            len = to - from;
            srcPos = from + 1;
            destPos = from;
        }
        if (this.array instanceof java.lang.Object[]) {
            java.lang.Object[] objectArray = (java.lang.Object[])this.array;
            java.lang.Object x = objectArray[from];
            System.arraycopy(objectArray, srcPos, objectArray, destPos, len);
            objectArray[to] = x;
        } else if (this.array instanceof long[]) {
            long[] longArray = (long[])this.array;
            long x = longArray[from];
            System.arraycopy(longArray, srcPos, longArray, destPos, len);
            longArray[to] = x;
        } else if (this.array instanceof int[]) {
            int[] intArray = (int[])this.array;
            int x = intArray[from];
            System.arraycopy(intArray, srcPos, intArray, destPos, len);
            intArray[to] = x;
        } else if (this.array instanceof short[]) {
            short[] shortArray = (short[])this.array;
            short x = shortArray[from];
            System.arraycopy(shortArray, srcPos, shortArray, destPos, len);
            shortArray[to] = x;
        } else if (this.array instanceof byte[]) {
            byte[] byteArray = (byte[])this.array;
            byte x = byteArray[from];
            System.arraycopy(byteArray, srcPos, byteArray, destPos, len);
            byteArray[to] = x;
        } else if (this.array instanceof boolean[]) {
            boolean[] booleanArray = (boolean[])this.array;
            boolean x = booleanArray[from];
            System.arraycopy(booleanArray, srcPos, booleanArray, destPos, len);
            booleanArray[to] = x;
        } else if (this.array instanceof double[]) {
            double[] doubleArray = (double[])this.array;
            double x = doubleArray[from];
            System.arraycopy(doubleArray, srcPos, doubleArray, destPos, len);
            doubleArray[to] = x;
        } else if (this.array instanceof float[]) {
            float[] floatArray = (float[])this.array;
            float x = floatArray[from];
            System.arraycopy(floatArray, srcPos, floatArray, destPos, len);
            floatArray[to] = x;
        } else {
            throw new AssertionError("impossible array type");
        }
    }

    private void setJavaItem(Element element, int idx) {
        switch (this.elementType) {
            case JavaLong: {
                ((long[])this.array)[idx] = (Long)element;
                break;
            }
            case JavaDouble: {
                ((double[])this.array)[idx] = (Double)element;
                break;
            }
            case JavaInteger: {
                ((int[])this.array)[idx] = (java.lang.Integer)element;
                break;
            }
            case JavaByte: {
                ((byte[])this.array)[idx] = (java.lang.Byte)element;
                break;
            }
            case JavaBoolean: {
                ((boolean[])this.array)[idx] = (java.lang.Boolean)element;
                break;
            }
            case JavaCharacter: {
                ((char[])this.array)[idx] = ((java.lang.Character)element).charValue();
                break;
            }
            case JavaShort: {
                ((short[])this.array)[idx] = (Short)element;
                break;
            }
            case JavaFloat: {
                ((float[])this.array)[idx] = ((java.lang.Float)element).floatValue();
                break;
            }
            case JavaString: {
                ((java.lang.String[])this.array)[idx] = (java.lang.String)element;
                break;
            }
            default: {
                throw new AssertionError("unknown element type");
            }
        }
    }

    @Override
    public Array<Element> $clone() {
        return new Array<Element>(this.$reifiedElement, this.copyArray());
    }

    private java.lang.Object copyArray() {
        if (this.array instanceof java.lang.Object[]) {
            return Arrays.copyOf((java.lang.Object[])this.array, ((java.lang.Object[])this.array).length);
        }
        if (this.array instanceof long[]) {
            return Arrays.copyOf((long[])this.array, ((long[])this.array).length);
        }
        if (this.array instanceof double[]) {
            return Arrays.copyOf((double[])this.array, ((double[])this.array).length);
        }
        if (this.array instanceof boolean[]) {
            return Arrays.copyOf((boolean[])this.array, ((boolean[])this.array).length);
        }
        if (this.array instanceof int[]) {
            return Arrays.copyOf((int[])this.array, ((int[])this.array).length);
        }
        if (this.array instanceof byte[]) {
            return Arrays.copyOf((byte[])this.array, ((byte[])this.array).length);
        }
        if (this.array instanceof short[]) {
            return Arrays.copyOf((short[])this.array, ((short[])this.array).length);
        }
        if (this.array instanceof float[]) {
            return Arrays.copyOf((float[])this.array, ((float[])this.array).length);
        }
        if (this.array instanceof char[]) {
            return Arrays.copyOf((char[])this.array, ((char[])this.array).length);
        }
        throw new AssertionError("impossible array type");
    }

    @Ignore
    public java.lang.Object toArray() {
        return this.array;
    }

    @Override
    public boolean contains(@Name(value="element") @TypeInfo(value="ceylon.language::Object") java.lang.Object element) {
        for (int i = 0; i < this.size; ++i) {
            Element elem = this.unsafeItem(i);
            if (elem == null || !elem.equals(element)) continue;
            return true;
        }
        return false;
    }

    @Override
    public long count(@Name(value="selecting") @FunctionalParameter(value="(element)") @TypeInfo(value="ceylon.language::Boolean(Element)") Callable<? extends Boolean> selecting) {
        int count = 0;
        for (int i = 0; i < this.size; ++i) {
            if (!selecting.$call$((java.lang.Object)this.unsafeItem(i)).booleanValue()) continue;
            ++count;
        }
        return count;
    }

    @Override
    public boolean any(@Name(value="selecting") @FunctionalParameter(value="(element)") @TypeInfo(value="ceylon.language::Boolean(Element)") Callable<? extends Boolean> selecting) {
        for (int i = 0; i < this.size; ++i) {
            if (!selecting.$call$((java.lang.Object)this.unsafeItem(i)).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean every(@Name(value="selecting") @FunctionalParameter(value="(element)") @TypeInfo(value="ceylon.language::Boolean(Element)") Callable<? extends Boolean> selecting) {
        for (int i = 0; i < this.size; ++i) {
            if (selecting.$call$((java.lang.Object)this.unsafeItem(i)).booleanValue()) continue;
            return false;
        }
        return true;
    }

    @Override
    @TypeInfo(value="ceylon.language::Null|Element")
    public Element find(@Name(value="selecting") @FunctionalParameter(value="(element)") @TypeInfo(value="ceylon.language::Boolean(Element&ceylon.language::Object)") Callable<? extends Boolean> selecting) {
        for (int i = 0; i < this.size; ++i) {
            Element elem = this.unsafeItem(i);
            if (elem == null || !selecting.$call$((java.lang.Object)elem).booleanValue()) continue;
            return elem;
        }
        return null;
    }

    @Override
    @TypeInfo(value="ceylon.language::Null|Element")
    public Element findLast(@Name(value="selecting") @FunctionalParameter(value="(element)") @TypeInfo(value="ceylon.language::Boolean(Element&ceylon.language::Object)") Callable<? extends Boolean> selecting) {
        for (int i = this.size - 1; i >= 0; --i) {
            Element elem = this.unsafeItem(i);
            if (elem == null || !selecting.$call$((java.lang.Object)elem).booleanValue()) continue;
            return elem;
        }
        return null;
    }

    @Override
    @TypeInfo(value="ceylon.language::Integer?")
    public Integer firstIndexWhere(@Name(value="selecting") @FunctionalParameter(value="(element)") @TypeInfo(value="ceylon.language::Boolean(Element&ceylon.language::Object)") Callable<? extends Boolean> selecting) {
        for (int i = 0; i < this.size; ++i) {
            Element elem = this.unsafeItem(i);
            if (elem == null || !selecting.$call$((java.lang.Object)elem).booleanValue()) continue;
            return Integer.instance(i);
        }
        return null;
    }

    @Override
    @TypeInfo(value="ceylon.language::Integer?")
    public Integer lastIndexWhere(@Name(value="selecting") @FunctionalParameter(value="(element)") @TypeInfo(value="ceylon.language::Boolean(Element&ceylon.language::Object)") Callable<? extends Boolean> selecting) {
        for (int i = this.size - 1; i >= 0; --i) {
            Element elem = this.unsafeItem(i);
            if (elem == null || !selecting.$call$((java.lang.Object)elem).booleanValue()) continue;
            return Integer.instance(i);
        }
        return null;
    }

    @Override
    @TypeInfo(value="ceylon.language::Null|ceylon.language::Entry<ceylon.language::Integer,Element&ceylon.language::Object>")
    public Entry<? extends Integer, ? extends Element> locate(@Name(value="selecting") @FunctionalParameter(value="(element)") @TypeInfo(value="ceylon.language::Boolean(Element&ceylon.language::Object)") Callable<? extends Boolean> selecting) {
        for (int i = 0; i < this.size; ++i) {
            Element elem = this.unsafeItem(i);
            if (elem == null || !selecting.$call$((java.lang.Object)elem).booleanValue()) continue;
            return new Entry<Integer, Element>(Integer.$TypeDescriptor$, this.$reifiedElement, Integer.instance(i), elem);
        }
        return null;
    }

    @Override
    @TypeInfo(value="ceylon.language::Null|ceylon.language::Entry<ceylon.language::Integer,Element&ceylon.language::Object>")
    public Entry<? extends Integer, ? extends Element> locateLast(@Name(value="selecting") @FunctionalParameter(value="(element)") @TypeInfo(value="ceylon.language::Boolean(Element&ceylon.language::Object)") Callable<? extends Boolean> selecting) {
        for (int i = this.size - 1; i >= 0; --i) {
            Element elem = this.unsafeItem(i);
            if (elem == null || !selecting.$call$((java.lang.Object)elem).booleanValue()) continue;
            return new Entry<Integer, Element>(Integer.$TypeDescriptor$, this.$reifiedElement, Integer.instance(i), elem);
        }
        return null;
    }

    @Override
    @TypeInfo(value="Result|Element|ceylon.language::Null")
    public <Result> java.lang.Object reduce(@Ignore TypeDescriptor $reifiedResult, @Name(value="accumulating") @FunctionalParameter(value="(partial,element)") @TypeInfo(value="ceylon.language::Callable<Result,ceylon.language::Tuple<Result|Element,Result|Element,ceylon.language::Tuple<Element,Element,ceylon.language::Empty>>>") Callable<? extends Result> accumulating) {
        if (this.size == 0) {
            return null;
        }
        java.lang.Object partial = this.unsafeItem(0);
        for (int i = 1; i < this.size; ++i) {
            partial = accumulating.$call$(partial, (java.lang.Object)this.unsafeItem(i));
        }
        return partial;
    }

    @Override
    @Annotations(value={@Annotation(value="actual")})
    @TypeInfo(value="ceylon.language::Null|Element")
    public Element getFirst() {
        if (this.size > 0) {
            return this.unsafeItem(0);
        }
        return null;
    }

    @Override
    @Annotations(value={@Annotation(value="actual")})
    @TypeInfo(value="ceylon.language::Null|Element")
    public Element getLast() {
        return this.size > 0 ? (Element)this.unsafeItem(this.size - 1) : null;
    }

    @Override
    @TypeInfo(value="ceylon.language::Sequential<Element>")
    public Sequential<? extends Element> sort(@Name(value="comparing") @FunctionalParameter(value="(x,y)") @TypeInfo(value="ceylon.language::Comparison(Element,Element)") Callable<? extends Comparison> comparing) {
        if (this.getEmpty()) {
            return empty_.get_();
        }
        List clone = this.$clone();
        ((Array)clone).sortInPlace(comparing);
        return new ArraySequence(this.$reifiedElement, clone);
    }

    @Override
    @Annotations(value={@Annotation(value="actual")})
    @TypeInfo(value="ceylon.language::Iterable<Element,ceylon.language::Null>")
    public Iterable<? extends Element, ?> skip(@Name(value="skipping") long skipping) {
        int intSkip = Util.toInt(skipping);
        int length = this.size;
        if (skipping <= 0L) {
            return this;
        }
        return new ArrayIterable(this.array, intSkip, Math.max(0, length - intSkip), 1);
    }

    @Override
    @Annotations(value={@Annotation(value="actual")})
    @TypeInfo(value="ceylon.language::Iterable<Element,ceylon.language::Null>")
    public Iterable<? extends Element, ?> take(@Name(value="taking") long taking) {
        int length = this.size;
        if (taking >= (long)length) {
            return this;
        }
        return new ArrayIterable(this.array, 0, Math.max(Util.toInt(taking), 0), 1);
    }

    @Override
    @Annotations(value={@Annotation(value="actual")})
    @TypeInfo(value="ceylon.language::Iterable<Element,ceylon.language::Null>")
    public Iterable<? extends Element, ?> by(@Name(value="step") long step) {
        if (step <= 0L) {
            throw new AssertionError("step size must be greater than zero");
        }
        if (step == 1L) {
            return this;
        }
        return new ArrayIterable(this.array, 0, Util.toInt(((long)this.size + step - 1L) / step), Util.toInt(step));
    }

    @Override
    @TypeInfo(value="ceylon.language::Sequence<Element>|ceylon.language::Empty")
    public Sequential<? extends Element> sequence() {
        if (this.getEmpty()) {
            return empty_.get_();
        }
        return new ArraySequence<Element>(this.$reifiedElement, new Array<Element>(this.$reifiedElement, this.copyArray()));
    }

    @Ignore
    public long copyTo$sourcePosition(Array<? super Element> destination) {
        return 0L;
    }

    @Ignore
    public long copyTo$destinationPosition(Array<? super Element> destination, long sourcePosition) {
        return 0L;
    }

    @Ignore
    public long copyTo$length(Array<? super Element> destination, long sourcePosition, long destinationPosition) {
        return Math.min((long)this.size - sourcePosition, destination.getSize() - destinationPosition);
    }

    @Ignore
    public void copyTo(Array<? super Element> destination) {
        this.copyTo(destination, 0L, 0L);
    }

    @Ignore
    public void copyTo(Array<? super Element> destination, long sourcePosition) {
        this.copyTo(destination, sourcePosition, 0L);
    }

    @Ignore
    public void copyTo(Array<? super Element> destination, long sourcePosition, long destinationPosition) {
        this.copyTo(destination, sourcePosition, destinationPosition, this.copyTo$length(destination, sourcePosition, destinationPosition));
    }

    public void copyTo(@Name(value="destination") @TypeInfo(value="ceylon.language::Array<in Element>") Array<? super Element> destination, @Name(value="sourcePosition") @Defaulted long sourcePosition, @Name(value="destinationPosition") @Defaulted long destinationPosition, @Name(value="length") @Defaulted long length) {
        if (length > 0L) {
            try {
                if (this.elementType == destination.elementType) {
                    System.arraycopy(this.array, Util.toInt(sourcePosition), destination.array, Util.toInt(destinationPosition), Util.toInt(length));
                } else {
                    java.lang.Object[] dst = (java.lang.Object[])destination.array;
                    int srcIndex = Util.toInt(sourcePosition);
                    int dstIndex = Util.toInt(destinationPosition);
                    int len = Util.toInt(length);
                    if (srcIndex < 0 || dstIndex < 0 || (long)(srcIndex + len) > this.getSize() || (long)(dstIndex + len) > destination.getSize()) {
                        throw new AssertionError("Index out of bounds");
                    }
                    while (len-- > 0) {
                        dst[dstIndex++] = this.getFromFirst(srcIndex++);
                    }
                }
            }
            catch (IndexOutOfBoundsException iob) {
                throw new AssertionError(iob.getMessage());
            }
        }
    }

    @Ignore
    @Deprecated
    public void copyTo(Array<Element> destination, int sourcePosition) {
        this.copyTo(destination, (long)sourcePosition, 0L);
    }

    @Ignore
    @Deprecated
    public void copyTo(Array<Element> destination, int sourcePosition, int destinationPosition) {
        this.copyTo(destination, (long)sourcePosition, (long)destinationPosition);
    }

    @Ignore
    @Deprecated
    public void copyTo(Array<Element> destination, int sourcePosition, int destinationPosition, int length) {
        this.copyTo(destination, (long)sourcePosition, (long)destinationPosition, (long)length);
    }

    @Override
    @Ignore
    public TypeDescriptor $getType$() {
        return TypeDescriptor.klass(Array.class, this.$reifiedElement);
    }

    @Override
    @TypeInfo(declaredVoid=true, value="ceylon.language::Anything")
    public java.lang.Object each(@Name(value="step") @FunctionalParameter(value="!(element)") @TypeInfo(value="ceylon.language::Anything(Element)") Callable<? extends java.lang.Object> step) {
        for (int i = 0; i < this.size; ++i) {
            step.$call$((java.lang.Object)this.unsafeItem(i));
        }
        return null;
    }

    @Override
    @TypeInfo(value="{Element*}")
    public Iterable<? extends Element, ? extends java.lang.Object> filter(final @Name(value="selecting") @FunctionalParameter(value="(element)") @TypeInfo(value="ceylon.language::Boolean(Element)") Callable<? extends Boolean> selecting) {
        return new BaseIterable<Element, java.lang.Object>(this.$reifiedElement, Null.$TypeDescriptor$){

            @Override
            public Iterator<? extends Element> iterator() {
                return new BaseIterator<Element>(Array.this.$reifiedElement){
                    int index;
                    {
                        this.index = 0;
                    }

                    @Override
                    public java.lang.Object next() {
                        while (this.index < Array.this.size) {
                            java.lang.Object element;
                            if (!((Boolean)selecting.$call$(element = Array.this.unsafeItem(this.index++))).booleanValue()) continue;
                            return element;
                        }
                        return finished_.get_();
                    }
                };
            }
        };
    }

    @Override
    @TypeInfo(value="{ceylon.language::Integer*}")
    public Iterable<? extends Integer, ? extends java.lang.Object> indexesWhere(final @Name(value="selecting") @FunctionalParameter(value="(element)") @TypeInfo(value="ceylon.language::Boolean(Element&ceylon.language::Object)") Callable<? extends Boolean> selecting) {
        return new BaseIterable<Integer, java.lang.Object>(Integer.$TypeDescriptor$, Null.$TypeDescriptor$){

            @Override
            public Iterator<? extends Integer> iterator() {
                return new BaseIterator<Integer>(Integer.$TypeDescriptor$){
                    int index;
                    {
                        this.index = 0;
                    }

                    @Override
                    public java.lang.Object next() {
                        while (this.index < Array.this.size) {
                            java.lang.Object element = Array.this.unsafeItem(this.index);
                            if (((Boolean)selecting.$call$(element)).booleanValue()) {
                                return Integer.instance(this.index++);
                            }
                            ++this.index;
                        }
                        return finished_.get_();
                    }
                };
            }
        };
    }

    @Override
    @TypeInfo(value="{ceylon.language::Entry<ceylon.language::Integer,Element>*}")
    public Iterable<? extends Entry<? extends Integer, ? extends Element>, ? extends java.lang.Object> locations(final @Name(value="selecting") @FunctionalParameter(value="(element)") @TypeInfo(value="ceylon.language::Boolean(Element&ceylon.language::Object)") Callable<? extends Boolean> selecting) {
        final TypeDescriptor klass = TypeDescriptor.klass(Entry.class, Integer.$TypeDescriptor$, this.$reifiedElement);
        return new BaseIterable<Entry<? extends Integer, ? extends Element>, java.lang.Object>(klass, Null.$TypeDescriptor$){

            @Override
            public Iterator<? extends Entry<? extends Integer, ? extends Element>> iterator() {
                return new BaseIterator<Entry<? extends Integer, ? extends Element>>(klass){
                    int index;
                    {
                        this.index = 0;
                    }

                    @Override
                    public java.lang.Object next() {
                        while (this.index < Array.this.size) {
                            java.lang.Object element = Array.this.unsafeItem(this.index);
                            if (((Boolean)selecting.$call$(element)).booleanValue()) {
                                return new Entry(Integer.$TypeDescriptor$, Array.this.$reifiedElement, Integer.instance(this.index++), element);
                            }
                            ++this.index;
                        }
                        return finished_.get_();
                    }
                };
            }
        };
    }

    @Override
    @TypeInfo(value="{ceylon.language::Integer*}")
    public Iterable<? extends Integer, ? extends java.lang.Object> occurrences(final @Name(value="element") Element element, final @Defaulted @Name(value="from") long from, final @Defaulted @Name(value="length") long length) {
        return new BaseIterable<Integer, Object>(Integer.$TypeDescriptor$, Null.$TypeDescriptor$){

            @Override
            public Iterator<? extends Integer> iterator() {
                return new BaseIterator<Integer>(Integer.$TypeDescriptor$){
                    long index;
                    {
                        this.index = from;
                    }

                    @Override
                    public java.lang.Object next() {
                        while (this.index < (long)Array.this.size && this.index < from + length) {
                            if (Array.this.occursAt(this.index, element)) {
                                return Integer.instance(this.index++);
                            }
                            ++this.index;
                        }
                        return finished_.get_();
                    }
                };
            }

            @Override
            public long getSize() {
                int size = 0;
                for (long index = from; index < (long)Array.this.size && index < from + length; ++index) {
                    if (!Array.this.occursAt(index, element)) continue;
                    ++size;
                }
                return size;
            }
        };
    }

    @Override
    @TypeInfo(value="ceylon.language::Null|ceylon.language::Integer")
    public Integer firstOccurrence(@Name(value="element") Element element, @Defaulted @Name(value="from") long from, @Defaulted @Name(value="length") long length) {
        if (from >= (long)this.size || length <= 0L) {
            return null;
        }
        if (from < 0L) {
            length += from;
            from = 0L;
        }
        for (int i = (int)from; i < this.size && (long)i < from + length; ++i) {
            if (!this.occursAt(i, element)) continue;
            return Integer.instance(i);
        }
        return null;
    }

    @Override
    @TypeInfo(value="ceylon.language::Null|ceylon.language::Integer")
    public Integer lastOccurrence(@Name(value="element") Element element, @Defaulted @Name(value="from") long from, @Defaulted @Name(value="length") long length) {
        if (from >= (long)this.size || length <= 0L) {
            return null;
        }
        if (from < 0L) {
            length += from;
            from = 0L;
        }
        for (int i = (int)from; i < this.size && (long)i < from + length; ++i) {
            int j = this.size - 1 - i;
            if (!this.occursAt(j, element)) continue;
            return Integer.instance(j);
        }
        return null;
    }

    @Override
    public boolean occurs(@Name(value="element") Element element, @Defaulted @Name(value="from") long from, @Defaulted @Name(value="length") long length) {
        if (from >= (long)this.size || length <= 0L) {
            return false;
        }
        if (from < 0L) {
            length += from;
            from = 0L;
        }
        for (int i = (int)from; i < this.size && (long)i < from + length; ++i) {
            if (!this.occursAt(i, element)) continue;
            return true;
        }
        return false;
    }

    public void reverseInPlace() {
        if (this.array instanceof java.lang.Object[]) {
            for (int index = 0; index < this.size / 2; ++index) {
                java.lang.Object[] arr = (java.lang.Object[])this.array;
                java.lang.Object swap = arr[index];
                int indexFromLast = this.size - index - 1;
                arr[index] = arr[indexFromLast];
                arr[indexFromLast] = swap;
            }
        } else if (this.array instanceof long[]) {
            for (int index = 0; index < this.size / 2; ++index) {
                long[] arr = (long[])this.array;
                long swap = arr[index];
                int indexFromLast = this.size - index - 1;
                arr[index] = arr[indexFromLast];
                arr[indexFromLast] = swap;
            }
        } else if (this.array instanceof int[]) {
            for (int index = 0; index < this.size / 2; ++index) {
                int[] arr = (int[])this.array;
                int swap = arr[index];
                int indexFromLast = this.size - index - 1;
                arr[index] = arr[indexFromLast];
                arr[indexFromLast] = swap;
            }
        } else if (this.array instanceof short[]) {
            for (int index = 0; index < this.size / 2; ++index) {
                short[] arr = (short[])this.array;
                short swap = arr[index];
                int indexFromLast = this.size - index - 1;
                arr[index] = arr[indexFromLast];
                arr[indexFromLast] = swap;
            }
        } else if (this.array instanceof byte[]) {
            for (int index = 0; index < this.size / 2; ++index) {
                byte[] arr = (byte[])this.array;
                byte swap = arr[index];
                int indexFromLast = this.size - index - 1;
                arr[index] = arr[indexFromLast];
                arr[indexFromLast] = swap;
            }
        } else if (this.array instanceof double[]) {
            for (int index = 0; index < this.size / 2; ++index) {
                double[] arr = (double[])this.array;
                double swap = arr[index];
                int indexFromLast = this.size - index - 1;
                arr[index] = arr[indexFromLast];
                arr[indexFromLast] = swap;
            }
        } else if (this.array instanceof float[]) {
            for (int index = 0; index < this.size / 2; ++index) {
                float[] arr = (float[])this.array;
                float swap = arr[index];
                int indexFromLast = this.size - index - 1;
                arr[index] = arr[indexFromLast];
                arr[indexFromLast] = swap;
            }
        } else if (this.array instanceof boolean[]) {
            for (int index = 0; index < this.size / 2; ++index) {
                boolean[] arr = (boolean[])this.array;
                boolean swap = arr[index];
                int indexFromLast = this.size - index - 1;
                arr[index] = arr[indexFromLast];
                arr[indexFromLast] = swap;
            }
        } else if (this.array instanceof char[]) {
            for (int index = 0; index < this.size / 2; ++index) {
                char[] arr = (char[])this.array;
                char swap = arr[index];
                int indexFromLast = this.size - index - 1;
                arr[index] = arr[indexFromLast];
                arr[indexFromLast] = swap;
            }
        } else {
            throw new AssertionError("illegal array type");
        }
    }

    public void sortInPlace(final @Name(value="comparing") @FunctionalParameter(value="(x,y)") @TypeInfo(value="ceylon.language::Callable<ceylon.language::Comparison,ceylon.language::Tuple<Element,Element,ceylon.language::Tuple<Element,Element,ceylon.language::Empty>>>") Callable<? extends Comparison> comparing) {
        AbstractList list = new AbstractList<Element>(){

            @Override
            public Element get(int index) {
                return Array.this.unsafeItem(index);
            }

            @Override
            public Element set(int index, Element element) {
                Array.this.set((long)index, element);
                return null;
            }

            @Override
            public int size() {
                return Array.this.size;
            }

            @Override
            public java.lang.Object[] toArray() {
                if (Array.this.array instanceof java.lang.Object[] && !(Array.this.array instanceof java.lang.String[])) {
                    return (java.lang.Object[])Array.this.array;
                }
                int size = this.size();
                java.lang.Object[] result = new java.lang.Object[size];
                for (int i = 0; i < size; ++i) {
                    result[i] = Array.this.unsafeItem(i);
                }
                return result;
            }
        };
        Comparator comparator = new Comparator<Element>(){

            @Override
            public int compare(Element x, Element y) {
                Comparison result = (Comparison)comparing.$call$(x, y);
                if (result == larger_.get_()) {
                    return 1;
                }
                if (result == smaller_.get_()) {
                    return -1;
                }
                return 0;
            }
        };
        Collections.sort(list, comparator);
    }

    private static ArrayType elementType(TypeDescriptor $reifiedElement) {
        if ($reifiedElement.containsNull()) {
            return ArrayType.Other;
        }
        java.lang.Class<?> arrayElementClass = $reifiedElement.getArrayElementClass();
        if (arrayElementClass == Integer.class) {
            return ArrayType.CeylonInteger;
        }
        if (arrayElementClass == Long.class) {
            return ArrayType.JavaLong;
        }
        if (arrayElementClass == Float.class) {
            return ArrayType.CeylonFloat;
        }
        if (arrayElementClass == Double.class) {
            return ArrayType.JavaDouble;
        }
        if (arrayElementClass == Character.class) {
            return ArrayType.CeylonCharacter;
        }
        if (arrayElementClass == java.lang.Integer.class) {
            return ArrayType.JavaInteger;
        }
        if (arrayElementClass == Byte.class) {
            return ArrayType.CeylonByte;
        }
        if (arrayElementClass == java.lang.Byte.class) {
            return ArrayType.JavaByte;
        }
        if (arrayElementClass == Boolean.class) {
            return ArrayType.CeylonBoolean;
        }
        if (arrayElementClass == java.lang.Boolean.class) {
            return ArrayType.JavaBoolean;
        }
        if (arrayElementClass == java.lang.Character.class) {
            return ArrayType.JavaCharacter;
        }
        if (arrayElementClass == Short.class) {
            return ArrayType.JavaShort;
        }
        if (arrayElementClass == java.lang.Float.class) {
            return ArrayType.JavaFloat;
        }
        if (arrayElementClass == String.class) {
            return ArrayType.CeylonString;
        }
        if (arrayElementClass == java.lang.String.class) {
            return ArrayType.JavaString;
        }
        return ArrayType.Other;
    }

    @Override
    public boolean equals(@Name(value="that") java.lang.Object that) {
        if (that instanceof Array) {
            java.lang.Object x = ((Array)that).array;
            java.lang.Object y = this.array;
            if (x instanceof double[] && y instanceof double[]) {
                return Arrays.equals((double[])x, (double[])y);
            }
            if (x instanceof float[] && y instanceof float[]) {
                return Arrays.equals((float[])x, (float[])y);
            }
            if (x instanceof long[] && y instanceof long[]) {
                return Arrays.equals((long[])x, (long[])y);
            }
            if (x instanceof int[] && y instanceof int[]) {
                return Arrays.equals((int[])x, (int[])y);
            }
            if (x instanceof short[] && y instanceof short[]) {
                return Arrays.equals((short[])x, (short[])y);
            }
            if (x instanceof byte[] && y instanceof byte[]) {
                return Arrays.equals((byte[])x, (byte[])y);
            }
            if (x instanceof boolean[] && y instanceof boolean[]) {
                return Arrays.equals((boolean[])x, (boolean[])y);
            }
            if (x instanceof char[] && y instanceof char[]) {
                return Arrays.equals((char[])x, (char[])y);
            }
            if (x instanceof Object[] && y instanceof Object[]) {
                return Arrays.equals((Object[])x, (Object[])y);
            }
        }
        return this.$ceylon$language$List$impl().equals(that);
    }

    @Override
    @Transient
    public int hashCode() {
        return this.$ceylon$language$List$impl().hashCode();
    }

    @Override
    @Transient
    public java.lang.String toString() {
        return this.$ceylon$language$Collection$impl().toString();
    }

    @Ignore
    public Array($Serialization$ ignored, TypeDescriptor $reifiedElement) {
        this.$reifiedElement = $reifiedElement;
        this.elementType = Array.elementType($reifiedElement);
        this.array = null;
        this.objectArray = null;
        this.longArray = null;
        this.intArray = null;
        this.doubleArray = null;
        this.booleanArray = null;
        this.byteArray = null;
        this.stringArray = null;
        this.size = 0;
    }

    @Override
    @Ignore
    public Collection<ReachableReference> $references$() {
        return Collections.singletonList(new MemberImpl(this.getArraySize()));
    }

    @Ignore
    protected ValueDeclaration getArraySize() {
        return (ValueDeclaration)((ClassDeclaration)Metamodel.getOrCreateMetamodel(Array.class)).getMemberDeclaration(ValueDeclaration.$TypeDescriptor$, "size");
    }

    @Override
    @Ignore
    public java.lang.Object $get$(ReachableReference indexOrAttr) {
        if (indexOrAttr instanceof Member && this.getArraySize().equals(((Member)indexOrAttr).getAttribute())) {
            return Integer.instance(this.size);
        }
        if (indexOrAttr instanceof Element) {
            return this.getFromFirst(((Element)indexOrAttr).getIndex());
        }
        throw new AssertionError("unknown reference " + indexOrAttr);
    }

    @Override
    @Ignore
    public void $set$(ReachableReference reference, java.lang.Object instance) {
        if (reference instanceof Member && this.getArraySize().equals(((Member)reference).getAttribute())) {
            int size = Array.toSize(((Integer)instance).value);
            try {
                MethodHandles.Lookup lookup = MethodHandles.lookup();
                Util.setter(lookup, "size").invokeExact(this, size);
                java.lang.Object array = Array.createArrayWithElement(this.$reifiedElement, size, null);
                Util.setter(lookup, "array").invokeExact(this, array);
                if (this.elementType.fieldName != null) {
                    MethodHandle fieldSetter = Util.setter(lookup, this.elementType.fieldName);
                    switch (this.elementType) {
                        case CeylonInteger: {
                            fieldSetter.invokeExact(this, (long[])array);
                            break;
                        }
                        case CeylonFloat: {
                            fieldSetter.invokeExact(this, (double[])array);
                            break;
                        }
                        case CeylonCharacter: {
                            fieldSetter.invokeExact(this, (int[])array);
                            break;
                        }
                        case CeylonByte: {
                            fieldSetter.invokeExact(this, (byte[])array);
                            break;
                        }
                        case CeylonBoolean: {
                            fieldSetter.invokeExact(this, (boolean[])array);
                            break;
                        }
                        case CeylonString: {
                            fieldSetter.invokeExact(this, (java.lang.String[])array);
                            break;
                        }
                        case Other: {
                            fieldSetter.invokeExact(this, (java.lang.Object[])array);
                            break;
                        }
                        default: {
                            fieldSetter.invoke(this, array);
                        }
                    }
                }
            }
            catch (Throwable t) {
                rethrow_.rethrow(t);
            }
        } else {
            Element index = (Element)reference;
            this.set(index.getIndex(), (Element)instance);
        }
    }

    @Override
    @Ignore
    public List$impl<? extends Element> $ceylon$language$List$impl() {
        return new List$impl(this.$reifiedElement, this);
    }

    @Override
    @Ignore
    public <Result> Sequential<? extends Result> collect(TypeDescriptor arg0, Callable<? extends Result> arg1) {
        return this.$ceylon$language$List$impl().collect(arg0, arg1);
    }

    @Override
    @Ignore
    public boolean endsWith(List<? extends java.lang.Object> sublist) {
        return this.$ceylon$language$List$impl().endsWith(sublist);
    }

    @Override
    @Ignore
    public Element get(Integer index) {
        return this.getFromFirst(index.value);
    }

    @Override
    @Ignore
    public List<? extends Integer> getKeys() {
        return this.$ceylon$language$List$impl().getKeys();
    }

    @Override
    @Ignore
    public List<? extends Element> getRest() {
        return this.$ceylon$language$List$impl().getRest();
    }

    @Override
    @Ignore
    public List<? extends Element> getReversed() {
        return this.$ceylon$language$List$impl().getReversed();
    }

    @Override
    @Ignore
    public List<? extends Element> initial(long arg0) {
        return this.$ceylon$language$List$impl().initial(arg0);
    }

    @Override
    @Ignore
    public boolean longerThan(long arg0) {
        return this.$ceylon$language$List$impl().longerThan(arg0);
    }

    @Override
    @Ignore
    public <Other> List patch(TypeDescriptor arg0, List<? extends Other> arg1) {
        return this.$ceylon$language$List$impl().patch(arg0, arg1);
    }

    @Override
    @Ignore
    public <Other> List patch(TypeDescriptor arg0, List<? extends Other> arg1, long arg2) {
        return this.$ceylon$language$List$impl().patch(arg0, arg1, arg2);
    }

    @Override
    @Ignore
    public <Other> List patch(TypeDescriptor arg0, List<? extends Other> arg1, long arg2, long arg3) {
        return this.$ceylon$language$List$impl().patch(arg0, arg1, arg3);
    }

    @Override
    @Ignore
    public <Other> long patch$from(TypeDescriptor arg0, List<? extends Other> arg1) {
        return this.$ceylon$language$List$impl().patch$from(arg0, arg1);
    }

    @Override
    @Ignore
    public <Other> long patch$length(TypeDescriptor arg0, List<? extends Other> arg1, long arg2) {
        return this.$ceylon$language$List$impl().patch$length(arg0, arg1, arg2);
    }

    @Override
    @Ignore
    public List<? extends Element> repeat(long arg0) {
        return this.$ceylon$language$List$impl().repeat(arg0);
    }

    @Override
    @Ignore
    public boolean shorterThan(long arg0) {
        return this.$ceylon$language$List$impl().shorterThan(arg0);
    }

    @Override
    @Ignore
    public Sequence<? extends List<? extends Element>> slice(long arg0) {
        return this.$ceylon$language$List$impl().slice(arg0);
    }

    @Override
    @Ignore
    public boolean startsWith(List<? extends java.lang.Object> sublist) {
        return this.$ceylon$language$List$impl().startsWith(sublist);
    }

    @Override
    @Ignore
    public List<? extends Element> sublist(long arg0, long arg1) {
        return this.$ceylon$language$List$impl().sublist(arg0, arg1);
    }

    @Override
    @Ignore
    public List<? extends Element> sublistFrom(long arg0) {
        return this.$ceylon$language$List$impl().sublistFrom(arg0);
    }

    @Override
    @Ignore
    public List<? extends Element> sublistTo(long arg0) {
        return this.$ceylon$language$List$impl().sublistTo(arg0);
    }

    @Override
    @Ignore
    public List<? extends Element> terminal(long arg0) {
        return this.$ceylon$language$List$impl().terminal(arg0);
    }

    @Override
    @Ignore
    public List<? extends Element> trim(Callable<? extends Boolean> arg0) {
        return this.$ceylon$language$List$impl().trim(arg0);
    }

    @Override
    @Ignore
    public List<? extends Element> trimLeading(Callable<? extends Boolean> arg0) {
        return this.$ceylon$language$List$impl().trimLeading(arg0);
    }

    @Override
    @Ignore
    public List<? extends Element> trimTrailing(Callable<? extends Boolean> arg0) {
        return this.$ceylon$language$List$impl().trimTrailing(arg0);
    }

    @Override
    @Ignore
    public Collection$impl<? extends Element> $ceylon$language$Collection$impl() {
        return new Collection$impl(this.$reifiedElement, this);
    }

    @Override
    @Ignore
    public Iterable<? extends Sequence<? extends Element>, ? extends java.lang.Object> getPermutations() {
        return this.$ceylon$language$Collection$impl().getPermutations();
    }

    @Override
    @Ignore
    public Iterable<? extends Sequence<? extends Element>, ? extends java.lang.Object> combinations(long length) {
        return this.$ceylon$language$Collection$impl().combinations(length);
    }

    @Override
    @Ignore
    public Iterable$impl<? extends Element, ? extends java.lang.Object> $ceylon$language$Iterable$impl() {
        return new Iterable$impl(this.$reifiedElement, Null.$TypeDescriptor$, this);
    }

    @Override
    @Ignore
    public <Other, OtherAbsent> Iterable chain(TypeDescriptor arg0, TypeDescriptor arg1, Iterable<? extends Other, ? extends OtherAbsent> arg2) {
        return this.$ceylon$language$Iterable$impl().chain(arg0, arg1, arg2);
    }

    @Override
    @Ignore
    public <Default> Iterable defaultNullElements(TypeDescriptor arg0, Default arg1) {
        return this.$ceylon$language$Iterable$impl().defaultNullElements(arg0, arg1);
    }

    @Override
    @Ignore
    public <Result, OtherAbsent> Iterable flatMap(TypeDescriptor arg0, TypeDescriptor arg1, Callable<? extends Iterable<? extends Result, ? extends OtherAbsent>> arg2) {
        return this.$ceylon$language$Iterable$impl().flatMap(arg0, arg1, arg2);
    }

    @Override
    @Ignore
    public <Result> Callable<? extends Result> fold(TypeDescriptor arg0, Result arg1) {
        return this.$ceylon$language$Iterable$impl().fold(arg0, arg1);
    }

    @Override
    @Ignore
    public <Other> Iterable follow(TypeDescriptor arg0, Other arg1) {
        return this.$ceylon$language$Iterable$impl().follow(arg0, arg1);
    }

    @Override
    @Ignore
    public Iterable<? extends Element, ? extends java.lang.Object> getCycled() {
        return this.$ceylon$language$Iterable$impl().getCycled();
    }

    @Override
    @Ignore
    public Iterable<? extends Element, ? extends java.lang.Object> getDistinct() {
        return this.$ceylon$language$Iterable$impl().getDistinct();
    }

    @Override
    @Ignore
    public Iterable<? extends Element, ? extends java.lang.Object> getExceptLast() {
        return this.$ceylon$language$Iterable$impl().getExceptLast();
    }

    @Override
    @Ignore
    public Iterable<? extends Entry<? extends Integer, ? extends Element>, ? extends java.lang.Object> getIndexed() {
        return this.$ceylon$language$Iterable$impl().getIndexed();
    }

    @Override
    @Ignore
    public Iterable<? extends Sequence<? extends Element>, ? extends java.lang.Object> getPaired() {
        return this.$ceylon$language$Iterable$impl().getPaired();
    }

    @Override
    @Ignore
    public <Group> Map<? extends Group, ? extends Sequence<? extends Element>> group(TypeDescriptor arg0, Callable<? extends Group> arg1) {
        return this.$ceylon$language$Iterable$impl().group(arg0, arg1);
    }

    @Override
    @Ignore
    public <Group, Result> Map<? extends Group, ? extends Result> summarize(TypeDescriptor arg0, TypeDescriptor arg1, Callable<? extends Group> arg2, Callable<? extends Result> arg3) {
        return this.$ceylon$language$Iterable$impl().summarize(arg0, arg1, arg2, arg3);
    }

    @Override
    @Ignore
    public java.lang.Object indexes() {
        return this.$ceylon$language$Iterable$impl().indexes();
    }

    @Override
    @Ignore
    public <Other> Iterable interpose(TypeDescriptor arg0, Other arg1) {
        return this.$ceylon$language$Iterable$impl().interpose(arg0, arg1);
    }

    @Override
    @Ignore
    public <Other> Iterable interpose(TypeDescriptor arg0, Other arg1, long arg2) {
        return this.$ceylon$language$Iterable$impl().interpose(arg0, arg1, arg2);
    }

    @Override
    @Ignore
    public <Other> long interpose$step(TypeDescriptor arg0, Other arg1) {
        return this.$ceylon$language$Iterable$impl().interpose$step(arg0, arg1);
    }

    @Override
    @Ignore
    public <Result> Iterable<? extends Result, ? extends java.lang.Object> map(TypeDescriptor arg0, Callable<? extends Result> arg1) {
        return this.$ceylon$language$Iterable$impl().map(arg0, arg1);
    }

    @Override
    @Ignore
    public java.lang.Object max(Callable<? extends Comparison> arg0) {
        return this.$ceylon$language$Iterable$impl().max(arg0);
    }

    @Override
    @Ignore
    public <Type> Iterable narrow(TypeDescriptor arg0) {
        return this.$ceylon$language$Iterable$impl().narrow(arg0);
    }

    @Override
    @Ignore
    public Iterable<? extends Sequence<? extends Element>, ? extends java.lang.Object> partition(long arg0) {
        return this.$ceylon$language$Iterable$impl().partition(arg0);
    }

    @Override
    @Ignore
    public <Other, OtherAbsent> Iterable product(TypeDescriptor arg0, TypeDescriptor arg1, Iterable<? extends Other, ? extends OtherAbsent> arg2) {
        return this.$ceylon$language$Iterable$impl().product(arg0, arg1, arg2);
    }

    @Override
    @Ignore
    public <Result> Callable<? extends Iterable<? extends Result, ? extends java.lang.Object>> scan(TypeDescriptor arg0, Result arg1) {
        return this.$ceylon$language$Iterable$impl().scan(arg0, arg1);
    }

    @Override
    @Ignore
    public Sequential<? extends Element> select(Callable<? extends Boolean> arg0) {
        return this.$ceylon$language$Iterable$impl().select(arg0);
    }

    @Override
    @Ignore
    public Iterable<? extends Element, ? extends java.lang.Object> skipWhile(Callable<? extends Boolean> arg0) {
        return this.$ceylon$language$Iterable$impl().skipWhile(arg0);
    }

    @Override
    @Ignore
    public <Result, Args extends Sequential<? extends java.lang.Object>> Callable<? extends Iterable<? extends Result, ? extends java.lang.Object>> spread(TypeDescriptor arg0, TypeDescriptor arg1, Callable<? extends Callable<? extends Result>> arg2) {
        return this.$ceylon$language$Iterable$impl().spread(arg0, arg1, arg2);
    }

    @Override
    @Ignore
    public Iterable<? extends Element, ? extends java.lang.Object> takeWhile(Callable<? extends Boolean> arg0) {
        return this.$ceylon$language$Iterable$impl().takeWhile(arg0);
    }

    @Override
    @Ignore
    public Category$impl<? super java.lang.Object> $ceylon$language$Category$impl() {
        return new Category$impl<java.lang.Object>(Object.$TypeDescriptor$, this);
    }

    @Override
    @Ignore
    public boolean containsAny(Iterable<? extends java.lang.Object, ? extends java.lang.Object> arg0) {
        return this.$ceylon$language$Category$impl().containsAny(arg0);
    }

    @Override
    @Ignore
    public boolean containsEvery(Iterable<? extends java.lang.Object, ? extends java.lang.Object> arg0) {
        return this.$ceylon$language$Category$impl().containsEvery(arg0);
    }

    @Override
    @Ignore
    public Correspondence$impl<? super Integer, ? extends Element> $ceylon$language$Correspondence$impl() {
        return new Correspondence$impl(Integer.$TypeDescriptor$, this.$reifiedElement, this);
    }

    @Override
    @Ignore
    public boolean definesAny(Iterable<? extends Integer, ? extends java.lang.Object> arg0) {
        return this.$ceylon$language$Correspondence$impl().definesAny(arg0);
    }

    @Override
    @Ignore
    public boolean definesEvery(Iterable<? extends Integer, ? extends java.lang.Object> arg0) {
        return this.$ceylon$language$Correspondence$impl().definesEvery(arg0);
    }

    @Override
    @Ignore
    public <Absent> Iterable<? extends Element, ? extends Absent> getAll(TypeDescriptor arg0, Iterable<? extends Integer, ? extends Absent> arg1) {
        return this.$ceylon$language$Correspondence$impl().getAll(arg0, arg1);
    }

    @Override
    @Ignore
    public SearchableList$impl<Element> $ceylon$language$SearchableList$impl() {
        return new SearchableList$impl(this.$reifiedElement, this);
    }

    @Override
    @Ignore
    public Integer firstInclusion(List<? extends Element> arg0) {
        return this.$ceylon$language$SearchableList$impl().firstInclusion(arg0);
    }

    @Override
    @Ignore
    public long firstInclusion$from(List<? extends Element> arg0) {
        return 0L;
    }

    @Override
    @Ignore
    public Integer firstOccurrence(Element arg0) {
        return this.firstOccurrence(arg0, 0L);
    }

    @Override
    @Ignore
    public Integer firstOccurrence(Element arg0, long arg1) {
        return this.firstOccurrence(arg0, arg1, (long)this.size - arg1);
    }

    @Override
    @Ignore
    public long firstOccurrence$from(Element arg0) {
        return 0L;
    }

    @Override
    @Ignore
    public long firstOccurrence$length(Element arg0, long arg1) {
        return (long)this.size - arg1;
    }

    @Override
    @Ignore
    public boolean includes(List<? extends Element> arg0) {
        return this.$ceylon$language$SearchableList$impl().includes(arg0);
    }

    @Override
    @Ignore
    public long includes$from(List<? extends Element> arg0) {
        return 0L;
    }

    @Override
    @Ignore
    public Iterable<? extends Integer, ? extends java.lang.Object> inclusions(List<? extends Element> arg0) {
        return this.$ceylon$language$SearchableList$impl().inclusions(arg0);
    }

    @Override
    @Ignore
    public Iterable<? extends Integer, ? extends java.lang.Object> inclusions(List<? extends Element> arg0, long arg1) {
        return this.$ceylon$language$SearchableList$impl().inclusions(arg0, arg1);
    }

    @Override
    @Ignore
    public long inclusions$from(List<? extends Element> arg0) {
        return 0L;
    }

    @Override
    @Ignore
    public Integer lastInclusion(List<? extends Element> arg0) {
        return this.$ceylon$language$SearchableList$impl().lastInclusion(arg0);
    }

    @Override
    @Ignore
    public long lastInclusion$from(List<? extends Element> arg0) {
        return 0L;
    }

    @Override
    @Ignore
    public Integer lastOccurrence(Element arg0) {
        return this.lastOccurrence(arg0, 0L);
    }

    @Override
    @Ignore
    public Integer lastOccurrence(Element arg0, long arg1) {
        return this.lastOccurrence(arg0, arg1, (long)this.size - arg1);
    }

    @Override
    @Ignore
    public long lastOccurrence$from(Element arg0) {
        return 0L;
    }

    @Override
    @Ignore
    public long lastOccurrence$length(Element arg0, long arg1) {
        return (long)this.size - arg1;
    }

    @Override
    @Ignore
    public Iterable<? extends Integer, ? extends java.lang.Object> occurrences(Element arg0) {
        return this.occurrences(arg0, 0L);
    }

    @Override
    @Ignore
    public Iterable<? extends Integer, ? extends java.lang.Object> occurrences(Element arg0, long arg1) {
        return this.occurrences(arg0, arg1, (long)this.size - arg1);
    }

    @Override
    @Ignore
    public long occurrences$from(Element arg0) {
        return 0L;
    }

    @Override
    @Ignore
    public long occurrences$length(Element arg0, long arg1) {
        return (long)this.size - arg1;
    }

    @Override
    @Ignore
    public boolean occurs(Element arg0) {
        return this.occurs(arg0, 0L);
    }

    @Override
    @Ignore
    public boolean occurs(Element arg0, long arg1) {
        return this.occurs(arg0, arg1, (long)this.size - arg1);
    }

    @Override
    @Ignore
    public long occurs$from(Element arg0) {
        return 0L;
    }

    @Override
    @Ignore
    public long occurs$length(Element arg0, long arg1) {
        return (long)this.size - arg1;
    }

    @Override
    @Ignore
    public Integer firstInclusion(List<? extends Element> arg0, long arg1) {
        return this.$ceylon$language$SearchableList$impl().firstInclusion(arg0, arg1);
    }

    @Override
    @Ignore
    public boolean includes(List<? extends Element> arg0, long arg1) {
        return this.$ceylon$language$SearchableList$impl().includes(arg0, arg1);
    }

    @Override
    @Ignore
    public boolean includesAt(long arg0, List<? extends Element> arg1) {
        return this.$ceylon$language$SearchableList$impl().includesAt(arg0, arg1);
    }

    @Override
    @Ignore
    public Integer lastInclusion(List<? extends Element> arg0, long arg1) {
        return this.$ceylon$language$SearchableList$impl().lastInclusion(arg0, arg1);
    }

    @Override
    @Ignore
    public <Item> Map<? extends Element, ? extends Item> tabulate(TypeDescriptor arg0, Callable<? extends Item> arg1) {
        return this.$ceylon$language$Iterable$impl().tabulate(arg0, arg1);
    }

    @Override
    @Ignore
    public Map<? extends Element, ? extends Integer> frequencies() {
        return this.$ceylon$language$Iterable$impl().frequencies();
    }

    @Override
    @Ignore
    public <Result> List<? extends Result> mapElements(TypeDescriptor arg0, Callable<? extends Result> arg1) {
        return this.$ceylon$language$List$impl().mapElements(arg0, arg1);
    }

    private static enum ArrayType {
        CeylonInteger("longArray"),
        JavaLong,
        CeylonFloat("doubleArray"),
        JavaDouble,
        CeylonCharacter("intArray"),
        JavaInteger,
        CeylonByte("byteArray"),
        JavaByte,
        CeylonBoolean("booleanArray"),
        JavaBoolean,
        JavaCharacter,
        JavaShort,
        JavaFloat,
        CeylonString("stringArray"),
        JavaString,
        Other("objectArray");

        final java.lang.String fieldName;

        private ArrayType(java.lang.String fieldName) {
            this.fieldName = fieldName;
        }

        private ArrayType() {
            this.fieldName = null;
        }
    }

    @Ignore
    final class ArrayIterable
    extends AbstractArrayIterable<Element, java.lang.Object> {
        ArrayIterable() {
            super(Array.this.$reifiedElement, Array.this.array, Array.this.size);
        }

        protected ArrayIterable(java.lang.Object array, int start, int len, int step) {
            super(Array.this.$reifiedElement, array, start, len, step);
        }

        protected ArrayIterable newInstance(java.lang.Object array, int start, int len, int step) {
            return new ArrayIterable(array, start, len, step);
        }

        @Override
        protected Element get(java.lang.Object array, int index) {
            return Array.this.unsafeItem(index);
        }

        @Ignore
        java.lang.String stringValue() {
            if (Array.this.array instanceof int[] && this.step == 1) {
                return new java.lang.String((int[])Array.this.array, this.start, (int)this.getSize());
            }
            return null;
        }
    }

    @Ignore
    private final class ArrayIterator
    extends BaseIterator<Element> {
        private int index;

        private ArrayIterator(TypeDescriptor $reified$Element) {
            super($reified$Element);
            this.index = 0;
        }

        @Override
        public java.lang.Object next() {
            if (this.index < Array.this.size) {
                return Array.this.unsafeItem(this.index++);
            }
            return FIN;
        }

        public java.lang.String toString() {
            return Array.this.toString() + ".iterator()";
        }
    }

    @Ignore
    private final class CoalescedArrayIterable
    extends BaseIterable<Element, java.lang.Object>
    implements Iterable<Element, java.lang.Object> {
        private final TypeDescriptor $reifiedElement;

        CoalescedArrayIterable(TypeDescriptor $reifiedElement) {
            super($reifiedElement, Null.$TypeDescriptor$);
            this.$reifiedElement = $reifiedElement;
        }

        @Override
        public Iterator<? extends Element> iterator() {
            return new CoalescedArrayIterator(this.$reifiedElement);
        }
    }

    @Ignore
    private final class CoalescedArrayIterator
    extends BaseIterator<Element> {
        private int index;

        CoalescedArrayIterator(TypeDescriptor $reified$Element) {
            super($reified$Element);
            this.index = 0;
        }

        @Override
        public java.lang.Object next() {
            if (this.index < Array.this.size) {
                java.lang.Object result;
                boolean isNull;
                do {
                    boolean bl = isNull = (result = Array.this.unsafeItem(this.index++)) == null;
                } while (isNull && this.index < Array.this.size);
                return isNull ? FIN : result;
            }
            return FIN;
        }

        public java.lang.String toString() {
            return Array.this.toString() + ".coalesced.iterator()";
        }
    }

    @Ceylon(major=8)
    @Ignore
    @ConstructorName(value="ofSize")
    public static final class ofSize_ {
        private ofSize_() {
        }
    }
}

