/*
 * Decompiled with CFR 0.152.
 */
package ceylon.language;

import ceylon.language.AuthorsAnnotation$annotation$;
import ceylon.language.Binary$impl;
import ceylon.language.DefaultAnnotation$annotation$;
import ceylon.language.DocAnnotation$annotation$;
import ceylon.language.FormalAnnotation$annotation$;
import ceylon.language.SeeAnnotation$annotation$;
import ceylon.language.SeeAnnotation$annotations$;
import ceylon.language.SharedAnnotation$annotation$;
import com.redhat.ceylon.compiler.java.metadata.Annotation;
import com.redhat.ceylon.compiler.java.metadata.Annotations;
import com.redhat.ceylon.compiler.java.metadata.CaseTypes;
import com.redhat.ceylon.compiler.java.metadata.Ceylon;
import com.redhat.ceylon.compiler.java.metadata.Defaulted;
import com.redhat.ceylon.compiler.java.metadata.Ignore;
import com.redhat.ceylon.compiler.java.metadata.Name;
import com.redhat.ceylon.compiler.java.metadata.TypeInfo;
import com.redhat.ceylon.compiler.java.metadata.TypeParameter;
import com.redhat.ceylon.compiler.java.metadata.TypeParameters;
import com.redhat.ceylon.compiler.java.metadata.Variance;

@Ceylon(major=8, minor=1)
@DocAnnotation$annotation$(description="Abstraction of types that are conceptually a sequence of \nbits, and may be the subject of bitwise operations. A bit \nis a [[Boolean]] value. Bits are indexed from right to \nleft, where `0` is the index of the least significant bit.")
@SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.3.2:ceylon.language::CInteger"})})
@AuthorsAnnotation$annotation$(authors={"Stef"})
@SharedAnnotation$annotation$
@Annotations(modifiers=2L, value={@Annotation(value="doc", arguments={"Abstraction of types that are conceptually a sequence of \nbits, and may be the subject of bitwise operations. A bit \nis a [[Boolean]] value. Bits are indexed from right to \nleft, where `0` is the index of the least significant bit."}), @Annotation(value="see", arguments={"Integer"}), @Annotation(value="by", arguments={"Stef"})})
@CaseTypes(of="Other")
@TypeParameters(value={@TypeParameter(value="Other", variance=Variance.NONE, satisfies={"ceylon.language::Binary<Other>"}, caseTypes={})})
public interface Binary<Other extends Binary<Other>> {
    @Ignore
    public Binary$impl<Other> $ceylon$language$Binary$impl();

    @DocAnnotation$annotation$(description="The binary complement of this sequence of bits.")
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=130L, value={@Annotation(value="doc", arguments={"The binary complement of this sequence of bits."})})
    @TypeInfo(value="Other", erased=true)
    public Other getNot();

    @DocAnnotation$annotation$(description="Shift the sequence of bits to the left, by the given \n[[number of places|shift]], filling the least\nsignificant bits with zeroes (zero extension).")
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=130L, value={@Annotation(value="doc", arguments={"Shift the sequence of bits to the left, by the given \n[[number of places|shift]], filling the least\nsignificant bits with zeroes (zero extension)."})})
    @TypeInfo(value="Other", erased=true)
    public Other leftLogicalShift(@Name(value="shift") long var1);

    @DocAnnotation$annotation$(description="Shift the sequence of bits to the right, by the given \n[[number of places|shift]], filling the most\nsignificant bits with zeroes (zero extension).\n\nIf the sequence of bits represents a signed integer, \nthe sign is not preserved.")
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=130L, value={@Annotation(value="doc", arguments={"Shift the sequence of bits to the right, by the given \n[[number of places|shift]], filling the most\nsignificant bits with zeroes (zero extension).\n\nIf the sequence of bits represents a signed integer, \nthe sign is not preserved."})})
    @TypeInfo(value="Other", erased=true)
    public Other rightLogicalShift(@Name(value="shift") long var1);

    @DocAnnotation$annotation$(description="Shift the sequence of bits to the right, by the given \n[[number of places|shift]], preserving the values of \nthe most significant bits (sign extension).\n\nIf the sequence of bits represents a signed integer, \nthe sign is preserved.")
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=130L, value={@Annotation(value="doc", arguments={"Shift the sequence of bits to the right, by the given \n[[number of places|shift]], preserving the values of \nthe most significant bits (sign extension).\n\nIf the sequence of bits represents a signed integer, \nthe sign is preserved."})})
    @TypeInfo(value="Other", erased=true)
    public Other rightArithmeticShift(@Name(value="shift") long var1);

    @DocAnnotation$annotation$(description="Performs a logical AND operation.")
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=130L, value={@Annotation(value="doc", arguments={"Performs a logical AND operation."})})
    @TypeInfo(value="Other", erased=true)
    public Other and(@Name(value="other") @TypeInfo(value="Other", erased=true) Other var1);

    @DocAnnotation$annotation$(description="Performs a logical inclusive OR operation.")
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=130L, value={@Annotation(value="doc", arguments={"Performs a logical inclusive OR operation."})})
    @TypeInfo(value="Other", erased=true)
    public Other or(@Name(value="other") @TypeInfo(value="Other", erased=true) Other var1);

    @DocAnnotation$annotation$(description="Performs a logical exclusive OR operation.")
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=130L, value={@Annotation(value="doc", arguments={"Performs a logical exclusive OR operation."})})
    @TypeInfo(value="Other", erased=true)
    public Other xor(@Name(value="other") @TypeInfo(value="Other", erased=true) Other var1);

    @DocAnnotation$annotation$(description="Retrieves a given bit from this bit sequence if \n`0 <= index < size`, otherwise returns false.")
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=130L, value={@Annotation(value="doc", arguments={"Retrieves a given bit from this bit sequence if \n`0 <= index < size`, otherwise returns false."})})
    public boolean get(@Name(value="index") long var1);

    @Ignore
    public Other set(long var1);

    @Ignore
    public boolean set$bit(long var1);

    @DocAnnotation$annotation$(description="Returns an instance with the given bit set to the given \nvalue if `0 <= index < size`, otherwise returns a value \nwith the same bits as this value.")
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=130L, value={@Annotation(value="doc", arguments={"Returns an instance with the given bit set to the given \nvalue if `0 <= index < size`, otherwise returns a value \nwith the same bits as this value."})})
    @TypeInfo(value="Other", erased=true)
    public Other set(@Name(value="index") long var1, @Name(value="bit") @Defaulted boolean var3);

    @DocAnnotation$annotation$(description="Returns an instance with the given bit set to 0 if \n`0 <= index < size`, otherwise returns a value with the \nsame bits as this value.")
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=258L, value={@Annotation(value="doc", arguments={"Returns an instance with the given bit set to 0 if \n`0 <= index < size`, otherwise returns a value with the \nsame bits as this value."})})
    @TypeInfo(value="Other", erased=true)
    public Other clear(@Name(value="index") long var1);

    @DocAnnotation$annotation$(description="Returns an instance with the given bit flipped to its \nopposite value if `0 <= index < size`, otherwise \nreturns a value with the same bits as this value.")
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=130L, value={@Annotation(value="doc", arguments={"Returns an instance with the given bit flipped to its \nopposite value if `0 <= index < size`, otherwise \nreturns a value with the same bits as this value."})})
    @TypeInfo(value="Other", erased=true)
    public Other flip(@Name(value="index") long var1);
}

