/*
 * Decompiled with CFR 0.152.
 */
package ceylon.language;

import ceylon.language.ActualAnnotation$annotation$;
import ceylon.language.DefaultAnnotation$annotation$;
import ceylon.language.DocAnnotation$annotation$;
import ceylon.language.Enumerable$impl;
import ceylon.language.FormalAnnotation$annotation$;
import ceylon.language.Ordinal;
import ceylon.language.SeeAnnotation$annotation$;
import ceylon.language.SeeAnnotation$annotations$;
import ceylon.language.SharedAnnotation$annotation$;
import ceylon.language.SinceAnnotation$annotation$;
import ceylon.language.ThrownExceptionAnnotation$annotation$;
import ceylon.language.ThrownExceptionAnnotation$annotations$;
import com.redhat.ceylon.compiler.java.metadata.Annotation;
import com.redhat.ceylon.compiler.java.metadata.Annotations;
import com.redhat.ceylon.compiler.java.metadata.CaseTypes;
import com.redhat.ceylon.compiler.java.metadata.Ceylon;
import com.redhat.ceylon.compiler.java.metadata.Ignore;
import com.redhat.ceylon.compiler.java.metadata.Name;
import com.redhat.ceylon.compiler.java.metadata.SatisfiedTypes;
import com.redhat.ceylon.compiler.java.metadata.Transient;
import com.redhat.ceylon.compiler.java.metadata.TypeInfo;
import com.redhat.ceylon.compiler.java.metadata.TypeParameter;
import com.redhat.ceylon.compiler.java.metadata.TypeParameters;
import com.redhat.ceylon.compiler.java.metadata.Variance;

@Ceylon(major=8, minor=1)
@DocAnnotation$annotation$(description="Abstraction of [[ordinal types|Ordinal]] whose values may \nbe used as endpoints of a [[span]] or [[measure]].\n\nAn `Enumerable` type is characterized by each element \nhaving well-defined [[offset]] and [[neighbour]] functions.\nGiven an instance `x` of an enumerable type `X`:\n\n- for any integer-valued offset, there is a unique \n  _neighbour_ `y` of `X` with that offset, and\n- if `y` is an instance of `X`, then there is a\n  well-defined integer-valued _offset_ of `x` from `y`.\n\nThe offset function must satisfy:\n\n- `x.offset(x) == 0`, and\n- `x.successor.offset(x) == 1` if `x!=x.successor`.\n\nThe neighbour function must satisfy:\n\n- `x.neighbour(0) == x`,\n- `x.neighbour(n-1) == x.neighbour(n).predecessor`, and\n- `x.neighbour(n+1) == x.neighbour(n).successor`.\n\nOf course, it follows that:\n\n- `x.neighbour(-1) == x.predecessor`, and\n- `x.neighbour(1) == x.successor`.\n\nAn enumerable type may be _linear_ or _recursive_. If `X` \nis a linear enumerable type, then the offset function \nsatisfies:\n\n- `x.predecessor.offset(x) == -1` if `x!=x.predecessor`,\n- `x.offset(y) == -y.offset(x)` for any instance `y` of `X`, \n  and\n- `x.offset(y) == x.offset(z) + z.offset(y)`.\n\nOtherwise, `X` is a recursive enumerable type with a finite\nlist of enumerated instances of size `count`, and its \noffset and neighbour functions must satisfy:\n\n- `x.neighbour(count)==x`,\n- `x.offset(y) >= 0` for any instance `y` of `X`, and \n- `x.predecessor.offset(x) == count - 1`.\n\nA range of values of an enumerable type may be specified \nusing:\n\n- the _span operator_, written `first..last`, or \n- the _segment operator_, written `first:length`.")
@SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.3.2:ceylon.language::CRange", "::1.3.2:ceylon.language::Fspan", "::1.3.2:ceylon.language::Fmeasure"})})
@SharedAnnotation$annotation$
@Annotations(modifiers=2L, value={@Annotation(value="doc", arguments={"Abstraction of [[ordinal types|Ordinal]] whose values may \nbe used as endpoints of a [[span]] or [[measure]].\n\nAn `Enumerable` type is characterized by each element \nhaving well-defined [[offset]] and [[neighbour]] functions.\nGiven an instance `x` of an enumerable type `X`:\n\n- for any integer-valued offset, there is a unique \n  _neighbour_ `y` of `X` with that offset, and\n- if `y` is an instance of `X`, then there is a\n  well-defined integer-valued _offset_ of `x` from `y`.\n\nThe offset function must satisfy:\n\n- `x.offset(x) == 0`, and\n- `x.successor.offset(x) == 1` if `x!=x.successor`.\n\nThe neighbour function must satisfy:\n\n- `x.neighbour(0) == x`,\n- `x.neighbour(n-1) == x.neighbour(n).predecessor`, and\n- `x.neighbour(n+1) == x.neighbour(n).successor`.\n\nOf course, it follows that:\n\n- `x.neighbour(-1) == x.predecessor`, and\n- `x.neighbour(1) == x.successor`.\n\nAn enumerable type may be _linear_ or _recursive_. If `X` \nis a linear enumerable type, then the offset function \nsatisfies:\n\n- `x.predecessor.offset(x) == -1` if `x!=x.predecessor`,\n- `x.offset(y) == -y.offset(x)` for any instance `y` of `X`, \n  and\n- `x.offset(y) == x.offset(z) + z.offset(y)`.\n\nOtherwise, `X` is a recursive enumerable type with a finite\nlist of enumerated instances of size `count`, and its \noffset and neighbour functions must satisfy:\n\n- `x.neighbour(count)==x`,\n- `x.offset(y) >= 0` for any instance `y` of `X`, and \n- `x.predecessor.offset(x) == count - 1`.\n\nA range of values of an enumerable type may be specified \nusing:\n\n- the _span operator_, written `first..last`, or \n- the _segment operator_, written `first:length`."}), @Annotation(value="see", arguments={"Range", "span", "measure"})})
@SatisfiedTypes(value={"ceylon.language::Ordinal<Other>"})
@CaseTypes(of="Other")
@TypeParameters(value={@TypeParameter(value="Other", variance=Variance.NONE, satisfies={"ceylon.language::Enumerable<Other>"}, caseTypes={})})
public interface Enumerable<Other extends Enumerable<Other>>
extends Ordinal<Other> {
    @Ignore
    public Enumerable$impl<Other> $ceylon$language$Enumerable$impl();

    @DocAnnotation$annotation$(description="The indirect successor or predecessor at the given\n[[offset]], where:\n\n- `x.neighbour(0) == x`,\n- `x.neighbour(i+1) == x.neighbour(i).successor`, and\n- `x.neighbour(i-1) == x.neighbour(i).predecessor`.")
    @ThrownExceptionAnnotation$annotations$(value={@ThrownExceptionAnnotation$annotation$(type="::1.3.2:ceylon.language::COverflowException", when="if the neighbour cannot be represented as an \ninstance of the type")})
    @SinceAnnotation$annotation$(version="1.1.0")
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=130L, value={@Annotation(value="doc", arguments={"The indirect successor or predecessor at the given\n[[offset]], where:\n\n- `x.neighbour(0) == x`,\n- `x.neighbour(i+1) == x.neighbour(i).successor`, and\n- `x.neighbour(i-1) == x.neighbour(i).predecessor`."}), @Annotation(value="throws", arguments={"OverflowException", "if the neighbour cannot be represented as an \ninstance of the type"})})
    @TypeInfo(value="Other", erased=true)
    public Other neighbour(@Name(value="offset") long var1);

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=322L)
    @TypeInfo(value="Other", erased=true, untrusted=true)
    @Transient
    public Other getSuccessor();

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=322L)
    @TypeInfo(value="Other", erased=true, untrusted=true)
    @Transient
    public Other getPredecessor();

    @DocAnnotation$annotation$(description="Compute the offset from the given value, where:\n\n- `x.offset(x) == 0`, and\n- `x.successor.offset(x) == 1` if `x!=x.successor`.")
    @ThrownExceptionAnnotation$annotations$(value={@ThrownExceptionAnnotation$annotation$(type="::1.3.2:ceylon.language::COverflowException", when="if the offset cannot be represented as an \ninteger")})
    @SinceAnnotation$annotation$(version="1.1.0")
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=130L, value={@Annotation(value="doc", arguments={"Compute the offset from the given value, where:\n\n- `x.offset(x) == 0`, and\n- `x.successor.offset(x) == 1` if `x!=x.successor`."}), @Annotation(value="throws", arguments={"OverflowException", "if the offset cannot be represented as an \ninteger"})})
    public long offset(@Name(value="other") @TypeInfo(value="Other", erased=true) Other var1);

    @DocAnnotation$annotation$(description="The sign of the offset from the given value.")
    @SinceAnnotation$annotation$(version="1.1.0")
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=258L, value={@Annotation(value="doc", arguments={"The sign of the offset from the given value."})})
    public long offsetSign(@Name(value="other") @TypeInfo(value="Other", erased=true) Other var1);
}

