/*
 * Decompiled with CFR 0.152.
 */
package ceylon.language;

import ceylon.language.AssertionError;
import ceylon.language.Boolean;
import ceylon.language.Callable;
import ceylon.language.Category$impl;
import ceylon.language.Collection$impl;
import ceylon.language.Comparison;
import ceylon.language.Correspondence$impl;
import ceylon.language.Empty;
import ceylon.language.Entry;
import ceylon.language.FinalAnnotation$annotation$;
import ceylon.language.Finished;
import ceylon.language.Integer;
import ceylon.language.Iterable;
import ceylon.language.Iterable$impl;
import ceylon.language.Iterator;
import ceylon.language.List;
import ceylon.language.List$impl;
import ceylon.language.Map;
import ceylon.language.NativeAnnotation$annotation$;
import ceylon.language.Range;
import ceylon.language.Sequence;
import ceylon.language.Sequence$impl;
import ceylon.language.Sequential;
import ceylon.language.Sequential$impl;
import ceylon.language.SerializableAnnotation$annotation$;
import ceylon.language.SharedAnnotation$annotation$;
import ceylon.language.StringBuilder;
import ceylon.language.empty_;
import ceylon.language.impl.BaseIterator;
import ceylon.language.impl.MemberImpl;
import ceylon.language.impl.rethrow_;
import ceylon.language.larger_;
import ceylon.language.meta.declaration.ClassDeclaration;
import ceylon.language.meta.declaration.FunctionOrValueDeclaration;
import ceylon.language.meta.declaration.ValueDeclaration;
import ceylon.language.serialization.Member;
import ceylon.language.serialization.ReachableReference;
import com.redhat.ceylon.compiler.java.Util;
import com.redhat.ceylon.compiler.java.metadata.Annotation;
import com.redhat.ceylon.compiler.java.metadata.Annotations;
import com.redhat.ceylon.compiler.java.metadata.Ceylon;
import com.redhat.ceylon.compiler.java.metadata.Class;
import com.redhat.ceylon.compiler.java.metadata.FunctionalParameter;
import com.redhat.ceylon.compiler.java.metadata.Ignore;
import com.redhat.ceylon.compiler.java.metadata.Name;
import com.redhat.ceylon.compiler.java.metadata.SatisfiedTypes;
import com.redhat.ceylon.compiler.java.metadata.Transient;
import com.redhat.ceylon.compiler.java.metadata.TypeInfo;
import com.redhat.ceylon.compiler.java.metadata.TypeParameter;
import com.redhat.ceylon.compiler.java.metadata.TypeParameters;
import com.redhat.ceylon.compiler.java.metadata.Variance;
import com.redhat.ceylon.compiler.java.runtime.metamodel.Metamodel;
import com.redhat.ceylon.compiler.java.runtime.model.ReifiedType;
import com.redhat.ceylon.compiler.java.runtime.model.TypeDescriptor;
import com.redhat.ceylon.compiler.java.runtime.serialization.$Serialization$;
import com.redhat.ceylon.compiler.java.runtime.serialization.Serializable;
import java.lang.invoke.MethodHandles;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

@Ceylon(major=8)
@Class(extendsType="ceylon.language::Object", basic=false, identifiable=false)
@Annotations(value={@Annotation(value="doc", arguments={"A _tuple_ is a typed linked list..."}), @Annotation(value="by", arguments={"Gavin"}), @Annotation(value="shared"), @Annotation(value="final")})
@SatisfiedTypes(value={"ceylon.language::Sequence<Element>"})
@TypeParameters(value={@TypeParameter(value="Element", variance=Variance.OUT, satisfies={}, caseTypes={}), @TypeParameter(value="First", variance=Variance.OUT, satisfies={"Element"}, caseTypes={}), @TypeParameter(value="Rest", variance=Variance.OUT, satisfies={"ceylon.language::Sequential<Element>"}, caseTypes={}, defaultValue="ceylon.language::Empty")})
@SharedAnnotation$annotation$
@FinalAnnotation$annotation$
@SerializableAnnotation$annotation$
@NativeAnnotation$annotation$(backends={})
public final class Tuple<Element, First extends Element, Rest extends Sequential<? extends Element>>
implements Sequence<Element>,
Serializable,
ReifiedType,
java.io.Serializable {
    private static final long serialVersionUID = 6194999680327535668L;
    @Ignore
    final Object[] array;
    @Ignore
    private TypeDescriptor $reifiedElement;
    private Sequential<? extends Element> rest;
    @Ignore
    private volatile SoftReference<TypeDescriptor> $cachedType = null;
    @Ignore
    private static final long USE_ARRAY_SIZE = -10L;

    @Ignore
    public Tuple(@Ignore TypeDescriptor $reifiedElement, Object[] array, Sequential<? extends Element> rest, boolean copy) {
        if ((long)array.length + rest.getSize() == 0L) {
            throw new AssertionError("Tuple may not have zero elements");
        }
        int length = array.length;
        this.$reifiedElement = $reifiedElement;
        this.array = copy ? Arrays.copyOfRange(array, 0, Util.toInt(length)) : array;
        this.rest = rest;
        if (this.array == null) {
            throw new AssertionError("");
        }
        if (this.rest == null) {
            throw new AssertionError("");
        }
    }

    public Tuple(@Ignore TypeDescriptor $reifiedElement, @Ignore TypeDescriptor $reifiedFirst, @Ignore TypeDescriptor $reifiedRest, @Name(value="first") @TypeInfo(value="First") First first, @Name(value="rest") @TypeInfo(value="Rest") Rest rest) {
        this($reifiedElement, Tuple.makeArray(first, rest), Tuple.makeRest(rest));
    }

    @Ignore
    private Tuple(TypeDescriptor $reifiedElement, Object[] array, Sequential<? extends Element> rest) {
        this($reifiedElement, array, rest, false);
    }

    private static Object[] makeArray(Object first, Sequential<?> rest) {
        Object[] array;
        if (rest instanceof Tuple) {
            Tuple other = (Tuple)rest;
            array = new Object[1 + other.array.length];
            array[0] = first;
            System.arraycopy(other.array, 0, array, 1, other.array.length);
            rest = other.rest;
        } else {
            array = new Object[]{first};
        }
        return array;
    }

    private static <Element> Sequential<? extends Element> makeRest(Sequential<? extends Element> rest) {
        if (rest instanceof Tuple) {
            Tuple other = (Tuple)rest;
            return other.rest;
        }
        return rest;
    }

    @Ignore
    public Tuple(TypeDescriptor $reifiedElement, Object[] elements) {
        this($reifiedElement, elements, empty_.get_(), false);
    }

    @Ignore
    public static Tuple<?, ?, ?> instance(TypeDescriptor $reifiedElement, Object[] elements, Sequential<?> tail) {
        Sequential<Object> rest;
        Object[] array;
        if (tail instanceof Tuple) {
            Tuple other = (Tuple)tail;
            array = new Object[elements.length + other.array.length];
            System.arraycopy(elements, 0, array, 0, elements.length);
            System.arraycopy(other.array, 0, array, elements.length, other.array.length);
            rest = other.rest;
        } else {
            array = elements;
            rest = tail;
        }
        return new Tuple($reifiedElement, array, rest, false);
    }

    @Ignore
    public static Tuple<?, ?, ?> instance(TypeDescriptor $reifiedElement, Object[] elements) {
        return Tuple.instance($reifiedElement, elements, empty_.get_());
    }

    @Ignore
    protected TypeDescriptor $getReifiedElement$() {
        return ((TypeDescriptor.Class)this.$getType$()).getSequenceElement();
    }

    @Override
    @Annotations(value={@Annotation(value="shared"), @Annotation(value="actual")})
    @TypeInfo(value="First")
    public final First getFirst() {
        return (First)this.getFromFirst(0L);
    }

    @Annotations(value={@Annotation(value="shared"), @Annotation(value="actual")})
    @TypeInfo(value="Rest")
    public Rest getRest() {
        if (this.getSize() == 1L) {
            return (Rest)empty_.get_();
        }
        if (this.array.length == 1) {
            return (Rest)this.rest;
        }
        TypeDescriptor typeArg = ((TypeDescriptor.Class)((TypeDescriptor.Class)this.$getType$()).getTupleRest()).getSequenceElement();
        Object[] copy = Arrays.copyOfRange(this.array, 1, this.array.length);
        return (Rest)new Tuple<Element, First, Rest>(typeArg, copy, this.rest, false);
    }

    @Override
    @Annotations(value={@Annotation(value="shared"), @Annotation(value="actual")})
    @TypeInfo(value="ceylon.language::Integer")
    @Transient
    public final long getSize() {
        return (long)this.array.length + this.rest.getSize();
    }

    @Override
    @Annotations(value={@Annotation(value="shared"), @Annotation(value="actual")})
    @TypeInfo(value="ceylon.language::Null|Element")
    public final Element getFromFirst(@Name(value="index") long index) {
        if (index < 0L) {
            return null;
        }
        if (index >= (long)this.array.length) {
            return this.rest.getFromFirst(index - (long)this.array.length);
        }
        return (Element)this.array[Util.toInt(index)];
    }

    @Override
    @Ignore
    public Element getFromLast(long index) {
        if (index < 0L) {
            return null;
        }
        if (index >= (long)this.array.length) {
            return this.rest.getFromLast(index - (long)this.array.length);
        }
        return (Element)this.array[this.array.length - 1 - Util.toInt(index)];
    }

    @Override
    @Annotations(value={@Annotation(value="shared"), @Annotation(value="actual")})
    @TypeInfo(value="ceylon.language::Integer")
    @Transient
    public final Integer getLastIndex() {
        return Integer.instance((long)this.array.length + this.rest.getSize() - 1L);
    }

    @Override
    @Annotations(value={@Annotation(value="shared"), @Annotation(value="actual")})
    @TypeInfo(value="Element")
    @Transient
    public final Element getLast() {
        if (!this.rest.getEmpty()) {
            return this.rest.getLast();
        }
        return (Element)this.array[this.array.length - 1];
    }

    @Override
    @Annotations(value={@Annotation(value="shared"), @Annotation(value="actual")})
    @TypeInfo(value="ceylon.language::Sequential<Element>")
    public final Sequential<? extends Element> measure(@Name(value="from") @TypeInfo(value="ceylon.language::Integer") Integer from, @Name(value="length") @TypeInfo(value="ceylon.language::Integer") long length) {
        long lastIndex;
        long fromIndex = from.longValue();
        if (fromIndex < 0L) {
            length += fromIndex;
            fromIndex = 0L;
        }
        if (fromIndex > (lastIndex = this.getSize() - 1L) || length <= 0L) {
            return this.getEmptyTuple();
        }
        long l = length > lastIndex - fromIndex ? lastIndex - fromIndex + 1L : length;
        if (fromIndex + l < (long)this.array.length) {
            Object[] copy = fromIndex + l == (long)this.array.length ? this.array : Arrays.copyOfRange(this.array, Util.toInt(fromIndex), Util.toInt(fromIndex + l));
            return new Tuple<Element, First, Rest>(this.$reifiedElement, copy, this.getEmptyTuple(), false);
        }
        if (fromIndex >= (long)this.array.length) {
            return this.rest.measure(Integer.instance(fromIndex - (long)this.array.length), l);
        }
        Object[] copy = Arrays.copyOfRange(this.array, Util.toInt(fromIndex), Util.toInt(this.array.length));
        Sequential rest = this.rest.measure(Integer.instance(0L), l - (long)(this.array.length - Util.toInt(fromIndex)));
        return new Tuple<Element, First, Rest>(this.$reifiedElement, copy, rest, false);
    }

    @Override
    @Annotations(value={@Annotation(value="shared"), @Annotation(value="actual")})
    @TypeInfo(value="ceylon.language::Sequential<Element>")
    public final Sequential<? extends Element> span(@Name(value="from") Integer from, @Name(value="end") Integer end) {
        boolean reverse;
        long fromIndex = Util.toInt(from.longValue());
        long toIndex = end == null ? this.getSize() : end.longValue();
        long lastIndex = this.getSize() - 1L;
        boolean bl = reverse = toIndex < fromIndex;
        if (reverse) {
            long tmp = fromIndex;
            fromIndex = toIndex;
            toIndex = tmp;
        }
        if (toIndex < 0L || fromIndex > lastIndex) {
            return this.getEmptyTuple();
        }
        fromIndex = Math.max(fromIndex, 0L);
        if ((toIndex = Math.min(toIndex, lastIndex)) < (long)this.array.length || this.rest.getEmpty()) {
            Object[] newArray;
            if (reverse) {
                int fromInt = Util.toInt(fromIndex);
                int toInt = Util.toInt(toIndex);
                newArray = new Object[toInt - fromInt + 1];
                int ii = toInt;
                int jj = 0;
                while ((long)ii >= fromIndex) {
                    newArray[jj] = this.getFromFirst(ii);
                    --ii;
                    ++jj;
                }
            } else {
                newArray = Arrays.copyOfRange(this.array, Util.toInt(fromIndex), Util.toInt(toIndex) + 1);
            }
            return new Tuple<Element, First, Rest>(this.$getReifiedElement$(), newArray, this.getEmptyTuple(), false);
        }
        if (fromIndex >= (long)this.array.length) {
            if (reverse) {
                return this.rest.span(Integer.instance(toIndex - (long)this.array.length), Integer.instance(fromIndex - (long)this.array.length));
            }
            return this.rest.span(Integer.instance(fromIndex - (long)this.array.length), Integer.instance(toIndex - (long)this.array.length));
        }
        Object[] newArray = Arrays.copyOfRange(this.array, Util.toInt(fromIndex), this.array.length);
        Sequential rest = this.rest.span(Integer.instance(0L), Integer.instance(toIndex - (long)this.array.length));
        Tuple<Element, First, Rest> result = new Tuple<Element, First, Rest>(this.$getReifiedElement$(), newArray, rest, false);
        return reverse ? result.getReversed() : result;
    }

    @Override
    @Annotations(value={@Annotation(value="shared"), @Annotation(value="actual")})
    @TypeInfo(value="ceylon.language::Sequential<Element>")
    public final Sequential<? extends Element> spanTo(@Name(value="to") Integer to) {
        return to.longValue() < 0L ? this.getEmptyTuple() : this.span(Integer.instance(0L), to);
    }

    private Sequential<? extends Element> getEmptyTuple() {
        return empty_.get_();
    }

    @Override
    @Annotations(value={@Annotation(value="shared"), @Annotation(value="actual")})
    @TypeInfo(value="ceylon.language::Sequential<Element>")
    public final Sequential<? extends Element> spanFrom(@Name(value="from") Integer from) {
        return this.span(from, Integer.instance(this.getSize()));
    }

    @Annotations(value={@Annotation(value="shared"), @Annotation(value="actual")})
    @TypeInfo(value="ceylon.language::Tuple<Element,First,Rest>")
    public final Tuple<Element, ? extends First, ? extends Rest> $clone() {
        return this;
    }

    @Override
    @Annotations(value={@Annotation(value="shared"), @Annotation(value="actual")})
    @TypeInfo(value="ceylon.language::Iterator<Element>")
    public Iterator<Element> iterator() {
        return new TupleIterator();
    }

    @Override
    @Annotations(value={@Annotation(value="shared"), @Annotation(value="actual")})
    public boolean contains(@Name(value="element") @TypeInfo(value="ceylon.language::Object") Object element) {
        for (int ii = 0; ii < this.array.length; ++ii) {
            Object x = this.array[ii];
            if (x == null || !element.equals(x)) continue;
            return true;
        }
        return this.rest.contains(element);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Ignore
    public TypeDescriptor $getType$() {
        TypeDescriptor type;
        SoftReference<TypeDescriptor> cachedType = this.$cachedType;
        TypeDescriptor typeDescriptor = type = cachedType != null ? cachedType.get() : null;
        if (type == null) {
            Tuple tuple = this;
            synchronized (tuple) {
                cachedType = this.$cachedType;
                TypeDescriptor typeDescriptor2 = type = cachedType != null ? cachedType.get() : null;
                if (type == null) {
                    type = this.computeType();
                    this.$cachedType = new SoftReference<TypeDescriptor>(type);
                }
            }
        }
        return type;
    }

    private TypeDescriptor computeType() {
        TypeDescriptor restType = Metamodel.getTypeDescriptor(this.rest);
        TypeDescriptor elementType = Metamodel.getIteratedTypeDescriptor(restType);
        for (int i = this.array.length - 1; i >= 0; --i) {
            TypeDescriptor elemType = this.$getElementType(i);
            elementType = TypeDescriptor.union(elementType, elemType);
            restType = TypeDescriptor.klass(Tuple.class, elementType, elemType, restType);
        }
        return restType;
    }

    @Ignore
    private TypeDescriptor $getElementType(int index) {
        return Metamodel.getTypeDescriptor(this.array[index]);
    }

    @Override
    @Ignore
    public boolean defines(@Name(value="key") Integer key) {
        long ind = key.longValue();
        return ind >= 0L && ind < (long)this.array.length || this.rest.defines(Integer.instance(ind - (long)this.array.length));
    }

    @Override
    @Ignore
    public long count(@TypeInfo(value="ceylon.language::Callable<ceylon.language::Boolean,ceylon.language::Tuple<Element,Element,ceylon.language::Empty>>") @Name(value="selecting") @FunctionalParameter(value="(element)") Callable<? extends Boolean> f) {
        int count = 0;
        for (int ii = 0; ii < this.array.length; ++ii) {
            Object x = this.array[ii];
            if (x == null || !f.$call$(x).booleanValue()) continue;
            ++count;
        }
        return (long)count + this.rest.count(f);
    }

    @Override
    @Ignore
    public Sequence<? extends Element> sequence() {
        return this;
    }

    @Override
    @Ignore
    public boolean longerThan(long length) {
        return (long)this.array.length + this.rest.getSize() > length;
    }

    @Override
    @Ignore
    public boolean shorterThan(long length) {
        return (long)this.array.length + this.rest.getSize() < length;
    }

    @Override
    @Annotations(value={@Annotation(value="shared"), @Annotation(value="actual")})
    @TypeInfo(value="ceylon.language::Tuple<Element|Other,Other,ceylon.language::Tuple<Element,First,Rest>>")
    public final <Other> Tuple<Object, ? extends Other, Tuple<Element, ? extends First, ? extends Rest>> withLeading(@Ignore TypeDescriptor $reifiedOther, @Name(value="element") Other e) {
        int length = this.array.length;
        Object[] array = new Object[length + 1];
        array[0] = e;
        System.arraycopy(this.array, 0, array, 1, length);
        return new Tuple<Element, First, Rest>(TypeDescriptor.union(this.$reifiedElement, $reifiedOther), array, this.rest);
    }

    @Override
    @Annotations(value={@Annotation(value="shared"), @Annotation(value="actual")})
    @TypeInfo(value="ceylon.language::Tuple<Element|Other,First,ceylon.language::Sequence<Element|Other>>")
    public <Other> Tuple<Object, First, ? extends Sequential<?>> withTrailing(@Ignore TypeDescriptor $reifiedOther, @Name(value="element") Other e) {
        if (this.rest.getEmpty()) {
            int length = this.array.length;
            Object[] array = new Object[length + 1];
            System.arraycopy(this.array, 0, array, 0, length);
            array[length] = e;
            return new Tuple<Element, First, Rest>(TypeDescriptor.union(this.$reifiedElement, $reifiedOther), array);
        }
        return new Tuple<Element, First, Rest>(TypeDescriptor.union(this.$reifiedElement, $reifiedOther), this.array, this.rest.withTrailing($reifiedOther, e));
    }

    @Override
    @Annotations(value={@Annotation(value="shared"), @Annotation(value="actual")})
    @TypeInfo(value="ceylon.language::Tuple<Element|Other,First,ceylon.language::Sequential<Element|Other>>")
    public <Other> Tuple<Object, First, Sequential<?>> append(@Ignore TypeDescriptor $reifiedOther, @Name(value="elements") Sequential<? extends Other> es) {
        if (this.rest.getEmpty()) {
            Object o;
            int length = this.array.length;
            Object[] array = new Object[length + Util.toInt(es.getSize())];
            System.arraycopy(this.array, 0, array, 0, length);
            int ii = length;
            Iterator iter = es.iterator();
            while (!((o = iter.next()) instanceof Finished)) {
                array[ii++] = o;
            }
            return new Tuple<Element, First, Rest>(TypeDescriptor.union(this.$reifiedElement, $reifiedOther), array);
        }
        return new Tuple<Element, First, Rest>(TypeDescriptor.union(this.$reifiedElement, $reifiedOther), this.array, this.rest.append($reifiedOther, es));
    }

    @Ignore
    public Object[] $getArray$() {
        if (this.rest instanceof Empty) {
            return this.array;
        }
        return null;
    }

    @Ignore
    public int $getFirst$() {
        return 0;
    }

    @Ignore
    public int $getLength$() {
        return Util.toInt((long)this.array.length + this.rest.getSize());
    }

    @Ignore
    public Tuple($Serialization$ ignored, TypeDescriptor $reifiedElement, TypeDescriptor $reifiedFirst, TypeDescriptor $reifiedRest) {
        this.$reifiedElement = $reifiedElement;
        this.array = null;
        this.rest = null;
    }

    @Override
    @Ignore
    public Collection<ReachableReference> $references$() {
        ArrayList<ReachableReference> s = new ArrayList<ReachableReference>(2);
        ClassDeclaration cd = (ClassDeclaration)Metamodel.getOrCreateMetamodel(Tuple.class);
        s.add(new MemberImpl((FunctionOrValueDeclaration)Util.assertExists(cd.getMemberDeclaration(ValueDeclaration.$TypeDescriptor$, "first"))));
        s.add(new MemberImpl((FunctionOrValueDeclaration)Util.assertExists(cd.getMemberDeclaration(ValueDeclaration.$TypeDescriptor$, "rest"))));
        return s;
    }

    @Override
    @Ignore
    public void $set$(ReachableReference indexOrAttr, Object ref) {
    }

    @Ignore
    public void $completeInit$(Object first, Object rest) {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            Object[] array = Tuple.makeArray(first, (Sequential)rest);
            Util.setter(lookup, "array").invokeExact(this, array);
            Sequential<Element> rest2 = Tuple.makeRest((Sequential)rest);
            Util.setter(lookup, "rest").invokeExact(this, rest2);
        }
        catch (Throwable t) {
            rethrow_.rethrow(t);
        }
    }

    @Override
    @Ignore
    public Object $get$(ReachableReference indexOrAttr) {
        if (indexOrAttr instanceof Member) {
            switch (((Member)indexOrAttr).getAttribute().getQualifiedName()) {
                case "ceylon.language::Tuple.first": {
                    return this.getFirst();
                }
                case "ceylon.language::Tuple.rest": {
                    return this.getRest();
                }
            }
            throw new AssertionError("unknown attribute " + indexOrAttr);
        }
        throw new AssertionError("unknown reference " + indexOrAttr);
    }

    @Override
    @Ignore
    public Sequential$impl<? extends Element> $ceylon$language$Sequential$impl() {
        return new Sequential$impl(this.$reifiedElement, this);
    }

    @Override
    @Ignore
    public Sequential<? extends Element> initial(long length) {
        if (length <= 0L) {
            return empty_.get_();
        }
        long restSize = this.rest.getSize();
        if (length >= (long)this.array.length + restSize) {
            return this;
        }
        if (length >= (long)this.array.length) {
            return new Tuple<Element, First, Rest>(this.$reifiedElement, this.array, this.rest.initial(length - (long)this.array.length));
        }
        int len = (int)length;
        Object[] initialArray = new Object[len];
        System.arraycopy(this.array, 0, initialArray, 0, len);
        return new Tuple<Element, First, Rest>(this.$reifiedElement, initialArray, this.rest.initial(length - (long)this.array.length));
    }

    @Override
    @Ignore
    public Sequential<? extends Element> terminal(long length) {
        if (length <= 0L) {
            return empty_.get_();
        }
        long restSize = this.rest.getSize();
        if (length >= (long)this.array.length + restSize) {
            return this;
        }
        if (length > restSize) {
            int len = (int)(length - restSize);
            Object[] initialArray = new Object[len];
            System.arraycopy(this.array, this.array.length - len, initialArray, 0, len);
            return new Tuple<Element, First, Rest>(this.$reifiedElement, initialArray, this.rest);
        }
        return this.rest.terminal(length);
    }

    @Override
    @Ignore
    public Sequential<? extends Element> trim(Callable<? extends Boolean> f) {
        int i;
        int j;
        if (!this.rest.getEmpty()) {
            return this.$ceylon$language$Sequential$impl().trim(f);
        }
        int size = this.array.length;
        for (j = 0; j < size && f.$call$(this.array[j]).booleanValue(); ++j) {
        }
        for (i = 0; i < size && f.$call$(this.array[size - 1 - i]).booleanValue(); ++i) {
        }
        if (i == 0 && j == 0) {
            return this;
        }
        Object[] trimmedArray = new Object[size - i - j];
        System.arraycopy(this.array, j, trimmedArray, 0, size - i);
        return new Tuple<Element, First, Rest>(this.$reifiedElement, trimmedArray);
    }

    @Override
    @Ignore
    public Sequential<? extends Element> trimLeading(Callable<? extends Boolean> f) {
        int i;
        if (!this.rest.getEmpty()) {
            return this.$ceylon$language$Sequential$impl().trimLeading(f);
        }
        int size = this.array.length;
        for (i = 0; i < size && f.$call$(this.array[i]).booleanValue(); ++i) {
        }
        if (i == 0) {
            return this;
        }
        Object[] trimmedArray = new Object[size - i];
        System.arraycopy(this.array, i, trimmedArray, 0, size - i);
        return new Tuple<Element, First, Rest>(this.$reifiedElement, trimmedArray, this.rest);
    }

    @Override
    @Ignore
    public Sequential<? extends Element> trimTrailing(Callable<? extends Boolean> f) {
        int i;
        if (!this.rest.getEmpty()) {
            return this.$ceylon$language$Sequential$impl().trimTrailing(f);
        }
        int size = this.array.length;
        for (i = 0; i < size && f.$call$(this.array[size - 1 - i]).booleanValue(); ++i) {
        }
        if (i == 0) {
            return this;
        }
        Object[] trimmedArray = new Object[size - i];
        System.arraycopy(this.array, 0, trimmedArray, 0, size - i);
        return new Tuple<Element, First, Rest>(this.$reifiedElement, trimmedArray);
    }

    @Override
    @Ignore
    public List$impl<? extends Element> $ceylon$language$List$impl() {
        return new List$impl(this.$reifiedElement, this);
    }

    @Override
    @Ignore
    public boolean endsWith(List<? extends Object> list) {
        if (!this.rest.getEmpty()) {
            return this.$ceylon$language$List$impl().endsWith(list);
        }
        long size = list.getSize();
        if (size > (long)this.array.length) {
            return false;
        }
        if (size <= 0L) {
            return true;
        }
        int offset = this.array.length - (int)size;
        if (offset < 0) {
            return false;
        }
        int i = 0;
        while ((long)i < size) {
            Object x = this.array[i + offset];
            Object y = list.getFromFirst(i);
            if (!(x == y || x != null && y != null && x.equals(y))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    @Ignore
    public boolean startsWith(List<? extends Object> list) {
        if (!this.rest.getEmpty()) {
            return this.$ceylon$language$List$impl().startsWith(list);
        }
        long size = list.getSize();
        if (size > (long)this.array.length) {
            return false;
        }
        if (size <= 0L) {
            return true;
        }
        int offset = this.array.length - (int)size;
        if (offset < 0) {
            return false;
        }
        int i = 0;
        while ((long)i < size) {
            Object x = this.array[i];
            Object y = list.getFromFirst(i);
            if (!(x == y || x != null && y != null && x.equals(y))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private Integer adjustIndex(Integer index) {
        return Integer.instance(index.longValue() + (long)this.array.length);
    }

    @Override
    @Ignore
    public Integer firstIndexWhere(Callable<? extends Boolean> f) {
        for (int i = 0; i < this.array.length; ++i) {
            if (!f.$call$(this.array[i]).booleanValue()) continue;
            return Integer.instance(i);
        }
        Integer index = this.rest.firstIndexWhere(f);
        return index == null ? null : this.adjustIndex(index);
    }

    @Override
    @Ignore
    public Integer lastIndexWhere(Callable<? extends Boolean> f) {
        Integer index = this.rest.lastIndexWhere(f);
        if (index != null) {
            return this.adjustIndex(index);
        }
        for (int i = this.array.length - 1; i >= 0; --i) {
            if (!f.$call$(this.array[i]).booleanValue()) continue;
            return Integer.instance(i);
        }
        return null;
    }

    @Override
    @Ignore
    public Element get(Integer index) {
        return this.getFromFirst(index.value);
    }

    @Override
    @Ignore
    public Iterable<? extends Integer, ? extends Object> indexesWhere(Callable<? extends Boolean> f) {
        return this.$ceylon$language$List$impl().indexesWhere(f);
    }

    @Override
    @Ignore
    public <Other> List patch(TypeDescriptor $reifiedOther, List<? extends Other> list) {
        return this.$ceylon$language$List$impl().patch($reifiedOther, list);
    }

    @Override
    @Ignore
    public <Other> List patch(TypeDescriptor $reifiedOther, List<? extends Other> list, long index) {
        return this.$ceylon$language$List$impl().patch($reifiedOther, list, index);
    }

    @Override
    @Ignore
    public <Other> List patch(TypeDescriptor $reifiedOther, List<? extends Other> list, long index, long len) {
        return this.$ceylon$language$List$impl().patch($reifiedOther, list, index, len);
    }

    @Override
    @Ignore
    public <Other> long patch$from(TypeDescriptor $reifiedOther, List<? extends Other> list) {
        return list.getSize();
    }

    @Override
    @Ignore
    public <Other> long patch$length(TypeDescriptor arg0, List<? extends Other> list, long from) {
        return 0L;
    }

    @Override
    @Ignore
    public List<? extends Element> sublist(long from, long to) {
        return this.sublistTo(to).sublistFrom(from);
    }

    @Override
    @Ignore
    public List<? extends Element> sublistFrom(long from) {
        return this.$ceylon$language$List$impl().sublistFrom(from);
    }

    @Override
    @Ignore
    public List<? extends Element> sublistTo(long to) {
        return this.$ceylon$language$List$impl().sublistTo(to);
    }

    @Override
    @Ignore
    public Collection$impl<? extends Element> $ceylon$language$Collection$impl() {
        return new Collection$impl(this.$reifiedElement, this);
    }

    @Override
    @Ignore
    public Iterable$impl<? extends Element, ? extends Object> $ceylon$language$Iterable$impl() {
        return new Iterable$impl(this.$reifiedElement, TypeDescriptor.NothingType, this);
    }

    @Override
    @Ignore
    public boolean any(Callable<? extends Boolean> f) {
        for (int i = 0; i < this.array.length; ++i) {
            if (!f.$call$(this.array[i]).booleanValue()) continue;
            return true;
        }
        return this.rest.any(f);
    }

    @Override
    @Ignore
    public boolean every(Callable<? extends Boolean> f) {
        for (int i = 0; i < this.array.length; ++i) {
            if (f.$call$(this.array[i]).booleanValue()) continue;
            return false;
        }
        return this.rest.every(f);
    }

    @Override
    @Ignore
    public Iterable<? extends Element, ? extends Object> by(long step) {
        return this.$ceylon$language$Iterable$impl().by(step);
    }

    @Override
    @Ignore
    public <Other, OtherAbsent> Iterable chain(TypeDescriptor $reifiedOther, TypeDescriptor $reifiedOtherAbsent, Iterable<? extends Other, ? extends OtherAbsent> it) {
        return this.$ceylon$language$Iterable$impl().chain($reifiedOther, $reifiedOtherAbsent, it);
    }

    @Override
    @Ignore
    public <Default> Iterable defaultNullElements(TypeDescriptor $reified$Default, Default defaultValue) {
        return this.$ceylon$language$Iterable$impl().defaultNullElements($reified$Default, defaultValue);
    }

    @Override
    @Ignore
    public Object each(Callable<? extends Object> f) {
        for (int i = 0; i < this.array.length; ++i) {
            f.$call$(this.array[i]);
        }
        this.rest.each(f);
        return null;
    }

    @Override
    @Ignore
    public Iterable<? extends Element, ? extends Object> filter(Callable<? extends Boolean> selecting) {
        return this.$ceylon$language$Iterable$impl().filter(selecting);
    }

    @Override
    @Ignore
    public <Type> Iterable narrow(@Ignore TypeDescriptor $reifiedType) {
        return this.$ceylon$language$Iterable$impl().narrow($reifiedType);
    }

    @Override
    @Ignore
    public <Result, OtherAbsent> Iterable flatMap(TypeDescriptor $reified$Result, TypeDescriptor $reified$OtherAbsent, Callable<? extends Iterable<? extends Result, ? extends OtherAbsent>> collecting) {
        return this.$ceylon$language$Iterable$impl().flatMap($reified$Result, $reified$OtherAbsent, collecting);
    }

    @Override
    @Ignore
    public <Result> Callable<? extends Result> fold(TypeDescriptor $reified$Result, Result initial) {
        return this.$ceylon$language$Iterable$impl().fold($reified$Result, initial);
    }

    @Override
    @Ignore
    public <Other> Iterable follow(TypeDescriptor $reified$Other, Other head) {
        return this.$ceylon$language$Iterable$impl().follow($reified$Other, head);
    }

    @Override
    @Ignore
    public Iterable<? extends Element, ? extends Object> getCoalesced() {
        return this.$ceylon$language$Iterable$impl().getCoalesced();
    }

    @Override
    @Ignore
    public Iterable<? extends Element, ? extends Object> getCycled() {
        return this.$ceylon$language$Iterable$impl().getCycled();
    }

    @Override
    @Ignore
    public Iterable<? extends Element, ? extends Object> getExceptLast() {
        return this.$ceylon$language$Iterable$impl().getExceptLast();
    }

    @Override
    @Ignore
    public Iterable<? extends Entry<? extends Integer, ? extends Element>, ? extends Object> getIndexed() {
        return this.$ceylon$language$Iterable$impl().getIndexed();
    }

    @Override
    @Ignore
    public Iterable<? extends Sequence<? extends Element>, ? extends Object> getPaired() {
        return this.$ceylon$language$Iterable$impl().getPaired();
    }

    @Override
    @Ignore
    public <Other> Iterable interpose(TypeDescriptor $reifiedOther, Other o) {
        return this.$ceylon$language$Iterable$impl().interpose($reifiedOther, o);
    }

    @Override
    @Ignore
    public <Other> Iterable interpose(TypeDescriptor $reifiedOther, Other o, long step) {
        return this.$ceylon$language$Iterable$impl().interpose($reifiedOther, o, step);
    }

    @Override
    @Ignore
    public <Other> long interpose$step(TypeDescriptor arg0, Other arg1) {
        return 1L;
    }

    @Override
    @Ignore
    public <Result> Iterable<? extends Result, ? extends Object> map(TypeDescriptor $reified$Result, Callable<? extends Result> collecting) {
        return this.$ceylon$language$Iterable$impl().map($reified$Result, collecting);
    }

    @Override
    @Ignore
    public Object max(Callable<? extends Comparison> f) {
        Object object;
        Object result = this.array[0];
        for (int i = 1; i < this.array.length; ++i) {
            Object object2 = this.array[i];
            if (f.$call$(object2, result) != larger_.get_()) continue;
            result = object2;
        }
        if (!this.rest.getEmpty() && f.$call$(object = this.rest.max(f), result) == larger_.get_()) {
            result = object;
        }
        return result;
    }

    @Override
    @Ignore
    public Iterable<? extends Sequence<? extends Element>, ? extends Object> partition(long length) {
        return this.$ceylon$language$Iterable$impl().partition(length);
    }

    @Override
    @Ignore
    public <Other, OtherAbsent> Iterable product(TypeDescriptor $reified$Other, TypeDescriptor $reified$OtherAbsent, Iterable<? extends Other, ? extends OtherAbsent> other) {
        return this.$ceylon$language$Iterable$impl().product($reified$Other, $reified$OtherAbsent, other);
    }

    @Override
    @Ignore
    public <Result> Object reduce(TypeDescriptor $reifiedResult, Callable<? extends Result> f) {
        return this.$ceylon$language$Iterable$impl().reduce($reifiedResult, f);
    }

    @Override
    @Ignore
    public <Result> Callable<? extends Iterable<? extends Result, ? extends Object>> scan(TypeDescriptor $reified$Result, Result initial) {
        return this.$ceylon$language$Iterable$impl().scan($reified$Result, initial);
    }

    @Override
    @Ignore
    public Sequential<? extends Element> select(Callable<? extends Boolean> selecting) {
        return this.$ceylon$language$Iterable$impl().select(selecting);
    }

    @Override
    @Ignore
    public Iterable<? extends Element, ? extends Object> skip(long skipping) {
        return this.$ceylon$language$Iterable$impl().skip(skipping);
    }

    @Override
    @Ignore
    public Iterable<? extends Element, ? extends Object> skipWhile(Callable<? extends Boolean> skipping) {
        return this.$ceylon$language$Iterable$impl().skipWhile(skipping);
    }

    @Override
    @Ignore
    public <Result, Args extends Sequential<? extends Object>> Callable<? extends Iterable<? extends Result, ? extends Object>> spread(TypeDescriptor $reified$Result, TypeDescriptor $reified$Args, Callable<? extends Callable<? extends Result>> method) {
        return this.$ceylon$language$Iterable$impl().spread($reified$Result, $reified$Args, method);
    }

    @Override
    @Ignore
    public Iterable<? extends Element, ? extends Object> take(long taking) {
        return this.$ceylon$language$Iterable$impl().take(taking);
    }

    @Override
    @Ignore
    public Iterable<? extends Element, ? extends Object> takeWhile(Callable<? extends Boolean> taking) {
        return this.$ceylon$language$Iterable$impl().takeWhile(taking);
    }

    @Override
    @Ignore
    public Category$impl<? super Object> $ceylon$language$Category$impl() {
        return new Category$impl<Object>(this.$reifiedElement, this);
    }

    @Override
    @Ignore
    public boolean containsAny(Iterable<? extends Object, ? extends Object> it) {
        return this.$ceylon$language$Category$impl().containsAny(it);
    }

    @Override
    @Ignore
    public boolean containsEvery(Iterable<? extends Object, ? extends Object> it) {
        return this.$ceylon$language$Category$impl().containsEvery(it);
    }

    @Override
    @Ignore
    public Correspondence$impl<? super Integer, ? extends Element> $ceylon$language$Correspondence$impl() {
        return new Correspondence$impl(Integer.$TypeDescriptor$, this.$reifiedElement, this);
    }

    @Override
    @Ignore
    public boolean definesAny(Iterable<? extends Integer, ? extends Object> it) {
        return this.$ceylon$language$Correspondence$impl().definesAny(it);
    }

    @Override
    @Ignore
    public boolean definesEvery(Iterable<? extends Integer, ? extends Object> it) {
        return this.$ceylon$language$Correspondence$impl().definesEvery(it);
    }

    @Override
    @Ignore
    public <Absent> Iterable<? extends Element, ? extends Absent> getAll(TypeDescriptor $reified$Absent, Iterable<? extends Integer, ? extends Absent> keys) {
        return this.$ceylon$language$Correspondence$impl().getAll($reified$Absent, keys);
    }

    @Override
    @Ignore
    public Sequence$impl<? extends Element> $ceylon$language$Sequence$impl() {
        return new Sequence$impl(this.$reifiedElement, this);
    }

    @Override
    @Ignore
    public <Result> Sequence<? extends Result> collect(TypeDescriptor $reified$Result, Callable<? extends Result> collecting) {
        return this.$ceylon$language$Sequence$impl().collect($reified$Result, collecting);
    }

    @Override
    @Ignore
    public Element find(Callable<? extends Boolean> f) {
        for (int i = 0; i < this.array.length; ++i) {
            Object object = this.array[i];
            if (!f.$call$(object).booleanValue()) continue;
            return (Element)object;
        }
        return this.rest.find(f);
    }

    @Override
    @Ignore
    public Element findLast(Callable<? extends Boolean> f) {
        Object element = this.rest.findLast(f);
        if (element != null) {
            return element;
        }
        for (int i = this.array.length - 1; i >= 0; --i) {
            Object object = this.array[i];
            if (!f.$call$(object).booleanValue()) continue;
            return (Element)object;
        }
        return null;
    }

    private Entry<Integer, Element> adjustEntry(Entry<? extends Integer, ?> entry) {
        return new Entry(Integer.$TypeDescriptor$, this.$reifiedElement, Integer.instance(entry.getKey().longValue() + (long)this.array.length), entry.getItem());
    }

    @Override
    @Ignore
    public Entry<? extends Integer, ? extends Element> locate(Callable<? extends Boolean> f) {
        for (int i = 0; i < this.array.length; ++i) {
            Object object = this.array[i];
            if (!f.$call$(object).booleanValue()) continue;
            return new Entry<Integer, Object>(Integer.$TypeDescriptor$, this.$reifiedElement, Integer.instance(i), object);
        }
        Entry entry = this.rest.locate(f);
        return entry == null ? null : this.adjustEntry(entry);
    }

    @Override
    @Ignore
    public Entry<? extends Integer, ? extends Element> locateLast(Callable<? extends Boolean> f) {
        Entry entry = this.rest.locateLast(f);
        if (entry != null) {
            return this.adjustEntry(entry);
        }
        for (int i = this.array.length - 1; i >= 0; --i) {
            Object object = this.array[i];
            if (!f.$call$(object).booleanValue()) continue;
            return new Entry<Integer, Object>(Integer.$TypeDescriptor$, this.$reifiedElement, Integer.instance(i), object);
        }
        return null;
    }

    @Override
    @Ignore
    public Iterable<? extends Entry<? extends Integer, ? extends Element>, ? extends Object> locations(Callable<? extends Boolean> f) {
        return this.$ceylon$language$Iterable$impl().locations(f);
    }

    @Override
    @Ignore
    public boolean getEmpty() {
        return false;
    }

    @Override
    @Ignore
    public Range getKeys() {
        return this.$ceylon$language$Sequence$impl().getKeys();
    }

    @Override
    @Ignore
    public Range indexes() {
        return this.$ceylon$language$Sequence$impl().indexes();
    }

    @Override
    @Ignore
    public Sequence<? extends Element> getReversed() {
        return this.$ceylon$language$Sequence$impl().getReversed();
    }

    @Override
    @Ignore
    public <Other> Sequence prepend(TypeDescriptor $reifiedOther, Sequential<? extends Other> elements) {
        return this.$ceylon$language$Sequence$impl().prepend($reifiedOther, elements);
    }

    @Override
    @Ignore
    public Sequential<? extends Element> repeat(long times) {
        return this.$ceylon$language$Sequence$impl().repeat(times);
    }

    @Override
    @Ignore
    public Sequence slice(long index) {
        return this.$ceylon$language$Sequence$impl().slice(index);
    }

    @Override
    @Ignore
    public Sequence<? extends Element> sort(Callable<? extends Comparison> comparing) {
        return this.$ceylon$language$Sequence$impl().sort(comparing);
    }

    @Override
    @Ignore
    public Iterable<? extends Sequence<? extends Element>, ? extends Object> getPermutations() {
        return this.$ceylon$language$Collection$impl().getPermutations();
    }

    @Override
    @Ignore
    public Iterable<? extends Sequence<? extends Element>, ? extends Object> combinations(long length) {
        return this.$ceylon$language$Collection$impl().combinations(length);
    }

    @Override
    @Ignore
    public <Group> Map<? extends Group, ? extends Sequence<? extends Element>> group(TypeDescriptor $reifiedGroup, Callable<? extends Group> fun) {
        return this.$ceylon$language$Iterable$impl().group($reifiedGroup, fun);
    }

    @Override
    @Ignore
    public <Group, Result> Map<? extends Group, ? extends Result> summarize(TypeDescriptor $reifiedGroup, TypeDescriptor $reifiedResult, Callable<? extends Group> fun, Callable<? extends Result> fold) {
        return this.$ceylon$language$Iterable$impl().summarize($reifiedGroup, $reifiedResult, fun, fold);
    }

    @Override
    @Ignore
    public Iterable<? extends Element, ? extends Object> getDistinct() {
        return this.$ceylon$language$Iterable$impl().getDistinct();
    }

    @Override
    @Ignore
    public <Item> Map<? extends Element, ? extends Item> tabulate(TypeDescriptor arg0, Callable<? extends Item> arg1) {
        return this.$ceylon$language$Iterable$impl().tabulate(arg0, arg1);
    }

    @Override
    @Ignore
    public Map<? extends Element, ? extends Integer> frequencies() {
        return this.$ceylon$language$Iterable$impl().frequencies();
    }

    @Override
    @Ignore
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.appendCharacter(91);
        boolean first = true;
        for (int i = 0; i < this.array.length; ++i) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            Object object = this.array[i];
            sb.append(object == null ? "<null>" : object.toString());
        }
        if (!this.rest.getEmpty()) {
            sb.append(", *").append(this.rest.toString());
        }
        sb.appendCharacter(93);
        return sb.toString();
    }

    @Override
    @Ignore
    public boolean equals(Object obj) {
        return this.$ceylon$language$List$impl().equals(obj);
    }

    @Override
    @Ignore
    public int hashCode() {
        return this.$ceylon$language$List$impl().hashCode();
    }

    @Override
    @Ignore
    public <Result> List<? extends Result> mapElements(TypeDescriptor $reified$Result, Callable<? extends Result> collecting) {
        return this.$ceylon$language$List$impl().mapElements($reified$Result, collecting);
    }

    @Ignore
    private class TupleIterator
    extends BaseIterator<Element> {
        private long idx;
        private Iterator<? extends Element> restIter;

        private TupleIterator() {
            super(Tuple.this.$getReifiedElement$());
            this.idx = 0L;
            this.restIter = Tuple.this.rest.iterator();
        }

        @Override
        public Object next() {
            if (this.idx < (long)Tuple.this.array.length) {
                return Tuple.this.array[Util.toInt(this.idx++)];
            }
            return this.restIter.next();
        }

        public String toString() {
            return "TupleIterator";
        }
    }
}

