/*
 * Decompiled with CFR 0.152.
 */
package ceylon.language.serialization;

import ceylon.language.Array;
import ceylon.language.AssertionError;
import ceylon.language.Collection;
import ceylon.language.Entry;
import ceylon.language.Integer;
import ceylon.language.Iterator;
import ceylon.language.String;
import ceylon.language.Tuple;
import ceylon.language.impl.ElementImpl;
import ceylon.language.impl.MemberImpl;
import ceylon.language.impl.rethrow_;
import ceylon.language.meta.declaration.ClassDeclaration;
import ceylon.language.meta.declaration.ValueDeclaration;
import ceylon.language.meta.model.ClassModel;
import ceylon.language.meta.model.Type;
import ceylon.language.serialization.DeserializationContextImpl;
import ceylon.language.serialization.DeserializationException;
import ceylon.language.serialization.Element;
import ceylon.language.serialization.Member;
import ceylon.language.serialization.NativeMap;
import ceylon.language.serialization.Outer;
import ceylon.language.serialization.Partial;
import ceylon.language.serialization.ReachableReference;
import ceylon.language.serialization.uninitializedLateValue_;
import com.redhat.ceylon.compiler.java.Util;
import com.redhat.ceylon.compiler.java.metadata.Ceylon;
import com.redhat.ceylon.compiler.java.metadata.Class;
import com.redhat.ceylon.compiler.java.runtime.metamodel.Metamodel;
import com.redhat.ceylon.compiler.java.runtime.metamodel.meta.ClassImpl;
import com.redhat.ceylon.compiler.java.runtime.metamodel.meta.MemberClassImpl;
import com.redhat.ceylon.compiler.java.runtime.model.ReifiedType;
import com.redhat.ceylon.compiler.java.runtime.model.TypeDescriptor;
import com.redhat.ceylon.compiler.java.runtime.serialization.$Serialization$;
import com.redhat.ceylon.compiler.java.runtime.serialization.Serializable;
import com.redhat.ceylon.model.typechecker.model.FunctionOrValue;
import com.redhat.ceylon.model.typechecker.model.TypedReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashSet;

@Ceylon(major=8, minor=0)
@Class
class PartialImpl
extends Partial {
    PartialImpl(Object id) {
        super(id);
    }

    private TypeDescriptor.Class getClassTypeDescriptor() {
        ClassModel classModel = this.getClazz();
        if (classModel == null) {
            throw new DeserializationException("no class specified for instance with id " + this.getId());
        }
        if (classModel instanceof ClassImpl) {
            return (TypeDescriptor.Class)((TypeDescriptor.Class)((ReifiedType)((Object)classModel)).$getType$()).getTypeArgument(0);
        }
        if (classModel instanceof MemberClassImpl) {
            return (TypeDescriptor.Class)((TypeDescriptor.Member)((TypeDescriptor.Class)((ReifiedType)((Object)classModel)).$getType$()).getTypeArgument(1)).getMember();
        }
        throw new AssertionError("unexpected class model for instance with id " + this.getId() + ": " + (classModel != null ? classModel.getClass().getName() : "null"));
    }

    private TypeDescriptor.Class getOuterClassTypeDescriptor() {
        ClassModel classModel = this.getClazz();
        if (classModel instanceof MemberClassImpl) {
            return (TypeDescriptor.Class)((TypeDescriptor.Class)((ReifiedType)((Object)classModel)).$getType$()).getTypeArgument(0);
        }
        return null;
    }

    @Override
    public Object instantiate() {
        Object outer;
        java.lang.Class<?> outerClass;
        ClassModel classModel = this.getClazz();
        if (classModel == null) {
            throw new DeserializationException("no class specified for instance with id " + this.getId());
        }
        java.lang.Class<?> clazz = this.getClassTypeDescriptor().getKlass();
        if (classModel instanceof ClassImpl) {
            outerClass = null;
            outer = null;
        } else if (classModel instanceof MemberClassImpl) {
            outerClass = this.getOuterClassTypeDescriptor().getKlass();
            outer = super.getContainer();
            if (outer instanceof Partial) {
                outer = ((Partial)outer).getInstance_();
            }
            if (outer == null) {
                throw new DeserializationException("no containing instance specified for member instance with id" + this.getId());
            }
        } else {
            throw new AssertionError("unexpected class model: " + (classModel != null ? classModel.getClass().getName() : "null"));
        }
        Collection<? extends Type<? extends Object>> typeArgs = classModel.getTypeArguments().getItems();
        java.lang.Class[] types = new java.lang.Class[(outerClass != null ? 2 : 1) + Util.toInt(typeArgs.getSize())];
        Object[] args = new Object[(outer != null ? 2 : 1) + Util.toInt(typeArgs.getSize())];
        int ii = 0;
        if (outerClass != null) {
            types[ii] = outerClass;
            args[ii] = outer;
            ++ii;
        }
        types[ii] = $Serialization$.class;
        args[ii] = null;
        ++ii;
        int jj = 0;
        while ((long)jj < typeArgs.getSize()) {
            types[ii] = TypeDescriptor.class;
            args[ii] = Metamodel.getTypeDescriptor((Type)typeArgs.getFromFirst(jj));
            ++ii;
            ++jj;
        }
        try {
            Constructor<?> ctor = clazz.getDeclaredConstructor(types);
            ctor.setAccessible(true);
            Object newInstance = ctor.newInstance(args);
            if (!(newInstance instanceof Serializable)) {
                throw new AssertionError("instance class " + classModel + " is not serializable for instance with id " + this.getId());
            }
            super.setInstance_(newInstance);
        }
        catch (NoSuchMethodException e) {
            throw new DeserializationException("instance class " + classModel + " is not serializable for instance with id " + this.getId());
        }
        catch (InvocationTargetException e) {
            rethrow_.rethrow(e);
        }
        catch (SecurityException e) {
            rethrow_.rethrow(e);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException e) {
            rethrow_.rethrow(e);
        }
        return null;
    }

    @Override
    public <Id> Object initialize(TypeDescriptor $reified$Id, DeserializationContextImpl<Id> context) {
        Object instance_2 = this.getInstance_();
        if (!(instance_2 instanceof Serializable)) {
            throw new AssertionError("Cannot initialize instance that is not serializable");
        }
        Serializable instance = (Serializable)instance_2;
        if (instance_2 instanceof Array) {
            this.initializeArray(context, (Array)instance);
        } else if (instance_2 instanceof Tuple) {
            this.initializeTuple($reified$Id, context, (Tuple)instance);
        } else {
            this.initializeObject($reified$Id, context, instance);
        }
        this.setState(null);
        return null;
    }

    protected <Id> void initializeTuple(TypeDescriptor $reified$Id, DeserializationContextImpl<Id> context, Tuple<?, ?, ?> instance) {
        com.redhat.ceylon.model.typechecker.model.Type restMemberType;
        NativeMap<ReachableReference, Object> state = this.getState();
        ValueDeclaration firstAttribute = Util.assertExists((ValueDeclaration)((ClassDeclaration)Metamodel.getOrCreateMetamodel(Tuple.class)).getMemberDeclaration(ValueDeclaration.$TypeDescriptor$, "first"));
        MemberImpl firstMember = new MemberImpl(firstAttribute);
        Object first = this.getReferredInstance(context, state, firstMember);
        ValueDeclaration restAttribute = Util.assertExists((ValueDeclaration)((ClassDeclaration)Metamodel.getOrCreateMetamodel(Tuple.class)).getMemberDeclaration(ValueDeclaration.$TypeDescriptor$, "rest"));
        MemberImpl restMember = new MemberImpl(restAttribute);
        Object restId = state.get(restMember);
        Object referredRest = context.leakInstance(restId);
        if (referredRest instanceof Partial && !((PartialImpl)referredRest).getInitialized()) {
            ((PartialImpl)referredRest).initialize($reified$Id, context);
        }
        Object rest = this.getReferredInstance(context, state, restMember);
        instance.$completeInit$(first, rest);
        com.redhat.ceylon.model.typechecker.model.Type firstMemberType = Metamodel.getModuleManager().getCachedType(this.getClassTypeDescriptor().getTypeArgument(1));
        com.redhat.ceylon.model.typechecker.model.Type firstInstanceType = Metamodel.getModuleManager().getCachedType(Metamodel.getTypeDescriptor(first));
        if (!firstInstanceType.isSubtypeOf(firstMemberType)) {
            throw this.notAssignable(firstMember, firstMemberType, firstInstanceType);
        }
        com.redhat.ceylon.model.typechecker.model.Type restInstanceType = Metamodel.getModuleManager().getCachedType(Metamodel.getTypeDescriptor(rest));
        if (!restInstanceType.isSubtypeOf(restMemberType = Metamodel.getModuleManager().getCachedType(this.getClassTypeDescriptor().getTypeArgument(2)))) {
            throw this.notAssignable(restMember, restMemberType, restInstanceType);
        }
    }

    protected <Id> void initializeArray(DeserializationContextImpl<Id> context, Array<?> instance) {
        ReachableReference sizeAttr;
        NativeMap<ReachableReference, Object> state = this.getState();
        Integer size = (Integer)this.getReferredInstance(context, state, sizeAttr = instance.$references$().iterator().next());
        if (size == null) {
            throw this.insufficiantState(sizeAttr);
        }
        instance.$set$(sizeAttr, size);
        int sz = Util.toInt(size.longValue());
        for (int ii = 0; ii < sz; ++ii) {
            ElementImpl index = new ElementImpl(ii);
            Object id = state.get(index);
            if (id == null) {
                throw this.insufficiantState(index);
            }
            TypeDescriptor.Class arrayType = (TypeDescriptor.Class)Metamodel.getTypeDescriptor(instance);
            com.redhat.ceylon.model.typechecker.model.Type arrayElementType = Metamodel.getModuleManager().getCachedType(arrayType.getTypeArguments()[0]);
            Object element = this.getReferredInstance(context, id);
            com.redhat.ceylon.model.typechecker.model.Type elementType = Metamodel.getModuleManager().getCachedType(Metamodel.getTypeDescriptor(element));
            if (!elementType.isSubtypeOf(arrayElementType)) {
                throw this.notAssignable(index, arrayElementType, elementType);
            }
            instance.$set$(index, element);
        }
        if (state.getSize() != (long)(sz + 1)) {
            throw this.insufficiantState((ReachableReference)null);
        }
    }

    protected <Id> void initializeObject(TypeDescriptor $reified$Id, DeserializationContextImpl<Id> context, Serializable instance) {
        NativeMap<ReachableReference, Object> state = this.getState();
        java.util.Collection<ReachableReference> reachables = instance.$references$();
        int numLate = 0;
        for (ReachableReference r : reachables) {
            if (r instanceof Member && ((Member)r).getAttribute().getLate()) {
                ++numLate;
                continue;
            }
            if (!(r instanceof Outer)) continue;
            ++numLate;
        }
        if (state.getSize() < (long)(reachables.size() - numLate)) {
            Object next;
            HashSet<ReachableReference> missingNames = new HashSet<ReachableReference>();
            java.util.Iterator<ReachableReference> it = reachables.iterator();
            while (it.hasNext()) {
                missingNames.add(it.next());
            }
            Iterator<ReachableReference> it2 = state.getKeys().iterator();
            while ((next = it2.next()) instanceof ReachableReference) {
                missingNames.remove(next);
            }
            throw this.insufficiantState(missingNames);
        }
        for (ReachableReference reference : reachables) {
            if (reference instanceof Member) {
                com.redhat.ceylon.model.typechecker.model.Type instanceType;
                Object referredId;
                Object r;
                Object referredInstance;
                Member member = (Member)reference;
                if (member.getAttribute().getLate() && !state.contains(member) || state.get(member) == uninitializedLateValue_.get_()) continue;
                TypeDescriptor.Class classTypeDescriptor = this.getClassTypeDescriptor();
                Entry<TypeDescriptor.Class, String> cacheKey = new Entry<TypeDescriptor.Class, String>(TypeDescriptor.klass(TypeDescriptor.Class.class, new TypeDescriptor[0]), String.$TypeDescriptor$, classTypeDescriptor, String.instance(member.getAttribute().getQualifiedName()));
                com.redhat.ceylon.model.typechecker.model.Type memberType = (com.redhat.ceylon.model.typechecker.model.Type)context.getMemberTypeCache().get(cacheKey);
                if (memberType == null) {
                    com.redhat.ceylon.model.typechecker.model.Type pt = Metamodel.getModuleManager().getCachedType(classTypeDescriptor);
                    while (!pt.getDeclaration().getQualifiedNameString().equals(((ClassDeclaration)member.getAttribute().getContainer()).getQualifiedName())) {
                        pt = pt.getExtendedType();
                    }
                    FunctionOrValue attributeDeclaration = (FunctionOrValue)pt.getDeclaration().getMember(member.getAttribute().getName(), null, false);
                    TypedReference attributeType = pt.getTypedMember(attributeDeclaration, Collections.emptyList(), true);
                    memberType = attributeType.getType();
                    context.getMemberTypeCache().put(cacheKey, memberType);
                }
                if ((referredInstance = this.getReferredInstance(context, state, member)) instanceof Tuple && (r = context.leakInstance(referredId = state.get(member))) instanceof PartialImpl) {
                    ((PartialImpl)r).initialize($reified$Id, context);
                }
                if (!(instanceType = Metamodel.getModuleManager().getCachedType(Metamodel.getTypeDescriptor(referredInstance))).isSubtypeOf(memberType)) {
                    throw this.notAssignable(member, memberType, instanceType);
                }
                instance.$set$(member, referredInstance);
                continue;
            }
            if (reference instanceof Outer) continue;
            throw new AssertionError("unexpected ReachableReference " + reference);
        }
    }

    java.lang.String descriptor(ReachableReference reachable) {
        if (reachable instanceof Member) {
            return java.lang.String.valueOf(((Member)reachable).getAttribute());
        }
        if (reachable instanceof Element) {
            return "index " + ((Element)reachable).getIndex();
        }
        return java.lang.String.valueOf(reachable);
    }

    DeserializationException notAssignable(ReachableReference attributeOrIndex, com.redhat.ceylon.model.typechecker.model.Type attributeOrIndexType, com.redhat.ceylon.model.typechecker.model.Type instanceType) {
        return new DeserializationException("instance not assignable to " + this.descriptor(attributeOrIndex) + " of id " + this.getId() + ": " + instanceType.asString() + " is not assignable to " + attributeOrIndexType.asString());
    }

    DeserializationException insufficiantState(java.util.Collection<ReachableReference> missingNames) {
        StringBuilder sb = new StringBuilder();
        java.util.Iterator<ReachableReference> iterator = missingNames.iterator();
        while (iterator.hasNext()) {
            ReachableReference r = iterator.next();
            sb.append(this.descriptor(r));
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        return new DeserializationException("lacking sufficient state for instance with id " + this.getId() + ": " + sb.toString());
    }

    DeserializationException insufficiantState(ReachableReference missing) {
        return new DeserializationException("lacking sufficient state for instance with id " + this.getId() + (missing != null ? ": " + this.descriptor(missing) : ""));
    }

    protected <Id> Object getReferredInstance(DeserializationContextImpl<Id> context, NativeMap<ReachableReference, Id> state, ReachableReference reachable) {
        Id referredId = state.get(reachable);
        return this.getReferredInstance(context, referredId);
    }

    protected <Id> Object getReferredInstance(DeserializationContextImpl<Id> context, Id referredId) {
        Object referred = context.leakInstance(referredId);
        if (referred instanceof Partial) {
            referred = ((Partial)referred).getInstance_();
        }
        return referred;
    }

    public java.lang.String toString() {
        return "Partial " + this.getId() + (this.getInitialized() ? " initialized " : (this.getInstantiated() ? " instantiated " : " uninstantiated ")) + this.getClazz();
    }
}

