/*
 * Decompiled with CFR 0.152.
 */
package ceylon.modules.jboss.runtime;

import ceylon.modules.jboss.runtime.UtilRegistryTransformer;
import com.redhat.ceylon.common.ModuleUtil;
import com.redhat.ceylon.model.cmr.RuntimeResolver;
import com.redhat.ceylon.model.runtime.CeylonModuleClassLoader;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleClassLoaderFactory;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;

public class CeylonModuleClassLoader
extends ModuleClassLoader
implements com.redhat.ceylon.model.runtime.CeylonModuleClassLoader {
    private UtilRegistryTransformer transformer;
    private volatile int registerThreadCount = 0;
    private final Object registerThreadLock = new Object();

    protected CeylonModuleClassLoader(ModuleClassLoader.Configuration configuration, UtilRegistryTransformer transformer) {
        super(configuration);
        this.transformer = transformer;
    }

    @Override
    public void registerInMetaModel() {
        this.transformer.register(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerThreadRunning() {
        Object object = this.registerThreadLock;
        synchronized (object) {
            ++this.registerThreadCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerThreadDone() {
        Object object = this.registerThreadLock;
        synchronized (object) {
            --this.registerThreadCount;
            this.registerThreadLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForRegisterThreads() {
        Object object = this.registerThreadLock;
        synchronized (object) {
            while (this.registerThreadCount > 0) {
                try {
                    this.registerThreadLock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    @Override
    public String getModuleName() {
        String name = ModuleUtil.getModuleNameFromUri(this.getModule().getIdentifier().getName());
        return name;
    }

    @Override
    public String getModuleVersion() {
        return this.getModule().getIdentifier().getSlot();
    }

    @Override
    public RuntimeResolver getRuntimeResolver() {
        ModuleLoader moduleLoader = this.getModule().getModuleLoader();
        return moduleLoader instanceof RuntimeResolver ? (RuntimeResolver)((Object)moduleLoader) : null;
    }

    @Override
    public com.redhat.ceylon.model.runtime.CeylonModuleClassLoader loadModule(String name, String version2) throws CeylonModuleClassLoader.ModuleLoadException {
        ModuleLoader moduleLoader = this.getModule().getModuleLoader();
        try {
            ModuleClassLoader classLoader = moduleLoader.loadModule(ModuleIdentifier.create(name, version2)).getClassLoader();
            return classLoader instanceof com.redhat.ceylon.model.runtime.CeylonModuleClassLoader ? (com.redhat.ceylon.model.runtime.CeylonModuleClassLoader)((Object)classLoader) : null;
        }
        catch (ModuleLoadException e) {
            throw new CeylonModuleClassLoader.ModuleLoadException(e);
        }
    }

    static {
        boolean parallelOk = true;
        try {
            parallelOk = ClassLoader.registerAsParallelCapable();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (!parallelOk) {
            throw new Error("Failed to register " + CeylonModuleClassLoader.class.getName() + " as parallel-capable");
        }
    }

    static class CeylonModuleClassLoaderFactory
    implements ModuleClassLoaderFactory {
        private UtilRegistryTransformer transformer;

        public CeylonModuleClassLoaderFactory(UtilRegistryTransformer transformer) {
            this.transformer = transformer;
        }

        @Override
        public ModuleClassLoader create(ModuleClassLoader.Configuration configuration) {
            return new CeylonModuleClassLoader(configuration, this.transformer);
        }
    }
}

