/*
 * Decompiled with CFR 0.152.
 */
package ceylon.modules.jboss.runtime;

import ceylon.modules.api.runtime.LogChecker;
import ceylon.modules.api.util.ModuleVersion;
import ceylon.modules.jboss.repository.ResourceLoaderProvider;
import ceylon.modules.jboss.runtime.CMRPathFilter;
import ceylon.modules.jboss.runtime.CeylonModuleClassLoader;
import ceylon.modules.jboss.runtime.Graph;
import ceylon.modules.jboss.runtime.Node;
import ceylon.modules.jboss.runtime.OnDemandLocalLoader;
import ceylon.modules.jboss.runtime.SecurityActions;
import ceylon.modules.jboss.runtime.UtilRegistryTransformer;
import com.redhat.ceylon.cmr.api.ArtifactContext;
import com.redhat.ceylon.cmr.api.ModuleDependencyInfo;
import com.redhat.ceylon.cmr.api.RepositoryManager;
import com.redhat.ceylon.common.ModuleUtil;
import com.redhat.ceylon.model.cmr.ArtifactResult;
import com.redhat.ceylon.model.cmr.ArtifactResultType;
import com.redhat.ceylon.model.cmr.JDKUtils;
import com.redhat.ceylon.model.cmr.ModuleScope;
import com.redhat.ceylon.model.cmr.RuntimeResolver;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.modules.AliasModuleSpec;
import org.jboss.modules.DependencySpec;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.ModuleSpec;
import org.jboss.modules.NativeLibraryResourceLoader;
import org.jboss.modules.ResourceLoader;
import org.jboss.modules.ResourceLoaderSpec;
import org.jboss.modules.filter.PathFilter;
import org.jboss.modules.filter.PathFilters;

public class CeylonModuleLoader
extends ModuleLoader
implements RuntimeResolver {
    private static final ModuleIdentifier LANGUAGE;
    private static final ModuleIdentifier COMMON;
    private static final ModuleIdentifier MODEL;
    private static final ModuleIdentifier CMR;
    private static final ModuleIdentifier TYPECHECKER;
    private static final ModuleIdentifier COMPILER;
    private static final ModuleIdentifier LANGTOOLS_CLASSFILE;
    private static final ModuleIdentifier TOOL_PROVIDER;
    private static final ModuleIdentifier MODULES;
    private static final ModuleIdentifier LOGMANAGER;
    private static final ModuleIdentifier RUNTIME;
    private static final ModuleIdentifier ANTLR_ANTLR;
    private static final ModuleIdentifier ANTLR_STRINGTEMPLATE;
    private static final ModuleIdentifier ANTLR_RUNTIME;
    private static final ModuleIdentifier CLI;
    private static final ModuleIdentifier MARKDOWN_PAPERS;
    private static final ModuleIdentifier AETHER_API;
    private static final ModuleIdentifier AETHER_SPI;
    private static final ModuleIdentifier AETHER_UTIL;
    private static final ModuleIdentifier AETHER_IMPL;
    private static final ModuleIdentifier AETHER_CONNECTOR_BASIC;
    private static final ModuleIdentifier AETHER_TRANSPORT_FILE;
    private static final ModuleIdentifier AETHER_TRANSPORT_HTTP;
    private static final ModuleIdentifier GUAVA;
    private static final ModuleIdentifier COMMONS_LANG3;
    private static final ModuleIdentifier MAVEN_ARTIFACT;
    private static final ModuleIdentifier MAVEN_MODEL;
    private static final ModuleIdentifier MAVEN_MODEL_BUILDER;
    private static final ModuleIdentifier MAVEN_REPOSITORY_METADATA;
    private static final ModuleIdentifier MAVEN_BUILDER_SUPPORT;
    private static final ModuleIdentifier MAVEN_SETTINGS;
    private static final ModuleIdentifier MAVEN_SETTINGS_BUILDER;
    private static final ModuleIdentifier MAVEN_AETHER_PROVIDER;
    private static final ModuleIdentifier PLEXUS_INTERPOLATION;
    private static final ModuleIdentifier PLEXUS_UTILS;
    private static final String CEYLON_RUNTIME_PATH;
    private static final Set<ModuleIdentifier> BOOTSTRAP;
    private static final Set<ModuleIdentifier> BOOTSTRAP_OPTIONAL;
    private static final DependencySpec JDK_DEPENDENCY;
    private static final Set<String> JDK_MODULE_NAMES;
    private static final List<LogChecker> checkers;
    private RepositoryManager repository;
    private Map<ModuleIdentifier, List<DependencySpec>> dependencies = new ConcurrentHashMap<ModuleIdentifier, List<DependencySpec>>();
    private Graph<ModuleIdentifier, ModuleIdentifier, Boolean> graph = new Graph();
    private boolean exportMavenImports = false;

    public CeylonModuleLoader(RepositoryManager repository, boolean autoExportMavenDependencies) throws Exception {
        if (repository == null) {
            throw new IllegalArgumentException("Null repository adapter");
        }
        this.repository = repository;
        this.exportMavenImports = autoExportMavenDependencies;
        this.init();
    }

    protected void init() throws Exception {
        ArtifactResult moduleArtifactResult;
        Module module;
        ModuleLoader bootModuleLoader = Module.getBootModuleLoader();
        for (ModuleIdentifier initialModule : BOOTSTRAP) {
            module = bootModuleLoader.loadModule(initialModule);
            moduleArtifactResult = this.findArtifact(initialModule);
            UtilRegistryTransformer.registerModule(initialModule.getName(), initialModule.getSlot(), moduleArtifactResult, SecurityActions.getClassLoader(module), false);
        }
        for (ModuleIdentifier initialModule : BOOTSTRAP_OPTIONAL) {
            try {
                module = bootModuleLoader.loadModule(initialModule);
                moduleArtifactResult = this.findArtifact(initialModule);
                UtilRegistryTransformer.registerModule(initialModule.getName(), initialModule.getSlot(), moduleArtifactResult, SecurityActions.getClassLoader(module), false);
            }
            catch (Exception exception) {}
        }
    }

    public void updateModule(Module module, DependencySpec dependencySpec) throws ModuleLoadException {
        ModuleIdentifier mi = module.getIdentifier();
        List<DependencySpec> deps = this.dependencies.get(mi);
        if (deps == null) {
            return;
        }
        deps.add(dependencySpec);
        this.setAndRelinkDependencies(module, deps);
        this.refreshResourceLoaders(module);
        this.relink(mi, new HashSet<ModuleIdentifier>());
    }

    private void relink(ModuleIdentifier mi, Set<ModuleIdentifier> visited) throws ModuleLoadException {
        if (!visited.add(mi)) {
            return;
        }
        Graph.Vertex<ModuleIdentifier, Boolean> v = this.graph.getVertex(mi);
        if (v == null) {
            return;
        }
        Module module = this.preloadModule(mi);
        this.relink(module);
        Set<Graph.Edge<ModuleIdentifier, Boolean>> in = v.getIn();
        for (Graph.Edge<ModuleIdentifier, Boolean> edge : in) {
            if (!edge.getCost().booleanValue()) continue;
            Graph.Vertex<ModuleIdentifier, Boolean> from = edge.getFrom();
            this.relink(from.getValue(), visited);
        }
    }

    @Override
    protected Module preloadModule(ModuleIdentifier mi) throws ModuleLoadException {
        if (BOOTSTRAP.contains(mi = this.findOverride(mi)) || BOOTSTRAP_OPTIONAL.contains(mi)) {
            return Module.getBootModuleLoader().loadModule(mi);
        }
        return super.preloadModule(mi);
    }

    void unloadModule(Module module) {
        this.dependencies.remove(module.getIdentifier());
        this.unloadModuleLocal(module);
    }

    protected ArtifactResult findArtifact(ModuleIdentifier mi) {
        String namespace = ModuleUtil.getNamespaceFromUri(mi.getName());
        String name = ModuleUtil.getModuleNameFromUri(mi.getName());
        ArtifactContext context = new ArtifactContext(namespace, name, mi.getSlot(), ".car", ".jar");
        return this.repository.getArtifactResult(context);
    }

    protected ModuleIdentifier findOverride(ModuleIdentifier mi) {
        String namespace = ModuleUtil.getNamespaceFromUri(mi.getName());
        String name = ModuleUtil.getModuleNameFromUri(mi.getName());
        ArtifactContext context = new ArtifactContext(namespace, name, mi.getSlot(), ".car", ".jar");
        ArtifactContext override = this.repository.getOverrides().applyOverrides(context);
        String newName = ModuleUtil.makeModuleName(override.getNamespace(), override.getName(), null);
        return ModuleIdentifier.create(newName, override.getVersion());
    }

    @Override
    public String resolveVersion(String moduleName, String moduleVersion) {
        if ("default".equals(moduleName)) {
            return null;
        }
        return this.findOverride(ModuleIdentifier.create(moduleName, moduleVersion)).getSlot();
    }

    protected boolean isLogging(List<DependencySpec> deps, ModuleSpec.Builder builder, ArtifactResult result) {
        for (LogChecker checker : checkers) {
            List<ModuleDependencyInfo> replacements = checker.handle(result);
            if (replacements == null) continue;
            if (replacements.isEmpty()) {
                throw new IllegalArgumentException(String.format("Log replacements cannot be empty - %s [%s]!", result, checker));
            }
            this.addLoggingModules(builder, deps, replacements);
            return true;
        }
        return false;
    }

    @Override
    protected ModuleSpec findModule(ModuleIdentifier moduleIdentifier) throws ModuleLoadException {
        try {
            ArtifactResult artifact = this.findArtifact(moduleIdentifier);
            if (artifact == null) {
                return null;
            }
            if (!artifact.version().equals(moduleIdentifier.getSlot())) {
                AliasModuleSpec alias = (AliasModuleSpec)ModuleSpec.buildAlias(moduleIdentifier, ModuleIdentifier.create(artifact.name(), artifact.version())).create();
                return alias;
            }
            File moduleFile = artifact.artifact();
            boolean isDefault = "default".equals(moduleIdentifier.getName());
            boolean isMaven = artifact.type() == ArtifactResultType.MAVEN;
            ArrayList<DependencySpec> deps = new ArrayList<DependencySpec>();
            ModuleSpec.Builder builder = ModuleSpec.build(moduleIdentifier);
            if (!ModuleUtil.isMavenJarlessModule(moduleFile)) {
                ResourceLoader resourceLoader = ResourceLoaderProvider.getResourceLoader(moduleIdentifier, this.repository, moduleFile);
                PathFilter filter = artifact.filter() != null ? new CMRPathFilter(artifact.filter()) : PathFilters.acceptAll();
                ResourceLoaderSpec rls = ResourceLoaderSpec.createResourceLoaderSpec(resourceLoader, filter);
                builder.addResourceRoot(rls);
            }
            NativeLibraryResourceLoader nativeLoader = new NativeLibraryResourceLoader(new File(moduleFile.getParent(), "lib"));
            builder.addResourceRoot(ResourceLoaderSpec.createResourceLoaderSpec(nativeLoader));
            Graph.Vertex<ModuleIdentifier, Boolean> vertex = this.graph.createVertex(moduleIdentifier, moduleIdentifier);
            DependencySpec lds = DependencySpec.createLocalDependencySpec();
            builder.addDependency(lds);
            deps.add(lds);
            if (!isDefault) {
                Node<ArtifactResult> root = new Node<ArtifactResult>();
                for (ArtifactResult i : artifact.dependencies()) {
                    if (i.moduleScope() == ModuleScope.TEST) continue;
                    String name = i.name();
                    if (this.isLogging(deps, builder, i) || JDK_MODULE_NAMES.contains(name)) continue;
                    boolean isDepMaven = "maven".equals(i.namespace());
                    if (i.optional()) {
                        String[] tokens;
                        Node<ArtifactResult> current = root;
                        for (String token : tokens = name.split("\\.")) {
                            Node<ArtifactResult> child = current.getChild(token);
                            if (child == null) {
                                child = current.addChild(token);
                            }
                            current = child;
                        }
                        current.setValue(i);
                    } else {
                        DependencySpec mds = this.createModuleDependency(i, this.exportMavenImports && isMaven && isDepMaven);
                        builder.addDependency(mds);
                        deps.add(mds);
                    }
                    ModuleIdentifier mi = CeylonModuleLoader.createModuleIdentifier(i);
                    Graph.Vertex<ModuleIdentifier, Boolean> dv = this.graph.createVertex(mi, mi);
                    Graph.Edge.create(i.exported() || this.exportMavenImports && isMaven && isDepMaven, vertex, dv);
                }
                if (!root.isEmpty()) {
                    OnDemandLocalLoader onDemandLoader = new OnDemandLocalLoader(moduleIdentifier, this, root);
                    builder.setFallbackLoader(onDemandLoader);
                }
            }
            builder.addDependency(JDK_DEPENDENCY);
            this.createModuleDependency(vertex, deps, builder, LANGUAGE, false);
            DependencySpec sds = DependencySpec.createModuleDependencySpec(PathFilters.match(CEYLON_RUNTIME_PATH), PathFilters.rejectAll(), this, RUNTIME, true);
            builder.addDependency(sds);
            deps.add(sds);
            Graph.Vertex<ModuleIdentifier, Boolean> sdsv = this.graph.createVertex(RUNTIME, RUNTIME);
            Graph.Edge.create(false, vertex, sdsv);
            this.dependencies.put(moduleIdentifier, deps);
            UtilRegistryTransformer transformer = new UtilRegistryTransformer(moduleIdentifier, artifact);
            builder.setClassFileTransformer(transformer);
            builder.setModuleClassLoaderFactory(new CeylonModuleClassLoader.CeylonModuleClassLoaderFactory(transformer));
            return builder.create();
        }
        catch (Exception e) {
            throw new ModuleLoadException(e);
        }
    }

    private void addLoggingModules(ModuleSpec.Builder builder, List<DependencySpec> deps, List<ModuleDependencyInfo> replacements) {
        for (ModuleDependencyInfo mi : replacements) {
            ModuleIdentifier identifier = ModuleIdentifier.create(mi.getName(), mi.getVersion());
            DependencySpec dependency = DependencySpec.createModuleDependencySpec(PathFilters.acceptAll(), mi.isExport() ? PathFilters.acceptAll() : PathFilters.rejectAll(), this, identifier, mi.isOptional());
            builder.addDependency(dependency);
            deps.add(dependency);
        }
    }

    protected void createModuleDependency(Graph.Vertex<ModuleIdentifier, Boolean> vertex, List<DependencySpec> deps, ModuleSpec.Builder builder, ModuleIdentifier mi, boolean optional) {
        DependencySpec dependency = DependencySpec.createModuleDependencySpec(PathFilters.acceptAll(), PathFilters.rejectAll(), this, mi, optional);
        builder.addDependency(dependency);
        deps.add(dependency);
        Graph.Vertex<ModuleIdentifier, Boolean> lv = this.graph.createVertex(mi, mi);
        Graph.Edge.create(false, vertex, lv);
    }

    DependencySpec createModuleDependency(ArtifactResult i, boolean forceExport) {
        if (JDK_MODULE_NAMES.contains(i.name())) {
            return JDK_DEPENDENCY;
        }
        ModuleIdentifier mi = CeylonModuleLoader.createModuleIdentifier(i);
        boolean export = forceExport || i.exported();
        return DependencySpec.createModuleDependencySpec(PathFilters.getMetaInfSubdirectoriesWithoutMetaInfFilter(), export ? PathFilters.acceptAll() : PathFilters.rejectAll(), this, mi, i.optional());
    }

    static ModuleIdentifier createModuleIdentifier(ArtifactResult i) {
        String name = ModuleUtil.makeModuleName(i.namespace(), i.name(), null);
        return ModuleIdentifier.create(name, i.version());
    }

    @Override
    public String toString() {
        return "Ceylon ModuleLoader: " + this.repository;
    }

    public void loadModuleSynchronous(String name, String version2) throws ModuleLoadException {
        ModuleIdentifier moduleIdentifier = ModuleIdentifier.create(name, version2);
        Module module = this.loadModule(moduleIdentifier);
        ModuleClassLoader classLoader = module.getClassLoader();
        if (classLoader instanceof CeylonModuleClassLoader) {
            ((CeylonModuleClassLoader)classLoader).registerInMetaModel();
            ((CeylonModuleClassLoader)classLoader).waitForRegisterThreads();
        }
    }

    static {
        Set<String> paths;
        String defaultVersion = System.getProperty("ceylon.system.version", "1.3.2");
        LANGUAGE = ModuleIdentifier.create("ceylon.language", defaultVersion);
        COMMON = ModuleIdentifier.create("com.redhat.ceylon.common", defaultVersion);
        MODEL = ModuleIdentifier.create("com.redhat.ceylon.model", defaultVersion);
        CMR = ModuleIdentifier.create("com.redhat.ceylon.module-resolver", defaultVersion);
        TYPECHECKER = ModuleIdentifier.create("com.redhat.ceylon.typechecker", defaultVersion);
        COMPILER = ModuleIdentifier.create("com.redhat.ceylon.compiler.java", defaultVersion);
        LANGTOOLS_CLASSFILE = ModuleIdentifier.create("com.redhat.ceylon.langtools.classfile", defaultVersion);
        TOOL_PROVIDER = ModuleIdentifier.create("com.redhat.ceylon.tool.provider", defaultVersion);
        CLI = ModuleIdentifier.create("com.redhat.ceylon.cli", defaultVersion);
        AETHER_API = ModuleIdentifier.create("org.eclipse.aether.api", "1.1.0");
        AETHER_SPI = ModuleIdentifier.create("org.eclipse.aether.spi", "1.1.0");
        AETHER_UTIL = ModuleIdentifier.create("org.eclipse.aether.util", "1.1.0");
        AETHER_IMPL = ModuleIdentifier.create("org.eclipse.aether.impl", "1.1.0");
        AETHER_CONNECTOR_BASIC = ModuleIdentifier.create("org.eclipse.aether.connector.basic", "1.1.0");
        AETHER_TRANSPORT_FILE = ModuleIdentifier.create("org.eclipse.aether.transport.file", "1.1.0");
        AETHER_TRANSPORT_HTTP = ModuleIdentifier.create("org.eclipse.aether.transport.http", "1.1.0");
        GUAVA = ModuleIdentifier.create("com.google.guava", "18.0");
        COMMONS_LANG3 = ModuleIdentifier.create("org.apache.commons.lang3", "3.4");
        MAVEN_ARTIFACT = ModuleIdentifier.create("org.apache.maven.maven-artifact", "3.3.9");
        MAVEN_MODEL = ModuleIdentifier.create("org.apache.maven.maven-model", "3.3.9");
        MAVEN_MODEL_BUILDER = ModuleIdentifier.create("org.apache.maven.maven-model-builder", "3.3.9");
        MAVEN_REPOSITORY_METADATA = ModuleIdentifier.create("org.apache.maven.maven-repository-metadata", "3.3.9");
        MAVEN_BUILDER_SUPPORT = ModuleIdentifier.create("org.apache.maven.maven-builder-support", "3.3.9");
        MAVEN_SETTINGS = ModuleIdentifier.create("org.apache.maven.maven-settings", "3.3.9");
        MAVEN_SETTINGS_BUILDER = ModuleIdentifier.create("org.apache.maven.maven-settings-builder", "3.3.9");
        MAVEN_AETHER_PROVIDER = ModuleIdentifier.create("org.apache.maven.maven-aether-provider", "3.3.9");
        PLEXUS_INTERPOLATION = ModuleIdentifier.create("org.codehaus.plexus.plexus-interpolation", "1.22");
        PLEXUS_UTILS = ModuleIdentifier.create("org.codehaus.plexus.plexus-utils", "3.0.22");
        MODULES = ModuleIdentifier.create("org.jboss.modules", "1.4.4.Final");
        LOGMANAGER = ModuleIdentifier.create("org.jboss.logmanager", "2.0.3.Final");
        RUNTIME = ModuleIdentifier.create("ceylon.runtime", defaultVersion);
        ANTLR_ANTLR = ModuleIdentifier.create("org.antlr.antlr", "2.7.7");
        ANTLR_STRINGTEMPLATE = ModuleIdentifier.create("org.antlr.stringtemplate", "3.2.1");
        ANTLR_RUNTIME = ModuleIdentifier.create("org.antlr.runtime", "3.4");
        MARKDOWN_PAPERS = ModuleIdentifier.create("org.tautua.markdownpapers.core", "1.2.7");
        CEYLON_RUNTIME_PATH = ModuleVersion.class.getPackage().getName().replace(".", "/");
        BOOTSTRAP = new HashSet<ModuleIdentifier>();
        BOOTSTRAP.add(LANGUAGE);
        BOOTSTRAP.add(COMMON);
        BOOTSTRAP.add(MODEL);
        BOOTSTRAP.add(CMR);
        BOOTSTRAP.add(TYPECHECKER);
        BOOTSTRAP.add(COMPILER);
        BOOTSTRAP.add(LANGTOOLS_CLASSFILE);
        BOOTSTRAP.add(TOOL_PROVIDER);
        BOOTSTRAP.add(CLI);
        BOOTSTRAP.add(MODULES);
        BOOTSTRAP.add(LOGMANAGER);
        BOOTSTRAP.add(RUNTIME);
        BOOTSTRAP.add(ANTLR_RUNTIME);
        BOOTSTRAP.add(ANTLR_ANTLR);
        BOOTSTRAP.add(ANTLR_STRINGTEMPLATE);
        BOOTSTRAP_OPTIONAL = new HashSet<ModuleIdentifier>();
        BOOTSTRAP_OPTIONAL.add(MARKDOWN_PAPERS);
        BOOTSTRAP_OPTIONAL.add(AETHER_API);
        BOOTSTRAP_OPTIONAL.add(AETHER_SPI);
        BOOTSTRAP_OPTIONAL.add(AETHER_UTIL);
        BOOTSTRAP_OPTIONAL.add(AETHER_IMPL);
        BOOTSTRAP_OPTIONAL.add(AETHER_CONNECTOR_BASIC);
        BOOTSTRAP_OPTIONAL.add(AETHER_TRANSPORT_FILE);
        BOOTSTRAP_OPTIONAL.add(AETHER_TRANSPORT_HTTP);
        BOOTSTRAP_OPTIONAL.add(GUAVA);
        BOOTSTRAP_OPTIONAL.add(COMMONS_LANG3);
        BOOTSTRAP_OPTIONAL.add(MAVEN_ARTIFACT);
        BOOTSTRAP_OPTIONAL.add(MAVEN_MODEL);
        BOOTSTRAP_OPTIONAL.add(MAVEN_MODEL_BUILDER);
        BOOTSTRAP_OPTIONAL.add(MAVEN_REPOSITORY_METADATA);
        BOOTSTRAP_OPTIONAL.add(MAVEN_BUILDER_SUPPORT);
        BOOTSTRAP_OPTIONAL.add(MAVEN_SETTINGS);
        BOOTSTRAP_OPTIONAL.add(MAVEN_SETTINGS_BUILDER);
        BOOTSTRAP_OPTIONAL.add(MAVEN_AETHER_PROVIDER);
        BOOTSTRAP_OPTIONAL.add(PLEXUS_INTERPOLATION);
        BOOTSTRAP_OPTIONAL.add(PLEXUS_UTILS);
        HashSet<String> jdkPaths = new HashSet<String>();
        JDK_MODULE_NAMES = new HashSet<String>();
        for (String module : JDKUtils.getJDKModuleNames()) {
            paths = JDKUtils.getJDKPathsByModule(module);
            jdkPaths.addAll(paths);
            JDK_MODULE_NAMES.add(module);
        }
        for (String module : JDKUtils.getOracleJDKModuleNames()) {
            paths = JDKUtils.getOracleJDKPathsByModule(module);
            JDK_MODULE_NAMES.add(module);
            jdkPaths.addAll(paths);
        }
        JDK_DEPENDENCY = DependencySpec.createSystemDependencySpec(jdkPaths, true);
        checkers = new ArrayList<LogChecker>();
        for (LogChecker checker : ServiceLoader.load(LogChecker.class)) {
            checkers.add(checker);
        }
    }
}

