/*
 * Decompiled with CFR 0.152.
 */
package ceylon.modules.jboss.runtime;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.jboss.modules.LocalLoader;
import org.jboss.modules.Module;
import org.jboss.modules.Resource;

class ModuleLocalLoader
implements LocalLoader {
    private static final Method getPackage = AccessController.doPrivileged(new PrivilegedAction<Method>(){

        @Override
        public Method run() {
            for (Method method : ClassLoader.class.getDeclaredMethods()) {
                Class<?>[] parameterTypes;
                if (!method.getName().equals("getPackage") || (parameterTypes = method.getParameterTypes()).length != 1 || parameterTypes[0] != String.class) continue;
                method.setAccessible(true);
                return method;
            }
            throw new IllegalStateException("No getPackage method found on ClassLoader");
        }
    });
    private final Module module;

    ModuleLocalLoader(Module module) {
        this.module = module;
    }

    @Override
    public Class<?> loadClassLocal(String name, boolean resolve) {
        try {
            return this.module.getClassLoader().loadClass(name, resolve);
        }
        catch (ClassNotFoundException ignored) {
            return null;
        }
    }

    @Override
    public List<Resource> loadResourceLocal(String name) {
        Enumeration<URL> urls = this.module.getExportedResources(name);
        ArrayList<Resource> list = new ArrayList<Resource>();
        while (urls.hasMoreElements()) {
            list.add(new URLResource(urls.nextElement()));
        }
        return list;
    }

    @Override
    public Package loadPackageLocal(String name) {
        try {
            return (Package)getPackage.invoke((Object)this.module.getClassLoader(), name);
        }
        catch (IllegalAccessException e) {
            throw new IllegalAccessError(e.getMessage());
        }
        catch (InvocationTargetException e) {
            try {
                throw e.getCause();
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Error er) {
                throw er;
            }
            catch (Throwable throwable) {
                throw new UndeclaredThrowableException(throwable);
            }
        }
    }

    static final class URLResource
    implements Resource {
        private final URL url;

        public URLResource(URL url) {
            this.url = url;
        }

        @Override
        public String getName() {
            return this.url.getPath();
        }

        @Override
        public URL getURL() {
            return this.url;
        }

        @Override
        public InputStream openStream() throws IOException {
            return this.url.openStream();
        }

        @Override
        public long getSize() {
            return 0L;
        }
    }
}

