/*
 * Decompiled with CFR 0.152.
 */
package ceylon.modules.jboss.runtime;

import ceylon.modules.jboss.runtime.CeylonModuleClassLoader;
import com.redhat.ceylon.common.ModuleUtil;
import com.redhat.ceylon.compiler.java.Util;
import com.redhat.ceylon.model.cmr.ArtifactResult;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import org.jboss.modules.ModuleIdentifier;

public class UtilRegistryTransformer
implements ClassFileTransformer {
    private volatile boolean done;
    private final ModuleIdentifier mi;
    private final ArtifactResult result;

    public UtilRegistryTransformer(ModuleIdentifier mi, ArtifactResult result) {
        this.mi = mi;
        this.result = result;
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        this.register(loader);
        return classfileBuffer;
    }

    static void registerModule(final String name, String _version, final ArtifactResult result, final ClassLoader cl, boolean async) {
        String version2;
        String string = version2 = "default".equals(name) ? null : _version;
        if (async) {
            if (cl instanceof CeylonModuleClassLoader) {
                ((CeylonModuleClassLoader)cl).registerThreadRunning();
            }
            new Thread(){

                @Override
                public void run() {
                    Util.loadModule(name, version2, result, cl);
                    if (cl instanceof CeylonModuleClassLoader) {
                        ((CeylonModuleClassLoader)cl).registerThreadDone();
                    }
                }
            }.start();
        } else {
            Util.loadModule(name, version2, result, cl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(ClassLoader loader) {
        if (!this.done) {
            UtilRegistryTransformer utilRegistryTransformer = this;
            synchronized (utilRegistryTransformer) {
                if (!this.done) {
                    this.done = true;
                    String name = ModuleUtil.getModuleNameFromUri(this.mi.getName());
                    UtilRegistryTransformer.registerModule(name, this.mi.getSlot(), this.result, loader, true);
                }
            }
        }
    }
}

